/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javajs.async.AsyncFileChooser;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;

public class ThumbnailDialog
extends JDialog {
    protected static ThumbnailDialog thumbnailDialog;
    protected static String[] viewNames;
    protected static String[] formatNames;
    protected static Dimension defaultSize;
    protected static VideoFileFilter[] fileFilters;
    protected static PropertyChangeListener fileChooserListener;
    protected static JTextComponent chooserField;
    protected static boolean settingsOnly;
    protected TFrame frame;
    protected Integer panelID;
    protected JButton saveAsButton;
    protected JButton closeButton;
    protected JComponent sizePanel;
    protected JComponent viewPanel;
    protected JComponent formatPanel;
    protected JComboBox<String> formatDropdown;
    protected JComboBox<String> viewDropdown;
    protected JComboBox<String> sizeDropdown;
    protected DefaultComboBoxModel<String> formatModel;
    protected DefaultComboBoxModel<String> viewModel;
    protected AffineTransform transform = new AffineTransform();
    protected BufferedImage sizedImage;
    protected HashMap<Object, Dimension> sizes;
    protected Dimension fullSize = new Dimension();
    protected Dimension thumbSize;
    protected boolean isRefreshing;
    protected String savedFilePath;
    protected JPanel buttonbar;

    static {
        TFrame.haveThumbnailDialog = true;
        viewNames = new String[]{"WholeFrame", "MainView", "VideoOnly"};
        formatNames = new String[]{"png", "jpg"};
        defaultSize = new Dimension(320, 240);
        fileFilters = new VideoFileFilter[formatNames.length];
    }

    public static ThumbnailDialog getDialog(TrackerPanel panel, boolean withSaveButton) {
        if (thumbnailDialog == null) {
            thumbnailDialog = new ThumbnailDialog(panel);
            FontSizer.setFonts(thumbnailDialog, FontSizer.getLevel());
            fileChooserListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (chooserField != null && e.getNewValue() != null) {
                        VideoFileFilter filter = (VideoFileFilter)e.getNewValue();
                        final String ext = filter.getDefaultExtension();
                        Runnable runner = new Runnable(){

                            @Override
                            public void run() {
                                String name = String.valueOf(XML.stripExtension(chooserField.getText())) + "." + ext;
                                chooserField.setText(name);
                            }
                        };
                        SwingUtilities.invokeLater(runner);
                    }
                }
            };
            int i = 0;
            while (i < formatNames.length) {
                VideoType type = VideoIO.getVideoType(null, formatNames[i]);
                VideoFileFilter[] videoFileFilterArray = type.getFileFilters();
                int n = videoFileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VideoFileFilter filter = videoFileFilterArray[n2];
                    if (filter.getDefaultExtension().equals(formatNames[i])) {
                        ThumbnailDialog.fileFilters[i] = filter;
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
            AsyncFileChooser chooser = TrackerIO.getChooser();
            String temp = "untitled.tmp";
            chooser.setSelectedFile(new File(temp));
            chooserField = ThumbnailDialog.getTextComponent(chooser, temp);
            chooser.setSelectedFile(new File(""));
        }
        settingsOnly = !withSaveButton;
        ThumbnailDialog.thumbnailDialog.panelID = panel.getID();
        ThumbnailDialog.thumbnailDialog.frame = panel.getTFrame();
        thumbnailDialog.refreshGUI();
        return thumbnailDialog;
    }

    public File saveThumbnail(String filePath) {
        int i = this.formatDropdown.getSelectedIndex();
        String format = formatNames[i];
        if (filePath == null) {
            FileFilter filter;
            AsyncFileChooser chooser = TrackerIO.getChooser();
            FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            int n = fileFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                filter = fileFilterArray[n2];
                chooser.removeChoosableFileFilter(filter);
                ++n2;
            }
            fileFilterArray = fileFilters;
            n = fileFilters.length;
            n2 = 0;
            while (n2 < n) {
                filter = fileFilterArray[n2];
                chooser.addChoosableFileFilter(filter);
                ++n2;
            }
            chooser.setFileFilter(fileFilters[i]);
            chooser.addPropertyChangeListener("fileFilterChanged", fileChooserListener);
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            String tabName = XML.stripExtension(trackerPanel.getTitle());
            chooser.setSelectedFile(new File(String.valueOf(tabName) + "_thumbnail." + format));
            File[] files = TrackerIO.getChooserFilesAsync(this.frame, "save thumbnail", null);
            chooser.removePropertyChangeListener("fileFilterChanged", fileChooserListener);
            if (files == null || files.length == 0) {
                return null;
            }
            filePath = files[0].getAbsolutePath();
            VideoFileFilter selectedFilter = (VideoFileFilter)chooser.getFileFilter();
            chooser.resetChoosableFileFilters();
            String ext = selectedFilter.getDefaultExtension();
            this.setFormat(ext);
            if (!selectedFilter.accept(files[0]) && !TrackerIO.canWrite(new File(filePath = String.valueOf(XML.stripExtension(filePath)) + "." + ext))) {
                return null;
            }
        }
        if (XML.getExtension(filePath) == null) {
            filePath = String.valueOf(XML.stripExtension(filePath)) + "." + format;
        }
        Dimension size = this.sizes.get(this.sizeDropdown.getSelectedItem());
        BufferedImage thumb = this.getThumbnailImage(size);
        File thumbnail = VideoIO.writeImageFile(thumb, filePath);
        return thumbnail;
    }

    public BufferedImage getThumbnail() {
        Dimension size = this.sizes.get(this.sizeDropdown.getSelectedItem());
        return this.getThumbnailImage(size);
    }

    public Dimension getThumbnailSize() {
        return this.sizes.get(this.sizeDropdown.getSelectedItem());
    }

    public void setFormat(String format) {
        int i = 0;
        while (i < formatNames.length) {
            if (format != null && formatNames[i].equals(format.toLowerCase())) {
                this.formatDropdown.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public String getFormat() {
        return formatNames[this.formatDropdown.getSelectedIndex()];
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (!vis && TFrame.haveExportDialog) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            ExportZipDialog.thumbnailDialogClosed(trackerPanel);
        }
    }

    private ThumbnailDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), true);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.setResizable(false);
        this.createGUI();
        this.refreshGUI();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        Box settingsPanel = Box.createVerticalBox();
        settingsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
        contentPane.add((Component)settingsPanel, "Center");
        JPanel upper = new JPanel(new GridLayout(1, 1));
        JPanel lower = new JPanel(new GridLayout(1, 2));
        this.sizes = new HashMap();
        this.sizePanel = Box.createVerticalBox();
        this.sizeDropdown = new JComboBox();
        this.sizePanel.add(this.sizeDropdown);
        this.viewPanel = Box.createVerticalBox();
        this.viewModel = new DefaultComboBoxModel();
        this.viewDropdown = new JComboBox<String>(this.viewModel);
        this.viewPanel.add(this.viewDropdown);
        this.viewDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !ThumbnailDialog.this.isRefreshing) {
                    ThumbnailDialog.this.refreshSizeDropdown();
                }
            }
        });
        this.formatPanel = Box.createVerticalBox();
        this.formatModel = new DefaultComboBoxModel();
        this.formatDropdown = new JComboBox<String>(this.formatModel);
        this.formatPanel.add(this.formatDropdown);
        settingsPanel.add(upper);
        settingsPanel.add(lower);
        upper.add(this.viewPanel);
        lower.add(this.sizePanel);
        lower.add(this.formatPanel);
        this.saveAsButton = new JButton();
        this.saveAsButton.setForeground(new Color(0, 0, 102));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThumbnailDialog.this.setVisible(false);
                ThumbnailDialog.this.saveThumbnail(null);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThumbnailDialog.this.setVisible(false);
                ThumbnailDialog.this.firePropertyChange("accepted", null, null);
            }
        });
        this.buttonbar = new JPanel();
        contentPane.add((Component)this.buttonbar, "South");
        this.buttonbar.add(this.saveAsButton);
        this.buttonbar.add(this.closeButton);
    }

    protected void refreshGUI() {
        String resource = settingsOnly ? "ThumbnailDialog.Settings.Title" : "ThumbnailDialog.Title";
        String title = TrackerRes.getString(resource);
        this.setTitle(title);
        title = TrackerRes.getString("ExportVideoDialog.Subtitle.Size");
        Border space = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titled = BorderFactory.createTitledBorder(title);
        int fontLevel = FontSizer.getLevel();
        FontSizer.setFonts(titled, fontLevel);
        this.sizePanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ThumbnailDialog.Subtitle.Image");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, fontLevel);
        this.viewPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ExportVideoDialog.Subtitle.Format");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, fontLevel);
        this.formatPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        this.saveAsButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        if (settingsOnly) {
            this.buttonbar.remove(this.saveAsButton);
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        } else {
            this.buttonbar.add((Component)this.saveAsButton, 0);
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        }
        this.isRefreshing = true;
        int index = this.formatDropdown.getSelectedIndex();
        index = Math.max(index, 0);
        this.formatModel.removeAllElements();
        int i = 0;
        while (i < formatNames.length) {
            String format = TrackerRes.getString("ThumbnailDialog.Format." + formatNames[i].toUpperCase());
            this.formatModel.addElement(format);
            ++i;
        }
        this.formatDropdown.setSelectedIndex(index);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int lastIndex = trackerPanel.getVideo() == null ? viewNames.length - 2 : viewNames.length - 1;
        index = Math.min(this.viewDropdown.getSelectedIndex(), lastIndex);
        index = Math.max(index, 0);
        this.viewModel.removeAllElements();
        int i2 = 0;
        while (i2 <= lastIndex) {
            String view = TrackerRes.getString("ThumbnailDialog.View." + viewNames[i2]);
            this.viewModel.addElement(view);
            ++i2;
        }
        this.viewDropdown.setSelectedIndex(index);
        this.isRefreshing = false;
        this.refreshSizeDropdown();
        this.pack();
    }

    private void refreshSizeDropdown() {
        String s;
        this.isRefreshing = true;
        Object selectedItem = this.sizeDropdown.getSelectedItem();
        this.sizeDropdown.removeAllItems();
        this.sizes.clear();
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        switch (this.viewDropdown.getSelectedIndex()) {
            case 1: {
                Rectangle bounds = trackerPanel.getMatBounds();
                this.fullSize.setSize(bounds.getWidth(), bounds.getHeight());
                this.thumbSize = this.getFullThumbnailSize(this.fullSize);
                break;
            }
            case 2: {
                Dimension d = trackerPanel.getVideo().getImageSize(true);
                this.fullSize.setSize(d.width, d.height);
                this.thumbSize = this.getFullThumbnailSize(this.fullSize);
                break;
            }
            default: {
                this.fullSize.setSize(trackerPanel.getTFrame().getSize());
                this.thumbSize = this.getFullThumbnailSize(this.fullSize);
            }
        }
        if (this.isAcceptedDimension(this.fullSize.width, this.fullSize.height)) {
            String s2 = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
            this.sizeDropdown.addItem(s2);
            this.sizes.put(s2, this.fullSize);
        }
        Dimension dim = new Dimension(this.fullSize.width / 2, this.fullSize.height / 2);
        if (dim.width > this.thumbSize.width && dim.height > this.thumbSize.height && this.isAcceptedDimension(dim.width, dim.height)) {
            s = String.valueOf(dim.width) + "x" + dim.height;
            this.sizeDropdown.addItem(s);
            this.sizes.put(s, dim);
        }
        String defaultItem = s = String.valueOf(this.thumbSize.width) + "x" + this.thumbSize.height;
        this.sizeDropdown.addItem(s);
        this.sizes.put(s, this.thumbSize);
        double[] factor = new double[]{0.75, 0.5, 0.375, 0.25};
        int i = 0;
        while (i < factor.length) {
            dim = new Dimension((int)((double)this.thumbSize.width * factor[i]), (int)((double)this.thumbSize.height * factor[i]));
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            ++i;
        }
        this.sizeDropdown.setSelectedItem(this.sizes.keySet().contains(selectedItem) ? selectedItem : defaultItem);
        this.isRefreshing = false;
    }

    private Dimension getFullThumbnailSize(Dimension imageSize) {
        double widthFactor = defaultSize.getWidth() / (double)imageSize.width;
        double heightFactor = defaultSize.getHeight() / (double)imageSize.height;
        double factor = Math.min(widthFactor, heightFactor);
        int w = (int)((double)imageSize.width * factor);
        int h = (int)((double)imageSize.height * factor);
        return new Dimension(w, h);
    }

    private boolean isAcceptedDimension(int w, int h) {
        return w >= 80 || h >= 60;
    }

    private BufferedImage getThumbnailImage(Dimension size) {
        BufferedImage rawImage;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        switch (this.viewDropdown.getSelectedIndex()) {
            case 1: {
                rawImage = trackerPanel.getMattedImage();
                break;
            }
            case 2: {
                rawImage = trackerPanel.getVideo().getImage();
                break;
            }
            default: {
                rawImage = (BufferedImage)this.frame.createImage(this.fullSize.width, this.fullSize.height);
                Graphics2D g2 = rawImage.createGraphics();
                this.frame.paint(g2);
                g2.dispose();
            }
        }
        return this.getResizedImage(rawImage, size);
    }

    private BufferedImage getResizedImage(BufferedImage source, Dimension size) {
        if (size.width == source.getWidth() && size.height == source.getHeight()) {
            return source;
        }
        if (this.sizedImage == null || this.sizedImage.getWidth() != size.width || this.sizedImage.getHeight() != size.height) {
            this.sizedImage = new BufferedImage(size.width, size.height, source.getType());
        }
        Graphics2D g2 = this.sizedImage.createGraphics();
        g2.drawImage(source, 0, 0, size.width, size.height, 0, 0, source.getWidth(), source.getHeight(), null);
        g2.dispose();
        return this.sizedImage;
    }

    private static JTextComponent getTextComponent(Container c, String toMatch) {
        Component[] comps = c.getComponents();
        int i = 0;
        while (i < comps.length) {
            JTextComponent tc;
            if (comps[i] instanceof JTextComponent && toMatch.equals(((JTextComponent)comps[i]).getText())) {
                return (JTextComponent)comps[i];
            }
            if (comps[i] instanceof Container && (tc = ThumbnailDialog.getTextComponent((Container)comps[i], toMatch)) != null) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    public void clear() {
    }
}

