/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackRenderer;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.tools.FontSizer;

public abstract class TrackChooserTView
extends TView {
    private static final String[] panelProps = new String[]{"clear", "transform", "stepnumber", "image", "data", "format", "radian_angles", "function"};
    public static boolean ignoreRefresh = false;
    protected Map<Object, TTrack> tracks = new HashMap<Object, TTrack>();
    protected Map<TTrack, TrackView> trackViews;
    protected TTrack selectedTrack;
    protected boolean refreshing;
    private JComboBox<Object[]> trackComboBox;
    private JPanel noData;
    private JLabel noDataLabel;
    private JLabel viewTypeLabel;

    protected TrackerPanel getPanel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    protected TrackChooserTView(TrackerPanel panel) {
        super(panel);
        if (panel == null) {
            return;
        }
        this.init();
        this.setBackground(panel.getBackground());
        this.trackComboBox = new JComboBox<Object[]>(){

            @Override
            public Dimension getMaximumSize() {
                return TViewChooser.getButtonMaxSize(this, new Dimension(this.getPreferredSize().width, super.getMaximumSize().height), this.getMinimumSize().height);
            }
        };
        this.trackComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
        this.toolbarComponents.add(this.trackComboBox);
        this.trackComboBox.setRenderer(new TrackRenderer());
        this.trackComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackChooserTView.this.dropDownAction();
            }
        });
        this.noData = new JPanel(new BorderLayout());
        this.noDataLabel = new JLabel();
        this.noDataLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        Font font = new JTextField().getFont();
        this.noDataLabel.setFont(font);
        this.noData.add((Component)this.noDataLabel, "North");
        this.noData.setBackground(this.getBackground());
        this.noData.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem helpItem = new JMenuItem(String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...");
                    helpItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (TrackChooserTView.this.getViewType() == 1) {
                                (this).TrackChooserTView.this.frame.showHelp("datatable", 0);
                            } else {
                                (this).TrackChooserTView.this.frame.showHelp("plot", 0);
                            }
                        }
                    });
                    popup.add(helpItem);
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    popup.show(TrackChooserTView.this.noData, e.getX(), e.getY());
                }
            }
        });
        this.viewTypeLabel = new JLabel();
        this.viewTypeLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 0));
    }

    protected void dropDownAction() {
        if (this.refreshing) {
            return;
        }
        Object item = this.trackComboBox.getSelectedItem();
        TTrack track = this.tracks.get(item);
        String name = (String)((Object[])item)[1];
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (track != null) {
            TrackPlottingPanel plot;
            int n;
            int n2;
            TrackPlottingPanel[] trackPlottingPanelArray;
            PlotTrackView plotView;
            trackerPanel.changed = true;
            TrackView trackView = this.getTrackView(track);
            TTrack prevTrack = this.selectedTrack;
            TrackView prevView = null;
            if (prevTrack != null) {
                prevView = this.getTrackView(prevTrack);
                prevTrack.removeStepListener(prevView);
                if (prevView instanceof PlotTrackView) {
                    plotView = (PlotTrackView)prevView;
                    trackPlottingPanelArray = plotView.plots;
                    n2 = plotView.plots.length;
                    n = 0;
                    while (n < n2) {
                        plot = trackPlottingPanelArray[n];
                        for (TTrack guest : plot.guests) {
                            guest.removeStepListener(prevView);
                        }
                        ++n;
                    }
                }
            }
            track.addStepListener(trackView);
            if (trackView instanceof PlotTrackView) {
                plotView = (PlotTrackView)trackView;
                trackPlottingPanelArray = plotView.plots;
                n2 = plotView.plots.length;
                n = 0;
                while (n < n2) {
                    plot = trackPlottingPanelArray[n];
                    for (TTrack guest : plot.guests) {
                        guest.addStepListener(trackView);
                    }
                    ++n;
                }
            }
            this.selectedTrack = track;
            Step step = trackerPanel.getSelectedStep();
            if (step != null && step.getTrack() == track) {
                trackView.refresh(step.getFrameNumber(), 6400);
            } else {
                trackView.refresh(trackerPanel.getFrameNumber(), 6400);
            }
            this.firePropertyChange("trackview", trackView, prevView);
            PropertyChangeEvent event = new PropertyChangeEvent(this, "track", null, track);
            Iterator<TTrack> it = this.trackViews.keySet().iterator();
            while (it.hasNext()) {
                this.trackViews.get(it.next()).propertyChange(event);
            }
            ((CardLayout)this.getLayout()).show(this, name);
            TFrame.repaintT(this);
        }
    }

    @Override
    public void refresh() {
        if (Tracker.timeLogEnabled) {
            Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh");
        }
        this.refreshing = true;
        TTrack selectedTrack = this.getSelectedTrack();
        TTrack defaultTrack = null;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        HashMap<TTrack, TrackView> newViews = new HashMap<TTrack, TrackView>();
        this.removeAll();
        this.tracks.clear();
        this.trackComboBox.removeAllItems();
        for (TTrack track : trackerPanel.getTracksTemp()) {
            TrackView trackView;
            if (!track.isViewable()) continue;
            if (defaultTrack == null) {
                defaultTrack = track;
            }
            if ((trackView = this.getTrackView(track)) == null) {
                trackView = this.createTrackView(track);
            }
            trackView.refreshGUI();
            newViews.put(track, trackView);
            String trackName = track.getName("point");
            Object[] item = new Object[]{trackView.getIcon(), trackName};
            this.trackComboBox.addItem(item);
            this.add((Component)trackView, trackName);
            this.tracks.put(item, track);
        }
        trackerPanel.clearTemp();
        this.validate();
        this.trackViews = newViews;
        this.refreshing = false;
        this.setSelectedTrack(selectedTrack == null || this.getTrackView(selectedTrack) == null ? defaultTrack : selectedTrack);
        this.trackComboBox.setToolTipText(TrackerRes.getString("TrackChooserTView.DropDown.Tooltip"));
    }

    protected abstract void refreshMenus();

    protected void getMenuItems() {
    }

    protected boolean isTrackViewDisplayed(TTrack track) {
        return track == this.getSelectedTrack() && TViewChooser.isSelectedView(this);
    }

    @Override
    public void init() {
        this.setLayout(new CardLayout());
        this.cleanup();
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.addListeners(panelProps, this);
        for (TTrack track : trackerPanel.getTracksTemp()) {
            track.addListenerNCF(this);
        }
        trackerPanel.clearTemp();
    }

    @Override
    public void cleanup() {
        if (this.panelID == null) {
            return;
        }
        this.getPanel().removeListeners(panelProps, this);
        for (TTrack t : TTrack.getValues()) {
            t.removeListenerNCF(this);
        }
    }

    @Override
    public void dispose() {
        this.cleanup();
        if (this.trackViews == null) {
            return;
        }
        for (Map.Entry<TTrack, TrackView> next : this.trackViews.entrySet()) {
            next.getValue().dispose();
            next.getKey().removeListenerNCF(this);
        }
        this.trackViews.clear();
        this.tracks.clear();
        this.setSelectedTrack(null);
        this.remove(this.noData);
        super.dispose();
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.getPanel();
    }

    public TTrack getSelectedTrack() {
        return this.selectedTrack;
    }

    public void setSelectedTrack(TTrack track) {
        if (track == null) {
            return;
        }
        TrackerPanel trackerPanel = this.getPanel();
        if (!trackerPanel.containsTrack(track) || !track.isViewable()) {
            return;
        }
        if (track == this.selectedTrack && this.tracks.get(this.trackComboBox.getSelectedItem()) == track) {
            this.getTrackView(this.selectedTrack).refresh(trackerPanel.getFrameNumber(), 6656);
            return;
        }
        Iterator<Object> it = this.tracks.keySet().iterator();
        if (!it.hasNext()) {
            this.selectedTrack = track;
        }
        while (it.hasNext()) {
            Object item = it.next();
            if (this.tracks.get(item) != track) continue;
            track.removeListenerNCF(this);
            track.addListenerNCF(this);
            this.trackComboBox.setSelectedItem(item);
            break;
        }
    }

    public TrackView getTrackView(TTrack track) {
        return this.trackViews == null ? null : this.trackViews.get(track);
    }

    @Override
    public abstract String getViewName();

    @Override
    public ArrayList<Component> getToolBarComponents() {
        this.toolbarComponents.clear();
        TrackView trackView = this.getTrackView(this.getSelectedTrack());
        if (trackView != null) {
            this.toolbarComponents.add(trackView.getViewButton());
        }
        if (this.trackComboBox.getItemCount() > 0) {
            this.toolbarComponents.add(this.trackComboBox);
        }
        if (trackView != null) {
            this.toolbarComponents.addAll(trackView.getToolBarComponents());
        } else {
            switch (this.getViewType()) {
                case 1: {
                    this.viewTypeLabel.setText(TrackerRes.getString("TFrame.View.Table"));
                    break;
                }
                case 0: {
                    this.viewTypeLabel.setText(TrackerRes.getString("TFrame.View.Plot"));
                }
            }
            this.toolbarComponents.add(this.viewTypeLabel);
        }
        return this.toolbarComponents;
    }

    @Override
    public boolean isCustomState() {
        if (this.trackViews == null) {
            return false;
        }
        Iterator<TTrack> it = this.trackViews.keySet().iterator();
        while (it.hasNext()) {
            TrackView view = this.trackViews.get(it.next());
            if (!view.isCustomState()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (ignoreRefresh) {
            return;
        }
        TrackerPanel panel = this.getPanel();
        switch (e.getPropertyName()) {
            case "track": {
                TTrack track = (TTrack)e.getOldValue();
                if (track != null) {
                    TrackView view;
                    track.removeListenerNCF(this);
                    TrackView trackView = view = this.trackViews == null ? null : this.trackViews.get(track);
                    if (view != null) {
                        view.dispose();
                        this.trackViews.remove(track);
                    }
                }
                this.refresh();
                if (this.frame != null) {
                    TFrame.repaintT(this.frame);
                }
                if ((track = (TTrack)e.getNewValue()) == null) break;
                this.setSelectedTrack(track);
                break;
            }
            case "clear": {
                for (TTrack t : TTrack.getValues()) {
                    t.removeListenerNCF(this);
                    TrackView view = this.trackViews.get(t);
                    if (view == null) continue;
                    view.dispose();
                    this.trackViews.remove(t);
                }
                this.refresh();
                if (this.frame == null) break;
                TFrame.repaintT(this.frame);
                break;
            }
            case "transform": {
                ImageCoordSystem coords;
                TrackView view;
                TTrack track = this.getSelectedTrack();
                if (track == null || (view = this.getTrackView(track)) == null) break;
                if (track instanceof ParticleModel && (coords = panel.getCoords()).isAdjusting()) {
                    return;
                }
                Step step = track.getStep(panel.getSelectedPoint(), panel);
                view.refresh(step == null ? panel.getFrameNumber() : step.getFrameNumber(), 6912);
                break;
            }
            case "data": {
                if (Integer.valueOf(0x830000).equals(e.getOldValue()) && this instanceof PlotTView) {
                    for (TrackView nextView : this.trackViews.values()) {
                        PlotTrackView plotView = (PlotTrackView)nextView;
                        TrackPlottingPanel[] trackPlottingPanelArray = plotView.plots;
                        int n = plotView.plots.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TrackPlottingPanel plot = trackPlottingPanelArray[n2];
                            plot.refreshDecimalSeparators();
                            ++n2;
                        }
                    }
                }
                TrackView view = null;
                TTrack track = this.getSelectedTrack();
                if (track == null || (view = this.getTrackView(track)) == null) break;
                int frameNo = panel.getFrameNumber();
                if (e.getNewValue() == Boolean.FALSE) {
                    view.setClipAdjusting(frameNo, false);
                    view.refresh(frameNo, 0x8000000);
                    break;
                }
                if (e.getNewValue() == Boolean.TRUE) {
                    view.setClipAdjusting(frameNo, true);
                    break;
                }
                view.refresh(frameNo, 7168);
                break;
            }
            case "radian_angles": 
            case "function": {
                for (TTrack t : panel.getTracks()) {
                    TrackView view = this.getTrackView(t);
                    if (view == null) continue;
                    view.refreshGUI();
                    view.refresh(panel.getFrameNumber(), 7424);
                }
                break;
            }
            case "stepnumber": {
                TrackView view;
                TTrack track = this.getSelectedTrack();
                if (track == null || (view = this.getTrackView(track)) == null) break;
                view.refresh(panel.getFrameNumber(), 0x840000);
                break;
            }
            case "image": {
                TrackView view;
                TTrack track = this.getSelectedTrack();
                if (track == null || (view = this.getTrackView(track)) == null || track.ttype != 3 && track.ttype != 7) break;
                view.refresh(panel.getFrameNumber(), 5376);
                break;
            }
            case "footprint": 
            case "name": 
            case "color": {
                TrackView view;
                TTrack track = (TTrack)e.getSource();
                if (this.trackViews != null && (view = this.trackViews.get(track)) != null) {
                    view.trackIcon = null;
                }
                this.refresh();
            }
        }
    }

    protected abstract TrackView createTrackView(TTrack var1);

    protected TTrack getTrack(String name) {
        return this.getPanel().getTrackByName(TTrack.class, name);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void repaint() {
        if (this.panelID != null && this.getPanel().isPaintable()) {
            super.repaint();
        }
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.panelID + " selected=" + this.selectedTrack + " views=" + (this.trackViews == null ? 0 : this.trackViews.size()) + " tracks=" + this.tracks.size() + "]";
    }
}

