/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class TrackControl
extends JDialog
implements OSPRuntime.Disposable,
PropertyChangeListener {
    private static final String[] panelProps = new String[]{"track", "clear", "mass", "footprint", "data"};
    protected static Map<Integer, TrackControl> panelTrackcontrols = new HashMap<Integer, TrackControl>();
    protected TFrame frame;
    protected Integer panelID;
    protected JPopupMenu popup;
    protected JPanel trackBarPanel;
    protected JToolBar[] trackBars = new JToolBar[0];
    protected boolean positioned = false;
    protected int trackCount;
    protected boolean wasVisible;
    protected KeyListener shiftKeyListener;
    protected TButton newTrackButton;
    private ComponentListener myFollower;

    public static synchronized TrackControl getControl(TrackerPanel panel) {
        TrackControl control = panelTrackcontrols.get(panel.getID());
        if (control == null) {
            control = new TrackControl(panel);
            panelTrackcontrols.put(panel.getID(), control);
            panel.trackControl = control;
        }
        return control;
    }

    private TrackControl(final TrackerPanel panel) {
        super((Frame)panel.getTFrame(), false);
        this.panelID = panel.getID();
        this.frame = panel.getTFrame();
        this.trackBarPanel = new JPanel();
        this.setContentPane(this.trackBarPanel);
        this.shiftKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TrackerPanel trackerPanel = TrackControl.this.frame.getTrackerPanelForID(TrackControl.this.panelID);
                if (e.getKeyCode() == 16) {
                    trackerPanel.requestFocus();
                    trackerPanel.requestFocusInWindow();
                } else if (e.getKeyCode() == 65) {
                    MainTView mainView = trackerPanel.getTFrame().getMainView(trackerPanel);
                    mainView.keyAdapter.keyPressed(e);
                    trackerPanel.requestFocus();
                    trackerPanel.requestFocusInWindow();
                }
            }
        };
        this.newTrackButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                TMenuBar.refreshPopup(panel, "TrackControl.tracks", TrackControl.this.popup);
                return TrackControl.this.popup;
            }
        };
        this.setResizable(false);
        this.pack();
        this.popup = new JPopupMenu();
        panel.addListeners(panelProps, this);
        this.myFollower = this.frame.addFollower(this, null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = Math.max(150, dim.width);
        return dim;
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.panelID == null) {
            return;
        }
        if (!this.positioned && vis) {
            this.positionForFrame();
        }
        if (vis && this.trackCount == 0 && !this.isEmpty()) {
            this.refresh();
        }
        super.setVisible(vis);
        this.wasVisible = vis;
        TToolBar toolbar = this.frame.getToolBar(this.panelID, false);
        if (toolbar != null) {
            toolbar.trackControlButton.setSelected(vis);
        }
    }

    private void positionForFrame() {
        if (this.positioned) {
            return;
        }
        if (!this.frame.isVisible()) {
            return;
        }
        Point p = this.frame.getLocationOnScreen();
        this.setLocation(p.x + this.frame.getWidth() / 2 - this.getWidth() / 2, p.y + 90);
        this.positioned = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "tab": {
                TrackerPanel p = (TrackerPanel)e.getNewValue();
                if (p == null) {
                    return;
                }
                if (p.getID() == this.panelID && !this.frame.isRemovingAll()) {
                    this.setVisible(this.wasVisible);
                    break;
                }
                boolean vis = this.wasVisible;
                this.setVisible(false);
                this.wasVisible = vis;
                break;
            }
            case "track": {
                if (e.getOldValue() == null) break;
                ((TTrack)e.getOldValue()).removeListenerNCF(this);
                break;
            }
            case "clear": {
                for (TTrack t : TTrack.getValues()) {
                    t.removeListenerNCF(this);
                }
                return;
            }
        }
        this.refresh();
    }

    public boolean isEmpty() {
        return false;
    }

    protected void refresh() {
        ResizableIcon icon;
        if (this.panelID == null) {
            return;
        }
        this.setTitle(TrackerRes.getString("TrackControl.Name"));
        if (TToolBar.pointmassOffIcon instanceof ResizableIcon && (icon = (ResizableIcon)TToolBar.pointmassOffIcon).getBaseIcon() instanceof ImageIcon) {
            ImageIcon imgIcon = (ImageIcon)icon.getBaseIcon();
            this.setIconImage(imgIcon.getImage());
        }
        int perbar = 4;
        ArrayList<TTrack> tracks = this.frame.getTrackerPanelForID(this.panelID).getUserTracks();
        int i = 0;
        while (i < this.trackBars.length) {
            this.trackBars[i].removeAll();
            ++i;
        }
        int barCount = 1 + tracks.size() / perbar;
        this.trackBarPanel.removeAll();
        this.trackBarPanel.setLayout(new GridLayout(barCount, 1));
        if (barCount > this.trackBars.length) {
            JToolBar[] newBars = new JToolBar[barCount];
            System.arraycopy(this.trackBars, 0, newBars, 0, this.trackBars.length);
            int i2 = this.trackBars.length;
            while (i2 < barCount) {
                newBars[i2] = new JToolBar();
                newBars[i2].setFloatable(false);
                ++i2;
            }
            this.trackBars = newBars;
        }
        int i3 = 0;
        while (i3 < barCount) {
            this.trackBarPanel.add(this.trackBars[i3]);
            ++i3;
        }
        this.newTrackButton.setText(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
        this.newTrackButton.setToolTipText(TrackerRes.getString("TrackControl.Button.NewTrack.ToolTip"));
        FontSizer.setFont(this.newTrackButton);
        this.trackBars[0].add(this.newTrackButton);
        this.trackCount = 0;
        TTrack track = null;
        Iterator<TTrack> it = tracks.iterator();
        while (it.hasNext()) {
            int barIndex = (this.trackCount + 1) / perbar;
            track = it.next();
            track.removeListenerNCF(this);
            track.addListenerNCF(this);
            TButton button = new TButton(track);
            button.addKeyListener(this.shiftKeyListener);
            this.trackBars[barIndex].add(button);
            ++this.trackCount;
        }
        FontSizer.setFonts(this);
        this.pack();
        TFrame.repaintT(this);
        if (this.frame != null) {
            this.frame.removePropertyChangeListener("tab", this);
            this.frame.addPropertyChangeListener("tab", this);
        }
    }

    @Override
    public void dispose() {
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            trackerPanel.removeListeners(panelProps, this);
            if (this.frame != null) {
                this.frame.removePropertyChangeListener("tab", this);
                this.frame.removeComponentListener(this.myFollower);
                this.myFollower = null;
            }
            panelTrackcontrols.remove(this.panelID);
            trackerPanel.trackControl = null;
            ArrayList<TTrack> tracks = trackerPanel.getTracks();
            int i = tracks.size();
            while (--i >= 0) {
                tracks.get(i).removeListenerNCF(this);
            }
            Object var1_1 = null;
        }
        super.dispose();
    }

    public void finalize() {
        OSPLog.finalized(this);
    }
}

