/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.AbstractAutoloadManager;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class TrackDataBuilder
extends FunctionTool {
    private static Icon openIcon;
    private static Icon saveIcon;
    private TFrame frame;
    private Integer panelID;
    private JButton loadButton;
    private JButton saveButton;
    private JButton autoloadButton;
    private AutoloadManager autoloadManager;

    protected TrackDataBuilder(TrackerPanel trackerPanel) {
        super(trackerPanel, false, true);
        this.panelID = trackerPanel.getID();
        this.frame = trackerPanel.getTFrame();
        this.addPropertyChangeListener("panel", trackerPanel);
        this.addPropertyChangeListener("function", trackerPanel);
        this.addPropertyChangeListener("ft_visible", trackerPanel);
        ArrayList<Drawable> nogos = trackerPanel.getSystemDrawables();
        for (TTrack track : trackerPanel.getTracksTemp()) {
            if (nogos.contains(track)) continue;
            FunctionPanel panel = trackerPanel.createFunctionPanel(track);
            this.addPanel(track.getName(), panel);
        }
        trackerPanel.clearTemp();
        this.setHelpPath("data_builder_help.html");
    }

    @Override
    protected void createGUI() {
        super.createGUI();
        this.createButtons();
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton, Box.createHorizontalGlue(), this.autoloadButton});
        this.setHelpAction(e -> this.frame.showHelp("datatable#databuilder", 0));
    }

    protected void createButtons() {
        if (openIcon == null) {
            openIcon = Tracker.getResourceIcon("open.gif", true);
            saveIcon = Tracker.getResourceIcon("save.gif", true);
        }
        this.loadButton = new JButton(openIcon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackDataBuilder.this.loadXMLFromDialog();
            }
        });
        this.saveButton = new JButton(saveIcon);
        final ActionListener saveBuilderAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final XMLControlElement control = new XMLControlElement(TrackDataBuilder.this);
                TrackDataBuilder.this.chooseBuilderDataFunctions(control, "Save", null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackDataBuilder.this.saveBuilderAction(control);
                    }
                });
            }
        };
        final ActionListener savePanelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final XMLControlElement control = new XMLControlElement(TrackDataBuilder.this.getSelectedPanel());
                TrackDataBuilder.this.choosePanelDataFunctions(control, "Save", null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackDataBuilder.this.savePanelAction(control);
                    }
                });
            }
        };
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem item = new JMenuItem(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveAll.Text"));
                item.setToolTipText(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveAll.Tooltip"));
                popup.add(item);
                item.addActionListener(saveBuilderAction);
                String s = " " + TrackDataBuilder.this.getSelectedPanel().getName();
                item = new JMenuItem(String.valueOf(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveOnly.Text")) + s);
                item.setToolTipText(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveOnly.Tooltip"));
                popup.add(item);
                item.addActionListener(savePanelAction);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                popup.show(TrackDataBuilder.this.saveButton, 0, TrackDataBuilder.this.saveButton.getHeight());
            }
        });
        this.autoloadButton = new JButton();
        this.autoloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoloadManager manager = TrackDataBuilder.this.getAutoloadManager();
                manager.refreshAutoloadData();
                manager.setVisible(true);
            }
        });
    }

    protected void savePanelAction(XMLControl control) {
        AsyncFileChooser chooser = OSPRuntime.createChooser(TrackerRes.getString("TrackerPanel.DataBuilder.Save.Title"), TrackerRes.getString("TrackerPanel.DataBuilder.Chooser.XMLFiles"), new String[]{"xml"});
        int result = ((JFileChooser)chooser).showSaveDialog(this);
        if (result == 0) {
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            File file = chooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (!"xml".equals(XML.getExtension(fileName))) {
                fileName = String.valueOf(XML.stripExtension(fileName)) + ".xml";
                file = new File(fileName);
            }
            if (!TrackerIO.canWrite(file)) {
                return;
            }
            control.write(fileName);
        }
    }

    protected void saveBuilderAction(XMLControl control) {
        AsyncFileChooser chooser = OSPRuntime.createChooser(TrackerRes.getString("TrackerPanel.DataBuilder.Save.Title"), TrackerRes.getString("TrackerPanel.DataBuilder.Chooser.XMLFiles"), new String[]{"xml"});
        int result = ((JFileChooser)chooser).showSaveDialog(this);
        if (result == 0) {
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            File file = chooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (!"xml".equals(XML.getExtension(fileName))) {
                fileName = String.valueOf(XML.stripExtension(fileName)) + ".xml";
                file = new File(fileName);
            }
            if (!TrackerIO.canWrite(file)) {
                return;
            }
            control.write(fileName);
        }
    }

    protected void loadXMLFromDialog() {
        final AsyncFileChooser chooser = OSPRuntime.createChooser(TrackerRes.getString("TrackerPanel.DataBuilder.Load.Title"), TrackerRes.getString("TrackerPanel.DataBuilder.Chooser.XMLFiles"), new String[]{"xml"});
        chooser.showOpenDialog(this, new Runnable(){

            @Override
            public void run() {
                OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                XMLControlElement control = new XMLControlElement(chooser.getSelectedFile());
                if (control.failedToRead()) {
                    JOptionPane.showMessageDialog(TrackDataBuilder.this.frame, TrackerRes.getString("Tracker.Dialog.Invalid.Message"), TrackerRes.getString("Tracker.Dialog.Invalid.Title"), 0);
                    return;
                }
                Class<?> type = control.getObjectClass();
                if (DataFunctionPanel.class.isAssignableFrom(type)) {
                    TrackDataBuilder.this.loadXMLDataFunction(control);
                } else if (TrackDataBuilder.class.isAssignableFrom(type)) {
                    TrackDataBuilder.this.loadXMLTrackData(control);
                } else {
                    JOptionPane.showMessageDialog(TrackDataBuilder.this.frame, TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongType.Message"), TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongType.Title"), 0);
                }
            }
        }, null);
    }

    protected void loadXMLTrackData(XMLControl control) {
        final FunctionPanel dataPanel = this.getSelectedPanel();
        final String panelTrackType = dataPanel.getDescription();
        XMLControl target = null;
        block0: for (XMLProperty next : control.getPropsRaw()) {
            XMLControl[] panels;
            if (!next.getPropertyName().equals("functions")) continue;
            XMLControl[] xMLControlArray = panels = next.getChildControls();
            int n = panels.length;
            int n2 = 0;
            while (n2 < n) {
                XMLControl panelControl = xMLControlArray[n2];
                String trackType = panelControl.getString("description");
                if (trackType != null && panelTrackType != null && panelTrackType.equals(trackType)) {
                    target = panelControl;
                    break block0;
                }
                ++n2;
            }
        }
        final XMLControl targetControl = target;
        String trackType = TrackerRes.getString("TrackerPanel.DataBuilder.TrackType.Unknown");
        if (panelTrackType != null) {
            trackType = TrackerRes.getString(String.valueOf(XML.getExtension(panelTrackType)) + ".Name").toLowerCase();
        }
        if (target == null) {
            JOptionPane.showMessageDialog(this.frame, String.valueOf(TrackerRes.getString("TrackDataBuilder.Dialog.NoFunctionsFound.Message")) + " \"" + trackType + ".\"", TrackerRes.getString("TrackDataBuilder.Dialog.NoFunctionsFound.Title"), 0);
            return;
        }
        final XMLControl finalTarget = target;
        final String ttype = trackType;
        this.choosePanelDataFunctions(target, "Load", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    if (panelTrackType == null || targetControl == null) {
                        return;
                    }
                    final ArrayList<FunctionPanel> panelsToLoad = new ArrayList<FunctionPanel>();
                    for (String name : TrackDataBuilder.this.getPanelNames()) {
                        FunctionPanel nextPanel = TrackDataBuilder.this.getPanel(name);
                        if (!panelTrackType.equalsIgnoreCase(nextPanel.getDescription())) continue;
                        panelsToLoad.add(nextPanel);
                    }
                    if (panelsToLoad.size() <= 1) {
                        finalTarget.loadObject(dataPanel);
                    } else {
                        Object[] options = new String[]{TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.All"), String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.Only")) + " " + dataPanel.getName(), TrackerRes.getString("Dialog.Button.Cancel")};
                        new AsyncDialog().showOptionDialog(TrackDataBuilder.this, String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Message")) + " \"" + ttype + "\"?", TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Title"), -1, 3, null, options, options[0], new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                switch (e.getActionCommand()) {
                                    case "0": {
                                        for (FunctionPanel nextPanel : panelsToLoad) {
                                            targetControl.loadObject(nextPanel);
                                        }
                                        break;
                                    }
                                    case "1": {
                                        targetControl.loadObject(dataPanel);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    protected void loadXMLDataFunction(final XMLControl control) {
        final FunctionPanel dataPanel = this.getSelectedPanel();
        Class<?> panelType = null;
        Class<?> controlType = null;
        try {
            panelType = Class.forName(dataPanel.getDescription());
            controlType = Class.forName(control.getString("description"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String trackType = TrackerRes.getString("TrackerPanel.DataBuilder.TrackType.Unknown");
        if (controlType != null) {
            trackType = TrackerRes.getString(String.valueOf(controlType.getSimpleName()) + ".Name").toLowerCase();
        }
        if (controlType != panelType && panelType != null) {
            String targetType = TrackerRes.getString(String.valueOf(panelType.getSimpleName()) + ".Name").toLowerCase();
            JOptionPane.showMessageDialog(this.frame, String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongTrackType.Message1")) + " \"" + trackType + ".\"" + "\n" + TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongTrackType.Message2") + " \"" + targetType + ".\"", TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongTrackType.Title"), 0);
            return;
        }
        final Class<?> ptype = panelType;
        final Class<?> ctype = controlType;
        final String ttype = trackType;
        this.choosePanelDataFunctions(control, "Load", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    Class<?> panelType = ptype;
                    final ArrayList<FunctionPanel> panelsToLoad = new ArrayList<FunctionPanel>();
                    for (String name : TrackDataBuilder.this.getPanelNames()) {
                        FunctionPanel nextPanel = TrackDataBuilder.this.getPanel(name);
                        try {
                            panelType = Class.forName(nextPanel.getDescription());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (panelType != ctype) continue;
                        panelsToLoad.add(nextPanel);
                    }
                    if (panelsToLoad.size() <= 1) {
                        control.loadObject(dataPanel);
                    } else {
                        Object[] options = new String[]{TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.All"), String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.Only")) + " " + dataPanel.getName(), TrackerRes.getString("Dialog.Button.Cancel")};
                        new AsyncDialog().showOptionDialog(TrackDataBuilder.this, String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Message")) + " \"" + ttype + "\"?", TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Title"), -1, 3, null, options, options[0], new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                switch (e.getActionCommand()) {
                                    case "0": {
                                        for (FunctionPanel nextPanel : panelsToLoad) {
                                            control.loadObject(nextPanel);
                                        }
                                        break;
                                    }
                                    case "1": {
                                        control.loadObject(dataPanel);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    protected void setTitles() {
        this.dropdownTipText = TrackerRes.getString("TrackerPanel.DataBuilder.Dropdown.Tooltip");
        this.titleText = TrackerRes.getString("TrackerPanel.DataBuilder.Title");
    }

    @Override
    protected void refreshGUI() {
        if (!this.haveGUI()) {
            return;
        }
        super.refreshGUI();
        if (this.loadButton != null) {
            FunctionPanel panel = this.getSelectedPanel();
            this.loadButton.setEnabled(panel != null);
            this.saveButton.setEnabled(panel != null);
            this.loadButton.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Save.Tooltip"));
            this.autoloadButton.setText(String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Autoload")) + "...");
            this.autoloadButton.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Autoload.Tooltip"));
        }
        this.setFontLevel(FontSizer.getLevel());
        if (this.autoloadManager != null) {
            this.autoloadManager.refreshGUI();
        }
    }

    @Override
    public void setFontLevel(int level) {
        if (this.autoloadButton == null) {
            return;
        }
        FontSizer.setFonts(new Object[]{this.loadButton, this.saveButton, this.autoloadButton}, level);
        if (!this.trackFunctionPanels.isEmpty()) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            ArrayList<TTrack> tracks = trackerPanel.getTracksTemp();
            for (String name : this.trackFunctionPanels.keySet()) {
                TTrack track;
                FunctionPanel panel = (FunctionPanel)this.trackFunctionPanels.get(name);
                if (panel == null || (track = trackerPanel.getTrack(name, tracks)) == null) continue;
                panel.setIcon(track.getIcon(21, 16, "point"));
            }
            tracks.clear();
        }
        super.setFontLevel(level);
        this.validate();
        this.autoloadButton.revalidate();
    }

    @Override
    public void addPanel(String name, FunctionPanel panel) {
        super.addPanel(name, panel);
        if (!Tracker.haveDataFunctions()) {
            return;
        }
        Class<?> trackType = null;
        try {
            trackType = Class.forName(panel.getDescription());
            Tracker.loadControlStringObjects(trackType, panel);
            Tracker.loadControls(trackType, panel);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void choosePanelDataFunctions(final XMLControl control, String description, Collection<String[]> selectedFunctions, final ActionListener listener) {
        final ArrayList<String[]> originals = new ArrayList<String[]>();
        final ArrayList<String[]> choices = new ArrayList<String[]>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        final ArrayList functions = (ArrayList)control.getObject("functions");
        for (Object next : functions) {
            String[] function = (String[])next;
            originals.add(function);
            choices.add(function);
            names.add(function[0]);
            expressions.add(function[1]);
        }
        boolean[] selected = new boolean[choices.size()];
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ListChooser listChooser = new ListChooser(TrackerRes.getString("TrackerPanel.DataBuilder." + description + ".Title"), TrackerRes.getString("TrackerPanel.DataBuilder." + description + ".Message"), this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    for (Object next : originals) {
                        if (choices.contains(next)) continue;
                        functions.remove(next);
                    }
                    control.setValue("functions", functions);
                }
                listener.actionPerformed(e);
            }
        });
        listChooser.setSeparator(" = ");
        listChooser.choose(choices, names, expressions, null, selected, null);
    }

    protected void chooseBuilderDataFunctions(final XMLControl control, String description, Collection<String[]> selectedFunctions, final ActionListener listener) {
        final ArrayList<String[]> originals = new ArrayList<String[]>();
        final ArrayList<String[]> choices = new ArrayList<String[]>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        ArrayList<String> trackTypes = new ArrayList<String>();
        final TreeMap<String, XMLControl> xmlControlMap = new TreeMap<String, XMLControl>();
        final TreeMap parameterMap = new TreeMap();
        final TreeMap functionMap = new TreeMap();
        for (XMLProperty prop : control.getPropsRaw()) {
            XMLControl[] xMLControlArray = prop.getChildControls();
            int n = xMLControlArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLControl xmlControl = xMLControlArray[n2];
                if (xmlControl.getObjectClass() == DataFunctionPanel.class) {
                    Parameter[] panelParams;
                    String trackType = xmlControl.getString("description");
                    xmlControlMap.put(trackType, xmlControl);
                    ArrayList<String[]> functions = (ArrayList<String[]>)functionMap.get(trackType);
                    if (functions == null) {
                        functions = new ArrayList<String[]>();
                        functionMap.put(trackType, functions);
                    }
                    ArrayList panelFunctions = (ArrayList)xmlControl.getObject("functions");
                    block2: for (String[] f : panelFunctions) {
                        for (String[] existing : functions) {
                            if (existing[0].equals(f[0])) continue block2;
                        }
                        functions.add(f);
                    }
                    ArrayList<Parameter> params = (ArrayList<Parameter>)parameterMap.get(trackType);
                    if (params == null) {
                        params = new ArrayList<Parameter>();
                        parameterMap.put(trackType, params);
                    }
                    Parameter[] parameterArray = panelParams = (Parameter[])xmlControl.getObject("user_parameters");
                    int n3 = panelParams.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block15: {
                            Parameter p = parameterArray[n4];
                            if (!trackType.endsWith("PointMass") || !p.getName().equals("m")) {
                                for (Parameter existing : params) {
                                    if (!existing.getName().equals(p.getName())) {
                                        continue;
                                    }
                                    break block15;
                                }
                                params.add(p);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (String trackType : functionMap.keySet()) {
            ArrayList functions = (ArrayList)functionMap.get(trackType);
            for (String[] f : functions) {
                originals.add(f);
                choices.add(f);
                names.add(f[0]);
                expressions.add(f[1]);
                String shortName = XML.getExtension(trackType);
                String localized = TrackerRes.getString(String.valueOf(shortName) + ".Name");
                if (!localized.startsWith("!")) {
                    shortName = localized;
                }
                trackTypes.add("[" + shortName + "]");
            }
        }
        boolean[] selected = new boolean[choices.size()];
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ListChooser listChooser = new ListChooser(TrackerRes.getString("TrackerPanel.DataBuilder." + description + ".Title"), TrackerRes.getString("TrackerPanel.DataBuilder." + description + ".Message"), this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    for (String[] function : originals) {
                        if (choices.contains(function)) continue;
                        for (String trackType : xmlControlMap.keySet()) {
                            ArrayList functions = (ArrayList)functionMap.get(trackType);
                            functions.remove(function);
                        }
                    }
                    for (String trackType : xmlControlMap.keySet()) {
                        ArrayList functions = (ArrayList)functionMap.get(trackType);
                        ArrayList paramList = (ArrayList)parameterMap.get(trackType);
                        Parameter[] params = paramList.toArray(new Parameter[paramList.size()]);
                        XMLControl xmlControl = (XMLControl)xmlControlMap.get(trackType);
                        xmlControl.setValue("functions", functions);
                        xmlControl.setValue("user_parameters", params);
                    }
                    for (Object next : control.getPropertyContent()) {
                        if (!(next instanceof XMLProperty) || !((XMLProperty)next).getPropertyName().equals("functions")) continue;
                        XMLProperty panels = (XMLProperty)next;
                        List<Object> content = panels.getPropertyContent();
                        ArrayList<Object> toRemove = new ArrayList<Object>();
                        for (Object child : content) {
                            XMLControl xmlControl = ((XMLProperty)child).getChildControls()[0];
                            if (!xmlControlMap.values().contains(xmlControl)) {
                                toRemove.add(child);
                                continue;
                            }
                            ArrayList functions = (ArrayList)xmlControl.getObject("functions");
                            if (functions != null && !functions.isEmpty()) continue;
                            toRemove.add(child);
                        }
                        for (Object remove : toRemove) {
                            content.remove(remove);
                        }
                    }
                }
                listener.actionPerformed(e);
            }
        });
        listChooser.setSeparator(" = ");
        listChooser.choose(choices, names, expressions, trackTypes, selected, null);
    }

    protected AutoloadManager getAutoloadManager() {
        if (this.autoloadManager == null) {
            this.autoloadManager = new AutoloadManager(this);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.autoloadManager.getBounds().width) / 2;
            int y = (dim.height - this.autoloadManager.getBounds().height) / 2;
            this.autoloadManager.setLocation(x, y);
            if (Tracker.haveDataFunctions()) {
                Tracker.loadControlStrings(new Runnable(){

                    @Override
                    public void run() {
                        TrackDataBuilder.this.autoloadManager.refreshAutoloadData();
                    }
                });
            }
        }
        this.autoloadManager.setFontLevel(FontSizer.getLevel());
        return this.autoloadManager;
    }

    protected void addPanelWithoutAutoloading(String name, FunctionPanel panel) {
        super.addPanel(name, panel);
    }

    @Override
    public void dispose() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.removePropertyChangeListener("panel", trackerPanel);
        this.removePropertyChangeListener("function", trackerPanel);
        this.removePropertyChangeListener("ft_visible", trackerPanel);
        ToolsRes.removePropertyChangeListener("locale", this);
        if (this.autoloadManager != null) {
            this.autoloadManager.dispose();
        }
        for (String key : this.trackFunctionPanels.keySet()) {
            FunctionPanel next = (FunctionPanel)this.trackFunctionPanels.get(key);
            next.setFunctionTool(null);
        }
        this.clearPanels();
        this.selectedPanel = null;
        if (trackerPanel != null) {
            trackerPanel.dataBuilder = null;
        }
        trackerPanel = null;
        super.dispose();
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    class AutoloadManager
    extends AbstractAutoloadManager {
        public AutoloadManager(JDialog dialog) {
            super(dialog);
        }

        @Override
        public void setVisible(boolean vis) {
            super.setVisible(vis);
            if (!vis) {
                Tracker.autoloadDataFunctions();
                Tracker.savePreferences();
                for (String name : TrackDataBuilder.this.getPanelNames()) {
                    DataFunctionPanel panel = (DataFunctionPanel)TrackDataBuilder.this.getPanel(name);
                    TrackDataBuilder.this.addPanel(name, panel);
                }
                Collection<String> searchPaths = this.getSearchPaths();
                Collection<String> defaultPaths = Tracker.getDefaultAutoloadSearchPaths();
                boolean isDefault = searchPaths.size() == defaultPaths.size();
                for (String next : searchPaths) {
                    boolean bl = isDefault = isDefault && defaultPaths.contains(next);
                }
                Tracker.preferredAutoloadSearchPaths = isDefault ? null : searchPaths.toArray(new String[searchPaths.size()]);
            }
        }

        @Override
        protected void refreshGUI() {
            this.refreshAutoloadData();
            super.refreshGUI();
            String title = String.valueOf(TrackDataBuilder.this.getTitle()) + " " + this.getTitle();
            this.setTitle(title);
            this.setInstructions(String.valueOf(TrackerRes.getString("TrackDataBuilder.Instructions.SelectToAutoload")) + "\n\n" + TrackerRes.getString("TrackDataBuilder.Instructions.WhereDefined") + " " + TrackerRes.getString("TrackDataBuilder.Instructions.HowToAddFunction") + " " + TrackerRes.getString("TrackDataBuilder.Instructions.HowToAddDirectory"));
        }

        protected String getLocalizedTrackName(String trackClass) {
            String trackName = XML.getExtension(trackClass);
            String localized = TrackerRes.getString(String.valueOf(trackName) + ".Name");
            if (!localized.startsWith("!")) {
                trackName = localized;
            }
            return trackName;
        }

        @Override
        protected void refreshAutoloadData() {
            TreeMap<String, Map<String, ArrayList<String[]>>> data = new TreeMap<String, Map<String, ArrayList<String[]>>>();
            for (String path : this.getSearchPaths()) {
                Map<String, ArrayList<String[]>> functionMap = Tracker.findDataFunctions(path);
                data.put(path, functionMap);
            }
            this.setAutoloadData(data);
        }

        @Override
        public Collection<String> getSearchPaths() {
            Collection<String> paths = super.getSearchPaths();
            if (paths.isEmpty() && !this.initialized) {
                this.initialized = true;
                for (String next : Tracker.getInitialSearchPaths()) {
                    paths.add(next);
                    this.addSearchPath(next);
                }
            }
            return paths;
        }

        @Override
        protected Map<String, String[]> getExclusionsMap() {
            return Tracker.autoloadMap;
        }
    }
}

