/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.cabrillo.tracker.DerivativeAlgorithmDialog;
import org.opensourcephysics.cabrillo.tracker.PlotGuestDialog;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.StepSet;
import org.opensourcephysics.cabrillo.tracker.TCoordinateStringBuilder;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Tool;

public class TrackPlottingPanel
extends PlottingPanel
implements Tool {
    private static final int VAR_NAME_NULL = Integer.MIN_VALUE;
    private static final int VAR_NOT_FOUND = -2;
    protected TFrame frame;
    protected Integer panelID;
    protected int trackID;
    protected DatasetManager datasetManager;
    protected HighlightableDataset dataset = new HighlightableDataset();
    protected ArrayList<TTrack> guests = new ArrayList();
    protected HashMap<TTrack, HighlightableDataset> guestDatasets = new HashMap();
    private int xIndex = -1;
    private int yIndex = 0;
    private String xName;
    private String yName;
    protected JPopupMenu xPopup;
    protected JPopupMenu yPopup;
    protected JPopupMenu popup;
    protected JCheckBoxMenuItem linesItem;
    protected JCheckBoxMenuItem pointsItem;
    protected JMenuItem dataToolItem;
    private JRadioButtonMenuItem[] xChoices;
    private JRadioButtonMenuItem[] yChoices;
    private ButtonGroup xGroup;
    private ButtonGroup yGroup;
    protected Action dataFunctionListener;
    protected Action guestListener;
    private JMenuItem copyImageItem;
    private JMenuItem dataBuilderItem;
    private JMenuItem showXZeroItem;
    private JMenuItem showYZeroItem;
    private JMenuItem selectPointsItem;
    private JMenuItem deselectPointsItem;
    private JMenuItem algorithmItem;
    private JMenuItem printItem;
    private JMenuItem helpItem;
    private JMenuItem mergeYScalesItem;
    private JMenuItem guestsItem;
    protected String xLabel;
    protected String yLabel;
    protected String title;
    protected ItemListener xListener;
    protected ItemListener yListener;
    protected PlotTrackView plotTrackView;
    protected boolean isCustom;
    protected Font font = new JTextField().getFont();
    protected Rectangle hitRect = new Rectangle(24, 24);
    protected ClickableAxes plotAxes;
    protected boolean isZoomMode;
    protected PlotMouseListener mouseListener;
    protected PropertyChangeListener playerListener;
    protected Step clickedStep;
    protected TCoordinateStringBuilder coordStringBuilder;
    protected boolean linesItemSelected = true;
    protected boolean pointsItemSelected = true;
    private Map<String, Integer> htVarToItem = new LinkedHashMap<String, Integer>();
    private int datasetCount;
    boolean selectionEnabled = true;
    public final BitSet bsFrameHighlights = new BitSet();

    public TrackPlottingPanel(TTrack track, DatasetManager data) {
        super(" ", " ", " ");
        this.displayCoordsOnMouseMoved = false;
        this.frame = track.tframe;
        this.panelID = track.tp.getID();
        this.trackID = track.getID();
        this.datasetManager = data;
        this.dataset.setConnected(true);
        this.dataset.setMarkerShape(2);
        this.coordStringBuilder = new TCoordinateStringBuilder();
        this.setCoordinateStringBuilder(this.coordStringBuilder);
        this.setVariables();
        this.mouseListener = new PlotMouseListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TrackerPanel trackerPanel = TrackPlottingPanel.this.frame.getTrackerPanelForID(TrackPlottingPanel.this.panelID);
                VideoPlayer player = trackerPanel.getPlayer();
                if (!player.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 33: {
                        if (e.isShiftDown()) {
                            int n = player.getStepNumber() - 5;
                            player.setStepNumber(n);
                            break;
                        }
                        player.back();
                        break;
                    }
                    case 34: {
                        if (e.isShiftDown()) {
                            int n = player.getStepNumber() + 5;
                            player.setStepNumber(n);
                            break;
                        }
                        player.step();
                        break;
                    }
                    case 36: {
                        player.setStepNumber(0);
                        break;
                    }
                    case 35: {
                        VideoClip clip = player.getVideoClip();
                        player.setStepNumber(clip.getStepCount() - 1);
                        break;
                    }
                    case 127: {
                        trackerPanel.deleteSelectedSteps();
                        if (trackerPanel.getSelectedPoint() != null && trackerPanel.getSelectingPanelID() == trackerPanel.getID()) {
                            trackerPanel.deletePoint(trackerPanel.getSelectedPoint());
                        }
                        return;
                    }
                }
            }
        });
    }

    @Override
    protected void initAxes() {
        this.plotAxes = new ClickableAxes(this);
        this.setAxes(this.plotAxes);
    }

    @Override
    public void send(Job job, Tool noReply) {
        this.receiveToolReply(job);
        TFrame.repaintT(this);
    }

    public HighlightableDataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setXLabel(String label) {
        String units;
        this.dataset.setXYColumnNames(label, this.yLabel);
        this.xLabel = label;
        String xStr = String.valueOf(TeXParser.removeSubscripting(this.xLabel)) + "=";
        String yStr = "  " + TeXParser.removeSubscripting(this.yLabel) + "=";
        this.getCoordinateStringBuilder().setCoordinateLabels(xStr, yStr);
        TTrack track = TTrack.getTrack(this.trackID);
        if (track.tp != null && !"".equals(units = track.tp.getUnits(track, label))) {
            label = String.valueOf(label) + " (" + units.trim() + ")";
        }
        super.setXLabel(label);
    }

    public String getXLabel() {
        return this.xLabel;
    }

    @Override
    public void setYLabel(String label) {
        String units;
        this.yLabel = label;
        this.dataset.setXYColumnNames(this.xLabel, label);
        String xStr = String.valueOf(TeXParser.removeSubscripting(this.xLabel)) + "=";
        String yStr = "  " + TeXParser.removeSubscripting(this.yLabel) + "=";
        this.getCoordinateStringBuilder().setCoordinateLabels(xStr, yStr);
        TTrack track = TTrack.getTrack(this.trackID);
        if (track.tp != null && !"".equals(units = track.tp.getUnits(track, label))) {
            label = String.valueOf(label) + " (" + units.trim() + ")";
        }
        super.setYLabel(label);
    }

    public String getYLabel() {
        return this.yLabel;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
        this.dataset.setName(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void addGuest(TTrack guest) {
        if (guest == null || this.guests.contains(guest)) {
            return;
        }
        this.guests.add(guest);
        this.isCustom = true;
        HighlightableDataset guestDataset = this.guestDatasets.get(guest);
        if (guestDataset == null) {
            guestDataset = new HighlightableDataset();
            this.guestDatasets.put(guest, guestDataset);
        }
        guest.removeStepListener(this.plotTrackView);
        guest.addStepListener(this.plotTrackView);
    }

    public void removeGuest(TTrack guest) {
        this.guests.remove(guest);
        guest.removeStepListener(this.plotTrackView);
    }

    @Override
    public void scale(ArrayList<Drawable> list) {
        if (this.autoscaleXMin && !this.autoscaleXMax) {
            this.scaleXMin();
        } else if (!this.autoscaleXMin && this.autoscaleXMax) {
            this.scaleXMax();
        } else if (this.autoscaleXMin && this.autoscaleXMax) {
            this.scaleX(list);
        }
        if (this.autoscaleYMin && !this.autoscaleYMax) {
            this.scaleYMin();
        } else if (!this.autoscaleYMin && this.autoscaleYMax) {
            this.scaleYMax();
        } else if (this.autoscaleYMin && this.autoscaleYMax) {
            this.scaleY(list);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        String s;
        if (!Tracker.allowMenuRefresh) {
            return null;
        }
        if (this.popupmenu == null) {
            this.buildPopupMenu();
        }
        this.mergeYScalesItem.setText(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.MergeYAxes"));
        this.linesItem.setText(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.Lines"));
        this.pointsItem.setText(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.Points"));
        this.selectPointsItem.setText(TrackerRes.getString("MainTView.Popup.MenuItem.Select"));
        this.deselectPointsItem.setText(TrackerRes.getString("MainTView.Popup.MenuItem.Deselect"));
        this.printItem.setText(TrackerRes.getString("TActions.Action.Print"));
        this.copyImageItem.setText(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
        this.dataBuilderItem.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.dataToolItem.setText(TrackerRes.getString("TableTrackView.Popup.MenuItem.Analyze"));
        this.algorithmItem.setText(TrackerRes.getString("Popup.MenuItem.Algorithm"));
        this.helpItem.setText(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
        this.guestsItem.setText(String.valueOf(TrackerRes.getString("TrackPlottingPanel.Popup.Menu.CompareWith")) + "...");
        if (this.plotTrackView.getPlotCount() > 1) {
            this.popupmenu.add((Component)this.mergeYScalesItem, 3);
        } else {
            this.popupmenu.remove(this.mergeYScalesItem);
        }
        this.popupmenu.remove(this.showXZeroItem);
        this.popupmenu.remove(this.showYZeroItem);
        if (this.getXMin() * this.getXMax() > 0.0) {
            s = TeXParser.removeSubscripting(this.dataset.getColumnName(0));
            s = String.valueOf(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.ShowZero")) + " " + s + "=0";
            this.showXZeroItem.setText(s);
            this.popupmenu.insert(this.showXZeroItem, this.popupmenu.getComponentIndex(this.scaleItem));
        }
        if (this.getYMin() * this.getYMax() > 0.0) {
            s = TeXParser.removeSubscripting(this.dataset.getColumnName(1));
            s = String.valueOf(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.ShowZero")) + " " + s + "=0";
            this.showYZeroItem.setText(s);
            this.popupmenu.insert(this.showYZeroItem, this.popupmenu.getComponentIndex(this.scaleItem));
        }
        TTrack track = TTrack.getTrack(this.trackID);
        Class<PointMass> type = track.ttype == 5 ? PointMass.class : (track.ttype == 9 ? Vector.class : track.getClass());
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        ArrayList<PointMass> tracks = trackerPanel.getDrawablesTemp(type);
        tracks.removeAll(trackerPanel.calibrationTools);
        tracks.remove(track);
        this.guestsItem.setEnabled(!tracks.isEmpty());
        tracks.clear();
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        this.algorithmItem.setEnabled(track.ttype == 5);
        return this.popupmenu;
    }

    @Override
    public void snapshot() {
        BufferedImage image = new TrackerIO.ComponentImage(TViewChooser.getChooserParent(this)).getImage();
        int w = image.getWidth();
        int h = image.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        MeasuredImage mi = new MeasuredImage(image, 0.0, w, h, 0.0);
        OSPFrame frame = null;
        try {
            Class<?> type = Class.forName("org.opensourcephysics.frames.ImageFrame");
            Constructor<?>[] constructors = type.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == 1 && parameters[0] == MeasuredImage.class) {
                    frame = (OSPFrame)constructors[i].newInstance(mi);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (frame == null) {
            return;
        }
        frame.setTitle(DisplayRes.getString("Snapshot.Title"));
        frame.setDefaultCloseOperation(2);
        frame.setKeepHidden(false);
        FontSizer.setFonts(frame, FontSizer.getLevel());
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    protected void buildPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu(){

                @Override
                public void setVisible(boolean vis) {
                    super.setVisible(vis);
                    if (!vis) {
                        TrackPlottingPanel.this.zoomBox.hide();
                    }
                }
            };
            this.setPopupMenu(this.popup);
            super.buildPopupMenu();
            this.linesItem = new JCheckBoxMenuItem("lines", this.linesItemSelected);
            this.pointsItem = new JCheckBoxMenuItem("points", this.pointsItemSelected);
            this.dataToolItem = new JMenuItem("datatool");
            this.linesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackPlottingPanel.this.dataset.setConnected(TrackPlottingPanel.this.linesItem.isSelected());
                    for (TTrack next : TrackPlottingPanel.this.guests) {
                        HighlightableDataset nextDataset = TrackPlottingPanel.this.guestDatasets.get(next);
                        nextDataset.setConnected(TrackPlottingPanel.this.linesItem.isSelected());
                    }
                    TrackPlottingPanel.this.isCustom = true;
                    TFrame.repaintT(TrackPlottingPanel.this);
                }
            });
            this.linesItem.setSelected(true);
            this.pointsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrackPlottingPanel.this.pointsItem.isSelected()) {
                        TrackPlottingPanel.this.dataset.setMarkerShape(2);
                        for (TTrack next : TrackPlottingPanel.this.guests) {
                            HighlightableDataset nextDataset = TrackPlottingPanel.this.guestDatasets.get(next);
                            nextDataset.setMarkerShape(2);
                        }
                    } else {
                        TrackPlottingPanel.this.dataset.setMarkerShape(0);
                        for (TTrack next : TrackPlottingPanel.this.guests) {
                            HighlightableDataset nextDataset = TrackPlottingPanel.this.guestDatasets.get(next);
                            nextDataset.setMarkerShape(0);
                        }
                    }
                    TrackPlottingPanel.this.isCustom = true;
                    TFrame.repaintT(TrackPlottingPanel.this);
                }
            });
            this.pointsItem.setSelected(true);
            this.showXZeroItem = new JMenuItem();
            this.showXZeroItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackPlottingPanel.this.showZeroOnAxis("x");
                }
            });
            this.showYZeroItem = new JMenuItem();
            this.showYZeroItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackPlottingPanel.this.showZeroOnAxis("y");
                }
            });
            this.printItem = new JMenuItem();
            this.printItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TViewChooser chooser = TrackPlottingPanel.this.getOwner();
                    if (chooser != null) {
                        new TrackerIO.ComponentImage(chooser).print();
                    }
                }
            });
            this.dataToolItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackPlottingPanel.this.showDataTool();
                }
            });
            this.algorithmItem = new JMenuItem();
            this.algorithmItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DerivativeAlgorithmDialog dialog = TrackPlottingPanel.this.frame.getTrackerPanelForID(TrackPlottingPanel.this.panelID).getAlgorithmDialog();
                    TTrack track = TTrack.getTrack(TrackPlottingPanel.this.trackID);
                    if (track.ttype == 5) {
                        dialog.setTargetMass((PointMass)track);
                    }
                    FontSizer.setFonts(dialog, FontSizer.getLevel());
                    dialog.pack();
                    dialog.setVisible(true);
                }
            });
            AbstractAction copyImageAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TViewChooser chooser = TrackPlottingPanel.this.getOwner();
                    if (chooser != null) {
                        new TrackerIO.ComponentImage(chooser).copyToClipboard();
                    }
                }
            };
            this.copyImageItem = new JMenuItem(copyImageAction);
            this.dataFunctionListener = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TTrack track = TTrack.getTrack(TrackPlottingPanel.this.trackID);
                    TrackerPanel trackerPanel = TrackPlottingPanel.this.frame.getTrackerPanelForID(TrackPlottingPanel.this.panelID);
                    trackerPanel.getDataBuilder().setSelectedPanel(track.getName());
                    trackerPanel.getDataBuilder().setVisible(true);
                }
            };
            this.dataBuilderItem = new JMenuItem();
            this.dataBuilderItem.addActionListener(this.dataFunctionListener);
            this.helpItem = new JMenuItem();
            this.helpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Container c = TrackPlottingPanel.this.getTopLevelAncestor();
                    if (c instanceof TFrame) {
                        TFrame frame = (TFrame)c;
                        frame.showHelp("plot", 0);
                    }
                }
            });
            this.mergeYScalesItem = new JMenuItem();
            this.mergeYScalesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (TrackPlottingPanel.this.plotTrackView.getPlotCount()) {
                        case 2: {
                            TrackPlottingPanel.this.plotTrackView.syncYAxes(TrackPlottingPanel.this.plotTrackView.plots[0], TrackPlottingPanel.this.plotTrackView.plots[1]);
                            break;
                        }
                        case 3: {
                            TrackPlottingPanel.this.plotTrackView.syncYAxes(TrackPlottingPanel.this.plotTrackView.plots);
                        }
                    }
                }
            });
        }
        this.guestsItem = new JMenuItem();
        this.guestsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotGuestDialog dialog = TrackPlottingPanel.this.frame.getTrackerPanelForID(TrackPlottingPanel.this.panelID).getPlotGuestDialog(TrackPlottingPanel.this);
                dialog.setLocationRelativeTo(TrackPlottingPanel.this);
                dialog.setVisible(true);
            }
        });
        AbstractAction selectAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackPlottingPanel.this.selectAction(e.getSource());
            }
        };
        this.selectPointsItem = new JMenuItem();
        this.selectPointsItem.addActionListener(selectAction);
        this.deselectPointsItem = new JMenuItem();
        this.deselectPointsItem.addActionListener(selectAction);
        this.popupmenu.removeAll();
        this.popupmenu.add(this.zoomInItem);
        this.popupmenu.add(this.zoomOutItem);
        this.popupmenu.add(this.autoscaleItem);
        this.popupmenu.add(this.showYZeroItem);
        this.popupmenu.add(this.showXZeroItem);
        this.popupmenu.add(this.scaleItem);
        this.popupmenu.addSeparator();
        this.popupmenu.add(this.selectPointsItem);
        this.popupmenu.add(this.deselectPointsItem);
        this.popupmenu.addSeparator();
        this.popupmenu.add(this.pointsItem);
        this.popupmenu.add(this.linesItem);
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            if (trackerPanel.isEnabled("edit.copyImage")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.copyImageItem);
                this.popupmenu.add(this.snapshotItem);
            }
            if (trackerPanel.isEnabled("plot.compare")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.guestsItem);
            }
            if (trackerPanel.isEnabled("data.builder") || trackerPanel.isEnabled("data.tool")) {
                this.popupmenu.addSeparator();
                if (trackerPanel.isEnabled("data.builder")) {
                    this.popupmenu.add(this.dataBuilderItem);
                }
                if (trackerPanel.isEnabled("data.tool")) {
                    this.popupmenu.add(this.dataToolItem);
                }
            }
            if (trackerPanel.isEnabled("data.algorithm")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.algorithmItem);
            }
            if (trackerPanel.isEnabled("file.print")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.printItem);
            }
        }
        this.popupmenu.addSeparator();
        this.popupmenu.add(this.helpItem);
    }

    protected void selectAction(Object source) {
        int frame;
        Rectangle rect = this.zoomBox.reportZoom();
        double x = this.pixToX(rect.x);
        double x2 = this.pixToX(rect.x + rect.width);
        double y = this.pixToY(rect.y + rect.height);
        double y2 = this.pixToY(rect.y);
        double xmin = Math.min(x, x2);
        double xmax = Math.max(x, x2);
        double ymin = Math.min(y, y2);
        double ymax = Math.max(y, y2);
        double[] xPoints = this.dataset.getXPointsRaw();
        double[] yPoints = this.dataset.getYPointsRaw();
        int len = this.dataset.getIndex();
        TTrack track = TTrack.getTrack(this.trackID);
        TreeSet<Integer> frames = new TreeSet<Integer>();
        int i = 0;
        while (i < len) {
            if (!Double.isNaN(xPoints[i]) && !Double.isNaN(yPoints[i]) && xPoints[i] >= xmin && xPoints[i] <= xmax && yPoints[i] >= ymin && yPoints[i] <= ymax && (frame = track.getFrameForData(this.getXLabel(), this.getYLabel(), new double[]{xPoints[i], yPoints[i]})) >= 0) {
                frames.add(frame);
            }
            ++i;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        Iterator iterator = frames.iterator();
        while (iterator.hasNext()) {
            frame = (Integer)iterator.next();
            Step step = track.getStep(frame);
            if (source == this.selectPointsItem) {
                trackerPanel.selectedSteps.add(step);
            } else {
                trackerPanel.selectedSteps.remove(step);
            }
            step.erase();
        }
        this.fireRepaint(track);
    }

    @Override
    public Rectangle findViewRect() {
        JViewport c = GUIUtils.getParentViewport(this);
        Rectangle rect = c == null ? super.findViewRect() : c.getViewRect();
        Rectangle bounds = this.getBounds();
        rect = rect.intersection(bounds);
        rect.y -= bounds.y;
        return rect;
    }

    protected void showZeroOnAxis(String axis) {
        if (axis.equals("x")) {
            if (this.xmin * this.xmax > 0.0) {
                if (this.xmax > 0.0) {
                    this.xmin = 0.0;
                } else {
                    this.xmax = 0.0;
                }
                this.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
                TFrame.repaintT(this);
                this.isCustom = true;
            }
        } else if (this.ymin * this.ymax > 0.0) {
            if (this.ymax > 0.0) {
                this.ymin = 0.0;
            } else {
                this.ymax = 0.0;
            }
            this.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
            TFrame.repaintT(this);
            this.isCustom = true;
        }
    }

    protected void scaleXMin() {
        double newXMin = Double.MAX_VALUE;
        HighlightableDataset dataset = this.getDataset();
        if (dataset != null && dataset.isMeasured()) {
            if (!Double.isNaN(dataset.getXMin())) {
                newXMin = Math.min(newXMin, dataset.getXMin());
            }
            if (newXMin == this.xmaxPreferred) {
                newXMin = 0.9 * newXMin - 0.5;
            }
            double range = this.xmaxPreferred - newXMin;
            this.xminPreferred = newXMin - this.autoscaleMargin * range;
        }
        if (!Double.isNaN(this.xfloor)) {
            this.xminPreferred = Math.min(this.xfloor, this.xminPreferred);
        }
    }

    protected void scaleXMax() {
        double newXMax = -1.7976931348623157E308;
        HighlightableDataset dataset = this.getDataset();
        if (dataset != null && dataset.isMeasured()) {
            if (!Double.isNaN(dataset.getXMax())) {
                newXMax = Math.max(newXMax, dataset.getXMax());
            }
            if (this.xminPreferred == newXMax) {
                newXMax = 1.1 * newXMax + 0.5;
            }
            double range = newXMax - this.xminPreferred;
            this.xmaxPreferred = newXMax + this.autoscaleMargin * range;
        }
        if (!Double.isNaN(this.xceil)) {
            this.xmaxPreferred = Math.max(this.xceil, this.xmaxPreferred);
        }
    }

    protected void scaleYMin() {
        double newYMin = Double.MAX_VALUE;
        double range = 0.0;
        HighlightableDataset dataset = this.getDataset();
        if (dataset != null && dataset.isMeasured()) {
            if (!Double.isNaN(dataset.getYMin())) {
                newYMin = Math.min(newYMin, dataset.getYMin());
            }
            if (newYMin == this.ymaxPreferred) {
                newYMin = 0.9 * newYMin - 0.5;
            }
            range = this.ymaxPreferred - newYMin;
            this.yminPreferred = newYMin - this.autoscaleMargin * range;
        }
        if (!Double.isNaN(this.yfloor)) {
            this.yminPreferred = Math.min(this.yfloor, this.yminPreferred);
        }
    }

    protected void scaleYMax() {
        double newYMax = -1.7976931348623157E308;
        HighlightableDataset dataset = this.getDataset();
        double range = 0.0;
        if (dataset != null && dataset.isMeasured()) {
            if (!Double.isNaN(dataset.getYMax())) {
                newYMax = Math.max(newYMax, dataset.getYMax());
            }
            if (this.yminPreferred == newYMax) {
                newYMax = 1.1 * newYMax + 0.5;
            }
            range = newYMax - this.yminPreferred;
            this.ymaxPreferred = newYMax + this.autoscaleMargin * range;
        }
        if (!Double.isNaN(this.yceil)) {
            this.ymaxPreferred = Math.max(this.yceil, this.ymaxPreferred);
        }
    }

    protected TViewChooser getOwner() {
        return this.plotTrackView.getOwner();
    }

    /*
     * Exception decompiling
     */
    protected void plotData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void refreshDataset(HighlightableDataset hds, DatasetManager manager, boolean xIsAngle, boolean yIsAngle, boolean degrees) {
        int n;
        int id = manager.hashCode() & 0xFFFF;
        hds.setID(id + this.xIndex * 100 + this.yIndex * 10);
        hds.setConnected(this.dataset.isConnected());
        hds.setMarkerShape(this.dataset.getMarkerShape());
        hds.clear();
        Dataset xData = manager.getDataset(this.xIndex >= 0 ? this.xIndex : 0);
        Dataset yData = manager.getDataset(this.yIndex);
        xData.setYColumnVisible(true);
        yData.setYColumnVisible(true);
        int xcol = this.xIndex >= 0 ? 1 : 0;
        double xMean = xData.getMean(xcol);
        if (xMean != xMean || (n = yData.getRowCount()) == 0) {
            return;
        }
        double[] _x = new double[n];
        double[] _y = new double[n];
        int i = 0;
        while (i < n) {
            double x = xData.getValueAt(i, xcol);
            double y = yData.getValueAt(i, 1);
            if (x == x) {
                if (xIsAngle && degrees) {
                    x *= 57.29577951308232;
                }
                if (y == y && yIsAngle && degrees) {
                    y *= 57.29577951308232;
                }
            } else {
                x = xMean;
                y = Double.NaN;
            }
            _x[i] = x;
            _y[i] = y;
            ++i;
        }
        hds.append(_x, _y);
    }

    protected void showPlotCoordinates(int index) {
        String msg = "";
        if (index >= 0 && this.dataset.getIndex() > index) {
            double x = this.dataset.getX(index);
            double y = this.dataset.getYShifted(index);
            TTrack track = TTrack.getTrack(this.trackID);
            msg = this.coordStringBuilder.getCoordinateString(track.tp, x, y);
            this.setMessage(msg, 0);
        }
    }

    @Override
    protected void refreshDecimalSeparators() {
        super.refreshDecimalSeparators();
        this.coordStringBuilder.refreshDecimalSeparators();
        this.plotAxes.refreshDecimalSeparators();
    }

    @Override
    public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax, boolean invalidateImage) {
        this.frame.getTrackerPanelForID((Integer)this.panelID).changed = true;
        this.isCustom = true;
        super.setPreferredMinMax(xmin, xmax, ymin, ymax, invalidateImage);
        if (this.plotTrackView != null) {
            this.plotTrackView.syncXAxesTo(this);
        }
    }

    @Override
    public void setPreferredMinMaxX(double xmin, double xmax) {
        this.frame.getTrackerPanelForID((Integer)this.panelID).changed = true;
        this.isCustom = true;
        super.setPreferredMinMaxX(xmin, xmax);
        if (this.plotTrackView != null) {
            this.plotTrackView.syncXAxesTo(this);
        }
    }

    @Override
    public void setPreferredMinMaxY(double ymin, double ymax) {
        this.frame.getTrackerPanelForID((Integer)this.panelID).changed = true;
        this.isCustom = true;
        super.setPreferredMinMaxY(ymin, ymax);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.plotAxes.getScaleSetter().isVisible() && super.requestFocusInWindow();
    }

    protected void setXVariable(String name) {
        int n = this.getVarIndexFromName(name);
        switch (n) {
            case -2147483648: {
                break;
            }
            case -2: {
                this.xName = name;
                break;
            }
            default: {
                this.xName = name;
                if (this.xIndex == n) break;
                this.xIndex = n;
                if (this.plotTrackView == null) break;
                this.plotTrackView.syncXAxesTo(this);
            }
        }
    }

    protected String getXVariable() {
        return this.xName;
    }

    protected void setYVariable(String name) {
        int n = this.getVarIndexFromName(name);
        switch (n) {
            case -2147483648: {
                break;
            }
            case -2: {
                this.yName = name;
                break;
            }
            default: {
                this.yName = name;
                if (this.yIndex == n) break;
                this.yIndex = n;
                super.setPreferredMinMaxY(Double.NaN, Double.NaN);
            }
        }
    }

    private int getVarIndexFromName(String name) {
        if ((name = TrackView.trimDefined(name)) == null) {
            return Integer.MIN_VALUE;
        }
        Integer ii = this.htVarToItem.get(name);
        return ii == null ? -2 : ii;
    }

    protected String getYVariable() {
        return this.yName;
    }

    protected void setPlotTrackView(PlotTrackView view) {
        if (this.playerListener == null) {
            this.playerListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (TrackPlottingPanel.this.clickedStep == null) {
                        return;
                    }
                    TPoint pt = TrackPlottingPanel.this.clickedStep.getDefaultPoint();
                    TrackerPanel trackerPanel = TrackPlottingPanel.this.getPlotPanel();
                    trackerPanel.setSelectedPoint(pt);
                    if (pt != null) {
                        pt.showCoordinates(trackerPanel);
                    }
                    TrackPlottingPanel.this.clickedStep = null;
                    TFrame.repaintT(TrackPlottingPanel.this);
                }
            };
        }
        this.plotTrackView = view;
        TrackerPanel trackerPanel = this.getPlotPanel();
        VideoPlayer player = trackerPanel.getPlayer();
        player.removePropertyChangeListener("stepnumber", this.playerListener);
        player.addPropertyChangeListener("stepnumber", this.playerListener);
    }

    private TrackerPanel getPlotPanel() {
        return this.plotTrackView.frame.getTrackerPanelForID(this.plotTrackView.panelID);
    }

    protected void createXYPopups() {
        if (this.popup == null) {
            this.buildPopupMenu();
        }
        this.xPopup = new JPopupMenu();
        this.yPopup = new JPopupMenu();
        this.createVarItems();
        int i = 0;
        while (i < this.xChoices.length) {
            this.xPopup.add(this.xChoices[i]);
            ++i;
        }
        i = 0;
        while (i < this.yChoices.length) {
            this.yPopup.add(this.yChoices[i]);
            ++i;
        }
        String def = TrackerRes.getString("TView.Menuitem.Define");
        JMenuItem item = new JMenuItem(def);
        item.addActionListener(this.dataFunctionListener);
        this.xPopup.addSeparator();
        this.xPopup.add(item);
        item = new JMenuItem(def);
        item.addActionListener(this.dataFunctionListener);
        this.yPopup.addSeparator();
        this.yPopup.add(item);
    }

    protected void createVarItems() {
        this.xListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TrackPlottingPanel.this.selectionEnabled && e.getStateChange() == 1) {
                    JMenuItem item = (JMenuItem)e.getSource();
                    TrackPlottingPanel.this.setXVariable(item.getText());
                    TrackPlottingPanel.this.plotData();
                    TrackPlottingPanel.this.isCustom = true;
                    TrackPlottingPanel.this.frame.getTrackerPanelForID((Integer)TrackPlottingPanel.this.panelID).changed = true;
                    TrackPlottingPanel.this.repaint();
                }
            }
        };
        this.yListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TrackPlottingPanel.this.selectionEnabled && e.getStateChange() == 1) {
                    JMenuItem item = (JMenuItem)e.getSource();
                    TrackPlottingPanel.this.setYVariable(item.getText());
                    TrackPlottingPanel.this.plotData();
                    TrackPlottingPanel.this.isCustom = true;
                    TrackPlottingPanel.this.frame.getTrackerPanelForID((Integer)TrackPlottingPanel.this.panelID).changed = true;
                    TrackPlottingPanel.this.repaint();
                }
            }
        };
        this.xGroup = new ButtonGroup();
        this.yGroup = new ButtonGroup();
        this.xChoices = new JRadioButtonMenuItem[this.datasetCount + 1];
        this.yChoices = new JRadioButtonMenuItem[this.datasetCount];
        TTrack track = TTrack.getTrack(this.trackID);
        for (Map.Entry<String, Integer> e : this.htVarToItem.entrySet()) {
            String name = e.getKey();
            int i = e.getValue() + 1;
            String desc = track.getDataDescription(i);
            if (desc != null && desc.length() > 0) {
                name = String.valueOf(name) + ": " + track.getDataDescription(i);
            }
            this.xChoices[i] = new JRadioButtonMenuItem(name);
            this.xChoices[i].setFont(this.font);
            this.xChoices[i].setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
            this.xChoices[i].addItemListener(this.xListener);
            this.xGroup.add(this.xChoices[i]);
            if (i == 0) continue;
            this.yChoices[--i] = new JRadioButtonMenuItem(name);
            this.yChoices[i].setFont(this.font);
            this.yChoices[i].setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            this.yChoices[i].addItemListener(this.yListener);
            this.yGroup.add(this.yChoices[i]);
        }
    }

    public void updateVarSelection() {
        this.selectionEnabled = false;
        this.xChoices[this.xIndex + 1].setSelected(true);
        this.yChoices[this.yIndex].setSelected(true);
        this.selectionEnabled = true;
    }

    protected void setVariables() {
        this.datasetCount = this.datasetManager.getDatasetsRaw().size();
        boolean smaller = this.yChoices == null ? false : this.datasetCount < this.yChoices.length;
        String xName = this.getXVariable();
        String yName = this.getYVariable();
        this.yPopup = null;
        this.xPopup = null;
        this.htVarToItem.clear();
        TTrack track = TTrack.getTrack(this.trackID);
        boolean foundY = false;
        boolean foundX = false;
        String name = TeXParser.removeSubscripting(track.getDataName(0));
        this.htVarToItem.put(name, -1);
        this.xIndex = -1;
        if (name == xName) {
            foundX = true;
        }
        int i = 0;
        while (i < this.datasetCount) {
            name = TeXParser.removeSubscripting(track.getDataName(i + 1));
            boolean isXVar = name.equals(xName);
            boolean isYVar = name.equals(yName);
            this.htVarToItem.put(name, i);
            if (isXVar) {
                this.xIndex = i;
                foundX = true;
            }
            if (isYVar) {
                this.yIndex = i;
                this.yName = yName;
                foundY = true;
            }
            ++i;
        }
        if (this.xIndex >= this.datasetCount || smaller && !foundX) {
            this.xIndex = -1;
        }
        if (this.yIndex >= this.datasetCount || smaller && !foundY) {
            this.yIndex = 0;
        }
        if (!foundX) {
            this.setXVariable(xName);
        }
        if (!foundY) {
            this.setYVariable(yName);
        }
    }

    private void padDataset(Dataset dataset, double[] newXArray) {
        double[] xArray = dataset.getXPointsRaw();
        double[] yArray = dataset.getYPointsRaw();
        HashMap<Double, Double> valueMap = new HashMap<Double, Double>();
        int k = 0;
        int n = dataset.getIndex();
        while (k < n) {
            valueMap.put(xArray[k], yArray[k]);
            ++k;
        }
        double[] newYArray = new double[newXArray.length];
        int k2 = 0;
        while (k2 < newXArray.length) {
            double x = newXArray[k2];
            newYArray[k2] = valueMap.keySet().contains(x) ? (Double)valueMap.get(x) : Double.NaN;
            ++k2;
        }
        dataset.clear();
        dataset.append(newXArray, newYArray);
    }

    @Override
    public boolean isShowCoordinates() {
        boolean stepSelected;
        boolean inside = this.mouseListener.region == 0;
        boolean bl = stepSelected = this.getPlotPanel().selectedSteps.size() == 1;
        return inside && !stepSelected && this.showCoordinates;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void fireRepaint(TTrack track) {
        TFrame.repaintT(this.frame.getTrackerPanelForID(this.panelID));
        track.fireStepsChanged();
    }

    public void showDataTool() {
        DataTool tool = DataTool.getTool(true);
        DataToolTab tab = tool.getTab(this.datasetManager);
        tool.setUseChooser(false);
        tool.setSaveChangesOnClose(false);
        DatasetManager toSend = new DatasetManager();
        DataRefreshTool refresher = DataRefreshTool.getTool(this.datasetManager);
        toSend.setID(this.datasetManager.getID());
        TTrack track = TTrack.getTrack(this.trackID);
        toSend.setName(track.getName());
        int i = 0;
        Dataset nextIn = this.datasetManager.getDataset(0);
        String xColName = nextIn.getXColumnName();
        XMLControlElement control = new XMLControlElement(nextIn);
        Dataset nextOut = toSend.getDataset(i++);
        control.loadObject(nextOut, true, true);
        nextOut.setYColumnVisible(false);
        nextOut.setConnected(false);
        nextOut.setMarkerShape(0);
        double[] tArray = nextOut.getXPointsRaw();
        if (!this.guests.isEmpty()) {
            TreeSet<Double> tSet = new TreeSet<Double>();
            int t = 0;
            int n = nextOut.getIndex();
            while (t < n) {
                tSet.add(tArray[t]);
                ++t;
            }
            block1: for (TTrack guest : this.guests) {
                DatasetManager guestData = guest.getData(guest.tp, this.plotTrackView.myDatasetIndex);
                Dataset nextGuestIn = guestData.getDataset(0);
                double[] guestTArray = nextGuestIn.getXPointsRaw();
                int t2 = 0;
                int n2 = nextOut.getIndex();
                while (t2 < n2) {
                    if (t2 >= guestTArray.length) continue block1;
                    tSet.add(guestTArray[t2]);
                    ++t2;
                }
            }
            int n3 = tSet.size();
            tArray = new double[n3];
            Double[] temp = tSet.toArray(new Double[n3]);
            int k = 0;
            while (k < n3) {
                tArray[k] = temp[k];
                ++k;
            }
            this.padDataset(nextOut, tArray);
        }
        if (this.xIndex >= 0) {
            nextIn = this.datasetManager.getDataset(this.xIndex);
            xColName = nextIn.getYColumnName();
            control = new XMLControlElement(nextIn);
            nextOut = toSend.getDataset(i++);
            control.loadObject(nextOut, true, true);
            nextOut.setMarkerColor(track.getColor());
            nextOut.setLineColor(track.getColor().darker());
            nextOut.setConnected(true);
            nextOut.setXColumnVisible(false);
            if (!this.guests.isEmpty()) {
                this.padDataset(nextOut, tArray);
            }
        }
        nextIn = this.datasetManager.getDataset(this.yIndex);
        String yColName = nextIn.getYColumnName();
        if (this.yIndex != this.xIndex) {
            control = new XMLControlElement(nextIn);
            nextOut = toSend.getDataset(i++);
            control.loadObject(nextOut, true, true);
            nextOut.setMarkerColor(track.getColor());
            nextOut.setLineColor(track.getColor().darker());
            nextOut.setConnected(true);
            nextOut.setXColumnVisible(false);
            if (!this.guests.isEmpty()) {
                this.padDataset(nextOut, tArray);
            }
        }
        for (TTrack guest : this.guests) {
            String newName;
            DatasetManager guestData = guest.getData(guest.tp);
            refresher.addData(guestData);
            if (this.xIndex >= 0) {
                nextIn = guestData.getDataset(this.xIndex);
                control = new XMLControlElement(nextIn);
                nextOut = toSend.getDataset(i++);
                control.loadObject(nextOut, true, true);
                nextOut.setMarkerColor(guest.getColor());
                nextOut.setLineColor(guest.getColor().darker());
                nextOut.setConnected(true);
                nextOut.setXColumnVisible(false);
                if (tab != null) {
                    newName = tab.getColumnName(nextOut.getID());
                    if (newName != null) {
                        nextOut.setXYColumnNames(nextOut.getXColumnName(), newName);
                    }
                } else {
                    newName = String.valueOf(nextOut.getYColumnName()) + "_{" + guest.getName() + "}";
                    nextOut.setXYColumnNames(nextOut.getXColumnName(), newName);
                }
                this.padDataset(nextOut, tArray);
            }
            if (this.yIndex == this.xIndex) continue;
            nextIn = guestData.getDataset(this.yIndex);
            control = new XMLControlElement(nextIn);
            nextOut = toSend.getDataset(i++);
            control.loadObject(nextOut, true, true);
            nextOut.setMarkerColor(guest.getColor());
            nextOut.setLineColor(guest.getColor().darker());
            nextOut.setConnected(true);
            nextOut.setXColumnVisible(false);
            if (tab != null) {
                newName = tab.getColumnName(nextOut.getID());
                if (newName != null) {
                    nextOut.setXYColumnNames(nextOut.getXColumnName(), newName);
                }
            } else {
                newName = String.valueOf(nextOut.getYColumnName()) + "_{" + guest.getName() + "}";
                nextOut.setXYColumnNames(nextOut.getXColumnName(), newName);
            }
            this.padDataset(nextOut, tArray);
        }
        tool.send(new LocalJob(toSend), refresher);
        tab = tool.getTab(toSend);
        if (tab != null) {
            tab.setWorkingColumns(xColName, yColName);
        }
        tool.setVisible(true);
    }

    public void clearPopup() {
        this.popup = null;
        this.popupmenu = null;
    }

    public void setHighlights(BitSet highlightFrames) {
        this.bsFrameHighlights.clear();
        this.bsFrameHighlights.or(highlightFrames);
    }

    @Override
    public void repaint() {
        if (this.panelID == null || !this.frame.getTrackerPanelForID(this.panelID).isPaintable()) {
            return;
        }
        super.repaint();
    }

    @Override
    public void dispose() {
        if (this.playerListener != null) {
            this.getPlotPanel().getPlayer().removePropertyChangeListener("stepnumber", this.playerListener);
        }
        for (TTrack guest : this.guests) {
            guest.removeStepListener(this.plotTrackView);
        }
        this.guests.clear();
        this.guestDatasets.clear();
        this.datasetManager = null;
        this.plotTrackView = null;
        this.panelID = null;
        this.frame = null;
        super.dispose();
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    @Override
    public String toString() {
        return "[TrackPlottingPanel " + this.id + " " + TTrack.getTrack(this.trackID).getName() + " " + this.yName + " vs. " + this.xName + " ]";
    }

    class ClickableAxes
    extends CartesianInteractive {
        ClickableAxes(PlottingPanel panel) {
            super(panel);
            this.setDefaultGutters(this.defaultLeftGutter, 30, this.defaultRightGutter, this.defaultBottomGutter);
            TrackPlottingPanel.this.setCoordinateStringBuilder(TrackPlottingPanel.this.coordStringBuilder);
        }

        @Override
        public CartesianInteractive.ScaleSetter getScaleSetter() {
            CartesianInteractive.ScaleSetter setter = super.getScaleSetter();
            FontSizer.setFonts(setter);
            return setter;
        }

        @Override
        protected boolean hasHorzVariablesPopup() {
            return true;
        }

        @Override
        protected JPopupMenu getHorzVariablesPopup() {
            if (TrackPlottingPanel.this.xPopup == null) {
                TrackPlottingPanel.this.createXYPopups();
            }
            FontSizer.setFonts(TrackPlottingPanel.this.xPopup, FontSizer.getLevel());
            TrackPlottingPanel.this.updateVarSelection();
            return TrackPlottingPanel.this.xPopup;
        }

        @Override
        protected boolean hasVertVariablesPopup() {
            return true;
        }

        @Override
        protected JPopupMenu getVertVariablesPopup() {
            if (TrackPlottingPanel.this.yPopup == null) {
                TrackPlottingPanel.this.createXYPopups();
            }
            FontSizer.setFonts(TrackPlottingPanel.this.yPopup, FontSizer.getLevel());
            TrackPlottingPanel.this.updateVarSelection();
            return TrackPlottingPanel.this.yPopup;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TrackPlottingPanel plot = (TrackPlottingPanel)obj;
            control.setValue("x_var", plot.getXVariable());
            control.setValue("y_var", plot.getYVariable());
            if (!plot.autoscaleXMin) {
                control.setValue("scaled", true);
                control.setValue("xmin", plot.getPreferredXMin());
            }
            if (!plot.autoscaleXMax) {
                control.setValue("scaled", true);
                control.setValue("xmax", plot.getPreferredXMax());
            }
            if (!plot.autoscaleYMin) {
                control.setValue("scaled", true);
                control.setValue("ymin", plot.getPreferredYMin());
            }
            if (!plot.autoscaleYMax) {
                control.setValue("scaled", true);
                control.setValue("ymax", plot.getPreferredYMax());
            }
            control.setValue("lines", plot.dataset.isConnected());
            control.setValue("points", plot.dataset.getMarkerShape() != 0);
            if (!plot.guests.isEmpty()) {
                String[] guestNames = new String[plot.guests.size()];
                int i = 0;
                while (i < guestNames.length) {
                    TTrack track = plot.guests.get(i);
                    guestNames[i] = track.getName();
                    ++i;
                }
                control.setValue("guests", guestNames);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[] guestnames;
            TrackPlottingPanel plot = (TrackPlottingPanel)obj;
            String[] vars = new String[]{control.getString("x_var"), control.getString("y_var")};
            TTrack track = TTrack.getTrack(plot.trackID);
            boolean isPointMass = track.ttype == 5;
            int i = 0;
            while (i < 2) {
                block42: {
                    if (vars[i] == null) break block42;
                    switch (vars[i]) {
                        case "theta": {
                            vars[i] = isPointMass ? "\u03b8r" : "\u03b8";
                            break;
                        }
                        case "theta_v": {
                            vars[i] = "\u03b8v";
                            break;
                        }
                        case "theta_a": {
                            vars[i] = "\u03b8a";
                            break;
                        }
                        case "theta_p": {
                            vars[i] = "\u03b8p";
                            break;
                        }
                        case "n": {
                            if (!isPointMass) break;
                            vars[i] = "step";
                            break;
                        }
                        case "KE": {
                            vars[i] = "K";
                            break;
                        }
                        case "x-comp": {
                            vars[i] = "x";
                            break;
                        }
                        case "y-comp": {
                            vars[i] = "y";
                            break;
                        }
                        case "x_tail": {
                            vars[i] = "xtail";
                            break;
                        }
                        case "y_tail": {
                            vars[i] = "ytail";
                        }
                    }
                }
                ++i;
            }
            plot.setXVariable(vars[0]);
            plot.setYVariable(vars[1]);
            if (control.getBoolean("scaled")) {
                double xmin = control.getDouble("xmin");
                double xmax = control.getDouble("xmax");
                double ymin = control.getDouble("ymin");
                double ymax = control.getDouble("ymax");
                plot.setPreferredMinMax(xmin, xmax, ymin, ymax, false);
            }
            if (control.getPropertyNamesRaw().contains("lines")) {
                plot.dataset.setConnected(control.getBoolean("lines"));
            }
            if (control.getPropertyNamesRaw().contains("points")) {
                if (control.getBoolean("points")) {
                    plot.dataset.setMarkerShape(2);
                } else {
                    plot.dataset.setMarkerShape(0);
                }
            }
            if ((guestnames = (String[])control.getObject("guests")) != null) {
                TrackerPanel trackerPanel = plot.frame.getTrackerPanelForID(plot.panelID);
                ArrayList<TTrack> tracks = trackerPanel.getTracks();
                String[] stringArray = guestnames;
                int n = guestnames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    TTrack guest = trackerPanel.getTrack(name, tracks);
                    plot.addGuest(guest);
                    ++n2;
                }
            }
            plot.plotData();
            return obj;
        }
    }

    class PlotMouseListener
    extends MouseInputAdapter {
        int region;
        Interactive iad;

        PlotMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 5;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 6;
            TrackPlottingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 7;
            TTrack track = TTrack.getTrack(TrackPlottingPanel.this.trackID);
            if (track.ttype != 3) {
                this.iad = TrackPlottingPanel.this.getInteractive();
            }
            Point p = e.getPoint();
            this.region = this.getRegion(p);
            if (this.region == 0) {
                TrackPlottingPanel.this.setToolTipText(TrackerRes.getString("TrackPlottingPanel.RightDrag.Hint"));
                if (TrackPlottingPanel.this.isShowCoordinates()) {
                    if (this.iad == TrackPlottingPanel.this.dataset) {
                        TrackPlottingPanel.this.showPlotCoordinates(TrackPlottingPanel.this.dataset.getHitIndex());
                    } else {
                        TrackPlottingPanel.this.displayCoordinates(e);
                    }
                }
            } else {
                TrackPlottingPanel.this.setToolTipText(null);
                if (((TrackPlottingPanel)TrackPlottingPanel.this).getPlotPanel().selectedSteps.size() != 1) {
                    TrackPlottingPanel.this.setMessage(null, 0);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 1;
            Point p = e.getPoint();
            this.region = this.getRegion(p);
            TTrack track = TTrack.getTrack(TrackPlottingPanel.this.trackID);
            if (this.iad == TrackPlottingPanel.this.dataset) {
                TrackerPanel trackerPanel = TrackPlottingPanel.this.getPlotPanel();
                TrackPlottingPanel.this.showPlotCoordinates(TrackPlottingPanel.this.dataset.getHitIndex());
                int frame = track.getFrameForData(TrackPlottingPanel.this.getXLabel(), TrackPlottingPanel.this.getYLabel(), new double[]{TrackPlottingPanel.this.dataset.getX(), TrackPlottingPanel.this.dataset.getY()});
                if (frame > -1) {
                    Step step = track.getStep(frame);
                    StepSet steps = trackerPanel.selectedSteps;
                    if (e.isControlDown()) {
                        if (step != null) {
                            if (steps.contains(step)) {
                                steps.remove(step);
                            } else {
                                steps.add(step);
                            }
                            step.erase();
                            TrackPlottingPanel.this.fireRepaint(track);
                        }
                    } else if (step != null) {
                        VideoPlayer player = trackerPanel.getPlayer();
                        if (player.getFrameNumber() == frame) {
                            TPoint pt = step.getDefaultPoint();
                            trackerPanel.setSelectedPoint(pt);
                            if (pt != null) {
                                pt.showCoordinates(trackerPanel);
                            }
                            step.erase();
                            TrackPlottingPanel.this.fireRepaint(track);
                        } else {
                            TrackPlottingPanel.this.clickedStep = step;
                            int stepNumber = player.getVideoClip().frameToStep(frame);
                            player.setStepNumber(stepNumber);
                        }
                    }
                    return;
                }
            } else if (this.region == 0 && e.getClickCount() == 2 && TrackPlottingPanel.this.frame.getTrackerPanelForID(TrackPlottingPanel.this.panelID).isEnabled("data.tool")) {
                TrackPlottingPanel.this.showDataTool();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 3;
            Point p = e.getPoint();
            this.region = this.getRegion(p);
            if (TrackPlottingPanel.this.getInteractive() == null) {
                if (this.region != 0) {
                    TrackPlottingPanel.this.setMouseCursor(Cursor.getDefaultCursor());
                    if (TrackPlottingPanel.this.isShowCoordinates()) {
                        TrackPlottingPanel.this.setMessage(null, 0);
                    }
                } else {
                    TrackPlottingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
            }
            TFrame.repaintT(TrackPlottingPanel.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 2;
            TTrack track = TTrack.getTrack(TrackPlottingPanel.this.trackID);
            if (track.ttype != 3 && TrackPlottingPanel.this.getInteractive() != null) {
                TrackPlottingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TrackPlottingPanel.this.mouseEvent = e;
            TrackPlottingPanel.this.mouseAction = 4;
        }

        private int getRegion(Point p) {
            int region = TrackPlottingPanel.this.plotAxes.getMouseRegion();
            if (region == 0) {
                int l = TrackPlottingPanel.this.getLeftGutter();
                int r = TrackPlottingPanel.this.getRightGutter();
                int t = TrackPlottingPanel.this.getTopGutter();
                int b = TrackPlottingPanel.this.getBottomGutter();
                Dimension plotDim = TrackPlottingPanel.this.getSize();
                if (p.x < l || p.y < t || p.x > plotDim.width - r || p.y > plotDim.height - b) {
                    return -1;
                }
            }
            return region;
        }
    }
}

