/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.util.ArrayList;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class TrackProperties {
    String name;
    String[] footprints;
    Color[] colors;

    TrackProperties(TTrack track) {
        this.name = track.getName();
        if (track instanceof ParticleDataTrack) {
            ParticleDataTrack dt = (ParticleDataTrack)track;
            ArrayList<ParticleDataTrack> mpoints = dt.morePoints;
            int np = mpoints.size();
            this.colors = new Color[np + 2];
            this.colors[0] = dt.getColor();
            this.colors[this.colors.length - 1] = dt.getModelFootprint().getColor();
            int i = 0;
            while (i < np) {
                this.colors[i + 1] = mpoints.get(i).getColor();
                ++i;
            }
            this.footprints = new String[np + 2];
            this.footprints[0] = dt.getFootprintName();
            this.footprints[this.footprints.length - 1] = dt.getModelFootprintName();
            i = 0;
            while (i < np) {
                this.footprints[i + 1] = mpoints.get(i).getFootprintName();
                ++i;
            }
        } else {
            this.footprints = new String[]{track.getFootprintName()};
            this.colors = new Color[]{track.getColor()};
        }
    }

    TrackProperties(String name, String[] footprints, Color[] colors) {
        this.name = name;
        this.footprints = footprints;
        this.colors = colors;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TrackProperties props = (TrackProperties)obj;
            control.setValue("name", props.name);
            control.setValue("footprints", props.footprints);
            control.setValue("colors", props.colors);
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            String[] footprints = (String[])control.getObject("footprints");
            Color[] colors = (Color[])control.getObject("colors");
            return new TrackProperties(name, footprints, colors);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            return obj;
        }
    }
}

