/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.StepSet;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.TeXParser;

public abstract class TrackView
extends JScrollPane
implements PropertyChangeListener {
    static final String DEFINED_AS = ": ";
    static int TVID = 0;
    protected TrackChooserTView viewParent;
    protected TFrame frame;
    protected Integer panelID;
    private int trackID;
    protected int myType;
    protected boolean forceRefresh = false;
    protected boolean highlightVisible = true;
    protected final BitSet highlightFrames = new BitSet();
    protected final BitSet highlightRows = new BitSet();
    protected ArrayList<Component> toolbarComponents = new ArrayList();
    protected Icon trackIcon;
    protected int myID;
    protected int myDatasetIndex = -1;
    protected int prevDatasetIndex;
    protected boolean clipAdjusting;
    private static final String[] panelProps = new String[]{"loaded", "selectedpoint", "units"};

    protected TrackView(TTrack track, TrackerPanel panel, TrackChooserTView view, int myType) {
        this.trackID = track.getID();
        this.myID = ++TVID;
        this.myType = myType;
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        panel.addListeners(panelProps, this);
        this.viewParent = view;
    }

    protected void dispose() {
        for (TTrack t : TTrack.getValues()) {
            t.removeStepListener(this);
        }
        this.frame.getTrackerPanelForID(this.panelID).removeListeners(panelProps, this);
        this.frame = null;
        this.panelID = null;
        this.viewParent = null;
    }

    abstract void refresh(int var1, int var2);

    abstract void refreshGUI();

    abstract boolean isCustomState();

    abstract JButton getViewButton();

    @Override
    public String getName() {
        return this.getTrack().getName();
    }

    public Icon getIcon() {
        if (this.trackIcon == null) {
            this.trackIcon = this.getTrack().getIcon(21, 16, "point");
        }
        return this.trackIcon;
    }

    TTrack getTrack() {
        return TTrack.getTrack(this.trackID);
    }

    public void setDatasetIndex(int index) {
        this.myDatasetIndex = index;
    }

    protected TViewChooser getOwner() {
        TViewChooser[] choosers = this.frame.getViewChoosers(this.panelID);
        int i = 0;
        while (i < choosers.length) {
            TView tview;
            TView tView = tview = choosers[i] == null ? null : choosers[i].getSelectedView();
            if (tview == this.viewParent && this.viewParent.getTrackView(this.viewParent.getSelectedTrack()) == this) {
                return choosers[i];
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Component> getToolBarComponents() {
        return this.toolbarComponents;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        int stepNumber = Integer.MIN_VALUE;
        int mode = 0;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        switch (e.getPropertyName()) {
            case "step": {
                stepNumber = (Integer)e.getNewValue();
                mode = e.getOldValue() == TTrack.HINT_STEP_ADDED_OR_REMOVED ? 8448 : 4864;
                break;
            }
            case "selectedpoint": {
                Step step = trackerPanel.getSelectedStep();
                TTrack track = this.getTrack();
                if (step != null && trackerPanel.getSelectedTrack() == track) {
                    stepNumber = step.getFrameNumber();
                }
                mode = 5120;
                break;
            }
            case "steps": {
                mode = TTrack.HINT_STEPS_SELECTED == e.getOldValue() ? 5120 : 5376;
                break;
            }
            case "loaded": {
                mode = 5632;
                break;
            }
            case "track": {
                mode = 7680;
            }
        }
        this.refresh(stepNumber == Integer.MIN_VALUE ? trackerPanel.getFrameNumber() : stepNumber, mode);
    }

    protected boolean isRefreshEnabled() {
        return this.frame.isPaintable() && this.frame.getTrackerPanelForID(this.panelID).isAutoRefresh() && this.viewParent.isTrackViewDisplayed(this.getTrack());
    }

    public static String trimDefined(String name) {
        int pt;
        return TeXParser.removeSubscript(name == null || (pt = name.indexOf(DEFINED_AS)) < 0 ? name : name.substring(0, pt));
    }

    public void setClipAdjusting(int frameNo, boolean adjusting) {
        this.clipAdjusting = adjusting;
        if (!adjusting) {
            SwingUtilities.invokeLater(() -> this.refresh(frameNo, 9216));
        }
    }

    boolean isClipAdjusting() {
        return this.clipAdjusting;
    }

    public void highlightFrames(int frameNumber) {
        this.highlightFrames.clear();
        StepSet steps = this.frame.getTrackerPanelForID((Integer)this.panelID).selectedSteps;
        if (steps.size() > 0) {
            for (Step step : steps) {
                if (step.getTrack() != this.getTrack()) continue;
                this.highlightFrames.set(step.getFrameNumber());
            }
        } else {
            this.highlightFrames.set(frameNumber);
        }
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.getTrack().getName() + " " + this.viewParent + " ]";
    }

    public void finalize() {
        OSPLog.finalized(this);
    }
}

