/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javajs.async.AsyncSwingWorker;
import javajs.async.SwingJSUtils;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.cabrillo.tracker.Configuration;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.PrefsDialog;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TrackDataBuilder;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Upgrader;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.mov.MovieFactory;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.DiagnosticsForThreads;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.JREFinder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import swingjs.api.JSUtilI;

public class Tracker {
    public static boolean loadTabsInSeparateThread = !OSPRuntime.isJS;
    public static String TRACKER_TEST_URL = "https://physlets.org/tracker/counter/counter.php";
    public static boolean doHoldRepaint = true;
    public static boolean allowDataFunctionControls = !OSPRuntime.isJS;
    public static boolean allowTableRefresh = true;
    public static boolean allowPlotRefresh = true;
    public static boolean allowDataRefresh = true;
    public static boolean allowViews = true;
    public static boolean allowMenuRefresh = true;
    public static boolean allowToolbarRefresh = true;
    public static boolean timeLogEnabled = false;
    public static JSUtilI jsutil;
    public static final String COPYRIGHT = "Copyright (c) 2025 D Brown, W Christian, R M Hanson";
    public static final ImageIcon TRACKER_ICON;
    public static final ImageIcon TRACKER_ICON_256;
    static final String THETA;
    static final String OMEGA;
    static final String ALPHA;
    static final String DEGREES = "\u00b0";
    static final String SQUARED = "\u00b2";
    static final String DOT = "\u00b7";
    static final Level DEFAULT_LOG_LEVEL;
    static final int DEFAULT_TRAIL_LENGTH_INDEX = 2;
    static final int MEMORY_OK = 0;
    static final int MEMORY_LOW_IGNORE = 1;
    static final int MEMORY_LOW_DONTIGNORE = 2;
    static final int MEMORY_OUT = 3;
    static final int MEMORY_INCREASE = 4;
    static boolean testOn;
    static double testVal;
    private static String testString;
    static String trackerHome;
    private static String[] fullConfig;
    static Set<String> defaultConfig;
    private static boolean usesXuggleServer;
    private static String[] mainArgs;
    private static JFrame splash;
    private static Icon trackerLogoIcon;
    private static JProgressBar progressBar;
    private static String counterPath;
    private static Tracker sharedTracker;
    private static String rootXMLPath;
    private static Cursor zoomInCursor;
    private static Cursor zoomOutCursor;
    private static Locale[] locales;
    private static Locale defaultLocale;
    static final String DEFAULT_TRACKER_PREFS = "tracker.prefs.default";
    static String latestVersion;
    static String newerVersion;
    static boolean checkedForNewerVersion;
    static boolean isNewInstall;
    static String trackerWebsite;
    static Cursor grabCursor;
    static boolean showHints;
    static boolean startupHintShown;
    static ArrayList<String> checkForUpgradeChoices;
    static Map<String, Integer> checkForUpgradeIntervals;
    static AbstractAction aboutXuggleAction;
    static AbstractAction aboutThreadsAction;
    static Action aboutTrackerAction;
    static Action readmeAction;
    static Action aboutJavaAction;
    static Action startLogAction;
    static Action trackerPrefsAction;
    static String readmeFileName;
    static JDialog readmeDialog;
    static JDialog startLogDialog;
    static JDialog trackerPrefsDialog;
    static JTextArea trackerPrefsTextArea;
    static String prefsPath;
    static String pdfHelpPath;
    static JButton pdfHelpButton;
    static ArrayList<String> recentFiles;
    static int minimumMemorySize;
    static int requestedMemorySize;
    static int originalMemoryRequest;
    static long lastMillisChecked;
    static int maxFontLevel;
    static Object[][] incompleteLocales;
    static Collection<String> initialAutoloadSearchPaths;
    static FileFilter xmlFilter;
    static Level preferredLogLevel;
    static boolean showHintsByDefault;
    static int recentFilesSize;
    static int preferredMemorySize;
    static String lookAndFeel;
    static String preferredLocale;
    static String preferredDecimalSeparator;
    static String preferredJRE;
    static String preferredTrackerJar;
    static String preferredPointMassFootprint;
    static int checkForUpgradeInterval;
    static int preferredFontLevel;
    static int preferredFontLevelPlus;
    static boolean isRadians;
    static boolean isXuggleFast;
    static boolean warnSkippedStep;
    static boolean warnXuggleError;
    static boolean warnNoVideoEngine;
    static boolean warnVariableDuration;
    static String[] prelaunchExecutables;
    static Map<String, String[]> autoloadMap;
    static String[] preferredAutoloadSearchPaths;
    static boolean markAtCurrentFrame;
    static boolean scrubMouseWheel;
    static boolean centerCalibrationStick;
    static boolean hideLabels;
    static boolean enableAutofill;
    static boolean showGaps;
    static int preferredTrailLengthIndex;
    private static boolean declareLocales;
    static TrackerPanel testPanel;
    private static boolean testingFinal;
    private TFrame frame;
    private boolean headless;
    private static Collection<String> dataFunctionControlStrings;
    private static Map<String, ArrayList<XMLControl>> dataFunctionControls;

    static {
        XML.setLoader(Preferences.class, new Preferences.Loader());
        try {
            if (OSPRuntime.isJS) {
                OSPRuntime.launcherAllowEJSModel = false;
                jsutil = (JSUtilI)Class.forName("swingjs.JSUtil").newInstance();
            }
        }
        catch (Exception e) {
            OSPLog.warning("OSPRuntime could not create jsutil");
        }
        OSPRuntime.addAssets("tracker", "tracker-assets.zip", "org/opensourcephysics");
        TRACKER_ICON = (ImageIcon)Tracker.getResourceIcon("tracker_icon_32.png", false);
        TRACKER_ICON_256 = (ImageIcon)Tracker.getResourceIcon("tracker_icon_256.png", false);
        THETA = TeXParser.parseTeX("$\\theta");
        OMEGA = TeXParser.parseTeX("$\\omega");
        ALPHA = TeXParser.parseTeX("$\\alpha");
        DEFAULT_LOG_LEVEL = ConsoleLevel.OUT_CONSOLE;
        testOn = false;
        testVal = 0.0;
        fullConfig = new String[]{"file.new", "file.open", "file.close", "file.import", "file.export", "file.save", "file.saveAs", "file.print", "file.library", "edit.copyObject", "edit.copyData", "edit.copyImage", "edit.paste", "edit.matSize", "edit.clear", "edit.undoRedo", "video.import", "video.close", "video.visible", "video.filters", "pageView.edit", "notes.edit", "new.pointMass", "new.cm", "new.vector", "new.vectorSum", "new.lineProfile", "new.RGBRegion", "new.analyticParticle", "new.clone", "new.circleFitter", "new.dynamicParticle", "new.dynamicTwoBody", "new.dataTrack", "new.tapeMeasure", "new.protractor", "calibration.stick", "calibration.tape", "calibration.points", "calibration.offsetOrigin", "track.name", "track.description", "track.color", "track.footprint", "track.visible", "track.locked", "track.delete", "track.autoAdvance", "track.markByDefault", "track.autotrack", "model.stamp", "help.diagnostics", "coords.locked", "coords.origin", "coords.angle", "data.algorithm", "coords.scale", "coords.refFrame", "button.x", "button.v", "button.a", "button.trails", "button.labels", "button.stretch", "button.clipSettings", "button.xMass", "button.axes", "button.path", "button.drawing", "number.formats", "number.units", "text.columns", "plot.compare", "config.saveWithData", "data.builder", "data.tool"};
        counterPath = "https://physlets.org/tracker/counter/counter.php?";
        rootXMLPath = "";
        trackerWebsite = "opensourcephysics.github.io/tracker-website";
        showHints = true;
        readmeFileName = "Tracker_README.txt";
        pdfHelpPath = "/tracker_help.pdf";
        recentFiles = new ArrayList();
        minimumMemorySize = 32;
        requestedMemorySize = -1;
        originalMemoryRequest = 0;
        maxFontLevel = 6;
        initialAutoloadSearchPaths = new TreeSet<String>();
        preferredLogLevel = DEFAULT_LOG_LEVEL;
        showHintsByDefault = true;
        recentFilesSize = 6;
        preferredMemorySize = -1;
        checkForUpgradeInterval = 0;
        preferredFontLevel = 0;
        preferredFontLevelPlus = 0;
        warnSkippedStep = true;
        warnXuggleError = true;
        warnNoVideoEngine = !OSPRuntime.isJS;
        warnVariableDuration = true;
        prelaunchExecutables = new String[0];
        autoloadMap = new TreeMap<String, String[]>();
        markAtCurrentFrame = true;
        centerCalibrationStick = true;
        enableAutofill = true;
        showGaps = true;
        preferredTrailLengthIndex = 2;
        declareLocales = true;
        testingFinal = true;
        dataFunctionControlStrings = new HashSet<String>();
        dataFunctionControls = new TreeMap<String, ArrayList<XMLControl>>();
    }

    public static Icon getResourceIcon(String imageName, boolean resizable) {
        URL url = Tracker.getClassResource("resources/images/" + imageName);
        if (url == null) {
            OSPLog.debug("Tracker.getResourceIcon was null for " + imageName);
            return null;
        }
        return resizable ? new ResizableIcon(url) : new ImageIcon(url);
    }

    private static void initClass(boolean isHeadless) {
        if (defaultLocale != null) {
            return;
        }
        defaultLocale = Locale.getDefault();
        trackerHome = System.getenv("TRACKER_HOME");
        if (trackerHome == null) {
            trackerHome = TrackerStarter.findTrackerHome(false);
        }
        trackerLogoIcon = Tracker.getResourceIcon("tracker_logo.png", false);
        Image grab = ((ImageIcon)Tracker.getResourceIcon("grab.gif", false)).getImage();
        grabCursor = GUIUtils.createCustomCursor(grab, new Point(14, 10), "Grab", 12);
        if (!declareLocales) {
            locales = new Locale[]{Locale.ENGLISH};
            incompleteLocales = new Object[0][];
        }
        OSPLog.getOSPLog(!isHeadless);
        Tracker.setDefaultConfig(Tracker.getFullConfig());
        Tracker.loadPreferences();
        if (!OSPRuntime.isJS && !isHeadless) {
            Timer timer = new Timer(86400000, e -> {
                Thread opener = new Thread(() -> {
                    checkedForNewerVersion = false;
                    Tracker.loadCurrentVersion(false, true, true);
                });
                opener.setPriority(5);
                opener.setDaemon(true);
                opener.start();
            });
            timer.setInitialDelay(10000);
            timer.setRepeats(true);
            timer.start();
        }
        xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null || f.isDirectory()) {
                    return false;
                }
                String ext = XML.getExtension(f.getName());
                return ext != null && "xml".equals(ext.toLowerCase());
            }
        };
        checkForUpgradeChoices = new ArrayList();
        checkForUpgradeIntervals = new HashMap<String, Integer>();
        if (!OSPRuntime.isJS) {
            Tracker.autoloadDataFunctions();
            String s = "PrefsDialog.Upgrades.Always";
            checkForUpgradeChoices.add(s);
            checkForUpgradeIntervals.put(s, 0);
            s = "PrefsDialog.Upgrades.Weekly";
            checkForUpgradeChoices.add(s);
            checkForUpgradeIntervals.put(s, 7);
            s = "PrefsDialog.Upgrades.Monthly";
            checkForUpgradeChoices.add(s);
            checkForUpgradeIntervals.put(s, 30);
            s = "PrefsDialog.Upgrades.Never";
            checkForUpgradeChoices.add(s);
            checkForUpgradeIntervals.put(s, 10000);
        }
        VideoIO.setDefaultXMLExtension("trk");
        pdfHelpButton = new JButton(TrackerRes.getString("Tracker.Button.PDFHelp"));
        pdfHelpButton.addActionListener(e -> {
            try {
                URL url = new URL("https://" + trackerWebsite + pdfHelpPath);
                OSPDesktop.displayURL(url.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        new Thread(() -> JREFinder.getFinder().getJREs(32)).start();
    }

    public static Locale[] getLocales() {
        if (locales != null) {
            return locales;
        }
        locales = new Locale[]{Locale.ENGLISH, new Locale("ar"), new Locale("ca"), new Locale("cs"), new Locale("da"), new Locale("de"), new Locale("el", "GR"), new Locale("es"), new Locale("fi"), new Locale("fr"), new Locale("hu", "HU"), new Locale("in"), new Locale("it"), new Locale("iw", "IL"), new Locale("ja"), new Locale("ko"), new Locale("lv"), new Locale("ms", "MY"), new Locale("nl", "NL"), new Locale("pl"), new Locale("pt", "BR"), new Locale("pt", "PT"), new Locale("ru"), new Locale("sk"), new Locale("sl"), new Locale("sv"), new Locale("th", "TH"), new Locale("tr"), new Locale("uk"), new Locale("vi", "VN"), new Locale("zh", "CN"), new Locale("zh", "TW")};
        incompleteLocales = new Object[][]{{new Locale("fi"), "2013"}, {new Locale("sk"), "2011"}};
        return locales;
    }

    public static URL getClassResource(String resource) {
        return ResourceLoader.getClassResource("org/opensourcephysics/cabrillo/tracker/" + resource, Tracker.class);
    }

    public static Tracker getTracker(Runnable whenLoaded) {
        if (sharedTracker == null) {
            OSPLog.fine("creating shared Tracker");
            sharedTracker = new Tracker(null, false, false, whenLoaded);
        }
        return sharedTracker;
    }

    public Tracker() {
        this(null, true, true, null);
    }

    public Tracker(Video video2) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("-video", video2);
        this.createFrame(options);
    }

    private Tracker(String[] args, boolean addTabIfEmpty, boolean showSplash, Runnable whenLoaded) {
        Map<String, Object> options = Tracker.parseArgs(args);
        this.headless = Boolean.TRUE.equals(options.get("-headless")) || "true".equals(System.getProperty("java.awt.headless"));
        String importVideoName = (String)options.get("-importVideo");
        String exportVideoName = (String)options.get("-exportVideo");
        if (this.headless) {
            if (exportVideoName == null && whenLoaded == null) {
                return;
            }
            Runnable r = whenLoaded;
            whenLoaded = () -> {
                try {
                    if (r != null) {
                        r.run();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.exit(0);
            };
        }
        Tracker.initClass(this.headless);
        if (!this.headless) {
            if (showSplash && !OSPRuntime.isJS) {
                this.getSplash();
                FontSizer.setFonts(splash);
                splash.pack();
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (dim.width - Tracker.splash.getBounds().width) / 2;
                int y = (dim.height - Tracker.splash.getBounds().height) / 2;
                splash.setLocation(x, y);
                splash.setVisible(true);
            }
            this.frame = this.createFrame(options);
        }
        TrackerIO.AsyncLoader loader = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    if ((args[i].endsWith(".trk") || args[i].endsWith(".trz")) && args[i].indexOf("/") != -1 && rootXMLPath.equals("")) {
                        rootXMLPath = args[i].substring(0, args[i].lastIndexOf("/") + 1);
                        OSPLog.fine("Setting rootPath: " + rootXMLPath);
                    }
                    String url = args[i];
                    if (this.headless) {
                        loader = TrackerIO.openURL(url, null, null);
                        break;
                    }
                    this.frame.doOpenURL(url);
                    addTabIfEmpty = false;
                }
                ++i;
            }
        }
        if (addTabIfEmpty && this.headless && importVideoName != null) {
            loader = TrackerIO.openURL(importVideoName, null, null);
        }
        if (loader != null) {
            if (exportVideoName != null) {
                TrackerIO.exportVideoImages(loader.panel(), exportVideoName);
            }
            whenLoaded.run();
            System.exit(0);
        }
        if (addTabIfEmpty) {
            TrackerPanel panel = this.frame.getCleanTrackerPanel();
            this.frame.addTab(panel, 2, () -> {
                if (showHints) {
                    startupHintShown = true;
                    panel.setMessage(TrackerRes.getString("Tracker.Startup.Hint"));
                }
            });
        }
    }

    private static Map<String, Object> parseArgs(String[] args) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (args == null || args.length == 0) {
            return options;
        }
        int i = 0;
        while (i < args.length) {
            block26: {
                String arg = args[i];
                if (arg == null) break block26;
                int i1 = i;
                try {
                    switch (arg.toLowerCase()) {
                        case "-headless": {
                            System.setProperty("java.awt.headless", "true");
                            args[i] = null;
                            options.put("-headless", true);
                            break;
                        }
                        case "-importvideo": {
                            args[i] = null;
                            String importName = args[++i];
                            options.put("-importVideo", importName);
                            args[i] = null;
                            break;
                        }
                        case "-exportvideo": {
                            args[i] = null;
                            String exportName = args[++i];
                            options.put("-exportVideo", exportName);
                            args[i] = null;
                            break;
                        }
                        case "-adaptive": {
                            args[i] = null;
                            options.put("-adaptive", true);
                            break;
                        }
                        case "-bounds": {
                            args[i] = null;
                            i1 = i + 4;
                            int bx = Tracker.getIntArg(args, ++i);
                            int by = Tracker.getIntArg(args, ++i);
                            int bw = Tracker.getIntArg(args, ++i);
                            int bh = Tracker.getIntArg(args, ++i);
                            options.put("-bounds", new Rectangle(bx, by, bw, bh));
                            break;
                        }
                        case "-dim": {
                            args[i] = null;
                            i1 = i + 2;
                            int w = Tracker.getIntArg(args, ++i);
                            int h = Tracker.getIntArg(args, ++i);
                            options.put("-dim", new Dimension(w, h));
                        }
                    }
                }
                catch (NumberFormatException e) {
                    System.err.println("Tracker: Could not parse argument " + arg);
                    i = i1;
                }
            }
            ++i;
        }
        System.out.println("Tracker.parseArgs: " + options);
        return options;
    }

    private static int getIntArg(String[] args, int i) throws NumberFormatException {
        String a = args[i];
        args[i] = null;
        return Integer.parseInt(a);
    }

    private void getSplash() {
        if (splash != null) {
            return;
        }
        Color darkred = new Color(153, 0, 0);
        Color darkblue = new Color(51, 51, 102);
        Color grayblue = new Color(116, 147, 179);
        Color darkgrayblue = new Color(83, 105, 128);
        Color lightblue = new Color(169, 193, 217);
        Color background = new Color(250, 250, 230);
        splash = new JFrame("Tracker");
        splash.setIconImage(TRACKER_ICON.getImage());
        splash.setUndecorated(true);
        splash.setAlwaysOnTop(true);
        splash.setResizable(false);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(background);
        contentPane.setBorder(BorderFactory.createBevelBorder(0, grayblue, darkgrayblue));
        splash.setContentPane(contentPane);
        MouseInputAdapter splashMouseListener = new MouseInputAdapter(){
            Point mouseLoc;
            Point splashLoc;

            @Override
            public void mousePressed(MouseEvent e) {
                this.splashLoc = splash.getLocation();
                this.mouseLoc = e.getPoint();
                this.mouseLoc.x += this.splashLoc.x;
                this.mouseLoc.y += this.splashLoc.y;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point loc = splash.getLocation();
                loc.x += e.getPoint().x;
                loc.y += e.getPoint().y;
                splash.setLocation(this.splashLoc.x + loc.x - this.mouseLoc.x, this.splashLoc.y + loc.y - this.mouseLoc.y);
            }
        };
        contentPane.addMouseListener(splashMouseListener);
        contentPane.addMouseMotionListener(splashMouseListener);
        JLabel trackerLogoLabel = new JLabel(trackerLogoIcon);
        trackerLogoLabel.setBorder(BorderFactory.createEmptyBorder(12, 24, 4, 24));
        contentPane.add((Component)trackerLogoLabel, "North");
        String tip = TrackerRes.getString("Tracker.Splash.HelpMessage");
        tip = String.valueOf(tip) + " " + TrackerRes.getString("TMenuBar.Menu.Help");
        tip = String.valueOf(tip) + "|" + TrackerRes.getString("TMenuBar.MenuItem.GettingStarted");
        JLabel helpLabel = new JLabel(tip);
        helpLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        Font font = helpLabel.getFont().deriveFont(0).deriveFont(14.0f);
        helpLabel.setFont(font);
        helpLabel.setForeground(darkred);
        helpLabel.setAlignmentX(0.5f);
        progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.setBorder(BorderFactory.createEmptyBorder(12, 50, 16, 50));
        progressPanel.add((Component)progressBar, "Center");
        progressPanel.setOpaque(false);
        Box center = Box.createVerticalBox();
        center.add(helpLabel);
        center.add(progressPanel);
        String vers = "Ver 6.3.3";
        if ("6.3.3".length() > 7 || testOn) {
            vers = String.valueOf(vers) + " BETA";
        }
        JLabel versionLabel = new JLabel(vers);
        versionLabel.setForeground(darkblue);
        font = font.deriveFont(1).deriveFont(10.0f);
        versionLabel.setFont(font);
        versionLabel.setHorizontalAlignment(0);
        versionLabel.setOpaque(false);
        versionLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        JPanel versionPanel = new JPanel(new BorderLayout());
        versionPanel.setBackground(new Color(212, 230, 247));
        versionPanel.add((Component)versionLabel, "Center");
        versionPanel.setBorder(BorderFactory.createLineBorder(lightblue));
        contentPane.add((Component)versionPanel, "South");
    }

    public void loadExperimentURL(String path) {
        this.getFrame().loadExperimentURL(path);
    }

    public TFrame getFrame() {
        return this.frame;
    }

    public OSPFrame getMainFrame() {
        return this.frame;
    }

    public int[] getMainFrameSize() {
        Dimension d = this.frame.getSize();
        return new int[]{d.width, d.height};
    }

    public int[] getMainFrameLocation() {
        Point d = this.frame.getLocation();
        return new int[]{d.x, d.y};
    }

    private TFrame createFrame(Map<String, Object> options) {
        Tracker.createActions();
        OSPRuntime.setLookAndFeel(true, lookAndFeel);
        TFrame frame = new TFrame(options);
        Diagnostics.setDialogOwner(frame);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Tracker.this.onWindowClosing();
            }
        });
        return frame;
    }

    protected void onWindowClosing() {
        boolean doClose;
        if (OSPRuntime.isJS) {
            Tracker.exit();
            return;
        }
        ArrayList<String> dirs = new ArrayList<String>();
        if (preferredAutoloadSearchPaths != null) {
            String[] stringArray = preferredAutoloadSearchPaths;
            int n = preferredAutoloadSearchPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                dirs.add(path);
                ++n2;
            }
        } else {
            dirs.addAll(Tracker.getDefaultAutoloadSearchPaths());
        }
        Iterator<String> it = autoloadMap.keySet().iterator();
        while (it.hasNext()) {
            String filePath = it.next();
            String parentPath = XML.getDirectoryPath(filePath);
            boolean keep = false;
            for (String dir : dirs) {
                boolean bl = keep = keep || parentPath.equals(dir);
            }
            if (keep && new File(filePath).exists()) continue;
            it.remove();
        }
        Tracker.savePreferences();
        boolean bl = doClose = this.frame.wishesToExit() && this.frame.getDefaultCloseOperation() == 2;
        if (this.frame.libraryBrowser != null) {
            boolean canceled;
            boolean bl2 = canceled = !this.frame.libraryBrowser.exit();
            if (canceled) {
                int op = this.frame.getDefaultCloseOperation();
                boolean exit = this.frame.wishesToExit();
                this.frame.setDefaultCloseOperation(0);
                EventQueue.invokeLater(() -> {
                    if (exit) {
                        this.frame.setDefaultCloseOperation(3);
                    }
                    this.frame.setDefaultCloseOperation(op);
                });
                return;
            }
        }
        if (doClose) {
            Tracker.exit();
        } else {
            this.frame.saveAllTabs(true, new Function<Integer, Void>(){

                @Override
                public Void apply(Integer panelID) {
                    Tracker.this.frame.removeTabSynchronously(panelID);
                    return null;
                }
            }, () -> Tracker.exit(), () -> {
                final int op = this.frame.getDefaultCloseOperation();
                final boolean exit = this.frame.wishesToExit();
                this.frame.setDefaultCloseOperation(0);
                new AsyncSwingWorker(null, null, 2, 0, 1){

                    @Override
                    public void initAsync() {
                    }

                    @Override
                    public int doInBackgroundAsync(int i) {
                        return 1;
                    }

                    @Override
                    public void doneAsync() {
                        Tracker.this.frame.setVisible(true);
                        Tracker.this.frame.setDefaultCloseOperation(exit ? 3 : op);
                    }
                }.execute();
            });
        }
    }

    public static void exit() {
        File toDelete = new File("/tmp/xuggle");
        if (toDelete.exists()) {
            toDelete.delete();
        }
        OSPRuntime.exit();
        System.exit(0);
    }

    public static int compareVersions(String ver1, String ver2) {
        if (ver1 == null || ver2 == null) {
            return 0;
        }
        try {
            double d1 = Double.parseDouble(ver1.substring(0, 3));
            if (d1 == 5.9) {
                ver1 = "5.1.9";
            } else if (d1 >= 5.2 && d1 < 6.0) {
                ver1 = String.valueOf(String.valueOf(d1 + 0.8)) + ver1.substring(3);
            }
            double d2 = Double.parseDouble(ver2.substring(0, 3));
            if (d2 == 5.9) {
                ver2 = "5.1.9";
            } else if (d2 >= 5.2 && d2 < 6.0) {
                ver2 = String.valueOf(String.valueOf(d2 + 0.8)) + ver2.substring(3);
            }
        }
        catch (Exception d1) {
            // empty catch block
        }
        String[] v1 = ver1.trim().split("\\.");
        String[] v2 = ver2.trim().split("\\.");
        if (v1.length == 4) {
            v1 = new String[]{v1[0], v1[1], v1[2]};
        }
        if (v2.length == 4) {
            v2 = new String[]{v2[0], v2[1], v2[2]};
        }
        if (v1.length == 3 && v1[2].length() > 2) {
            v1[2] = v1[2].substring(0, 1);
        }
        if (v2.length == 3 && v2[2].length() > 2) {
            v2[2] = v2[2].substring(0, 1);
        }
        int i = 0;
        while (i < v1.length) {
            Integer.parseInt(v1[i]);
            ++i;
        }
        i = 0;
        while (i < v2.length) {
            Integer.parseInt(v2[i]);
            ++i;
        }
        if (v2.length > v1.length) {
            return -1;
        }
        if (v1.length > v2.length) {
            return 1;
        }
        i = 0;
        while (i < v1.length) {
            int int2;
            int int1 = Integer.parseInt(v1[i]);
            if (int1 < (int2 = Integer.parseInt(v2[i]))) {
                return -1;
            }
            if (int1 > int2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static void showAboutTracker() {
        String newline = System.getProperty("line.separator", "\n");
        String vers = "6.3.3";
        if (vers.length() > 7 || testOn) {
            vers = String.valueOf(vers) + " BETA";
        }
        String date = OSPRuntime.getLaunchJarBuildDate();
        String desc = "\nBuild date ";
        if ("".equals(date)) {
            date = "27 Oct 2025";
            desc = "\nRelease date ";
        }
        vers = String.valueOf(vers) + desc + date;
        if (OSPRuntime.isJS) {
            vers = String.valueOf(vers) + "\n\nJavaScript transcription created using the\njava2script/SwingJS framework developed at\nSt. Olaf College.\n";
        }
        String aboutString = "Version " + vers + newline + COPYRIGHT + newline + "https://" + trackerWebsite + newline + newline + TrackerRes.getString("Tracker.About.ProjectOf") + " " + "Open Source Physics" + newline + "www.compadre.org/osp" + newline;
        String translator = TrackerRes.getString("Tracker.About.Translator");
        if (!translator.equals("")) {
            aboutString = String.valueOf(aboutString) + newline + TrackerRes.getString("Tracker.About.TranslationBy") + " " + translator + newline;
        }
        if (trackerHome != null) {
            aboutString = String.valueOf(aboutString) + newline + TrackerRes.getString("Tracker.About.TrackerHome") + newline + trackerHome + newline;
        }
        if (!OSPRuntime.isJS) {
            Tracker.loadCurrentVersion(true, false, false);
            aboutString = newerVersion != null ? String.valueOf(aboutString) + newline + TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Message1") + " " + newerVersion + " " + TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Message2") + newline : String.valueOf(aboutString) + newline + TrackerRes.getString("PrefsDialog.Dialog.NewVersion.None.Message");
        }
        JOptionPane.showMessageDialog(null, aboutString, TrackerRes.getString("Tracker.Dialog.AboutTracker.Title"), 1);
    }

    public static Map<String, ArrayList<String[]>> findDataFunctions(String dirPath) {
        TreeMap<String, ArrayList<String[]>> results = new TreeMap<String, ArrayList<String[]>>();
        if (dirPath == null) {
            return results;
        }
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return results;
        }
        File[] files = dir.listFiles(xmlFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type;
                File file = fileArray[n2];
                XMLControlElement control = new XMLControlElement(file.getPath());
                if (!control.failedToRead() && (type = control.getObjectClass()) != null && TrackDataBuilder.class.isAssignableFrom(type)) {
                    ArrayList<String[]> expandedFunctions = new ArrayList<String[]>();
                    for (XMLProperty next : control.getPropsRaw()) {
                        XMLControl[] panels;
                        if (!next.getPropertyName().equals("functions")) continue;
                        XMLControl[] xMLControlArray = panels = next.getChildControls();
                        int n3 = panels.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XMLControl panelControl = xMLControlArray[n4];
                            String trackType = panelControl.getString("description");
                            ArrayList functions = (ArrayList)panelControl.getObject("functions");
                            if (trackType != null && functions != null && !functions.isEmpty()) {
                                for (String[] f : functions) {
                                    String[] data = new String[3];
                                    System.arraycopy(f, 0, data, 0, 2);
                                    String trackName = XML.getExtension(trackType);
                                    String localized = TrackerRes.getString(String.valueOf(trackName) + ".Name");
                                    if (!localized.startsWith("!")) {
                                        trackName = localized;
                                    }
                                    data[2] = trackName;
                                    expandedFunctions.add(data);
                                }
                            }
                            ++n4;
                        }
                    }
                    results.put(file.getName(), expandedFunctions);
                }
                ++n2;
            }
        }
        return results;
    }

    protected static void createActions() {
        aboutTrackerAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutTracker")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.showAboutTracker();
            }
        };
        if (prefsPath != null) {
            trackerPrefsAction = new AbstractAction(String.valueOf(TrackerRes.getString("Tracker.Prefs.MenuItem.Text")) + "..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (trackerPrefsDialog == null) {
                        String s = ResourceLoader.getString(prefsPath);
                        if (s == null || "".equals(s)) {
                            s = String.valueOf(TrackerRes.getString("Tracker.Prefs.NotFound")) + ": " + prefsPath;
                            JOptionPane.showMessageDialog(null, s, TrackerRes.getString("Tracker.Prefs.NotFound"), 2);
                            return;
                        }
                        trackerPrefsDialog = new JDialog(null, true);
                        trackerPrefsDialog.setTitle(String.valueOf(TrackerRes.getString("ConfigInspector.Title")) + ": " + XML.forwardSlash(prefsPath));
                        trackerPrefsTextArea = new JTextArea();
                        trackerPrefsTextArea.setEditable(false);
                        trackerPrefsTextArea.setTabSize(2);
                        trackerPrefsTextArea.setLineWrap(true);
                        trackerPrefsTextArea.setWrapStyleWord(true);
                        JScrollPane scroller = new JScrollPane(trackerPrefsTextArea);
                        trackerPrefsDialog.setContentPane(scroller);
                        trackerPrefsTextArea.setText(s);
                        trackerPrefsTextArea.setCaretPosition(0);
                        FontSizer.setFonts(trackerPrefsDialog, FontSizer.getLevel());
                        trackerPrefsDialog.setSize(800, 400);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        int x = (dim.width - Tracker.trackerPrefsDialog.getBounds().width) / 2;
                        int y = (dim.height - Tracker.trackerPrefsDialog.getBounds().height) / 2;
                        trackerPrefsDialog.setLocation(x, y);
                    } else {
                        String s = ResourceLoader.getString(prefsPath);
                        trackerPrefsTextArea.setText(s);
                        trackerPrefsTextArea.setCaretPosition(0);
                    }
                    trackerPrefsDialog.setVisible(true);
                }
            };
        }
        if (!OSPRuntime.isJS) {
            readmeAction = new AbstractAction(String.valueOf(TrackerRes.getString("Tracker.Readme")) + "..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (readmeDialog == null && trackerHome != null) {
                        String s;
                        String slash = System.getProperty("file.separator", "/");
                        String path = String.valueOf(trackerHome) + slash + readmeFileName;
                        if (OSPRuntime.isMac()) {
                            path = "/usr/local/tracker/" + readmeFileName;
                        }
                        if ((s = ResourceLoader.getString(path)) == null || "".equals(s)) {
                            s = String.valueOf(TrackerRes.getString("Tracker.Readme.NotFound")) + ": " + path;
                            JOptionPane.showMessageDialog(null, s, TrackerRes.getString("Tracker.Readme.NotFound"), 2);
                            return;
                        }
                        readmeDialog = new JDialog(null, true);
                        readmeDialog.setTitle(TrackerRes.getString("Tracker.Readme"));
                        JTextArea textPane = new JTextArea();
                        textPane.setEditable(false);
                        textPane.setTabSize(2);
                        textPane.setLineWrap(true);
                        textPane.setWrapStyleWord(true);
                        JScrollPane scroller = new JScrollPane(textPane);
                        readmeDialog.setContentPane(scroller);
                        textPane.setText(s);
                        textPane.setCaretPosition(0);
                        readmeDialog.setSize(600, 600);
                        FontSizer.setFonts(readmeDialog, FontSizer.getLevel());
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        int x = (dim.width - Tracker.readmeDialog.getBounds().width) / 2;
                        int y = (dim.height - Tracker.readmeDialog.getBounds().height) / 2;
                        readmeDialog.setLocation(x, y);
                    }
                    readmeDialog.setVisible(true);
                }
            };
            final String startLogPath = System.getenv("START_LOG");
            if (startLogPath != null) {
                startLogAction = new AbstractAction(String.valueOf(TrackerRes.getString("Tracker.StartLog")) + "..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (startLogDialog == null) {
                            String s = ResourceLoader.getString(startLogPath);
                            if (s == null || "".equals(s)) {
                                s = String.valueOf(TrackerRes.getString("Tracker.StartLog.NotFound")) + ": " + startLogPath;
                                JOptionPane.showMessageDialog(null, s, TrackerRes.getString("Tracker.startLogPath.NotFound"), 2);
                                return;
                            }
                            startLogDialog = new JDialog(null, true);
                            startLogDialog.setTitle(TrackerRes.getString("Tracker.StartLog"));
                            JTextArea textPane = new JTextArea();
                            textPane.setEditable(false);
                            textPane.setTabSize(2);
                            textPane.setLineWrap(true);
                            textPane.setWrapStyleWord(true);
                            JScrollPane scroller = new JScrollPane(textPane);
                            startLogDialog.setContentPane(scroller);
                            textPane.setText(s);
                            textPane.setCaretPosition(0);
                            FontSizer.setFonts(startLogDialog, FontSizer.getLevel());
                            startLogDialog.setSize(600, 600);
                            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                            int x = (dim.width - Tracker.startLogDialog.getBounds().width) / 2;
                            int y = (dim.height - Tracker.startLogDialog.getBounds().height) / 2;
                            startLogDialog.setLocation(x, y);
                        }
                        startLogDialog.setVisible(true);
                    }
                };
            }
            aboutJavaAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutJava")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Diagnostics.aboutJava();
                }
            };
            aboutXuggleAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutXuggle")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MovieFactory.showAbout("Xuggle", "Tracker");
                }
            };
            aboutThreadsAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutThreads")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiagnosticsForThreads.aboutThreads();
                }
            };
        }
    }

    protected static Set<String> getFullConfig() {
        TreeSet<String> set = new TreeSet<String>();
        String[] stringArray = fullConfig;
        int n = fullConfig.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            set.add(next);
            ++n2;
        }
        return set;
    }

    protected static Set<String> getDefaultConfig() {
        if (defaultConfig == null) {
            defaultConfig = Tracker.getFullConfig();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (String next : defaultConfig) {
            set.add(next);
        }
        return set;
    }

    protected static void setDefaultConfig(Set<String> config) {
        if (defaultConfig == null) {
            defaultConfig = new TreeSet<String>();
        }
        defaultConfig.clear();
        for (String next : config) {
            defaultConfig.add(next);
        }
    }

    protected static void autoloadDataFunctions() {
        dataFunctionControls.clear();
        for (String dirPath : Tracker.getInitialSearchPaths()) {
            File[] files;
            File dir;
            if (dirPath == null || !(dir = new File(dirPath)).exists() || (files = dir.listFiles(xmlFilter)) == null) continue;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type;
                File file = fileArray[n2];
                XMLControlElement control = new XMLControlElement(file.getPath());
                if (!control.failedToRead() && (type = control.getObjectClass()) != null && TrackDataBuilder.class.isAssignableFrom(type)) {
                    for (XMLProperty next : control.getPropsRaw()) {
                        XMLControl[] panels;
                        if (!next.getPropertyName().equals("functions")) continue;
                        ArrayList<XMLControl> controls = new ArrayList<XMLControl>();
                        XMLControl[] xMLControlArray = panels = next.getChildControls();
                        int n3 = panels.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XMLControl panelControl = xMLControlArray[n4];
                            String trackType = panelControl.getString("description");
                            ArrayList functions = (ArrayList)panelControl.getObject("functions");
                            if (trackType != null && functions != null && !functions.isEmpty()) {
                                controls.add(panelControl);
                            }
                            ++n4;
                        }
                        String filePath = XML.forwardSlash(file.getAbsolutePath());
                        dataFunctionControls.put(filePath, controls);
                    }
                }
                ++n2;
            }
        }
    }

    public static Collection<String> getDefaultAutoloadSearchPaths() {
        return OSPRuntime.getDefaultSearchPaths();
    }

    protected static Collection<String> getInitialSearchPaths() {
        block4: {
            if (!initialAutoloadSearchPaths.isEmpty()) break block4;
            if (preferredAutoloadSearchPaths != null) {
                String[] stringArray = preferredAutoloadSearchPaths;
                int n = preferredAutoloadSearchPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    initialAutoloadSearchPaths.add(next);
                    ++n2;
                }
            } else {
                for (String next : Tracker.getDefaultAutoloadSearchPaths()) {
                    initialAutoloadSearchPaths.add(next);
                }
            }
        }
        return initialAutoloadSearchPaths;
    }

    protected static void setPreferredLocale(String localeName) {
        if (localeName == null) {
            Locale.setDefault(defaultLocale);
            preferredLocale = null;
        } else {
            Tracker.getLocales();
            Locale[] localeArray = locales;
            int n = locales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale locale = localeArray[n2];
                if (locale.toString().equals(localeName)) {
                    Locale.setDefault(locale);
                    preferredLocale = localeName;
                    break;
                }
                ++n2;
            }
        }
        int separator = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        if ("pt_PT".equals(localeName)) {
            separator = 44;
        }
        OSPRuntime.setDefaultDecimalSeparator((char)separator);
    }

    protected static boolean updateResources() {
        String[] updatedEngines = MovieFactory.getUpdatedVideoEngines();
        return updatedEngines != null && updatedEngines.length > 0 && updatedEngines[0].equals("Xuggle");
    }

    protected static boolean areEqual(Set<?> set1, Set<?> set2) {
        for (Object next : set1) {
            if (set2.contains(next)) continue;
            return false;
        }
        for (Object next : set2) {
            if (set1.contains(next)) continue;
            return false;
        }
        return true;
    }

    protected static void showUpgradeStatus(TrackerPanel trackerPanel) {
        checkedForNewerVersion = false;
        boolean userInformed = Tracker.loadCurrentVersion(true, false, true);
        if (!userInformed) {
            String message = TrackerRes.getString("PrefsDialog.Dialog.NewVersion.None.Message");
            if (newerVersion != null) {
                message = String.valueOf(TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Message1")) + " " + newerVersion + " " + TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Message2") + XML.NEW_LINE + "https://" + trackerWebsite;
            }
            TFrame frame = trackerPanel == null ? null : trackerPanel.getTFrame();
            JOptionPane.showMessageDialog(frame, message, TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Title"), 1);
        }
    }

    protected static boolean loadCurrentVersion(boolean ignoreInterval, boolean logToFile, boolean dialogOK) {
        if (OSPRuntime.isJS || TRACKER_TEST_URL == null || !ResourceLoader.isURLAvailable(TRACKER_TEST_URL)) {
            return false;
        }
        if (checkedForNewerVersion) {
            return false;
        }
        checkedForNewerVersion = true;
        long millis = System.currentTimeMillis();
        double days = (double)(millis - lastMillisChecked) / 8.64E7;
        if (logToFile && days < 0.0833) {
            logToFile = false;
        }
        String pageName = Tracker.getPHPPageName(logToFile);
        String newVersion = Tracker.loginGetLatestVersion(pageName);
        if (!ignoreInterval) {
            double interval;
            double d = interval = checkForUpgradeInterval == 0 ? 0.0833 : (double)checkForUpgradeInterval;
            if (days < interval) {
                return false;
            }
        }
        lastMillisChecked = millis;
        if (testOn && testString != null) {
            newVersion = testString;
        }
        int result = 0;
        try {
            result = Tracker.compareVersions(newVersion, "6.3.3");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result > 0) {
            newerVersion = newVersion;
            TFrame tFrame = null;
            Frame[] frames = Frame.getFrames();
            int i = 0;
            int n22 = frames.length;
            while (i < n22) {
                TrackerPanel trackerPanel;
                if (frames[i] instanceof TFrame && (trackerPanel = (tFrame = (TFrame)frames[i]).getSelectedPanel()) != null) {
                    trackerPanel.taintEnabled();
                    trackerPanel.getToolBar(true).refresh("new version");
                }
                ++i;
            }
            String testVersion = latestVersion == null ? "6.3.3" : latestVersion;
            result = 0;
            try {
                result = Tracker.compareVersions(newVersion, testVersion);
            }
            catch (Exception n22) {
                // empty catch block
            }
            if (result == 1 && tFrame != null && dialogOK) {
                Object[] options = new Object[]{TrackerRes.getString("Tracker.Dialog.NewVersion.Button.Upgrade"), TrackerRes.getString("TTrackBar.Popup.MenuItem.LearnMore"), TrackerRes.getString("Tracker.Dialog.NewVersion.Button.Later")};
                String message = String.valueOf(TrackerRes.getString("Tracker.Dialog.NewVersion.Message1")) + " " + newVersion;
                message = String.valueOf(message) + " " + TrackerRes.getString("Tracker.Dialog.NewVersion.Message2");
                message = String.valueOf(message) + "  " + TrackerRes.getString("Tracker.Dialog.NewVersion.Message3");
                message = String.valueOf(message) + "\n" + TrackerRes.getString("Tracker.Dialog.NewVersion.Message4");
                JTextPane pane = new JTextPane();
                pane.setOpaque(false);
                pane.setText(message);
                JCheckBox checkbox = new JCheckBox(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Checkbox"));
                Box b = Box.createHorizontalBox();
                b.add(checkbox);
                b.add(Box.createHorizontalGlue());
                Box box = Box.createVerticalBox();
                box.add(pane);
                box.add(b);
                int response = JOptionPane.showOptionDialog(tFrame, box, TrackerRes.getString("Tracker.Dialog.NewVersion.Title"), 0, 1, TRACKER_ICON, options, options[0]);
                if (response == 0) {
                    new Upgrader(tFrame).upgrade();
                } else if (response == 1) {
                    String websiteURL = "https://" + trackerWebsite + "/change_log.html";
                    OSPDesktop.displayURL(websiteURL);
                }
                if (checkbox.isSelected()) {
                    latestVersion = newVersion;
                }
                return true;
            }
        }
        return false;
    }

    private static String getPHPPageName(boolean logToFile) {
        String page = "version";
        if (logToFile) {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String engine = MovieFactory.getMovieEngineName(false);
            String os = "unknownOS";
            try {
                os = System.getProperty("os.name", "unknownOS").toLowerCase();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            os = os.replace(" ", "");
            if (os.indexOf("windows") > -1) {
                os = "windows";
            }
            page = "log_6.3.3_" + os + "_" + engine;
            if (!"".equals(language)) {
                if (!"".equals(country)) {
                    language = String.valueOf(language) + "-" + country;
                }
                page = String.valueOf(page) + "_" + language;
            }
        }
        return page;
    }

    private static String loginGetLatestVersion(String page) {
        String path = String.valueOf(counterPath) + "page=" + page;
        try {
            URL url = new URL(path);
            Resource res = new Resource(url);
            String version = res.getString().trim();
            OSPLog.finer(String.valueOf(path) + ":   " + version);
            return version;
        }
        catch (Exception exception) {
            return "6.3.3";
        }
    }

    protected static void loadPreferences() {
        XMLControl prefsControl = TrackerStarter.findPreferences();
        if (prefsControl != null) {
            prefsPath = prefsControl.getString("prefsPath");
            if (prefsPath != null) {
                OSPLog.getOSPLog();
                OSPLog.info("preferences loaded from " + XML.getAbsolutePath(new File(prefsPath)));
            }
            prefsControl.loadObject(null);
            boolean bl = isNewInstall = System.getenv("NEW_INSTALL") != null;
            if (isNewInstall) {
                preferredJRE = null;
                preferredTrackerJar = null;
                Tracker.savePreferences();
            }
            return;
        }
        Tracker.loadDefaultPreferences();
        String recommendedPath = null;
        String fileName = "tracker.prefs";
        if (!OSPRuntime.isWindows()) {
            fileName = "." + fileName;
        }
        for (String path : OSPRuntime.getDefaultSearchPaths()) {
            String prefs_path = new File(path, fileName).getAbsolutePath();
            recommendedPath = recommendedPath == null ? prefs_path : String.valueOf(recommendedPath) + " or " + prefs_path;
            XMLControlElement control = new XMLControlElement(new Preferences());
            if (control.write(prefs_path) == null) continue;
            prefsPath = prefs_path;
            OSPLog.getOSPLog();
            OSPLog.info("wrote new preferences file to " + XML.getAbsolutePath(new File(prefsPath)));
        }
        if (prefsPath == null) {
            OSPLog.getOSPLog();
            if (recommendedPath != null) {
                OSPLog.warning("administrator action required: unable to write preferences file to " + recommendedPath);
            } else {
                OSPLog.warning("unable to find or create preferences file tracker.prefs");
            }
        }
    }

    protected static void loadDefaultPreferences() {
        XMLControlElement prefsControl;
        if (trackerHome == null) {
            return;
        }
        File f = new File(trackerHome);
        f = OSPRuntime.isMac() ? new File(f.getParent(), "Resources/tracker.prefs.default") : new File(f.getPath(), DEFAULT_TRACKER_PREFS);
        XMLControlElement xMLControlElement = prefsControl = f.exists() ? new XMLControlElement(f) : null;
        if (prefsControl != null) {
            prefsControl.loadObject(null);
        }
    }

    protected static String savePreferences() {
        XMLControlElement control = new XMLControlElement(new Preferences());
        if (!OSPRuntime.isJS) {
            String xuggleHome;
            if (prefsPath != null) {
                control.write(prefsPath);
                if (isNewInstall) {
                    OSPLog.info("new preferences saved at " + prefsPath);
                }
            }
            int i = 0;
            while (i < 2) {
                String fileName = "tracker.prefs";
                if (i == 1) {
                    fileName = "." + fileName;
                }
                for (String path : OSPRuntime.getDefaultSearchPaths()) {
                    File prefsFile = new File(path, fileName);
                    if (prefsFile.getAbsolutePath().equals(prefsPath) || !prefsFile.exists() || !prefsFile.canWrite()) continue;
                    control.write(prefsFile.getAbsolutePath());
                }
                File prefsFile = new File(fileName);
                if (!prefsFile.getAbsolutePath().equals(prefsPath) && prefsFile.exists() && prefsFile.canWrite()) {
                    control.write(prefsFile.getAbsolutePath());
                }
                ++i;
            }
            if (trackerHome != null && new File(trackerHome, "tracker.jar").exists()) {
                OSPRuntime.setPreference("TRACKER_HOME", trackerHome);
            }
            if ((xuggleHome = System.getenv("XUGGLE_HOME")) != null) {
                OSPRuntime.setPreference("XUGGLE_HOME", xuggleHome);
            }
            OSPRuntime.savePreferences();
            return prefsPath;
        }
        return null;
    }

    protected static Cursor getZoomInCursor() {
        if (zoomInCursor == null) {
            String imageFile = "/org/opensourcephysics/cabrillo/tracker/resources/images/zoom_in.gif";
            Image zoom = ResourceLoader.getImage(imageFile);
            zoomInCursor = GUIUtils.createCustomCursor(zoom, new Point(12, 12), "Zoom In", 0);
        }
        return zoomInCursor;
    }

    protected static boolean isZoomInCursor(Cursor cursor) {
        return cursor == zoomInCursor && zoomInCursor != Cursor.getDefaultCursor();
    }

    protected static Cursor getZoomOutCursor() {
        if (zoomOutCursor == null) {
            String imageFile = "/org/opensourcephysics/cabrillo/tracker/resources/images/zoom_out.gif";
            Image zoom = ResourceLoader.getImage(imageFile);
            zoomOutCursor = GUIUtils.createCustomCursor(zoom, new Point(12, 12), "Zoom Out", 0);
        }
        return zoomOutCursor;
    }

    protected static boolean isZoomOutCursor(Cursor cursor) {
        return cursor == zoomOutCursor && zoomOutCursor != Cursor.getDefaultCursor();
    }

    public static void main(String[] args) {
        OSPLog.debug(SwingJSUtils.Performance.timeCheckStr("Tracker.main start", 0));
        boolean isHeadless = args != null && args.length > 0 && "-headless".equals(args[0]) || "true".equals(System.getProperty("java.awt.headless"));
        Tracker.initClass(isHeadless);
        if (Tracker.initializeJava(args)) {
            Tracker.start(args);
        }
    }

    static void testFinalize(TFrame frame) {
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                TrackerPanel panel = testPanel;
                if (panel == null) {
                    panel = frame.getTrackerPanelForTab(0);
                }
                if (panel == null) {
                    return;
                }
                if (!frame.doCloseAction(panel)) {
                    panel.dispose();
                }
                panel = null;
                System.gc();
                Thread.sleep(500L);
                System.gc();
                Thread.sleep(100000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.exit(0);
        }).start();
    }

    private static boolean initializeJava(String[] args) {
        if (OSPRuntime.isJS) {
            originalMemoryRequest = requestedMemorySize;
            return true;
        }
        String memoryEnvironment = System.getenv("MEMORY_SIZE");
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        long currentMemory = memory.getHeapMemoryUsage().getMax() / 0x100000L;
        boolean bl = isNewInstall = System.getenv("NEW_INSTALL") != null;
        if (!isNewInstall && !Tracker.isRelaunch(args)) {
            boolean isJar = Tracker.checkIsJAR();
            boolean needsJavaVM = Tracker.checkNeedsJVM(currentMemory);
            boolean updated = Tracker.updateResources();
            boolean needsMemory = Tracker.checkNeedsMemory(memoryEnvironment, currentMemory);
            boolean needsEnvironment = Tracker.checkNeedsEnvironment();
            if (isJar && (needsJavaVM || needsMemory || needsEnvironment || updated)) {
                Tracker.doRelaunch(needsJavaVM, needsMemory, needsEnvironment, args);
                return false;
            }
        }
        preferredMemorySize = requestedMemorySize;
        if (requestedMemorySize < 0) {
            requestedMemorySize = (int)(currentMemory + 2L);
        }
        return true;
    }

    private static void doRelaunch(boolean needsJavaVM, boolean needsMemory, boolean needsEnvironment, String[] args) {
        TrackerStarter.logMessage("relaunch required");
        TrackerStarter.logMessage("needs Java VM? " + needsJavaVM);
        TrackerStarter.logMessage("needs memory? " + needsMemory);
        TrackerStarter.logMessage("needs environment? " + needsEnvironment);
        mainArgs = args;
        if (requestedMemorySize <= 10) {
            requestedMemorySize = 1024;
        }
        System.setProperty("PREFERRED_MEMORY_SIZE", String.valueOf(requestedMemorySize));
        System.setProperty("PREFERRED_TRACKER_JAR", OSPRuntime.getLaunchJarPath());
        TrackerStarter.relaunch(mainArgs, true);
    }

    private static boolean checkNeedsEnvironment() {
        try {
            String trackerEnv;
            String trackerDir = TrackerStarter.findTrackerHome(false);
            if (trackerDir != null && !trackerDir.equals(trackerEnv = System.getenv("TRACKER_HOME"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkNeedsMemory(String memoryEnvironment, long currentMemory) {
        if (memoryEnvironment != null) {
            originalMemoryRequest = requestedMemorySize;
            requestedMemorySize = Integer.parseInt(memoryEnvironment);
        }
        return requestedMemorySize > 10 && (currentMemory < (long)(9 * requestedMemorySize / 10) || currentMemory > (long)(11 * requestedMemorySize / 10));
    }

    private static boolean checkNeedsJVM(long currentMemory) {
        boolean needsJavaVM;
        if (usesXuggleServer && JREFinder.getFinder().is32BitVM(preferredJRE)) {
            preferredJRE = null;
        }
        boolean needs64BitVM = usesXuggleServer || !OSPRuntime.isWindows();
        boolean bl = needsJavaVM = OSPRuntime.getVMBitness() == (needs64BitVM ? 32 : 64);
        if (!needsJavaVM) {
            String javaCommand = System.getProperty("java.home");
            javaCommand = String.valueOf(XML.forwardSlash(javaCommand)) + "/bin/java";
            String javaPath = preferredJRE;
            if (javaPath != null) {
                File javaFile;
                javaPath = JREFinder.getFinder().is32BitVM(javaPath) ? null : ((javaFile = OSPRuntime.getJavaFile(javaPath)) != null ? XML.stripExtension(XML.forwardSlash(javaFile.getPath())) : null);
            }
            needsJavaVM = javaPath != null && !javaCommand.equals(javaPath);
        }
        return needsJavaVM;
    }

    private static boolean isRelaunch(String[] args) {
        boolean isRelaunch;
        boolean bl = isRelaunch = args != null && args.length > 0 && "relaunch".equals(args[args.length - 1]);
        if (args != null && isRelaunch) {
            args[args.length - 1] = null;
        } else {
            String s = System.getenv("TRACKER_RELAUNCH");
            isRelaunch = "true".equals(s);
        }
        return isRelaunch;
    }

    private static boolean checkIsJAR() {
        JarFile jarfile = OSPRuntime.getLaunchJar();
        if (jarfile != null) {
            try {
                Attributes att = jarfile.getManifest().getMainAttributes();
                String mainclass = att.getValue("Main-Class");
                String classpath = att.getValue("Class-Path");
                usesXuggleServer = classpath.toString().contains("-server-");
                return mainclass.toString().endsWith("Tracker");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void start(String[] args) {
        TFrame frame;
        FontSizer.setLevel(preferredFontLevel + preferredFontLevelPlus);
        Dataset.maxPointsMultiplier = 32.0;
        Tracker tracker = new Tracker(args, true, true, null);
        OSPRuntime.setAppClass(tracker);
        if (OSPRuntime.isMac()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Tracker");
            String className = "org.opensourcephysics.cabrillo.tracker.deploy.OSXServices";
            try {
                Class<?> OSXClass = Class.forName(className);
                Constructor<?> constructor = OSXClass.getConstructor(Tracker.class);
                constructor.newInstance(tracker);
            }
            catch (Exception OSXClass) {
            }
            catch (Error OSXClass) {
                // empty catch block
            }
        }
        if ((frame = tracker.getFrame()) == null) {
            return;
        }
        if (!OSPRuntime.isJS) {
            frame.setVisible(true);
        }
        frame.setDefaultCloseOperation(3);
        LaunchNode node = OSPRuntime.activeNode;
        if (node != null) {
            frame.setDefaultCloseOperation(1);
        }
        TrackerPanel trackerPanel = frame.getSelectedPanel();
        TToolBar.refreshMemoryButton(trackerPanel);
        if (!OSPRuntime.isJS && originalMemoryRequest > requestedMemorySize) {
            JOptionPane.showMessageDialog(frame, String.valueOf(TrackerRes.getString("Tracker.Dialog.MemoryReduced.Message1")) + " " + originalMemoryRequest + "MB\n" + TrackerRes.getString("Tracker.Dialog.MemoryReduced.Message2") + " " + requestedMemorySize + "MB.\n\n" + TrackerRes.getString("Tracker.Dialog.MemoryReduced.Message3"), TrackerRes.getString("Tracker.Dialog.MemoryReduced.Title"), 1);
        }
        if (warnNoVideoEngine && !MovieFactory.hasVideoEngine()) {
            Tracker.warnNoVideo(frame, trackerPanel);
        }
        Tracker.checkShowStarterWarning();
        Tracker.showJavaMessages(frame);
        if (OSPRuntime.isJS) {
            frame.setVisible(true);
            if (OSPRuntime.cssCursor) {
                new AsyncDialog().showConfirmDialog(frame, TrackerRes.getString("Tracker.Dialog.MobileKeyboard.Message"), TrackerRes.getString("Tracker.Dialog.MobileKeyboard.Title"), 0, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        switch (e.getID()) {
                            case 0: {
                                OSPRuntime.hasKeyboard = true;
                            }
                        }
                    }
                });
            }
        }
    }

    private static void showJavaMessages(TFrame frame) {
        if (!OSPRuntime.isJS) {
            String newVersionURL = System.getenv("TRACKER_NEW_VERSION");
            if (newVersionURL != null) {
                OSPRuntime.trigger(2000, e -> {
                    if (OSPRuntime.isWindows()) {
                        File target = new File(trackerHome, "tracker.jar");
                        ResourceLoader.download(newVersionURL, target, true);
                    }
                    if (preferredTrackerJar != null && !"tracker.jar".equals(preferredTrackerJar)) {
                        String prefVers = preferredTrackerJar.substring(8, preferredTrackerJar.lastIndexOf("."));
                        String s1 = String.valueOf(TrackerRes.getString("Tracker.Dialog.ChangePrefVersionAfterUpgrade.Message1")) + " " + "6.3.3";
                        String s2 = String.valueOf(TrackerRes.getString("Tracker.Dialog.ChangePrefVersionAfterUpgrade.Message2")) + " " + prefVers;
                        String s3 = TrackerRes.getString("Tracker.Dialog.ChangePrefVersionAfterUpgrade.Message3");
                        String title = TrackerRes.getString("Tracker.Dialog.ChangePrefVersionAfterUpgrade.Title");
                        int response = JOptionPane.showConfirmDialog(null, String.valueOf(s1) + XML.NEW_LINE + s2 + XML.NEW_LINE + s3, title, 0, 3);
                        if (response == 0) {
                            preferredTrackerJar = null;
                        }
                        Tracker.savePreferences();
                    }
                });
            }
            frame.startMemoryTimer();
        }
    }

    private static void checkShowStarterWarning() {
        String warningString = System.getenv("STARTER_WARNING");
        if (warningString == null) {
            return;
        }
        String[] lines = warningString.split("\n");
        Box box = Box.createVerticalBox();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            box.add(new JLabel(line));
            ++n2;
        }
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JOptionPane.showMessageDialog(null, box, TrackerRes.getString("Tracker.Dialog.StarterWarning.Title"), 2);
    }

    private static void warnNoVideo(TFrame frame, TrackerPanel trackerPanel) {
        boolean xuggleInstalled = !OSPRuntime.isJS && MovieFactory.hasVideoEngine();
        ArrayList<String> message = new ArrayList<String>();
        boolean showRelaunchDialog = false;
        if (!xuggleInstalled) {
            message.add(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Message1"));
            message.add(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Message2"));
            message.add(" ");
            message.add(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Message3"));
        } else if (OSPRuntime.isWindows() && OSPRuntime.getVMBitness() == 32) {
            message.add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Message1"));
            message.add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Message2"));
            message.add(" ");
            message.add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Question"));
            showRelaunchDialog = true;
        } else {
            message.add(TrackerRes.getString("Tracker.Dialog.EngineProblems.Message1"));
            message.add(TrackerRes.getString("Tracker.Dialog.EngineProblems.Message2"));
        }
        Box box = Box.createVerticalBox();
        for (String line : message) {
            box.add(new JLabel(line));
        }
        box.add(new JLabel("  "));
        JCheckBox checkbox = new JCheckBox(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Checkbox"));
        checkbox.addActionListener(e -> {
            warnNoVideoEngine = !checkbox.isSelected();
        });
        box.add(checkbox);
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        if (showRelaunchDialog) {
            Object[] options = new Object[]{TrackerRes.getString("Tracker.Dialog.Button.RelaunchNow"), TrackerRes.getString("Tracker.Dialog.Button.ContinueWithoutEngine")};
            int response = JOptionPane.showOptionDialog(frame, box, TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Title"), 0, 2, null, options, options[0]);
            if (response == 0) {
                SwingUtilities.invokeLater(() -> {
                    PrefsDialog prefs = frame.getPrefsDialog();
                    prefs.relaunch64Bit();
                });
            }
        } else {
            JOptionPane.showMessageDialog(frame, box, TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Title"), 1);
        }
    }

    protected static void logTime(String message) {
        if (timeLogEnabled) {
            SimpleDateFormat sdf = new SimpleDateFormat("ss.SSS");
            Calendar cal = Calendar.getInstance();
            OSPLog.info(String.valueOf(sdf.format(cal.getTime())) + ": " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addRecent(String filename, boolean atEnd) {
        ArrayList<String> arrayList = recentFiles;
        synchronized (arrayList) {
            while (recentFiles.contains(filename)) {
                recentFiles.remove(filename);
            }
            if (atEnd) {
                recentFiles.add(filename);
            } else {
                recentFiles.add(0, filename);
            }
            while (recentFiles.size() > recentFilesSize) {
                recentFiles.remove(recentFiles.size() - 1);
            }
        }
    }

    protected static void setRecentSize(int max) {
        max = Math.min(max, 12);
        recentFilesSize = Math.max(max, 0);
        while (recentFiles.size() > recentFilesSize) {
            recentFiles.remove(recentFiles.size() - 1);
        }
    }

    public static boolean haveDataFunctions() {
        return !allowDataFunctionControls ? false : !dataFunctionControlStrings.isEmpty() || !dataFunctionControls.isEmpty();
    }

    public static void loadControlStringObjects(Class<?> trackType, FunctionPanel panel) {
        for (String xml : dataFunctionControlStrings) {
            XMLControlElement control = new XMLControlElement(xml);
            Class<?> controlTrackType = null;
            try {
                controlTrackType = Class.forName(control.getString("description"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (controlTrackType != trackType) continue;
            control.loadObject(panel);
        }
    }

    public static void loadControlStrings(Runnable reload) {
        String directory;
        if (dataFunctionControlStrings.isEmpty()) {
            return;
        }
        ArrayList<String> searchPaths = OSPRuntime.getDefaultSearchPaths();
        String string = directory = searchPaths.size() > 0 ? searchPaths.get(0) : null;
        if (directory != null) {
            SwingUtilities.invokeLater(() -> {
                int response = JOptionPane.showConfirmDialog(null, String.valueOf(TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Message1")) + "\n" + TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Message2") + "\n\n" + TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Message3"), TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Title"), 0);
                if (response == 0) {
                    TrackDataBuilder builder = new TrackDataBuilder(new TrackerPanel());
                    int i = 0;
                    for (String next : dataFunctionControlStrings) {
                        XMLControlElement panelControl = new XMLControlElement(next);
                        DataFunctionPanel panel = new DataFunctionPanel(new DatasetManager());
                        panelControl.loadObject(panel);
                        builder.addPanelWithoutAutoloading("panel" + i, panel);
                        ++i;
                    }
                    File file = new File(directory, "TrackerConvertedAutoloadFunctions.xml");
                    XMLControlElement control = new XMLControlElement(builder);
                    control.write(file.getAbsolutePath());
                    dataFunctionControlStrings.clear();
                    reload.run();
                }
            });
        }
    }

    public static void loadControls(Class<?> trackType, FunctionPanel panel) {
        for (String path : dataFunctionControls.keySet()) {
            ArrayList<XMLControl> controls = dataFunctionControls.get(path);
            for (XMLControl control : controls) {
                Class<?> controlTrackType = null;
                try {
                    controlTrackType = Class.forName(control.getString("description"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (controlTrackType != trackType) continue;
                XMLControlElement copyControl = new XMLControlElement(control);
                Tracker.eliminateExcludedFunctions(copyControl, path);
                FunctionEditor editor = panel.getFunctionEditor();
                boolean confirmChanges = editor.getConfirmChanges();
                editor.setConfirmChanges(false);
                copyControl.loadObject(panel);
                editor.setConfirmChanges(confirmChanges);
            }
        }
    }

    private static void eliminateExcludedFunctions(XMLControl panelControl, String filePath) {
        for (XMLProperty functions : panelControl.getPropsRaw()) {
            if (!functions.getPropertyName().equals("functions")) continue;
            List<Object> items = functions.getPropertyContent();
            ArrayList<XMLProperty> toRemove = new ArrayList<XMLProperty>();
            for (Object child : items) {
                XMLProperty item = (XMLProperty)child;
                XMLProperty nameProp = (XMLProperty)item.getPropertyContent().get(0);
                String functionName = (String)nameProp.getPropertyContent().get(0);
                if (!Tracker.isFunctionExcluded(filePath, functionName)) continue;
                toRemove.add(item);
            }
            for (XMLProperty next : toRemove) {
                items.remove(next);
            }
        }
    }

    private static boolean isFunctionExcluded(String filePath, String functionName) {
        String[] functions = autoloadMap.get(filePath);
        if (functions == null) {
            return false;
        }
        String[] stringArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals("*")) {
                return true;
            }
            if (name.equals(functionName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void askToSetMemory(TFrame frame) {
        String s = String.valueOf(TrackerRes.getString("TTrackBar.Dialog.SetMemory.Message")) + " " + 1024 + " MB.";
        String response = GUIUtils.showInputDialog(frame, s, TrackerRes.getString("TTrackBar.Dialog.SetMemory.Title"), -1, String.valueOf(preferredMemorySize));
        if (response == null || response.length() <= 0) {
            return;
        }
        try {
            int n;
            double d = Math.rint(Double.parseDouble(response));
            int n2 = n = d < 0.0 ? -1 : (int)Math.max(d, 32.0);
            if (n != preferredMemorySize) {
                preferredMemorySize = n;
                int ans = JOptionPane.showConfirmDialog(frame, TrackerRes.getString("TTrackBar.Dialog.Memory.Relaunch.Message"), TrackerRes.getString("TTrackBar.Dialog.Memory.Relaunch.Title"), 0, 3);
                if (ans == 0) {
                    Tracker.savePreferences();
                    frame.relaunchCurrentTabs();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int checkMemory(TFrame frame, boolean ignoreLowMemory) {
        long used;
        long[] m = OSPRuntime.getMemory();
        long max = m[1];
        long remaining = max - (used = m[0]);
        boolean warning = remaining < 50L && 1.0 * (double)remaining / (double)max < 0.4 && !ignoreLowMemory;
        boolean danger = remaining < 20L;
        String remains = " " + remaining + " MB";
        String limit = " " + max + " MB";
        if (danger) {
            String message = String.valueOf(TrackerRes.getString("Tracker.Dialog.OutOfMemory.Message1")) + limit + "\n" + TrackerRes.getString("Tracker.Dialog.OutOfMemory.Message2");
            String stop = TrackerRes.getString("Tracker.Dialog.OutOfMemory.Stop");
            String increase = TrackerRes.getString("Tracker.Dialog.OutOfMemory.Increase");
            int response = JOptionPane.showOptionDialog(frame, message, TrackerRes.getString("Tracker.Dialog.OutOfMemory.Title"), -1, 2, null, new String[]{stop, increase}, increase);
            if (response == 1) {
                return 4;
            }
            return 3;
        }
        if (warning) {
            String percent = " (" + (int)(100L * remaining / max) + "%)";
            String message = String.valueOf(TrackerRes.getString("Tracker.Dialog.LowMemory.Message1")) + "\n" + TrackerRes.getString("Tracker.Dialog.LowMemory.Remaining") + remains + percent + "\n" + TrackerRes.getString("Tracker.Dialog.LowMemory.Message2") + "\n\n" + TrackerRes.getString("Tracker.Dialog.LowMemory.Message3");
            if (frame == null) {
                System.out.println(message);
            } else {
                return JOptionPane.showConfirmDialog(frame, message, TrackerRes.getString("Tracker.Dialog.LowMemory.Title"), 0, 2) == 0 ? 1 : 2;
            }
        }
        return 0;
    }

    static void checkSplash() {
        if (splash == null || !splash.isVisible()) {
            return;
        }
        OSPRuntime.trigger(1000, e -> {
            if (splash != null) {
                splash.dispose();
            }
            splash = null;
        });
    }

    static boolean isDefaultConfiguration(Set<String> panelConfig) {
        return Tracker.areEqual(panelConfig, defaultConfig);
    }

    static class Preferences {
        Preferences() {
        }

        public static XML.ObjectLoader getLoader() {
            return new Loader();
        }

        static class Loader
        implements XML.ObjectLoader {
            Loader() {
            }

            @Override
            public void saveObject(XMLControl control, Object obj) {
                String jar;
                if (!preferredLogLevel.equals(DEFAULT_LOG_LEVEL)) {
                    control.setValue("log_level", preferredLogLevel.getName());
                }
                if (!showHintsByDefault) {
                    control.setValue("show_hints", showHintsByDefault);
                }
                if (isRadians) {
                    control.setValue("radians", isRadians);
                }
                if (!markAtCurrentFrame) {
                    control.setValue("mark_current_frame", markAtCurrentFrame);
                }
                if (scrubMouseWheel) {
                    control.setValue("scrub_mousewheel", scrubMouseWheel);
                }
                if (!showGaps) {
                    control.setValue("show_gaps", showGaps);
                }
                if (!enableAutofill) {
                    control.setValue("enable_autofill", enableAutofill);
                }
                if (preferredTrailLengthIndex != 2) {
                    control.setValue("trail_length", TToolBar.trailLengthNames[preferredTrailLengthIndex]);
                }
                if (!centerCalibrationStick) {
                    control.setValue("center_stick", centerCalibrationStick);
                }
                if (DatasetCurveFitter.isFixedDecimalFormat) {
                    control.setValue("decimal_format", DatasetCurveFitter.isFixedDecimalFormat);
                }
                if (!isXuggleFast) {
                    control.setValue("xuggle_smooth", true);
                }
                if (!warnNoVideoEngine) {
                    control.setValue("warn_no_engine", warnNoVideoEngine);
                }
                if (!warnVariableDuration) {
                    control.setValue("warn_variable_frame_duration", warnVariableDuration);
                }
                if (!warnXuggleError) {
                    control.setValue("warn_xuggle_error", warnXuggleError);
                }
                if (!warnSkippedStep) {
                    control.setValue("warn_skipped_step", warnSkippedStep);
                }
                String string = jar = preferredTrackerJar == null ? "tracker.jar" : preferredTrackerJar;
                if (!new File(trackerHome, jar).exists()) {
                    jar = "tracker.jar";
                }
                control.setValue("tracker_jar", jar);
                if (preferredJRE != null) {
                    control.setValue("java_vm", preferredJRE);
                }
                if (preferredPointMassFootprint != null) {
                    control.setValue("pointmass_footprint", preferredPointMassFootprint);
                }
                if (preferredMemorySize > -1) {
                    control.setValue("memory_size", preferredMemorySize);
                }
                if (lookAndFeel != null) {
                    control.setValue("look_feel", lookAndFeel);
                }
                if (prelaunchExecutables.length > 0) {
                    control.setValue("run", prelaunchExecutables);
                }
                if (preferredLocale != null) {
                    control.setValue("locale", preferredLocale);
                }
                if (preferredDecimalSeparator != null) {
                    control.setValue("decimal_separator", preferredDecimalSeparator);
                }
                if (preferredFontLevel > 0) {
                    control.setValue("font_size", preferredFontLevel);
                }
                if (preferredFontLevelPlus > 0) {
                    control.setValue("font_size_plus", preferredFontLevelPlus);
                }
                if (ResourceLoader.getOSPCache() != null) {
                    File cache = ResourceLoader.getOSPCache();
                    control.setValue("cache", cache.getPath());
                }
                control.setValue("upgrade_interval", checkForUpgradeInterval);
                int lastChecked = (int)(lastMillisChecked / 1000L);
                control.setValue("last_checked", lastChecked);
                if (latestVersion != null) {
                    control.setValue("latest_version", latestVersion);
                }
                AsyncFileChooser chooser = VideoIO.getChooser();
                File file = chooser.getCurrentDirectory();
                String userDir = System.getProperty("user.dir");
                if (!file.getAbsolutePath().equals(userDir)) {
                    control.setValue("file_chooser_directory", XML.getAbsolutePath(file));
                }
                if (!VideoIO.getPreferredExportExtension().equals("mp4")) {
                    control.setValue("export_extension", VideoIO.getPreferredExportExtension());
                }
                if (!ExportZipDialog.preferredExtension.equals("jpg")) {
                    control.setValue("zip_export_extension", ExportZipDialog.preferredExtension);
                }
                if (recentFilesSize != 6) {
                    control.setValue("max_recent", recentFilesSize);
                }
                if (!recentFiles.isEmpty()) {
                    control.setValue("recent_files", recentFiles);
                }
                if (preferredAutoloadSearchPaths != null) {
                    control.setValue("autoload_search_paths", preferredAutoloadSearchPaths);
                }
                if (!autoloadMap.isEmpty()) {
                    String[][] autoloadData = new String[autoloadMap.size()][];
                    int i = 0;
                    for (String filePath : autoloadMap.keySet()) {
                        String[] functions = autoloadMap.get(filePath);
                        String[] fileAndFunctions = new String[functions.length + 1];
                        fileAndFunctions[0] = filePath;
                        System.arraycopy(functions, 0, fileAndFunctions, 1, functions.length);
                        autoloadData[i] = fileAndFunctions;
                        ++i;
                    }
                    control.setValue("autoload_exclusions", autoloadData);
                }
                if (!dataFunctionControlStrings.isEmpty()) {
                    control.setValue("data_functions", dataFunctionControlStrings);
                }
                if (defaultConfig != null && !Tracker.areEqual(defaultConfig, Tracker.getFullConfig())) {
                    Configuration config = new Configuration(defaultConfig);
                    control.setValue("configuration", config);
                }
            }

            @Override
            public Object createObject(XMLControl control) {
                return new Preferences();
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                XMLControl child;
                Level logLevel = OSPLog.parseLevel(control.getString("log_level"));
                if (logLevel != null) {
                    preferredLogLevel = logLevel;
                    OSPLog.setLevel(logLevel);
                    if (logLevel == Level.ALL) {
                        OSPLog.showLogInvokeLater();
                    }
                }
                isRadians = control.getBoolean("radians");
                if (control.getPropertyNamesRaw().contains("mark_current_frame")) {
                    markAtCurrentFrame = control.getBoolean("mark_current_frame");
                }
                scrubMouseWheel = control.getBoolean("scrub_mousewheel");
                if (control.getPropertyNamesRaw().contains("enable_autofill")) {
                    enableAutofill = control.getBoolean("enable_autofill");
                }
                if (control.getPropertyNamesRaw().contains("show_gaps")) {
                    showGaps = control.getBoolean("show_gaps");
                }
                if (control.getPropertyNamesRaw().contains("center_stick")) {
                    centerCalibrationStick = control.getBoolean("center_stick");
                }
                boolean bl = isXuggleFast = !control.getBoolean("xuggle_smooth");
                if (control.getPropertyNamesRaw().contains("trail_length")) {
                    String name = control.getString("trail_length");
                    int i = 0;
                    while (i < TToolBar.trailLengthNames.length) {
                        if (TToolBar.trailLengthNames[i].equals(name)) {
                            preferredTrailLengthIndex = i;
                        }
                        ++i;
                    }
                }
                if (control.getPropertyNamesRaw().contains("warn_no_engine")) {
                    warnNoVideoEngine = control.getBoolean("warn_no_engine");
                }
                if (control.getPropertyNamesRaw().contains("warn_xuggle_error")) {
                    warnXuggleError = control.getBoolean("warn_xuggle_error");
                }
                if (control.getPropertyNamesRaw().contains("warn_skipped_step")) {
                    warnSkippedStep = control.getBoolean("warn_skipped_step");
                }
                if (control.getPropertyNamesRaw().contains("warn_variable_frame_duration")) {
                    warnVariableDuration = control.getBoolean("warn_variable_frame_duration");
                }
                if (control.getPropertyNamesRaw().contains("show_hints")) {
                    showHintsByDefault = control.getBoolean("show_hints");
                    showHints = showHintsByDefault;
                    boolean bl2 = startupHintShown = !showHints;
                }
                if (control.getPropertyNamesRaw().contains("java_vm") && OSPRuntime.getJavaFile(preferredJRE = control.getString("java_vm")) == null) {
                    preferredJRE = null;
                }
                preferredPointMassFootprint = control.getString("pointmass_footprint");
                if (control.getPropertyNamesRaw().contains("decimal_format")) {
                    DatasetCurveFitter.isFixedDecimalFormat = control.getBoolean("decimal_format");
                }
                if (control.getPropertyNamesRaw().contains("memory_size")) {
                    requestedMemorySize = control.getInt("memory_size");
                }
                if (control.getPropertyNamesRaw().contains("look_feel")) {
                    lookAndFeel = control.getString("look_feel");
                }
                if (control.getPropertyNamesRaw().contains("decimal_separator")) {
                    preferredDecimalSeparator = control.getString("decimal_separator");
                    OSPRuntime.setPreferredDecimalSeparator(preferredDecimalSeparator);
                }
                if (control.getPropertyNamesRaw().contains("run")) {
                    prelaunchExecutables = (String[])control.getObject("run");
                }
                if (control.getPropertyNamesRaw().contains("locale")) {
                    Tracker.setPreferredLocale(control.getString("locale"));
                }
                if (control.getPropertyNamesRaw().contains("font_size")) {
                    preferredFontLevel = control.getInt("font_size");
                    preferredFontLevelPlus = control.getInt("font_size_plus");
                    if (preferredFontLevelPlus == Integer.MIN_VALUE) {
                        preferredFontLevelPlus = 0;
                    }
                }
                if (ResourceLoader.getOSPCache() == null) {
                    ResourceLoader.setOSPCache(control.getString("cache"));
                }
                if (control.getPropertyNamesRaw().contains("upgrade_interval")) {
                    checkForUpgradeInterval = control.getInt("upgrade_interval");
                    lastMillisChecked = (long)control.getInt("last_checked") * 1000L;
                }
                latestVersion = control.getString("latest_version");
                if (control.getPropertyNamesRaw().contains("file_chooser_directory")) {
                    OSPRuntime.chooserDir = control.getString("file_chooser_directory");
                }
                VideoIO.setPreferredExportExtension(control.getString("export_extension"));
                if (control.getPropertyNamesRaw().contains("zip_export_extension")) {
                    ExportZipDialog.preferredExtension = control.getString("zip_export_extension");
                }
                if (control.getPropertyNamesRaw().contains("max_recent")) {
                    recentFilesSize = control.getInt("max_recent");
                }
                if (control.getPropertyNamesRaw().contains("recent_files")) {
                    ArrayList recent = (ArrayList)ArrayList.class.cast(control.getObject("recent_files"));
                    for (Object next : recent) {
                        Tracker.addRecent(next.toString(), true);
                    }
                }
                preferredAutoloadSearchPaths = (String[])control.getObject("autoload_search_paths");
                if (control.getPropertyNamesRaw().contains("autoload_exclusions")) {
                    String[][] autoloadData;
                    String[][] stringArray = autoloadData = (String[][])control.getObject("autoload_exclusions");
                    int n = autoloadData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] next = stringArray[n2];
                        String filePath = XML.forwardSlash(next[0]);
                        String[] functions = new String[next.length - 1];
                        System.arraycopy(next, 1, functions, 0, functions.length);
                        autoloadMap.put(filePath, functions);
                        ++n2;
                    }
                }
                if (control.getPropertyNamesRaw().contains("data_functions")) {
                    Collection autoloads = (Collection)control.getObject("data_functions");
                    dataFunctionControlStrings.addAll(autoloads);
                }
                if ((child = control.getChildControl("configuration")) != null) {
                    Configuration config = (Configuration)child.loadObject(null);
                    Tracker.setDefaultConfig(config.enabled);
                }
                preferredTrackerJar = control.getString("tracker_jar");
                return obj;
            }
        }
    }
}

