/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javajs.async.AsyncSwingWorker;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.media.core.AsyncVideoI;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.IncrementallyLoadable;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TrackerIO
extends VideoIO {
    static final String[] XUGGLE_VIDEO_EXTENSIONS = new String[]{"mov", "flv", "mp4", "wmv", "avi"};
    public static final Runnable NULL_RUNNABLE = () -> {};
    protected static boolean isffmpegError = false;
    protected static TFrame theFrame;
    protected static PropertyChangeListener ffmpegListener;
    private static boolean loadInSeparateThread;
    private static Set<TrackerMonitor> monitors;
    protected static double defaultBadFrameTolerance;
    protected static boolean dataCopiedToClipboard;
    protected static TreeSet<String> videoFormatDescriptions;
    protected static HashMap<String, VideoType> videoFormats;
    public static String selectedVideoFormat;
    public static final int PROGRESS_PANEL_READY = 5;
    public static final int PROGRESS_VIDEO_LOADED = 85;
    public static final int PROGRESS_TOOLBAR_AND_COORD_READY = 90;
    public static final int PROGRESS_TRACKS_ADDED = 92;
    public static final int PROGRESS_TRACKS_INITIALIZED = 95;
    private static FileFilter[] imageFilters;
    private static FileFilter videoFilter;

    static {
        loadInSeparateThread = true;
        monitors = new HashSet<TrackerMonitor>();
        defaultBadFrameTolerance = 0.2;
        if (!OSPRuntime.isJS) {
            ffmpegListener = e -> {
                if (e.getPropertyName().equals("ffmpeg_error") && !isffmpegError) {
                    isffmpegError = true;
                    if (!Tracker.warnXuggleError) {
                        if (e.getNewValue() != null) {
                            String s = e.getNewValue().toString();
                            int n = s.indexOf("]");
                            if (n > -1) {
                                s = s.substring(n + 1);
                            }
                            s = String.valueOf(s) + TrackerRes.getString("TrackerIO.ErrorFFMPEG.LogMessage");
                            OSPLog.warning(s);
                        }
                        return;
                    }
                    Box box = Box.createVerticalBox();
                    box.add(new JLabel(TrackerRes.getString("TrackerIO.Dialog.ErrorFFMPEG.Message1")));
                    String error = e.getNewValue().toString();
                    int n = error.lastIndexOf("]");
                    if (n > -1) {
                        error = error.substring(n + 1).trim();
                    }
                    box.add(new JLabel("  "));
                    JLabel erLabel = new JLabel("\"" + error + "\"");
                    erLabel.setBorder(BorderFactory.createEmptyBorder(0, 60, 0, 0));
                    box.add(erLabel);
                    box.add(new JLabel("  "));
                    box.add(new JLabel(TrackerRes.getString("TrackerIO.Dialog.ErrorFFMPEG.Message2")));
                    box.add(new JLabel("  "));
                    box.setBorder(BorderFactory.createEmptyBorder(20, 15, 0, 15));
                    final JDialog dialog = new JDialog((Frame)theFrame, false);
                    JPanel contentPane = new JPanel(new BorderLayout());
                    dialog.setContentPane(contentPane);
                    contentPane.add((Component)box, "Center");
                    JButton closeButton = new JButton(TrackerRes.getString("Dialog.Button.Close"));
                    closeButton.setForeground(new Color(0, 0, 102));
                    closeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dialog.setVisible(false);
                        }
                    });
                    JButton dontShowAgainButton = new JButton(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Checkbox"));
                    dontShowAgainButton.setForeground(new Color(0, 0, 102));
                    dontShowAgainButton.addActionListener(ee -> {
                        Tracker.warnXuggleError = false;
                        dialog.setVisible(false);
                    });
                    JPanel buttonbar = new JPanel();
                    buttonbar.add(dontShowAgainButton);
                    buttonbar.add(closeButton);
                    buttonbar.setBorder(BorderFactory.createEtchedBorder());
                    contentPane.add((Component)buttonbar, "South");
                    FontSizer.setFonts(dialog, FontSizer.getLevel());
                    dialog.pack();
                    dialog.setTitle(TrackerRes.getString("TrackerIO.Dialog.ErrorFFMPEG.Title"));
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    int x = (dim.width - dialog.getBounds().width) / 2;
                    int y = (dim.height - dialog.getBounds().height) / 2;
                    dialog.setLocation(x, y);
                    dialog.setVisible(true);
                }
            };
            OSPLog.addPropertyChangeListener(ffmpegListener);
        }
        zipFileFilter = new VideoIO.SingleExtFileFilter("zip", TrackerRes.getString("TrackerIO.ZipFileFilter.Description"));
        trzFileFilter = new VideoIO.SingleExtFileFilter("trz", TrackerRes.getString("TrackerIO.ZIPResourceFilter.Description"));
        txtFileFilter = new VideoIO.SingleExtFileFilter("txt", TrackerRes.getString("TrackerIO.TextFileFilter.Description"));
        jarFileFilter = new VideoIO.SingleExtFileFilter("jar", TrackerRes.getString("TrackerIO.JarFileFilter.Description"));
        trkFileFilter = new VideoIO.SingleExtFileFilter("trk", TrackerRes.getString("TrackerIO.DataFileFilter.Description")){

            @Override
            public boolean accept(File f, boolean checkDir) {
                return checkDir && f.isDirectory() || zipFileFilter.accept(f, false) || trzFileFilter.accept(f, false) || super.accept(f, false);
            }
        };
        videoAndTrkFileFilter = new VideoIO.SingleExtFileFilter(null, TrackerRes.getString("TrackerIO.VideoAndDataFileFilter.Description")){

            @Override
            public boolean accept(File f, boolean checkDir) {
                return checkDir && f.isDirectory() || trkFileFilter.accept(f, false) || videoFileFilter.accept(f, false) || super.accept(f, false);
            }
        };
        delimitedTextFileFilter = new VideoIO.SingleExtFileFilter(null, "Delimited Text Files"){

            @Override
            public boolean accept(File f, boolean checkDir) {
                String ext = TrackerIO.getExtension(f);
                return checkDir && f.isDirectory() || "txt".equalsIgnoreCase(ext) || "csv".equalsIgnoreCase(ext);
            }
        };
        videoFormatDescriptions = new TreeSet();
        videoFormats = new HashMap();
    }

    private TrackerIO() {
    }

    public static Map<String, String> getDelimiters() {
        if (delimiters.isEmpty()) {
            delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Tab"), "\t");
            delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Space"), " ");
            delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Comma"), ",");
            delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Semicolon"), ";");
        }
        return delimiters;
    }

    public static File save(File file, TrackerPanel trackerPanel) {
        VideoClip clip;
        trackerPanel.restoreViews();
        TrackerIO.getChooser().setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(trkFileFilter);
        chooser.setAccessory(null);
        if (file == null && trackerPanel.getDataFile() == null && (clip = trackerPanel.getPlayer().getVideoClip()).getVideoPath() != null) {
            File dir = new File(clip.getVideoPath()).getParentFile();
            chooser.setCurrentDirectory(dir);
        }
        boolean isNew = file == null;
        file = TrackerIO.save(file, trackerPanel, TrackerRes.getString("TrackerIO.Dialog.SaveTab.Title"));
        chooser.removeChoosableFileFilter(trkFileFilter);
        chooser.setAcceptAllFileFilterUsed(true);
        if (isNew && file != null) {
            Tracker.addRecent(XML.getAbsolutePath(file), false);
            trackerPanel.refreshMenus("TrackerIO.save");
        }
        return file;
    }

    public static File saveTabset(File file, TFrame frame) {
        int n = 0;
        int i = 0;
        while (i < frame.getTabCount()) {
            TrackerPanel trackerPanel = frame.getTrackerPanelForTab(i);
            if (trackerPanel.getDataFile() != null) {
                ++n;
            } else {
                String path;
                Video video2 = trackerPanel.getVideo();
                if (!trackerPanel.changed && video2 != null && (path = (String)video2.getProperty("absolutePath")) != null) {
                    ++n;
                } else {
                    int selected = JOptionPane.showConfirmDialog(frame, String.valueOf(TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Message1")) + " " + i + " (\"" + frame.getTabTitle(i) + "\") " + TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Message2") + XML.NEW_LINE + TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Message3"), TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Title"), 1);
                    if (selected == 2) {
                        return null;
                    }
                    if (selected == 0) {
                        TrackerIO.getChooser().setAccessory(null);
                        File newFile = TrackerIO.save(null, trackerPanel, TrackerRes.getString("TrackerIO.Dialog.SaveTab.Title"));
                        if (newFile == null) {
                            return null;
                        }
                        Tracker.addRecent(XML.getAbsolutePath(newFile), false);
                        ++n;
                    }
                }
            }
            ++i;
        }
        if (n == 0) {
            JOptionPane.showMessageDialog(frame, TrackerRes.getString("TrackerIO.Dialog.NoTabs.Message"), TrackerRes.getString("TrackerIO.Dialog.NoTabs.Title"), 2);
            return null;
        }
        if (file == null) {
            File[] files = TrackerIO.getChooserFiles("save tabset");
            if (files == null || files.length == 0) {
                return null;
            }
            file = files[0];
        }
        frame.tabsetFile = file;
        XMLControlElement xmlControl = new XMLControlElement(frame);
        xmlControl.write(XML.getAbsolutePath(file));
        Tracker.addRecent(XML.getAbsolutePath(file), false);
        frame.getSelectedPanel().refreshMenus("TrackerIO.saveTabset");
        return file;
    }

    @Deprecated
    public static File[] getChooserFiles(String type) {
        return TrackerIO.getChooserFilesAsync(null, type, null);
    }

    public static File[] getChooserFilesAsync(TFrame frame, String type, Function<File[], Void> processFiles) {
        File[] fileArray;
        AsyncFileChooser chooser = TrackerIO.getChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setAccessory(null);
        Runnable resetChooser = () -> {
            if (frame != null) {
                frame.setCursor(Cursor.getDefaultCursor());
            }
            chooser.resetChoosableFileFilters();
            chooser.setSelectedFile(null);
        };
        Runnable okOpen = () -> {
            if (frame != null) {
                frame.setCursor(Cursor.getDefaultCursor());
            }
            if (processFiles != null) {
                File[] fileArray;
                File[] files = chooser.getSelectedFiles();
                File file = chooser.getSelectedFile();
                resetChooser.run();
                if (files != null && files.length > 0) {
                    fileArray = files;
                } else if (file != null) {
                    File[] fileArray2 = new File[1];
                    fileArray = fileArray2;
                    fileArray2[0] = file;
                } else {
                    fileArray = null;
                }
                processFiles.apply(fileArray);
            }
        };
        Runnable okSave = () -> {
            File file = chooser.getSelectedFile();
            resetChooser.run();
            if (TrackerIO.canWrite(file)) {
                processFiles.apply(new File[]{file});
            }
        };
        File ret = null;
        boolean isSave = false;
        switch (type.toLowerCase()) {
            case "open": {
                chooser.addChoosableFileFilter(videoAndTrkFileFilter);
                chooser.setFileFilter(videoAndTrkFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "open trk": {
                chooser.addChoosableFileFilter(trkFileFilter);
                chooser.setFileFilter(trkFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "open any": {
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "open video": {
                chooser.addChoosableFileFilter(videoFileFilter);
                chooser.setFileFilter(videoFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "open data": {
                chooser.addChoosableFileFilter(txtFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.OpenData.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "open ejs": {
                chooser.addChoosableFileFilter(jarFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.OpenEJS.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "insert images": {
                chooser.setMultiSelectionEnabled(true);
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.addChoosableFileFilter(imageFileFilter);
                chooser.setSelectedFile(new File(""));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "import file": {
                chooser.addChoosableFileFilter(trkFileFilter);
                chooser.setFileFilter(trkFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Import.Title"));
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "export file": {
                isSave = true;
                chooser.addChoosableFileFilter(trkFileFilter);
                chooser.setFileFilter(trkFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Export.Title"));
                chooser.showSaveDialog(null, okSave, resetChooser);
                break;
            }
            case "save thumbnail": {
                File[] fileArray2;
                isSave = true;
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setDialogTitle(TrackerRes.getString("ThumbnailDialog.Chooser.SaveThumbnail.Title"));
                if (chooser.showSaveDialog(null) != 0) {
                    return null;
                }
                File f = chooser.getSelectedFile();
                if (f == null) {
                    fileArray2 = null;
                } else {
                    File[] fileArray3 = new File[1];
                    fileArray2 = fileArray3;
                    fileArray3[0] = f;
                }
                return fileArray2;
            }
            case "save data": {
                File[] fileArray4;
                isSave = true;
                chooser.resetChoosableFileFilters();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.addChoosableFileFilter(txtFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("ExportDataDialog.Chooser.SaveData.Title"));
                if (chooser.showSaveDialog(null) != 0) {
                    return null;
                }
                File f = chooser.getSelectedFile();
                if (f == null) {
                    fileArray4 = null;
                } else {
                    File[] fileArray5 = new File[1];
                    fileArray4 = fileArray5;
                    fileArray5[0] = f;
                }
                return fileArray4;
            }
            case "save tabset": {
                isSave = true;
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.addChoosableFileFilter(trkFileFilter);
                chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.SaveTabset.Title"));
                String filename = "";
                File[] theFile = new File[]{new File(String.valueOf(filename) + "." + defaultXMLExt)};
                String parent = XML.getDirectoryPath(filename);
                if (!parent.equals("")) {
                    XML.createFolders(parent);
                    chooser.setCurrentDirectory(new File(parent));
                }
                chooser.setSelectedFile(theFile[0]);
                chooser.showSaveDialog(null, () -> {
                    fileArray[0] = chooser.getSelectedFile();
                    resetChooser.run();
                    if (processFiles != null) {
                        processFiles.apply(new File[]{TrackerIO.fixXML(theFile[0])});
                    }
                }, resetChooser);
                ret = processFiles != null || chooser.getSelectedOption() != 0 ? null : TrackerIO.fixXML(theFile[0]);
                break;
            }
            case "save document": {
                File[] fileArray6;
                isSave = true;
                chooser.resetChoosableFileFilters();
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setDialogTitle(TrackerRes.getString("TMenuBar.Menu.Save"));
                chooser.showSaveDialog(null, () -> {
                    File fil = chooser.getSelectedFile();
                    resetChooser.run();
                    if (processFiles != null) {
                        processFiles.apply(new File[]{fil});
                    }
                }, resetChooser);
                File f = chooser.getSelectedFile();
                if (f == null) {
                    fileArray6 = null;
                } else {
                    File[] fileArray7 = new File[1];
                    fileArray6 = fileArray7;
                    fileArray7[0] = f;
                }
                return fileArray6;
            }
            default: {
                return TrackerIO.getChooserFilesAsync(frame, "save document", processFiles);
            }
        }
        ret = TrackerIO.processChoose(chooser, ret, processFiles != null);
        if (processFiles == null) {
            resetChooser.run();
        }
        if (ret == null || isSave && !TrackerIO.canWrite(ret)) {
            fileArray = null;
        } else {
            File[] fileArray8 = new File[1];
            fileArray = fileArray8;
            fileArray8[0] = ret;
        }
        return fileArray;
    }

    protected static File fixXML(File file) {
        if (file == null) {
            return null;
        }
        if (!defaultXMLExt.equals(TrackerIO.getExtension(file))) {
            String filename = XML.stripExtension(file.getPath());
            File f = new File(String.valueOf(filename) + "." + defaultXMLExt);
            if (OSPRuntime.isJS) {
                OSPRuntime.jsutil.setFileBytes(f, (Object)OSPRuntime.jsutil.getBytes(file));
                OSPRuntime.cacheJSFile(f, true);
            }
            file = f;
        }
        return file;
    }

    public static File getChooserFileForName(String name) {
        String extension = XML.getExtension(name);
        extension = extension != null && !extension.trim().equals("") ? extension.trim().toLowerCase() : null;
        final String ext = extension;
        TrackerIO.getChooser().setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveVideoAs.Title"));
        chooser.setSelectedFile(new File(name));
        chooser.resetChoosableFileFilters();
        chooser.setAccessory(null);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(ext != null);
        if (ext != null) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    return ext.equals(TrackerIO.getExtension(f));
                }

                @Override
                public String getDescription() {
                    String file = TrackerRes.getString("TMenuBar.Menu.File").toLowerCase();
                    return String.valueOf(ext.toUpperCase()) + " " + file + " (." + ext + ")";
                }
            };
            chooser.addChoosableFileFilter(fileFilter);
            chooser.setFileFilter(fileFilter);
        }
        int result = chooser.showSaveDialog(null);
        File file = chooser.getSelectedFile();
        chooser.resetChoosableFileFilters();
        chooser.setSelectedFile(new File(""));
        if (file == null) {
            return null;
        }
        if (result == 0) {
            if (ext != null && !ext.equals(XML.getExtension(file.getName()))) {
                String path = file.getAbsolutePath();
                path = String.valueOf(XML.stripExtension(path)) + "." + ext;
                file = new File(path);
            }
            if (!TrackerIO.canWrite(file)) {
                return null;
            }
            return file;
        }
        return null;
    }

    public static boolean loadFiles(TFrame frame, List<File> fileList, final TrackerPanel targetPanel) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                int frameNumber = -1;
                int nf = fileList.size();
                boolean haveOneVideo = nf == 1 && TrackerIO.isVideo(fileList.get(0));
                boolean haveOneData = nf == 1 && delimitedTextFileFilter.accept(fileList.get(0), false);
                int j = 0;
                while (j < nf) {
                    final File file = fileList.get(j);
                    OSPRuntime.cacheJSFile(file, true);
                    if (!haveOneVideo && !haveOneData) {
                        list.add(XML.getAbsolutePath(file));
                    } else if (targetPanel == null) {
                        list.add(XML.getAbsolutePath(file));
                    } else if (haveOneData) {
                        targetPanel.importDataAsync(XML.getAbsolutePath(file), null, null);
                    } else {
                        boolean addFramesAllowed = false;
                        if (addFramesAllowed && targetPanel.getVideo() instanceof ImageVideo && TrackerIO.isImageFile(file)) {
                            if (frameNumber < 0) {
                                frameNumber = 0;
                                targetPanel.setMouseCursor(Cursor.getPredefinedCursor(3));
                                frame.setCursor(Cursor.getPredefinedCursor(3));
                                if (targetPanel.getVideo() != null) {
                                    frameNumber = targetPanel.getVideo().getFrameNumber();
                                }
                            }
                            File[] added = TrackerIO.insertImagesIntoVideo(new File[]{file}, targetPanel, frameNumber + 1);
                            frameNumber += added.length;
                        } else {
                            Runnable runner = new Runnable(){

                                @Override
                                public void run() {
                                    TrackerIO.importVideo(file.getAbsolutePath(), targetPanel, null);
                                }
                            };
                            TrackerIO.run("TFrame.loadFiles", runner);
                        }
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                if (list.isEmpty()) {
                    frame.setCursor(Cursor.getDefaultCursor());
                } else {
                    TrackerIO.openFiles(frame, list, () -> frame.setCursor(Cursor.getDefaultCursor()));
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (list.isEmpty()) {
                frame.setCursor(Cursor.getDefaultCursor());
            } else {
                TrackerIO.openFiles(frame, list, () -> frame.setCursor(Cursor.getDefaultCursor()));
            }
            throw throwable;
        }
        if (list.isEmpty()) {
            frame.setCursor(Cursor.getDefaultCursor());
        } else {
            TrackerIO.openFiles(frame, list, () -> frame.setCursor(Cursor.getDefaultCursor()));
        }
        return true;
    }

    public static void openFileFromDialog(File file, TFrame frame, Runnable whenDone) {
        if (file == null) {
            TrackerIO.getChooserFilesAsync(frame, "open", files -> {
                File f = null;
                if (files != null) {
                    f = files[0];
                }
                if (f == null) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    OSPLog.finer("no file to open");
                } else {
                    TrackerIO.openFiles(frame, TrackerIO.listOf(f), whenDone);
                }
                return null;
            });
        } else {
            TrackerIO.openFiles(frame, TrackerIO.listOf(file), whenDone);
        }
    }

    static void openFiles(TFrame frame, List<String> files, Runnable whenDone) {
        frame.loadedFiles.clear();
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < files.size()) {
            String next = files.get(i);
            if (next != null && !next.contains("/OSP/Cache/") && trzFileFilter.accept(new File(next), false)) {
                paths.add(next);
            }
            ++i;
        }
        TrackerIO.startLoading(files, null, frame, null, () -> {
            int i = 0;
            while (i < paths.size()) {
                TrackerIO.addToLibrary(frame, (String)paths.get(i));
                ++i;
            }
        });
    }

    private static AsyncLoader startLoading(List<String> paths, TrackerPanel existingPanel, TFrame frame, LibraryBrowser libraryBrowser, Runnable whenDone) {
        loadIncrementally = true;
        AsyncLoader loader = new AsyncLoader(paths, existingPanel, frame, libraryBrowser, whenDone);
        if (frame == null) {
            loader.executeSynchronously();
        } else {
            loader.execute();
        }
        return loader;
    }

    static void run(String name, Runnable r) {
        if (loadInSeparateThread) {
            Thread t = new Thread(r);
            t.setName(name);
            t.setPriority(5);
            t.setDaemon(true);
            t.start();
        } else {
            r.run();
        }
    }

    public static AsyncLoader openURL(String path, TFrame frame, Runnable whenDone) {
        if (frame != null) {
            frame.loadedFiles.clear();
        }
        return TrackerIO.startLoading(TrackerIO.listOf(path), null, frame, null, () -> {
            if (frame != null && trzFileFilter.accept(new File(path), false) && !ResourceLoader.isHTTP(path) && !path.contains("/OSP/Cache/")) {
                TrackerIO.addToLibrary(frame, path);
            }
            if (whenDone != null) {
                whenDone.run();
            }
        });
    }

    public static AsyncLoader openFromLibrary(List<String> uriPaths, TFrame frame, Runnable whenDone) {
        if (uriPaths == null || uriPaths.isEmpty()) {
            return null;
        }
        frame.loadedFiles.clear();
        return TrackerIO.startLoading(uriPaths, null, frame, frame.libraryBrowser, whenDone);
    }

    private static void addToLibrary(TFrame frame, String path) {
        if (!OSPRuntime.autoAddLibrary) {
            return;
        }
        TrackerIO.run("addToLibrary", () -> {
            frame.getLibraryBrowser().open(path);
            OSPRuntime.trigger(1000, e -> {
                LibraryTreePanel treePanel = frame.getLibraryBrowser().getSelectedTreePanel();
                if (treePanel != null) {
                    treePanel.refreshSelectedNode();
                }
            });
        });
    }

    public static void importFile(final TrackerPanel trackerPanel) {
        TFrame frame = trackerPanel.getTFrame();
        TrackerIO.getChooserFilesAsync(frame, "import file", new Function<File[], Void>(){

            @Override
            public Void apply(File[] files) {
                if (files != null) {
                    TrackerIO.importXMLAction(trackerPanel, files[0]);
                }
                return null;
            }
        });
    }

    protected static void importXMLAction(TrackerPanel trackerPanel, File file) {
        String path;
        Map<String, ZipEntry> contents;
        if ((trzFileFilter.accept(file) || zipFileFilter.accept(file)) && (contents = ResourceLoader.getZipContents(path = file.getAbsolutePath(), true)) != null) {
            for (String key : contents.keySet()) {
                ZipEntry entry = contents.get(key);
                String name = entry.getName();
                if (name == null || !name.toLowerCase().endsWith(".trk")) continue;
                name = String.valueOf(file.getAbsolutePath()) + "!/" + name;
                file = new File(name);
                break;
            }
        }
        OSPLog.fine("importing from " + file);
        XMLControlElement control = new XMLControlElement(file.getAbsolutePath());
        Class<?> type = control.getObjectClass();
        if (TrackerPanel.class.equals(type)) {
            TrackerIO.choose(trackerPanel, control, false, () -> {
                ArrayList tracks;
                ImageCoordSystem coords;
                trackerPanel.changed = true;
                VideoClip vidClip = (VideoClip)control.getObject("videoclip");
                if (vidClip != null) {
                    trackerPanel.getPlayer().setVideoClip(vidClip);
                }
                if ((coords = (ImageCoordSystem)control.getObject("coords")) != null) {
                    trackerPanel.setCoords(coords);
                }
                if ((tracks = (ArrayList)ArrayList.class.cast(control.getObject("tracks"))) != null) {
                    int i = 0;
                    int n = tracks.size();
                    while (i < n) {
                        trackerPanel.addTrack((TTrack)tracks.get(i));
                        ++i;
                    }
                }
                trackerPanel.refreshTrackData(0x8000000);
                TToolBar.refreshMemoryButton(trackerPanel);
            });
        } else {
            JOptionPane.showMessageDialog(trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.LoadFailed.Message")) + " " + XML.getName(XML.getAbsolutePath(file)), TrackerRes.getString("TrackerPanel.Dialog.LoadFailed.Title"), 2);
        }
    }

    public static File saveVideo(File file, TrackerPanel trackerPanel, boolean asZipFile, boolean notify) {
        int pt;
        Video video2 = trackerPanel.getVideo();
        if (video2 == null) {
            return null;
        }
        boolean isImageVideo = video2 instanceof ImageVideo;
        if (isImageVideo) {
            asZipFile |= OSPRuntime.isJS;
            boolean saved = ((ImageVideo)video2).saveInvalidImages();
            if (!saved) {
                return null;
            }
        }
        String source = (String)video2.getProperty("absolutePath");
        String name = XML.getName(source);
        if (asZipFile && (pt = name.indexOf("00.")) > 0) {
            name = name.substring(0, pt);
        }
        if (file == null && (file = TrackerIO.getChooserFileForName(name)) == null) {
            return null;
        }
        if (asZipFile && !file.getName().endsWith(".zip")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".zip");
        }
        boolean success = true;
        boolean isZipSource = source.endsWith(".zip");
        if (!isZipSource && (isImageVideo || asZipFile)) {
            String targetDir = XML.forwardSlash(file.getParent());
            String[] paths = isImageVideo ? ((ImageVideo)video2).getValidPaths() : new String[video2.getFrameCount()];
            name = file.getName();
            String[] targets = ImageVideoRecorder.getFileNames(name, paths.length, isImageVideo ? XML.getExtension(name) : "png");
            String[] jarURLParts = ResourceLoader.getJarURLParts(source);
            String srcDir = jarURLParts == null ? (XML.forwardSlash(source).contains(":/") ? "" : String.valueOf(XML.getDirectoryPath(source)) + "/") : String.valueOf(XML.getDirectoryPath(source)) + "/";
            ZipOutputStream zos = null;
            if (asZipFile) {
                try {
                    zos = new ZipOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            int i2 = 0;
            while (i2 < paths.length) {
                File out;
                File in = paths[i2] == null ? null : new File(String.valueOf(srcDir) + paths[i2]);
                File file2 = out = zos == null ? new File(targetDir, targets[i2]) : null;
                if (in == null) {
                    if (zos == null) {
                        success = false;
                        break;
                    }
                    try {
                        zos.putNextEntry(new ZipEntry(targets[i2]));
                        zos.write(TrackerIO.getImageBytes(trackerPanel, i2));
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        success = false;
                    }
                } else {
                    success = ResourceLoader.copyAllFiles(in, zos == null ? out : zos);
                }
                if (!success) break;
                ++i2;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException i2) {
                    // empty catch block
                }
            }
            if (success && !OSPRuntime.isJS) {
                String msg = String.valueOf(targets.length) + " files were saved in " + (asZipFile ? file : targetDir);
                if (notify) {
                    JOptionPane.showMessageDialog(null, msg, "", 1);
                } else {
                    System.out.println(msg);
                }
            }
        } else {
            success = ResourceLoader.copyAllFiles(new File(ResourceLoader.getNonURIPath(source)), file);
        }
        if (!success) {
            return null;
        }
        if (notify && !OSPRuntime.isJS) {
            Tracker.addRecent(XML.getAbsolutePath(file), false);
            trackerPanel.getTFrame().refreshMenus(trackerPanel, "TrackerIO.saveVideoOK");
        }
        return file;
    }

    public static void importVideo(final TrackerPanel trackerPanel, final Runnable whenDone) {
        AsyncFileChooser chooser = TrackerIO.getChooser();
        chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.ImportVideo.Title"));
        TFrame frame = trackerPanel.getTFrame();
        TrackerIO.getChooserFilesAsync(frame, "open video", new Function<File[], Void>(){

            @Override
            public Void apply(File[] files) {
                File file;
                File file2 = file = files == null ? null : files[0];
                if (file != null) {
                    OSPRuntime.cacheJSFile(file, true);
                    TrackerIO.run("importVideo", () -> TrackerIO.importVideo(file.getAbsolutePath(), trackerPanel, whenDone));
                }
                return null;
            }
        });
    }

    public static void importVideo(String path, TrackerPanel trackerPanel, Runnable whenDone) {
        TFrame frame = trackerPanel.getTFrame();
        frame.loadedFiles.clear();
        loader = TrackerIO.startLoading(TrackerIO.listOf(path), trackerPanel, frame, frame.libraryBrowser, whenDone);
    }

    static List<String> listOf(String path) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(path);
        return list;
    }

    static List<String> listOf(File f) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(XML.getAbsolutePath(f));
        return list;
    }

    public static BitSet findBadVideoFrames(TrackerPanel trackerPanel, double tolerance, boolean showDialog, boolean onlyIfFound, boolean showSetDefaultButton) {
        Object[] objectArray;
        Video video2 = trackerPanel.getVideo();
        if (video2 == null) {
            return new BitSet();
        }
        BitSet outliers = video2.getOutliers(tolerance);
        if (!showDialog || outliers.isEmpty() && onlyIfFound) {
            return outliers;
        }
        NumberFormat format = NumberFormat.getInstance();
        String message = TrackerRes.getString("TrackerIO.Dialog.DurationIsConstant.Message");
        int messageType = 1;
        if (!outliers.isEmpty()) {
            messageType = 2;
            int last = outliers.length() - 1;
            int maxClear = -1;
            int start = 0;
            int end = 0;
            int prevBadFrame = -1;
            int i = outliers.nextSetBit(0);
            while (i >= 0) {
                int clear = i - prevBadFrame - 2;
                if (clear > maxClear) {
                    start = prevBadFrame + 1;
                    end = i - 1;
                    maxClear = clear;
                    prevBadFrame = i;
                }
                i = outliers.nextSetBit(i + 1);
            }
            VideoClip clip = trackerPanel.getPlayer().getVideoClip();
            if (clip.getEndFrameNumber() - last - 1 > maxClear) {
                start = last + 1;
                end = clip.getEndFrameNumber();
            }
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
            message = TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message1");
            message = String.valueOf(message) + " " + (int)(tolerance * 100.0) + "%.";
            message = String.valueOf(message) + "\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message2");
            message = String.valueOf(message) + "\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message3");
            message = String.valueOf(message) + "\n\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message4");
            int count = 2;
            int i2 = outliers.nextSetBit(0);
            while (i2 >= 0) {
                ++count;
                message = String.valueOf(message) + " " + i2 + " (" + format.format(video2.getFrameDuration(i2)) + "ms)";
                if (i2 < last) {
                    message = String.valueOf(message) + ",";
                }
                if (count % 6 == 0) {
                    message = String.valueOf(message) + "\n";
                }
                i2 = outliers.nextSetBit(i2 + 1);
            }
            message = String.valueOf(message) + "\n\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Recommended") + ":  " + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Start") + " " + start + ",  " + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.End") + " " + end + "\n ";
        } else {
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
            double frameDur = trackerPanel.getPlayer().getClipControl().getMeanFrameDuration();
            message = String.valueOf(message) + ": " + format.format(frameDur) + "ms";
        }
        String close = TrackerRes.getString("Dialog.Button.OK");
        String dontShow = TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Checkbox");
        if (showSetDefaultButton) {
            String[] stringArray = new String[2];
            stringArray[0] = dontShow;
            objectArray = stringArray;
            stringArray[1] = close;
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = close;
        }
        Object[] buttons = objectArray;
        new AsyncDialog().showOptionDialog(theFrame, message, TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Title"), 0, messageType, null, buttons, close, arg_0 -> TrackerIO.lambda$15((String[])buttons, dontShow, arg_0));
        return null;
    }

    public static void insertImagesIntoVideo(final TrackerPanel trackerPanel, final int startIndex) {
        AsyncFileChooser chooser = TrackerIO.getChooser();
        TFrame frame = trackerPanel.getTFrame();
        chooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.AddImage.Title"));
        TrackerIO.getChooserFilesAsync(frame, "insert images", new Function<File[], Void>(){

            @Override
            public Void apply(File[] files) {
                if (files == null || files.length == 0) {
                    return null;
                }
                String[] paths = new String[files.length];
                int i = 0;
                while (i < paths.length) {
                    paths[i] = files[i].getPath();
                    ++i;
                }
                Undo.postImageVideoEdit(trackerPanel, paths, startIndex, trackerPanel.getPlayer().getStepNumber(), true);
                TrackerIO.insertImagesIntoVideo(files, trackerPanel, startIndex);
                return null;
            }
        });
    }

    public static File[] insertImagesIntoVideo(File[] files, TrackerPanel trackerPanel, int startIndex) {
        if (files == null) {
            return null;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (imageFileFilter.accept(file)) {
                try {
                    ImageVideo imageVid = (ImageVideo)trackerPanel.getVideo();
                    imageVid.insert(file.getAbsolutePath(), startIndex, files.length == 1);
                    VideoClip clip = trackerPanel.getPlayer().getVideoClip();
                    clip.setStepCount(imageVid.getFrameCount());
                    trackerPanel.getPlayer().setStepNumber(clip.frameToStep(startIndex++));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                String s = TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Message1");
                if (i < files.length - 1) {
                    s = String.valueOf(s) + XML.NEW_LINE + TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Message2");
                    int result = JOptionPane.showConfirmDialog(trackerPanel, "\"" + file + "\" " + s, TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Title"), 2);
                    if (result != 0) {
                        if (i == 0) {
                            return null;
                        }
                        File[] inserted = new File[i];
                        System.arraycopy(files, 0, inserted, 0, i);
                        TToolBar.refreshMemoryButton(trackerPanel);
                        return inserted;
                    }
                } else {
                    JOptionPane.showMessageDialog(trackerPanel.getTFrame(), "\"" + file + "\" " + s, TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Title"), 2);
                    if (i == 0) {
                        return null;
                    }
                    File[] inserted = new File[i];
                    System.arraycopy(files, 0, inserted, 0, i);
                    TToolBar.refreshMemoryButton(trackerPanel);
                    return inserted;
                }
            }
            ++i;
        }
        TToolBar.refreshMemoryButton(trackerPanel);
        return files;
    }

    public static void exportXMLFile(TrackerPanel trackerPanel) {
        XMLControlElement control = new XMLControlElement(trackerPanel);
        TrackerIO.choose(trackerPanel, control, true, () -> {
            TrackerIO.getChooser().setSelectedFile(new File(String.valueOf(MediaRes.getString("VideoIO.FileName.Untitled")) + "." + defaultXMLExt));
            TFrame frame = trackerPanel.getTFrame();
            TrackerIO.getChooserFilesAsync(frame, "export file", files -> {
                if (files == null) {
                    return null;
                }
                File file = files[0];
                if (!defaultXMLExt.equals(TrackerIO.getExtension(file))) {
                    String filename = XML.stripExtension(file.getPath());
                    file = new File(String.valueOf(filename) + "." + defaultXMLExt);
                }
                if (TrackerIO.canWrite(file)) {
                    try {
                        control.write(new FileWriter(file));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            });
        });
    }

    /*
     * Unable to fully structure code
     */
    public static void choose(TrackerPanel trackerPanel, final XMLControl control, boolean isExport, final Runnable ok) {
        control.setValue("clipcontrol", null);
        control.setValue("toolbar", null);
        choices = new ArrayList<XMLControl>();
        names = new ArrayList<String>();
        originals = new ArrayList<XMLControl>();
        primitives = new ArrayList<XMLProperty>();
        children = control.getChildControls();
        i = 0;
        while (i < children.length) {
            block6: {
                name = children[i].getPropertyName();
                if (!name.equals("coords")) break block6;
                name = TrackerRes.getString("TMenuBar.MenuItem.Coords");
                ** GOTO lbl20
            }
            if (!name.equals("videoclip")) ** GOTO lbl20
            if (children[i].getChildControl("video") == null || OSPRuntime.isJS) {
                control.setValue("videoclip", null);
            } else {
                name = TrackerRes.getString("TMenuBar.MenuItem.VideoClip");
lbl20:
                // 3 sources

                originals.add(children[i]);
                choices.add(children[i]);
                names.add(name);
            }
            ++i;
        }
        for (XMLProperty prop : control.getPropsRaw()) {
            if ("tracks".indexOf(prop.getPropertyName()) != -1) {
                children = prop.getChildControls();
                i = 0;
                while (i < children.length) {
                    choices.add(children[i]);
                    names.add(children[i].getString("name"));
                    originals.add(children[i]);
                    ++i;
                }
                continue;
            }
            if (prop.getPropertyType() == 6) continue;
            primitives.add(prop);
        }
        listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() != 1001) {
                    return;
                }
                for (XMLProperty prop : primitives) {
                    control.setValue(prop.getPropertyName(), null);
                }
                control.getPropertyContent().removeAll(primitives);
                for (XMLControl next : originals) {
                    if (choices.contains(next)) continue;
                    XMLProperty prop = next.getParentProperty();
                    XMLProperty parent = prop.getParentProperty();
                    if (parent == control) {
                        control.setValue(prop.getPropertyName(), null);
                    }
                    parent.getPropertyContent().remove(prop);
                }
                boolean deleteTracks = true;
                for (Object next : control.getPropertyContent()) {
                    XMLProperty prop = (XMLProperty)next;
                    if ("tracks".indexOf(prop.getPropertyName()) <= -1) continue;
                    boolean bl = deleteTracks = prop.getChildControls().length == 0;
                }
                if (deleteTracks) {
                    control.setValue("tracks", null);
                }
                ok.run();
            }
        };
        dialog = isExport != false ? new ListChooser(TrackerRes.getString("TrackerIO.Dialog.Export.Title"), TrackerRes.getString("TrackerIO.Dialog.Export.Message"), trackerPanel, listener) : new ListChooser(TrackerRes.getString("TrackerIO.Dialog.Import.Title"), TrackerRes.getString("TrackerIO.Dialog.Import.Message"), trackerPanel, listener);
        dialog.choose(choices, names, null, null, null, null);
    }

    public static void copyXML(Object obj) {
        XMLControlElement control = new XMLControlElement(obj);
        StringSelection data = new StringSelection(control.toXML());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
    }

    public static void copyTable(DataTable table, boolean asFormatted, String header) {
        table.copyTable(asFormatted, header);
        dataCopiedToClipboard = true;
    }

    public static void copyImage(Image image) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferImage(image), null);
    }

    public static Image getClipboardImage() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static StringBuffer getData(DataTable table, boolean asFormatted) {
        StringBuffer buf = new StringBuffer();
        int[] selectedRows = table.getSelectedRows();
        int[] selectedColumns = table.getSelectedColumns();
        int[] restoreRows = null;
        int[] restoreColumns = null;
        if (selectedRows.length == 0) {
            table.selectAll();
            restoreRows = selectedRows;
            restoreColumns = selectedColumns;
            selectedRows = table.getSelectedRows();
            selectedColumns = table.getSelectedColumns();
        }
        int j = 0;
        while (j < selectedColumns.length) {
            if (!table.isRowNumberVisible() || selectedColumns[j] != 0) {
                buf.append(table.getColumnName(selectedColumns[j]));
                if (j < selectedColumns.length - 1) {
                    buf.append(delimiter);
                }
            }
            ++j;
        }
        buf.append(XML.NEW_LINE);
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
        nf.applyPattern("0.000000000E0");
        nf.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        DateFormat df = DateFormat.getInstance();
        int i = 0;
        while (i < selectedRows.length) {
            int j2 = 0;
            while (j2 < selectedColumns.length) {
                int temp = table.convertColumnIndexToModel(selectedColumns[j2]);
                if (!table.isRowNumberVisible() || temp != 0) {
                    Object value = null;
                    if (asFormatted) {
                        value = table.getFormattedValueAt(selectedRows[i], selectedColumns[j2]);
                    } else {
                        value = table.getValueAt(selectedRows[i], selectedColumns[j2]);
                        if (value != null) {
                            if (value instanceof Number) {
                                value = nf.format(value);
                            } else if (value instanceof Date) {
                                value = df.format(value);
                            }
                        }
                    }
                    if (value != null) {
                        buf.append(value);
                    }
                    if (j2 < selectedColumns.length - 1) {
                        buf.append(delimiter);
                    }
                }
                ++j2;
            }
            buf.append(XML.NEW_LINE);
            ++i;
        }
        if (restoreRows != null && restoreColumns != null) {
            table.clearSelection();
            int[] nArray = restoreRows;
            int n = restoreRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                table.addRowSelectionInterval(row, row);
                ++n2;
            }
            nArray = restoreColumns;
            n = restoreColumns.length;
            n2 = 0;
            while (n2 < n) {
                int col = nArray[n2];
                table.addColumnSelectionInterval(col, col);
                ++n2;
            }
        }
        return buf;
    }

    public static void addCustomDelimiter(String custom) {
        if (!TrackerIO.getDelimiters().values().contains(custom)) {
            customDelimiters.put(custom, custom);
        }
    }

    public static void removeCustomDelimiter(String custom) {
        if (TrackerIO.getDelimiter().equals(custom)) {
            TrackerIO.setDelimiter(defaultDelimiter);
        }
        String selected = null;
        for (String key : customDelimiters.keySet()) {
            if (!((String)customDelimiters.get(key)).equals(custom)) continue;
            selected = key;
        }
        if (selected != null) {
            customDelimiters.remove(selected);
        }
    }

    private static void findPageViewFiles(XMLControl control, Map<String, String> pageViewFiles, String trkPath) {
        String xml = control.toXML();
        String token = "PageTView$TabView";
        int j = xml.indexOf(token);
        while (j > -1) {
            xml = xml.substring(j + token.length());
            token = "<property name=\"text\" type=\"string\">";
            j = xml.indexOf(token);
            String path = xml.substring(j + token.length());
            j = path.indexOf("</property>");
            if ((path = path.substring(0, j)).endsWith(".html") || path.endsWith(".htm")) {
                Resource res;
                String base = XML.getDirectoryPath(trkPath);
                Resource resource = res = "".equals(base) ? ResourceLoader.getResource(path) : ResourceLoader.getResource(String.valueOf(base) + "/" + path);
                if (res != null) {
                    String zipPath;
                    int n;
                    String urlPath = res.getURL().toExternalForm();
                    if (OSPRuntime.unzipFiles && (n = (zipPath = ResourceLoader.getNonURIPath(res.getAbsolutePath())).indexOf("!/")) > 0) {
                        ResourceLoader.unzip(zipPath.substring(0, n));
                        File target = new File(ResourceLoader.tempDirFile, path);
                        if (target.exists()) {
                            res = ResourceLoader.getResource(target.getAbsolutePath());
                            urlPath = res.getURL().toExternalForm();
                        } else {
                            path = null;
                        }
                    }
                    if (path != null) {
                        pageViewFiles.put(path, urlPath);
                    }
                }
            }
            token = "PageTView$TabView";
            j = xml.indexOf(token);
        }
    }

    static void closeMonitor(String fileName) {
        for (TrackerMonitor monitor : monitors) {
            if (fileName == null) {
                monitor.close();
                continue;
            }
            if (!XML.forwardSlash(monitor.getName()).endsWith(XML.forwardSlash(fileName))) continue;
            monitor.close();
            monitors.remove(monitor);
            return;
        }
        monitors.clear();
    }

    static void setProgress(String name, String string, int framesLoaded) {
        for (TrackerMonitor monitor : monitors) {
            String monitorName = XML.forwardSlash(monitor.getName());
            if (!monitorName.endsWith(name)) continue;
            int progress = monitor.getFrameCount() > 0 ? 20 + (int)((double)framesLoaded * 60.0 / (double)monitor.getFrameCount()) : 20 + framesLoaded / 20 % 60;
            monitor.setProgressAsync(progress);
            monitor.setTitle(String.valueOf(TrackerRes.getString("TFrame.ProgressDialog.Title.FramesLoaded")) + ": " + framesLoaded);
            break;
        }
    }

    protected static Object[] getVideoFormats() {
        return videoFormatDescriptions.toArray();
    }

    public static void refreshVideoFormats() {
        videoFormats.clear();
        videoFormatDescriptions.clear();
        for (VideoType next : TrackerIO.getVideoTypes(true)) {
            String desc = next.getDescription();
            videoFormats.put(desc, next);
            videoFormatDescriptions.add(desc);
        }
    }

    public static String getVideoFormat(String preferredExtension) {
        String[] extensions = preferredExtension.split(" ");
        String selected = selectedVideoFormat;
        boolean hasSelected = false;
        String preferred = null;
        for (String format : videoFormatDescriptions) {
            VideoIO.ZipImageVideoType type;
            if (format.equals(selected)) {
                hasSelected = true;
            }
            if (preferred != null || !format.contains("." + extensions[0]) || extensions.length > 1 && !(type = (VideoIO.ZipImageVideoType)videoFormats.get(format)).getImageExtension().equals(extensions[1])) continue;
            preferred = format;
        }
        return preferred == null && hasSelected ? selected : preferred;
    }

    public static boolean isImageFile(File file) {
        if (imageFilters == null) {
            imageFilters = new ImageVideoType().getFileFilters();
        }
        int i = 0;
        while (i < imageFilters.length) {
            if (imageFilters[i].accept(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isVideo(File f) {
        if (videoFilter == null) {
            videoFilter = new VideoFileFilter();
        }
        return videoFilter.accept(f);
    }

    public static void exportVideoImages(TrackerPanel panel, String exportVideoName) {
        if (panel != null) {
            TrackerIO.saveVideo(new File(exportVideoName), panel, true, false);
        }
    }

    public static byte[] getImageBytes(TrackerPanel panel, int i) throws IOException {
        VideoAdapter video2 = (VideoAdapter)panel.getVideo();
        video2.setNotify(false);
        video2.setFrameNumber(i);
        video2.setNotify(true);
        BufferedImage img = video2.getRawBufferedImage();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", bos);
        return bos.toByteArray();
    }

    private static /* synthetic */ void lambda$15(String[] stringArray, String string, ActionEvent e) {
        int response = e.getID();
        if (response >= 0 && response < stringArray.length && stringArray[response].equals(string)) {
            Tracker.warnVariableDuration = false;
        }
    }

    static class AsyncLoader
    extends AsyncSwingWorker
    implements TrackerMonitor,
    XMLControlElement.FrameDataAdjusterI {
        private final List<String> paths;
        private final Integer existingPanelID;
        private final TFrame frame;
        private Integer panelID;
        private final ArrayList<String> desktopFiles = new ArrayList();
        private static final int TYPE_UNK = 0;
        private static final int TYPE_TRZ = 1;
        private static final int TYPE_TRK = 2;
        private static final int TYPE_FRAME = 3;
        private static final int TYPE_VIDEO = 4;
        private static final int TYPE_UNSUPPORTED_VIDEO = 5;
        private static final int TYPE_TEXT = 6;
        private static final int TYPE_LIBRARY_COLLECTION = 7;
        private boolean panelChanged;
        private Video video;
        private String rawPath;
        private String nonURIPath;
        private XMLControlElement control;
        private String path;
        private String path0;
        private int type = 0;
        private int frameCount;
        private String name;
        private String xmlPath;
        private String xmlPath0;
        private Runnable whenDone;
        private Set<Integer> panelList = new HashSet<Integer>();
        private LibraryBrowser libraryBrowser;
        private TrackerPanel.Loader loader;
        private int videoCount;
        private boolean ignoreLowMemory;
        private TrackerPanel panel;

        public void finalize() {
            OSPLog.finalized(this);
        }

        public AsyncLoader(List<String> paths, TrackerPanel existingPanel, TFrame frame, LibraryBrowser libraryBrowser, Runnable whenDone) {
            super(frame, "Loading " + XML.getName(paths.get(0)), frame == null || whenDone == null ? 0 : 10, 0, 100);
            if (whenDone != null && frame != null) {
                frame.setFrameBlocker(true, null);
            }
            this.path0 = this.name = paths.remove(0);
            this.path = this.name;
            this.paths = paths;
            this.isAsync = this.delayMillis > 0;
            this.existingPanelID = existingPanel == null ? null : existingPanel.getID();
            this.frame = frame;
            this.libraryBrowser = libraryBrowser;
            this.whenDone = whenDone;
            monitors.add(this);
        }

        @Override
        public void initAsync() {
            this.setupLoader();
        }

        private boolean setupLoader() {
            this.ignoreLowMemory = false;
            this.xmlPath = null;
            this.panelID = null;
            this.panelChanged = false;
            this.nonURIPath = null;
            this.frameCount = 0;
            this.control = null;
            this.rawPath = this.path;
            this.path = ResourceLoader.getURIPath(this.path);
            isffmpegError = false;
            theFrame = this.frame;
            this.nonURIPath = ResourceLoader.getNonURIPath(this.path);
            if (this.rawPath.startsWith("//") && this.nonURIPath.startsWith("/") && !this.nonURIPath.startsWith("//")) {
                this.nonURIPath = "/" + this.nonURIPath;
            }
            if (this.frame != null && this.frame.loadedFiles.contains(this.nonURIPath)) {
                return false;
            }
            if (this.frame != null) {
                this.frame.loadedFiles.add(this.nonURIPath);
            }
            if (!ResourceLoader.isHTTP(this.path)) {
                if (this.path.contains("&")) {
                    new AsyncDialog().showMessageDialog(null, String.valueOf(TrackerRes.getString("ZipResourceDialog.Dialog.BadFileName.Message")) + " \n\"&\"", TrackerRes.getString("ZipResourceDialog.Dialog.BadFileName.Title"), 2, ev -> {});
                    TrackerIO.setCanceled(true);
                    return false;
                }
                this.path = this.nonURIPath;
            }
            TrackerIO.setCanceled(false);
            String[] paths = TrackerIO.getZippedImagePaths(this.path);
            if (zipFileFilter.accept(new File(this.path)) && paths != null) {
                this.type = 4;
                if (!ResourceLoader.isHTTP(this.path)) {
                    this.path = paths[0];
                }
                this.newPanel();
                return true;
            }
            ResourceLoader.RemoteFile testFile = new ResourceLoader.RemoteFile(this.path);
            if (videoFileFilter.accept(testFile, false)) {
                this.type = 4;
                this.newPanel();
                return true;
            }
            boolean isTRZ = ResourceLoader.isJarZipTrz(this.path, false);
            if (isTRZ || this.path.indexOf("&TrackerSet=") >= 0) {
                this.type = 1;
                if (this.frame != null) {
                    this.frame.holdPainting(true);
                }
                return true;
            }
            String[] stringArray = KNOWN_VIDEO_EXTENSIONS;
            int n = KNOWN_VIDEO_EXTENSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (this.path.endsWith("." + ext)) {
                    this.type = 5;
                    return true;
                }
                ++n2;
            }
            if (delimitedTextFileFilter.accept(testFile, false)) {
                this.type = 6;
                this.newPanel();
                return true;
            }
            this.control = new XMLControlElement();
            this.xmlPath = this.control.read(this.path);
            if (this.path.equals(this.path0)) {
                this.xmlPath0 = this.xmlPath;
            }
            if (TrackerIO.isCanceled()) {
                this.cancelAsync();
                return false;
            }
            Class<?> ctype = this.control.getObjectClass();
            if (TrackerPanel.class.isAssignableFrom(ctype)) {
                this.type = 2;
                if (this.panelID == null) {
                    Integer n3;
                    if (this.frame == null) {
                        this.panel = new TrackerPanel(false);
                        n3 = this.panel.getID();
                    } else {
                        n3 = this.frame.getCleanTrackerPanel().getID();
                    }
                    this.panelID = n3;
                }
                return true;
            }
            if (TFrame.class.isAssignableFrom(ctype)) {
                this.type = 3;
                return true;
            }
            if (LibraryCollection.class.isAssignableFrom(ctype)) {
                this.type = 7;
                return true;
            }
            if (this.frame == null) {
                return !this.control.failedToRead();
            }
            if (this.control.failedToRead()) {
                JOptionPane.showMessageDialog(this.frame, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFile.Message")) + ResourceLoader.getNonURIPath(this.path));
            } else {
                JOptionPane.showMessageDialog(this.frame, "\"" + XML.getName(this.path) + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
            }
            TrackerIO.setCanceled(true);
            this.cancelAsync();
            return false;
        }

        private void newPanel() {
            this.panelID = this.existingPanelID == null ? this.frame.getCleanTrackerPanel().getID() : this.existingPanelID;
            this.panelChanged = this.panel().changed;
        }

        @Override
        public int doInBackgroundAsync(int progress) {
            if (TrackerIO.isCanceled()) {
                this.cancelAsync();
                return 100;
            }
            switch (this.type) {
                case 3: {
                    progress = this.loadFrame(progress);
                    break;
                }
                case 1: {
                    progress = this.loadTRZ(progress);
                    break;
                }
                case 2: {
                    progress = this.loadTRK(progress);
                    break;
                }
                case 4: {
                    ++this.videoCount;
                    progress = this.loadVideo(progress);
                    break;
                }
                case 5: {
                    TrackerIO.handleUnsupportedVideo(this.path, XML.getExtension(this.path), null, this.panel(), "TrackerIO.unsupp video-asyncLoad");
                    return 100;
                }
                case 6: {
                    progress = this.loadData(progress);
                    break;
                }
                case 7: {
                    progress = this.loadCollection(progress);
                    break;
                }
                default: {
                    return 100;
                }
            }
            if (progress == 100) {
                if (this.paths.size() > 0) {
                    this.path = this.paths.remove(0);
                    if (this.setupLoader()) {
                        progress = 0;
                    }
                } else if (this.frame != null) {
                    this.frame.removeEmptyTabIfTabCountGreaterThan(1);
                }
            } else if (!OSPRuntime.isJS) {
                switch (Tracker.checkMemory(this.frame, this.ignoreLowMemory)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.ignoreLowMemory = true;
                        TToolBar.refreshMemoryButton(this.panel());
                        break;
                    }
                    case 2: 
                    case 3: {
                        TrackerIO.setCanceled(true);
                        this.cancelAsync();
                        TToolBar.refreshMemoryButton(this.panel());
                        break;
                    }
                    case 4: {
                        TrackerIO.setCanceled(true);
                        this.cancelAsync();
                        Tracker.askToSetMemory(this.frame);
                    }
                }
            }
            return progress;
        }

        public TrackerPanel panel() {
            return this.frame == null ? this.panel : this.frame.getTrackerPanelForID(this.panelID);
        }

        @Override
        public void doneAsync() {
            if (this.path.equals(this.path0)) {
                this.doneLoading();
            }
        }

        private int loadFrame(int progress) {
            if (this.frame != null) {
                this.frame.whenObjectLoadingComplete = new Function<List<String>, Void>(){

                    @Override
                    public Void apply(List<String> files) {
                        if (files.size() > 0) {
                            final File dataFile = new File(files.remove(0));
                            paths.addAll(files);
                            final Runnable done = whenDone;
                            whenDone = new Runnable(){

                                @Override
                                public void run() {
                                    frame.setSelectedTab(dataFile);
                                    if (done != null) {
                                        done.run();
                                    }
                                }
                            };
                        }
                        return null;
                    }
                };
            }
            this.control.loadObject(this.frame);
            return 100;
        }

        private int loadTRZ(int progress) {
            boolean haveHTML;
            Map<String, ZipEntry> contents;
            HashMap pageViewTabs = new HashMap();
            String name = XML.getName(ResourceLoader.getNonURIPath(this.path));
            boolean isWebPath = ResourceLoader.isHTTP(this.path);
            if (isWebPath) {
                File localFile = ResourceLoader.downloadToOSPCache(this.path, name, false);
                if (localFile == null) {
                    this.path = null;
                } else {
                    this.path = localFile.toURI().toString();
                    OSPLog.debug("TrackerIO downloaded zip file: " + this.path);
                }
            }
            Map<String, ZipEntry> map = contents = this.path == null ? null : ResourceLoader.getZipContents(this.path, true);
            if (contents == null) {
                if (this.frame != null) {
                    this.frame.sayFileNotFound(this.path == null ? name : this.path);
                }
                this.cancelAsync();
                return 100;
            }
            ArrayList<String> trkFiles = new ArrayList<String>();
            ArrayList<String> htmlFiles = new ArrayList<String>();
            ArrayList<String> pdfFiles = new ArrayList<String>();
            ArrayList<String> otherFiles = new ArrayList<String>();
            ArrayList<String> tempFiles = new ArrayList<String>();
            String trkForTFrame = null;
            String baseName = XML.stripExtension(name);
            for (String next : contents.keySet()) {
                if (next.indexOf("_thumbnail") <= -1) continue;
                String thumb = XML.getName(next);
                baseName = thumb.substring(0, thumb.indexOf("_thumbnail"));
                break;
            }
            for (String next : contents.keySet()) {
                if (next.endsWith(".trk")) {
                    String s = ResourceLoader.getURIPath(String.valueOf(this.path) + "!/" + next);
                    trkFiles.add(s);
                    continue;
                }
                if (next.endsWith(".pdf")) {
                    pdfFiles.add(next);
                    continue;
                }
                if (next.endsWith(".html") || next.endsWith(".htm")) {
                    String nextName = XML.getName(next);
                    if (XML.stripExtension(nextName).equals(String.valueOf(baseName) + "_info")) continue;
                    htmlFiles.add(next);
                    continue;
                }
                if (next.indexOf("thumbnail") != -1 || next.indexOf("/") != -1 || TrackerIO.isKnownVideoExtension(next)) continue;
                otherFiles.add(next);
            }
            contents = null;
            if (this.frame != null && trkFiles.isEmpty()) {
                String s = TrackerRes.getString("TrackerIO.Dialog.NotATrackerFile.Message");
                JOptionPane.showMessageDialog(this.frame, String.valueOf(s) + " \"" + name + "\".", TrackerRes.getString("TFrame.Dialog.LibraryError.Title"), 2);
                return 100;
            }
            boolean bl = haveHTML = !htmlFiles.isEmpty();
            if (!trkFiles.isEmpty()) {
                ArrayList<String> trkNames = new ArrayList<String>();
                for (String next : trkFiles) {
                    trkNames.add(XML.stripExtension(XML.getName(next)));
                    try {
                        String data = new String(ResourceLoader.getZipEntryBytes(this.path, next, null));
                        String className = XMLControlElement.getClassName(data);
                        if (className.endsWith("TrackerPanel")) {
                            if (!haveHTML) continue;
                            TrackerIO.findPageViewFiles(new XMLControlElement(data), pageViewTabs, next);
                            continue;
                        }
                        if (trkForTFrame != null || !className.endsWith("TFrame")) continue;
                        trkForTFrame = next;
                    }
                    catch (IOException data) {
                        // empty catch block
                    }
                }
                if (!htmlFiles.isEmpty()) {
                    String[] paths;
                    String[] stringArray = paths = htmlFiles.toArray(new String[htmlFiles.size()]);
                    int n = paths.length;
                    int data = 0;
                    while (data < n) {
                        String htmlPath = stringArray[data];
                        boolean isPageView = false;
                        for (String page : pageViewTabs.keySet()) {
                            boolean bl2 = isPageView = isPageView || htmlPath.endsWith(page);
                        }
                        if (isPageView) {
                            htmlFiles.remove(htmlPath);
                        }
                        for (String trkName : trkNames) {
                            if (!htmlPath.contains(String.valueOf(trkName) + "_info.")) continue;
                            htmlFiles.remove(htmlPath);
                        }
                        ++data;
                    }
                }
                if (trkForTFrame != null) {
                    trkFiles.clear();
                    trkFiles.add(trkForTFrame);
                }
            }
            if (!(htmlFiles.isEmpty() && pdfFiles.isEmpty() && otherFiles.isEmpty())) {
                if (OSPRuntime.unzipFiles) {
                    for (File next : ResourceLoader.unzip(this.path)) {
                        next.deleteOnExit();
                        String relPath = XML.getPathRelativeTo(next.getPath(), ResourceLoader.tempDirFile.getPath());
                        if (!pdfFiles.contains(relPath) && !htmlFiles.contains(relPath) && !otherFiles.contains(relPath)) continue;
                        String tempPath = ResourceLoader.getURIPath(next.getAbsolutePath());
                        tempFiles.add(tempPath);
                    }
                } else {
                    tempFiles.addAll(htmlFiles);
                    tempFiles.addAll(pdfFiles);
                    tempFiles.addAll(otherFiles);
                }
                if (!OSPRuntime.getSkipDisplayOfPDF()) {
                    Thread displayURLOpener = new Thread(() -> {
                        for (String relpath : tempFiles) {
                            if (ResourceLoader.wasPDFOpen(relpath)) continue;
                            OSPDesktop.displayURL(OSPRuntime.unzipFiles ? relpath : String.valueOf(this.path) + "!/" + relpath);
                        }
                    });
                    displayURLOpener.setName("displayURLOpener");
                    displayURLOpener.start();
                } else if (!tempFiles.isEmpty()) {
                    for (String relpath : tempFiles) {
                        String s = OSPRuntime.unzipFiles ? relpath : String.valueOf(this.path) + "!/" + relpath;
                        JOptionPane.showMessageDialog(null, s, "Cannot show supplemental files.", 1);
                    }
                }
            }
            if (!TrackerIO.isCanceled()) {
                if (this.path.equals(this.nonURIPath)) {
                    Tracker.addRecent(this.nonURIPath, false);
                }
                this.paths.addAll(trkFiles);
                if (OSPRuntime.unzipFiles) {
                    this.desktopFiles.addAll(tempFiles);
                } else {
                    for (String f : tempFiles) {
                        this.desktopFiles.add(String.valueOf(this.path) + "!/" + f);
                    }
                }
            }
            return 100;
        }

        private int loadTRK(int progress) {
            this.panelList.add(this.panelID);
            TrackerPanel trackerPanel = this.panel();
            if (this.loader != null && this.loader.control == this.control) {
                this.loader.loadObject(this.control, trackerPanel);
            } else {
                this.control.loadObject((Object)trackerPanel, this);
            }
            int p = trackerPanel.getProgress();
            if (p < 100) {
                if (p == 10) {
                    ++this.videoCount;
                }
                return p;
            }
            trackerPanel.setIgnoreRepaint(true);
            TrackerIO.findPageViewFiles(this.control, trackerPanel.pageViewFilePaths, this.path);
            while (this.desktopFiles.size() > 0) {
                trackerPanel.supplementalFilePaths.add(this.desktopFiles.remove(0));
            }
            if (ResourceLoader.isJarZipTrz(this.xmlPath, true)) {
                String parent = this.xmlPath.substring(0, this.xmlPath.indexOf("!"));
                parent = ResourceLoader.getNonURIPath(parent);
                String parentName = XML.stripExtension(XML.getName(parent));
                String tabName = XML.stripExtension(XML.getName(this.xmlPath));
                if (tabName.startsWith(parentName) && parentName.length() + 1 < tabName.length()) {
                    tabName = tabName.substring(parentName.length() + 1, tabName.length());
                }
                trackerPanel.openedFromPath = parent;
                trackerPanel.defaultFileName = tabName;
                String html = ResourceLoader.getString(String.valueOf(parent) + "!/html/" + parentName + "_info.html");
                if (html != null) {
                    ArrayList<String[]> metadata = LibraryBrowser.getMetadataFromHTML(html);
                    int i = 0;
                    while (i < metadata.size()) {
                        String[] meta = metadata.get(i);
                        String key = meta[0];
                        String value = meta[1];
                        if (trackerPanel.author == null && "Author".toLowerCase().contains(key.toLowerCase())) {
                            trackerPanel.author = value;
                        } else if (trackerPanel.contact == null && "Contact".toLowerCase().contains(key.toLowerCase())) {
                            trackerPanel.contact = value;
                        }
                        ++i;
                    }
                }
            } else {
                trackerPanel.defaultFileName = XML.getName(this.path);
                trackerPanel.openedFromPath = this.path;
                trackerPanel.setDataFile(new File(ResourceLoader.getNonURIPath(this.path)));
            }
            if (TrackerIO.isCanceled()) {
                this.cancelAsync();
                return 100;
            }
            if (this.frame != null) {
                this.frame.addTab(trackerPanel, 1, null);
            }
            trackerPanel.setIgnoreRepaint(false);
            if (this.control.failedToRead()) {
                JOptionPane.showMessageDialog(trackerPanel.getTFrame(), "\"" + XML.getName(this.path) + "\" " + TrackerRes.getString("TrackerIO.Dialog.ReadFailed.Message"), TrackerRes.getString("TrackerIO.Dialog.ReadFailed.Title"), 2);
            }
            this.checkDone(false);
            this.control = null;
            this.libraryBrowser = null;
            this.loader = null;
            if (this.path.equals(this.nonURIPath) && !this.path.contains("!/")) {
                Tracker.addRecent(this.nonURIPath, false);
            }
            return 100;
        }

        private int loadCollection(int progress) {
            if (this.frame != null) {
                LibraryBrowser browser = this.frame.getLibraryBrowser();
                browser.setVisible(true);
                browser.open(this.path);
            }
            return 100;
        }

        void checkDone(boolean b) {
            if (this.panelList.size() == 0 && this.paths.size() == 0) {
                this.doneLoading();
            }
        }

        private int loadData(int progress) {
            if (this.frame != null) {
                this.frame.addTab(this.panel(), 1, null);
            }
            this.panel().importDataAsync(this.path, null, null);
            return 100;
        }

        private int loadVideo(int progress) {
            boolean logConsole = OSPLog.isConsoleMessagesLogged();
            if (progress == 0) {
                String name;
                File localFile;
                if (!TrackerIO.checkMP4(this.path, this.libraryBrowser, this.panel())) {
                    return 100;
                }
                if (ResourceLoader.isHTTP(this.path) && (localFile = ResourceLoader.downloadToOSPCache(this.path, name = ResourceLoader.getNonURIPath(XML.getName(this.path)), false)) != null) {
                    this.path = localFile.toURI().toString();
                }
                if (!Tracker.warnXuggleError) {
                    OSPLog.setConsoleMessagesLogged(false);
                }
                this.video = TrackerIO.getVideo(this.path, null);
            }
            if (this.video != null && this.video instanceof IncrementallyLoadable && loadIncrementally) {
                IncrementallyLoadable iVideo = (IncrementallyLoadable)((Object)this.video);
                try {
                    if (iVideo.loadMoreFrames(incrementToLoad)) {
                        this.setFrameCount(iVideo.getLoadedFrameCount());
                        progress = this.getFrameCount() / incrementToLoad;
                        progress = 1 + progress % 95;
                        return progress;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            OSPLog.setConsoleMessagesLogged(logConsole);
            if (TrackerIO.isCanceled()) {
                this.cancelAsync();
                return 100;
            }
            if (this.video == null) {
                if (this.frame != null && this.frame.libraryBrowser != null) {
                    this.frame.libraryBrowser.setMessage(null, null);
                }
                String codec = TrackerIO.getVideoCodec(this.path);
                TrackerIO.handleUnsupportedVideo(this.path, XML.getExtension(this.path), codec, this.panel(), "OpenTabPathVideo null video");
                this.cancelAsync();
                return 100;
            }
            if (this.video instanceof AsyncVideoI) {
                this.video.addPropertyChangeListener("asyncVideoReady", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        video.removePropertyChangeListener("asyncVideoReady", this);
                        this.finalizeVideoLoading(video);
                    }
                });
            } else {
                this.finalizeVideoLoading(this.video);
            }
            String thePath = XML.forwardSlash(this.path);
            int n = thePath.indexOf("!/");
            if (n > 0) {
                thePath = thePath.substring(0, n);
            }
            Tracker.addRecent(ResourceLoader.getNonURIPath(thePath), false);
            return 100;
        }

        private void finalizeVideoLoading(Video video2) {
            Integer panelID;
            int tab;
            TrackerPanel trackerPanel = this.panel();
            if (this.frame != null && (tab = this.frame.getTab(panelID = trackerPanel.getID())) < 0) {
                this.frame.addTabFromLoader(trackerPanel);
            }
            trackerPanel.setVideo(video2);
            boolean bl = this.panelChanged = trackerPanel.getID() == this.existingPanelID;
            if (video2.getFrameCount() == 1) {
                trackerPanel.getPlayer().getVideoClip().setStepCount(10);
            }
            if (this.existingPanelID == null) {
                ImageCoordSystem coords = trackerPanel.getCoords();
                coords.setAllOriginsXY(video2.getWidth() / 2.0, video2.getHeight() / 2.0);
            }
            if (this.frame != null) {
                TFrame.repaintT(trackerPanel);
                this.frame.setSelectedTab(trackerPanel);
            }
            if (Tracker.warnVariableDuration) {
                TrackerIO.findBadVideoFrames(trackerPanel, defaultBadFrameTolerance, true, true, true);
            }
            this.checkDone(false);
        }

        public void finalized(TrackerPanel trackerPanel) {
            this.panelList.remove(trackerPanel.getID());
        }

        private void doneLoading() {
            if (this.frame != null) {
                TrackerPanel trackerPanel = this.panel();
                this.frame.setFrameBlocker(false, trackerPanel);
                if (this.xmlPath0 != null && !ResourceLoader.isJarZipTrz(this.xmlPath0, true)) {
                    Tracker.addRecent(ResourceLoader.getNonURIPath(XML.forwardSlash(this.xmlPath0)), false);
                }
                TToolBar.refreshMemoryButton(trackerPanel);
                switch (this.type) {
                    case 4: {
                        trackerPanel.changed = this.panelChanged;
                    }
                    case 2: {
                        this.frame.clearHoldPainting();
                        trackerPanel.notifyLoadingComplete();
                        this.frame.refresh();
                    }
                }
            }
            if (this.whenDone != null) {
                SwingUtilities.invokeLater(() -> this.whenDone.run());
            }
        }

        @Override
        public void setFrameCount(int count) {
            this.frameCount = count;
        }

        @Override
        public void close() {
            this.cancelAsync();
            this.setProgress(100);
        }

        @Override
        public void cancelAsync() {
            int tab;
            super.cancelAsync();
            if (this.frame == null) {
                return;
            }
            TrackerPanel trackerPanel = this.panel();
            this.frame.clearHoldPainting();
            this.frame.setFrameBlocker(false, trackerPanel);
            this.frame.setCursor(Cursor.getDefaultCursor());
            if (this.libraryBrowser != null) {
                this.libraryBrowser.cancelLoading();
            }
            if (trackerPanel != null) {
                trackerPanel.releaseResources();
            }
            if (this.type == 4 && this.existingPanelID != null && (tab = this.frame.getRemovableTabNumber(this.existingPanelID)) > -1) {
                this.frame.removeTabNow(tab);
            }
            this.frame.removeEmptyTabIfTabCountGreaterThan(1);
            TrackerIO.setCanceled(true);
            if (!OSPRuntime.isJS) {
                this.frame.doTabStateChanged();
            }
        }

        @Override
        public int getFrameCount() {
            return this.frameCount;
        }

        @Override
        public void restart() {
            this.setProgress(0);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setTitle(String title) {
        }

        public TFrame getFrame() {
            return this.frame;
        }

        @Override
        public String getNote(int progress) {
            switch (this.type) {
                case 4: {
                    return "Video frames loaded: " + this.getFrameCount();
                }
                case 2: {
                    if (this.type != 2 || progress <= 20 || progress >= 80) break;
                    return "Video " + this.videoCount + ": frames loaded " + this.panel().framesLoaded;
                }
            }
            return String.format("Completed %d%%.\n", this.progressPercent);
        }

        public void setLoader(TrackerPanel.Loader loader) {
            this.loader = loader;
        }

        @Override
        public Object[] adjustFrameData(Object[] data) {
            int arrayOffset = this.panel().getPlayer().getVideoClip().frameShift;
            if (arrayOffset > 0) {
                if (arrayOffset >= data.length) {
                    return null;
                }
                data = Arrays.copyOfRange(data, arrayOffset, data.length);
            }
            return data;
        }
    }

    static class ComponentImage
    implements Printable {
        private BufferedImage image;
        Component c;

        ComponentImage(Component comp) {
            this.c = comp;
            if (comp instanceof JFrame) {
                comp = ((JFrame)comp).getContentPane();
            } else if (comp instanceof JDialog) {
                comp = ((JDialog)comp).getContentPane();
            }
            int w = comp.isVisible() ? comp.getWidth() : comp.getPreferredSize().width;
            int h = comp.isVisible() ? comp.getHeight() : comp.getPreferredSize().height;
            this.image = new BufferedImage(w, h, 5);
            if (comp instanceof Renderable) {
                this.image = ((Renderable)((Object)comp)).render(this.image);
            } else {
                Graphics g = this.image.getGraphics();
                comp.paint(g);
                g.dispose();
            }
        }

        BufferedImage getImage() {
            return this.image;
        }

        void copyToClipboard() {
            TrackerIO.copyImage(this.image);
        }

        public void print() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat format = new PageFormat();
            Book book = new Book();
            book.append(this, format);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(this.c, TrackerRes.getString("TActions.Dialog.PrintError.Message"), TrackerRes.getString("TActions.Dialog.PrintError.Title"), 0);
                }
            }
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex >= 1) {
                return 1;
            }
            if (g == null) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)g;
            double scalex = pageFormat.getImageableWidth() / (double)this.image.getWidth();
            double scaley = pageFormat.getImageableHeight() / (double)this.image.getHeight();
            double scale = Math.min(scalex, scaley);
            scale = Math.min(scale, 1.0);
            g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            g2.scale(scale, scale);
            g2.drawImage((Image)this.image, 0, 0, null);
            return 0;
        }
    }

    public static interface TrackerMonitor {
        public void setFrameCount(int var1);

        public void close();

        public int getFrameCount();

        public void setProgressAsync(int var1);

        public void restart();

        public String getName();

        public void setTitle(String var1);
    }

    static class TransferImage
    implements Transferable {
        private Image image;

        TransferImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

