/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javajs.async.AsyncDialog;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.Configuration;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.DerivativeAlgorithmDialog;
import org.opensourcephysics.cabrillo.tracker.ExportDataDialog;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineProfileStep;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.MarkingRequired;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.NumberFormatDialog;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PasteDataDialog;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PencilDrawing;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.PlotGuestDialog;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.StepSet;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TCoordinateStringBuilder;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMat;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TMouseHandler;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.TrackDataBuilder;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.UnitsDialog;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLPropertyElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.BaselineFilter;
import org.opensourcephysics.media.core.BrightnessFilter;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.DarkGhostFilter;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.DeinterlaceFilter;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.GhostFilter;
import org.opensourcephysics.media.core.GrayScaleFilter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.LogFilter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NegativeFilter;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.RadialDistortionFilter;
import org.opensourcephysics.media.core.ResizeFilter;
import org.opensourcephysics.media.core.RotateFilter;
import org.opensourcephysics.media.core.StrobeFilter;
import org.opensourcephysics.media.core.SumFilter;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.XYCoordinateStringBuilder;
import org.opensourcephysics.media.mov.SmoothPlayable;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FileDropHandler;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.VideoCaptureTool;

public class TrackerPanel
extends VideoPanel
implements Scrollable {
    public static final String PROPERTY_TRACKERPANEL_CLEAR = "clear";
    public static final String PROPERTY_TRACKERPANEL_IMAGE = "image";
    public static final String PROPERTY_TRACKERPANEL_LOADED = "loaded";
    public static final String PROPERTY_TRACKERPANEL_MAGNIFICATION = "magnification";
    public static final String PROPERTY_TRACKERPANEL_SELECTEDPOINT = "selectedpoint";
    public static final String PROPERTY_TRACKERPANEL_SELECTEDTRACK = "selectedtrack";
    public static final String PROPERTY_TRACKERPANEL_SIZE = "size";
    public static final String PROPERTY_TRACKERPANEL_STEPNUMBER = "stepnumber";
    public static final String PROPERTY_TRACKERPANEL_TRACK = "track";
    public static final String PROPERTY_TRACKERPANEL_UNITS = "units";
    public static final String PROPERTY_TRACKERPANEL_VIDEO = "video";
    public static final String PROPERTY_TRACKERPANEL_VIDEOVISIBLE = "videovisible";
    public static final double MIN_ZOOM = 0.1;
    public static final double MAX_ZOOM = 20.0;
    public static final double ZOOM_STEP = Math.pow(2.0, 0.16666666666666666);
    public static final double[] ZOOM_LEVELS = new double[]{0.1, 0.25, 0.5, 1.0, 2.0, 4.0, 8.0, 12.0, 20.0};
    public static final String STICK = "Stick";
    public static final String TAPE = "CalibrationTapeMeasure";
    public static final String CALIBRATION = "Calibration";
    public static final String OFFSET = "OffsetOrigin";
    protected TFrame frame;
    protected Integer panelID;
    private double defaultImageBorder;
    private String description = "";
    protected TPoint selectedPoint;
    protected Step selectedStep;
    protected Integer selectingPanelID;
    protected TTrack selectedTrack;
    protected TPoint newlyMarkedPoint;
    protected Rectangle dirty;
    private boolean tainted;
    protected AffineTransform prevPixelTransform;
    protected double zoom = 1.0;
    protected JScrollPane scrollPane;
    protected JPopupMenu popup;
    protected Set<String> enabled;
    protected TPoint snapPoint;
    private BufferedImage renderedImage;
    private BufferedImage mattedImage;
    protected XMLControl currentState;
    protected XMLControl currentCoords;
    protected XMLControl currentSteps;
    protected TPoint pointState = new TPoint();
    protected TMouseHandler mouseHandler;
    protected JLabel badNameLabel;
    protected TrackDataBuilder dataBuilder;
    protected boolean dataToolVisible;
    protected XMLProperty customViewsProperty;
    protected XMLProperty selectedViewsProperty;
    protected XMLProperty selectedViewTypesProperty;
    protected XMLProperty selectedTrackViewsProperty;
    protected double[] dividerLocs;
    protected Point zoomCenter;
    protected Map<Filter, Point> visibleFilters;
    protected int trackControlX = Integer.MIN_VALUE;
    protected int trackControlY;
    protected int infoX = Integer.MIN_VALUE;
    protected int infoY;
    protected String defaultSavePath;
    protected String openedFromPath;
    protected ModelBuilder modelBuilder;
    protected TrackControl trackControl;
    protected boolean isModelBuilderVisible;
    protected boolean isShiftKeyDown;
    protected boolean isControlKeyDown;
    protected boolean isEnterKeyDown;
    protected boolean isAutoPaste;
    private int cursorType;
    private boolean showTrackControlDelayed;
    protected ArrayList<TTrack> calibrationTools = new ArrayList();
    protected Set<TTrack> visibleCalibrationTools = new HashSet<TTrack>();
    protected Set<TTrack> measuringTools = new HashSet<TTrack>();
    protected Set<TTrack> visibleMeasuringTools = new HashSet<TTrack>();
    protected String author;
    protected String contact;
    protected AutoTracker autoTracker;
    protected DerivativeAlgorithmDialog algorithmDialog;
    protected AttachmentDialog attachmentDialog;
    protected PlotGuestDialog guestsDialog;
    protected UnitsDialog unitsDialog;
    protected PasteDataDialog pasteDataDialog;
    private boolean isAutoRefresh = true;
    protected boolean isNotesVisible = false;
    protected TreeSet<String> supplementalFilePaths = new TreeSet();
    protected Map<String, String> pageViewFilePaths = new HashMap<String, String>();
    protected StepSet selectedSteps;
    protected boolean hideDescriptionWhenLoaded;
    protected PropertyChangeListener massParamListener;
    protected PropertyChangeListener massChangeListener;
    protected TreeMap<String, String>[] formatPatterns = new TreeMap[TTrack.getDefaultFormatPatterns().length];
    protected String lengthUnit = "m";
    protected String massUnit = "kg";
    protected boolean unitsVisible = true;
    protected TCoordinateStringBuilder coordStringBuilder;
    protected ArrayList<Integer> andWorld = new ArrayList();
    protected double[] dividerFractions = new double[4];
    private int enabledCount;
    public NumberFormatDialog numberFormatDialog;
    private ArrayList<TTrack> userTracks;
    private ArrayList<TTrack> exportableTracks;
    private Map<String, AbstractAction> actions;
    protected String title;
    private ArrayList<Drawable> tempA;

    public Integer getID() {
        return this.panelID;
    }

    public TrackerPanel() {
        this(null, null, null, true);
    }

    public TrackerPanel(boolean ignored) {
        this(null, null, null, false);
    }

    public TrackerPanel(TFrame frame) {
        this(frame, null, null, true);
    }

    public TrackerPanel(TFrame frame, Video video2) {
        this(frame, video2, null, true);
    }

    public TrackerPanel(TFrame frame, TrackerPanel panel) {
        this(frame, null, panel, true);
    }

    public TrackerPanel(TFrame frame, Video video2, TrackerPanel panel) {
        this(frame, video2, panel, true);
    }

    private TrackerPanel(TFrame frame, Video video2, TrackerPanel panel, boolean createFrame) {
        super(video2);
        this.setTFrame(frame == null && createFrame ? new TFrame() : frame);
        if (panel == null) {
            this.andWorld.add(this.panelID);
        } else {
            panel.andWorld.add(this.panelID);
        }
        this.selectedSteps = new StepSet(frame, this.panelID);
        this.setGUI();
    }

    public void setTFrame(TFrame frame) {
        this.frame = frame;
        this.panelID = frame == null ? Integer.valueOf(0) : frame.allocatePanel(this);
        System.out.println("TrackerPanel " + this + " created");
    }

    public boolean isWorldPanel() {
        return this.getClass() != TrackerPanel.class;
    }

    public Map<String, AbstractAction> getActions() {
        return this.actions;
    }

    protected void setGUI() {
        this.actions = TActions.createActions(this);
        this.displayCoordsOnMouseMoved = true;
        this.zoomBox.setShowUndraggedBox(false);
        this.coordStringBuilder = new TCoordinateStringBuilder();
        this.setCoordinateStringBuilder(this.coordStringBuilder);
        this.badNameLabel = new JLabel();
        this.badNameLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.massParamListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("m".equals(e.getOldValue())) {
                    ParamEditor paramEditor = (ParamEditor)e.getSource();
                    Parameter param = (Parameter)paramEditor.getObject("m");
                    FunctionPanel panel = paramEditor.getFunctionPanel();
                    PointMass m = (PointMass)TrackerPanel.this.getTrack(panel.getName());
                    if (m != null && m.getMass() != param.getValue()) {
                        m.setMass(param.getValue());
                        m.massField.setValue(m.getMass());
                    }
                }
            }
        };
        this.massChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                FunctionPanel panel;
                PointMass pm = (PointMass)e.getSource();
                FunctionPanel functionPanel = panel = TrackerPanel.this.dataBuilder == null ? null : TrackerPanel.this.dataBuilder.getPanel(pm.getName());
                if (panel == null) {
                    return;
                }
                ParamEditor paramEditor = panel.getParamEditor();
                Parameter param = (Parameter)paramEditor.getObject("m");
                double newMass = (Double)e.getNewValue();
                if (newMass != param.getValue()) {
                    paramEditor.setExpression("m", String.valueOf(newMass), false);
                }
            }
        };
        this.coords.addPropertyChangeListenerSafely(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    if (!TrackerPanel.this.isShiftKeyDown) {
                        TrackerPanel.this.isShiftKeyDown = true;
                        boolean marking = TrackerPanel.this.setCursorForMarking(true, e);
                        if (TrackerPanel.this.selectedTrack != null && marking != TrackerPanel.this.selectedTrack.isMarking) {
                            TrackerPanel.this.selectedTrack.setMarking(marking);
                        }
                    }
                } else if (e.getKeyCode() == 17) {
                    if (!TrackerPanel.this.isControlKeyDown) {
                        TrackerPanel.this.isControlKeyDown = true;
                        boolean marking = TrackerPanel.this.setCursorForMarking(TrackerPanel.this.isShiftKeyDown, e);
                        if (TrackerPanel.this.selectedTrack != null && marking != TrackerPanel.this.selectedTrack.isMarking) {
                            TrackerPanel.this.selectedTrack.setMarking(marking);
                        }
                    }
                } else if (e.getKeyCode() == 10 && TrackerPanel.this.selectedTrack != null && TrackerPanel.this.cursorType == TrackerPanel.this.selectedTrack.getMarkingCursorType(e) && TrackerPanel.this.getFrameNumber() > 0) {
                    if (TrackerPanel.this.isEnterKeyDown) {
                        return;
                    }
                    TrackerPanel.this.isEnterKeyDown = true;
                    int n = TrackerPanel.this.getFrameNumber();
                    Step step = TrackerPanel.this.selectedTrack.getStep(n - 1);
                    if (step != null) {
                        Step clone = null;
                        if (TrackerPanel.this.selectedTrack.getClass() == PointMass.class) {
                            PositionStep.Position p = ((PositionStep)step).getPosition();
                            clone = TrackerPanel.this.selectedTrack.createStep(n, p.x, p.y);
                            ((PointMass)TrackerPanel.this.selectedTrack).keyFrames.add(n);
                        } else if (TrackerPanel.this.selectedTrack.getClass() == Vector.class) {
                            VectorStep s = (VectorStep)step;
                            TPoint tail = s.getTail();
                            TPoint tip = s.getTip();
                            Vector vector = (Vector)TrackerPanel.this.selectedTrack;
                            double dx = tip.x - tail.x;
                            double dy = tip.y - tail.y;
                            clone = vector.createStep(n, tail.x, tail.y, dx, dy);
                        }
                        if (clone != null && TrackerPanel.this.selectedTrack.isAutoAdvance()) {
                            TrackerPanel.this.selectedTrack.repaintStep(clone);
                            SwingUtilities.invokeLater(() -> {
                                TrackerPanel.this.getPlayer().step();
                                TrackerPanel.this.hideMouseBox();
                                TrackerPanel.this.isEnterKeyDown = false;
                            });
                        } else {
                            TrackerPanel.this.setMouseCursor(Cursor.getDefaultCursor());
                            if (clone != null) {
                                TrackerPanel.this.setSelectedPoint(clone.getDefaultPoint());
                                TrackerPanel.this.selectedTrack.repaintStep(clone);
                            }
                        }
                    }
                } else {
                    TrackerPanel.this.handleKeyPress(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    TrackerPanel.this.isShiftKeyDown = false;
                    boolean marking = TrackerPanel.this.setCursorForMarking(false, e);
                    if (TrackerPanel.this.selectedTrack != null && marking != TrackerPanel.this.selectedTrack.isMarking) {
                        TrackerPanel.this.selectedTrack.setMarking(marking);
                    }
                } else if (e.getKeyCode() == 17) {
                    TrackerPanel.this.isControlKeyDown = false;
                    boolean marking = TrackerPanel.this.setCursorForMarking(TrackerPanel.this.isShiftKeyDown, e);
                    if (TrackerPanel.this.selectedTrack != null && marking != TrackerPanel.this.selectedTrack.isMarking) {
                        TrackerPanel.this.selectedTrack.setMarking(marking);
                    }
                }
            }
        });
        this.setDrawingInImageSpace(true);
        this.setPreferredSize(new Dimension(1, 1));
        this.enabled = Tracker.getDefaultConfig();
        ++this.enabledCount;
        this.changed = false;
    }

    @Override
    protected void addVideoPlayer() {
        super.addVideoPlayer();
        this.player.setInspectorButtonVisible(false);
        this.player.addActionListener(this);
    }

    @Override
    protected void setMouseListeners() {
        this.mouseController = new TMouseController();
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.addOptionController();
    }

    @Override
    public void setVideo(Video newVideo) {
        TMat mat;
        boolean undoable;
        XMLControl state = null;
        Video oldVideo = this.getVideo();
        boolean bl = undoable = oldVideo != null;
        if (newVideo != oldVideo && oldVideo instanceof ImageVideo) {
            ImageVideo vid = (ImageVideo)this.getVideo();
            vid.saveInvalidImages();
            undoable = vid.isFileBased();
        }
        if (newVideo != oldVideo && undoable) {
            state = Undo.getXMLControl(this.getPlayer().getVideoClip());
        }
        if (newVideo != oldVideo && oldVideo != null) {
            TActions.clearFiltersAction(this, false);
        }
        super.setVideo(newVideo, true);
        if (state != null) {
            state = new XMLControlElement(state.toXML());
            Undo.postVideoReplace(this, state);
        }
        if ((mat = this.getMat()) != null && newVideo != null) {
            mat.refresh();
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.refreshSpinners();
        }
        this.firePropertyChange(PROPERTY_TRACKERPANEL_IMAGE, null, null);
    }

    public String getTitle() {
        if (this.getDataFile() != null) {
            this.title = this.getDataFile().getName();
        } else if (this.defaultFileName != null) {
            this.title = this.defaultFileName;
        } else if (this.getVideo() != null && (this.title = (String)this.getVideo().getProperty("name")) != null) {
            this.title = XML.forwardSlash(this.title);
            int i = this.title.lastIndexOf("/");
            if (i >= 0) {
                this.title = this.title.substring(i + 1);
            }
        } else {
            this.title = TrackerRes.getString("TrackerPanel.NewTab.Name");
        }
        return this.title;
    }

    public String getToolTipPath() {
        String path;
        if (this.getDataFile() != null) {
            return XML.forwardSlash(this.getDataFile().getPath());
        }
        if (this.openedFromPath != null) {
            return this.openedFromPath;
        }
        if (this.getVideo() != null && (path = (String)this.getVideo().getProperty("absolutePath")) != null) {
            return XML.forwardSlash(path);
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc == null ? "" : desc;
    }

    public ModelBuilder getModelBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = new ModelBuilder(this);
            try {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                Point frameLoc = this.frame.getLocationOnScreen();
                int w = this.modelBuilder.getWidth() + 20;
                int h = this.modelBuilder.getHeight() + 100;
                int x = Math.min(screen.width - w, frameLoc.x + this.frame.getWidth() - w);
                x = Math.max(x, 0);
                int y = Math.min(screen.height - h, frameLoc.y);
                y = Math.max(y, 0);
                this.modelBuilder.setLocation(x, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modelBuilder;
    }

    public void addDirtyRegion(Rectangle dirtyRect) {
        this.tainted = true;
        if (this.dirty == null) {
            this.dirty = dirtyRect;
        }
    }

    public void repaintDirtyRegion() {
        if (this.getHeight() >= 0 && (this.tainted || this.dirty != null)) {
            TFrame.repaintT(this);
        }
    }

    public ArrayList<TTrack> getTracks() {
        return this.getDrawables(TTrack.class);
    }

    public ArrayList<TTrack> getTracksTemp() {
        return this.getDrawablesTemp(TTrack.class);
    }

    public ArrayList<TTrack> getUserTracks() {
        if (this.userTracks != null) {
            return this.userTracks;
        }
        ArrayList<TTrack> tracks = this.getTracks();
        tracks.remove(this.getAxes());
        tracks.removeAll(this.calibrationTools);
        tracks.removeAll(this.measuringTools);
        tracks.removeAll(this.getDrawablesTemp(PerspectiveTrack.class));
        ArrayList<ParticleDataTrack> list = this.getDrawablesTemp(ParticleDataTrack.class);
        int m = 0;
        int n = list.size();
        while (m < n) {
            ParticleDataTrack track = list.get(m);
            if (track.getLeader() != track) {
                tracks.remove(track);
            }
            ++m;
        }
        list.clear();
        this.userTracks = tracks;
        return this.userTracks;
    }

    public ArrayList<TTrack> getExportableTracks() {
        if (this.exportableTracks != null) {
            return this.exportableTracks;
        }
        ArrayList<TTrack> tracks = this.getTracks();
        tracks.remove(this.getAxes());
        tracks.removeAll(this.calibrationTools);
        tracks.removeAll(this.getDrawablesTemp(PerspectiveTrack.class));
        this.exportableTracks = tracks;
        return this.exportableTracks;
    }

    public ArrayList<TTrack> getTracksToSave() {
        ArrayList<TTrack> tracks = this.getTracks();
        ArrayList<ParticleDataTrack> list = this.getDrawablesTemp(ParticleDataTrack.class);
        int m = 0;
        int n = list.size();
        while (m < n) {
            ParticleDataTrack track = list.get(m);
            if (track.getLeader() != track) {
                tracks.remove(track);
            }
            ++m;
        }
        list.clear();
        return tracks;
    }

    public TTrack getTrack(String name) {
        TTrack t = this.getTrack(name, this.getTracksTemp());
        this.clearTemp();
        return t;
    }

    public TTrack getTrack(String name, ArrayList<TTrack> list) {
        int it = 0;
        int n = list.size();
        while (it < n) {
            TTrack track = list.get(it);
            if (track.getName().equals(name) || track.getName(PROPERTY_TRACKERPANEL_TRACK).equals(name)) {
                return track;
            }
            ++it;
        }
        return null;
    }

    public synchronized void addTrack(TTrack track) {
        boolean doAddDrawable;
        boolean isUserTrack;
        boolean firstTrack;
        block39: {
            block40: {
                block38: {
                    if (track == null) {
                        return;
                    }
                    firstTrack = this.userTracks == null || this.userTracks.isEmpty();
                    isUserTrack = false;
                    this.userTracks = null;
                    this.exportableTracks = null;
                    track.setActive();
                    if (track.tp == null) {
                        track.setTrackerPanel(this);
                        track.addListener(this);
                    }
                    track.setAnglesInRadians(this.frame != null && this.frame.isAnglesInRadians());
                    this.showTrackControlDelayed = true;
                    doAddDrawable = true;
                    if (!(track instanceof ParticleDataTrack)) break block38;
                    ParticleDataTrack pdt = (ParticleDataTrack)track;
                    super.addDrawable(pdt);
                    if (pdt.morePoints.size() > 0) {
                        SwingUtilities.invokeLater(() -> this.addDataTrackPoints(pdt));
                    }
                    doAddDrawable = false;
                    isUserTrack = true;
                    break block39;
                }
                if (!this.calibrationTools.contains(track)) break block40;
                this.showTrackControlDelayed = false;
                break block39;
            }
            switch (track.getBaseType()) {
                case "PerspectiveTrack": {
                    this.showTrackControlDelayed = false;
                    break;
                }
                case "TapeMeasure": {
                    this.showTrackControlDelayed = false;
                    TapeMeasure tape = (TapeMeasure)track;
                    if (tape.isReadOnly()) {
                        this.measuringTools.add(tape);
                        this.visibleMeasuringTools.add(tape);
                        isUserTrack = true;
                        break;
                    }
                    this.calibrationTools.add(tape);
                    this.visibleCalibrationTools.add(tape);
                    break;
                }
                case "Calibration": 
                case "OffsetOrigin": {
                    this.showTrackControlDelayed = false;
                    this.calibrationTools.add(track);
                    this.visibleCalibrationTools.add(track);
                    break;
                }
                case "CoordAxes": {
                    this.showTrackControlDelayed = false;
                    if (this.getAxes() != null) {
                        this.removeDrawable(this.getAxes());
                    }
                    super.addDrawable(track);
                    this.moveToBack(track);
                    TMat mat = this.getMat();
                    if (mat != null) {
                        this.moveToBack(mat);
                    }
                    doAddDrawable = false;
                    break;
                }
                case "Protractor": 
                case "CircleFitter": {
                    this.showTrackControlDelayed = false;
                    this.measuringTools.add(track);
                    this.visibleMeasuringTools.add(track);
                    isUserTrack = true;
                    break;
                }
                default: {
                    this.setTrackName(track, track.getName(), false);
                    isUserTrack = true;
                }
            }
        }
        if (doAddDrawable) {
            if (isUserTrack) {
                boolean automark = track.isMarkByDefault();
                track.setMarkByDefault(automark || !OSPRuntime.hasKeyboard);
            }
            super.addDrawable(track);
        }
        if (this.trackControl != null && this.trackControl.isVisible()) {
            this.trackControl.refresh();
        }
        if (this.dataBuilder != null && !this.getSystemDrawables().contains(track)) {
            FunctionPanel panel = this.createFunctionPanel(track);
            this.dataBuilder.addPanel(track.getName(), panel);
            this.dataBuilder.setSelectedPanel(track.getName());
        }
        int len = track.getSteps().length;
        len = Math.max(len, this.getCoords().getLength());
        this.getCoords().setLength(len);
        track.setFontLevel(FontSizer.getLevel());
        if (this.frame != null) {
            track.setInitialFormatPatterns(this);
        }
        this.changed = true;
        if (this.autoTracker != null && track != this.getAxes()) {
            this.autoTracker.setTrack(track);
        }
        if (firstTrack && isUserTrack && this.frame != null && !this.frame.areViewsVisible(0, this)) {
            if (!TFrame.isPortraitOrientation) {
                this.frame.setDividerLocation(this, 0, 0.67);
            } else {
                this.frame.setDividerLocation(this, 2, 0.5);
            }
        }
        this.firePropertyChange(PROPERTY_TRACKERPANEL_TRACK, null, track);
    }

    private void addDataTrackPoints(ParticleDataTrack dt) {
        for (ParticleDataTrack child : dt.morePoints) {
            this.addTrack(child);
        }
        if (this.frame != null && this.isShowing()) {
            List<TView> views = this.frame.getTViews(this.panelID, 0, null);
            this.frame.getTViews(this.panelID, 1, views);
            int i = 0;
            while (i < views.size()) {
                ((TrackChooserTView)views.get(i)).setSelectedTrack(dt);
                ++i;
            }
        }
    }

    protected boolean isTrackViewDisplayed(TTrack track) {
        TFrame frame = this.getTFrame();
        if (frame != null && this.isShowing()) {
            List<TView> views = frame.getTViews(this.panelID, 0, null);
            frame.getTViews(this.panelID, 1, views);
            int i = 0;
            while (i < views.size()) {
                TView view = views.get(i);
                if (((TrackChooserTView)view).isTrackViewDisplayed(track)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected FunctionPanel createFunctionPanel(TTrack track) {
        track.refreshDataLater = true;
        DatasetManager data = track.getData(this);
        track.refreshDataLater = false;
        DataFunctionPanel functionPanel = new DataFunctionPanel(data);
        functionPanel.setIcon(track.getIcon(21, 16, "point"));
        ParamEditor paramEditor = functionPanel.getParamEditor();
        switch (track.getBaseType()) {
            case "PointMass": {
                functionPanel.setDescription(PointMass.class.getName());
                PointMass pm = (PointMass)track;
                Parameter param = (Parameter)paramEditor.getObject("m");
                if (param == null) {
                    param = new Parameter("m", String.valueOf(pm.getMass()));
                    param.setDescription(TrackerRes.getString("ParticleModel.Parameter.Mass.Description"));
                    paramEditor.addObject(param, false);
                }
                param.setNameEditable(false);
                paramEditor.addPropertyChangeListener("edit", this.massParamListener);
                pm.addPropertyChangeListener("mass", this.massChangeListener);
                break;
            }
            case "Vector": {
                functionPanel.setDescription(Vector.class.getName());
                break;
            }
            default: {
                functionPanel.setDescription(track.getClass().getName());
            }
        }
        return functionPanel;
    }

    public void removePointMassListeners(PointMass pointMass) {
        FunctionPanel functionPanel;
        pointMass.removePropertyChangeListener("mass", this.massChangeListener);
        if (this.dataBuilder != null && (functionPanel = this.dataBuilder.getPanel(this.getName())) != null) {
            functionPanel.getParamEditor().removePropertyChangeListener("edit", this.massParamListener);
        }
    }

    public synchronized void removeTrack(TTrack track) {
        if (this.getTrackByName(track.getClass(), track.getName()) == null) {
            return;
        }
        this.userTracks = null;
        this.exportableTracks = null;
        track.removeListener(this);
        super.removeDrawable(track);
        if (this.dataBuilder != null) {
            this.dataBuilder.removePanel(track.getName());
        }
        if (this.getSelectedTrack() == track) {
            this.setSelectedTrack(null);
        }
        this.firePropertyChange(PROPERTY_TRACKERPANEL_TRACK, track, null);
        TTrack.removeActiveTrack(track.getID());
        this.changed = true;
    }

    public boolean containsTrack(TTrack track) {
        ArrayList<TTrack> list = this.getTracksTemp();
        boolean ret = false;
        int it = 0;
        int n = list.size();
        while (it < n) {
            TTrack next = list.get(it);
            if (track == next) {
                ret = true;
                break;
            }
            ++it;
        }
        this.clearTemp();
        return ret;
    }

    public void eraseAll() {
        ArrayList<TTrack> list = this.getTracks();
        int it = 0;
        int n = list.size();
        while (it < n) {
            TTrack track = list.get(it);
            track.erase();
            ++it;
        }
    }

    public void askSaveIfChanged(final Function<Boolean, Void> whenClosed, final Runnable whenCanceled) {
        int i;
        if (!this.changed) {
            whenClosed.apply(false);
            return;
        }
        String name = this.getTitle();
        if (this.getDataFile() == null && (i = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, i);
        }
        new AsyncDialog().showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.SaveChanges.Message")) + " \"" + name + "\"?", TrackerRes.getString("TrackerPanel.Dialog.SaveChanges.Title"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 0: {
                        TrackerPanel.this.restoreViews();
                        File file = VideoIO.save(TrackerPanel.this.getDataFile(), TrackerPanel.this);
                        if (file == null && whenCanceled != null) {
                            whenCanceled.run();
                            break;
                        }
                        TrackerPanel.this.changed = false;
                        if (whenClosed == null) break;
                        whenClosed.apply(true);
                        break;
                    }
                    case 1: {
                        if (whenClosed == null) break;
                        whenClosed.apply(false);
                        break;
                    }
                    default: {
                        if (whenCanceled == null) break;
                        whenCanceled.run();
                    }
                }
            }
        });
    }

    @Override
    public ArrayList<Drawable> getDrawables() {
        TMat mat;
        ArrayList<Drawable> list = super.getDrawables();
        TTrack track = this.getSelectedTrack();
        if (track != null && list.contains(track) && track != this.getAxes()) {
            list.remove(track);
            list.add(track);
        }
        if ((mat = this.getMat()) != null && list.get(0) != mat) {
            list.remove(mat);
            list.add(0, mat);
        }
        return list;
    }

    public ArrayList<Drawable> getSystemDrawables() {
        ArrayList<Drawable> list = new ArrayList<Drawable>();
        Trackable drawable = this.getMat();
        if (drawable != null) {
            list.add(drawable);
        }
        if ((drawable = this.getAxes()) != null) {
            list.add(drawable);
        }
        for (TTrack next : this.calibrationTools) {
            list.add(next);
        }
        return list;
    }

    @Override
    public synchronized void addDrawable(Drawable drawable) {
        if (drawable instanceof TTrack) {
            this.addTrack((TTrack)drawable);
        } else {
            super.addDrawable(drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToBack(Drawable drawable) {
        if (drawable != null && this.drawableList.contains(drawable)) {
            ArrayList arrayList = this.drawableList;
            synchronized (arrayList) {
                this.drawableList.remove(drawable);
                if (drawable instanceof TMat) {
                    this.drawableList.add(0, drawable);
                } else {
                    int index;
                    int n = index = this.getMat() == null ? 0 : 1;
                    if (this.getVideo() != null) {
                        ++index;
                    }
                    this.drawableList.add(index, drawable);
                }
            }
        }
    }

    @Override
    public synchronized void removeDrawable(Drawable drawable) {
        if (drawable instanceof TTrack) {
            this.removeTrack((TTrack)drawable);
        } else {
            super.removeDrawable(drawable);
        }
    }

    @Override
    public synchronized <T extends Drawable> void removeObjectsOfClass(Class<T> c) {
        if (TTrack.class.isAssignableFrom(c)) {
            ArrayList<T> removed = this.getObjectOfClass(c);
            int i = 0;
            int n = removed.size();
            while (i < n) {
                ((TTrack)removed.get(i)).removeListener(this);
                ++i;
            }
            super.removeObjectsOfClass(c);
            for (T next : removed) {
                TTrack track = (TTrack)next;
                this.firePropertyChange(PROPERTY_TRACKERPANEL_TRACK, track, null);
            }
            this.changed = true;
        } else {
            super.removeObjectsOfClass(c);
        }
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    private synchronized void clear(boolean andSetCoords) {
        this.setSelectedTrack(null);
        this.selectedPoint = null;
        ArrayList<TTrack> list = this.getTracks();
        int i = 0;
        int n = list.size();
        while (i < n) {
            TTrack track = list.get(i);
            track.removeListener(this);
            ImageCoordSystem coords = this.getCoords();
            if (andSetCoords && coords instanceof ReferenceFrame && ((ReferenceFrame)coords).getOriginTrack() == track) {
                coords = ((ReferenceFrame)coords).getCoords();
                this.setCoords(coords);
            }
            ++i;
        }
        TMat mat = this.getMat();
        if (mat != null) {
            mat.cleanup();
        }
        super.clear();
        if (this.dataBuilder != null) {
            this.dataBuilder.clearPanels();
            this.dataBuilder.setVisible(false);
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.clearPanels();
            this.modelBuilder.setVisible(false);
        }
        if (!this.isDisposed) {
            this.firePropertyChange(PROPERTY_TRACKERPANEL_CLEAR, null, null);
        }
        int it = 0;
        int n2 = list.size();
        while (it < n2) {
            TTrack.removeActiveTrack(list.get(it).getID());
            ++it;
        }
        this.changed = true;
    }

    public synchronized void clearTracks() {
        ArrayList<TTrack> list = this.getTracks();
        ArrayList<Drawable> keepers = this.getSystemDrawables();
        this.clear();
        int i = 0;
        int n = keepers.size();
        while (i < n) {
            Drawable drawable = keepers.get(i);
            if (drawable instanceof TMat) {
                ((TMat)drawable).setTrackerPanel(this);
            }
            this.addDrawable(drawable);
            list.remove(drawable);
            ++i;
        }
        int it = 0;
        n = list.size();
        while (it < n) {
            TTrack track = list.get(it);
            track.dispose();
            ++it;
        }
    }

    @Override
    public void setCoords(ImageCoordSystem _coords) {
        if (_coords == null || _coords == this.coords) {
            return;
        }
        if (this.video == null) {
            this.coords.removePropertyChangeListener(this);
            this.coords = _coords;
            this.coords.addPropertyChangeListener(this);
            int n = this.getFrameNumber();
            this.getSnapPoint().setXY(this.coords.getOriginX(n), this.coords.getOriginY(n));
            try {
                this.firePropertyChange("coords", null, this.coords);
                this.firePropertyChange("transform", null, null);
            }
            catch (Exception exception) {}
        } else {
            this.video.setCoords(_coords);
        }
    }

    public void setReferenceFrame(String trackName) {
        final PointMass thePM = this.getTrackByName(PointMass.class, trackName);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (thePM != null) {
                    ImageCoordSystem coords = TrackerPanel.this.getCoords();
                    boolean wasRefFrame = coords instanceof ReferenceFrame;
                    while (coords instanceof ReferenceFrame) {
                        coords = ((ReferenceFrame)coords).getCoords();
                    }
                    TrackerPanel.this.setCoords(new ReferenceFrame(coords, thePM));
                    if (thePM instanceof ParticleModel && wasRefFrame) {
                        ((ParticleModel)thePM).setLastValidFrame(-1);
                        ((ParticleModel)thePM).refreshSteps("referenceFrame change");
                    }
                    TrackerPanel.this.setSelectedPoint(null);
                    TrackerPanel.this.selectedSteps.clear();
                    TFrame.repaintT(TrackerPanel.this);
                } else {
                    ImageCoordSystem coords = TrackerPanel.this.getCoords();
                    if (coords instanceof ReferenceFrame) {
                        coords = ((ReferenceFrame)coords).getCoords();
                        TrackerPanel.this.setCoords(coords);
                        TrackerPanel.this.setSelectedPoint(null);
                        TrackerPanel.this.selectedSteps.clear();
                        TFrame.repaintT(TrackerPanel.this);
                    }
                }
            }
        };
        runner.run();
    }

    public CoordAxes getAxes() {
        return this.getFirstDrawable(CoordAxes.class);
    }

    public TMat getMat() {
        TMat mat = this.getFirstDrawable(TMat.class);
        if (mat != null) {
            mat.checkVideo(this);
        }
        return mat;
    }

    public TPoint getSnapPoint() {
        if (this.snapPoint == null) {
            this.snapPoint = new TPoint();
        }
        return this.snapPoint;
    }

    @Override
    public void setCursor(Cursor c) {
        this.cursorType = c == TMouseHandler.autoTrackCursor ? 2 : (c == TMouseHandler.autoTrackMarkCursor ? 3 : (c == TMouseHandler.markPointCursor ? 1 : 0));
        super.setCursor(c);
    }

    public void setSelectedTrack(TTrack track) {
        if (this.selectedTrack == track) {
            return;
        }
        if (track != null && track instanceof ParticleModel && ((ParticleModel)track).refreshing) {
            return;
        }
        TTrack prevTrack = this.selectedTrack;
        this.selectedTrack = track;
        if (Tracker.showHints && track != null) {
            this.setMessage(track.getMessage());
        } else {
            this.setMessage("");
        }
        this.firePropertyChange(PROPERTY_TRACKERPANEL_SELECTEDTRACK, prevTrack, track);
        this.coordStringBuilder.setUnitsAndPatterns(track, "x", "y");
    }

    public TTrack getSelectedTrack() {
        return this.selectedTrack;
    }

    public void setSelectedPoint(TPoint point) {
        boolean prevPointChanged;
        boolean stepsChanged;
        if (point == this.selectedPoint && point == null) {
            return;
        }
        TPoint prevPoint = this.selectedPoint;
        if (prevPoint != null) {
            prevPoint.setAdjusting(false, null);
        }
        this.selectedPoint = point;
        boolean bl = stepsChanged = !this.selectedSteps.isEmpty() && this.selectedSteps.isChanged();
        if (this.selectedSteps.size() > 1) {
            boolean newStepSelected = false;
            if (point != null) {
                Step step = null;
                ArrayList<TTrack> list = this.getTracksTemp();
                int it = 0;
                int n = list.size();
                while (it < n) {
                    TTrack track = list.get(it);
                    step = track.getStep(point, this);
                    if (step != null) {
                        newStepSelected = this.selectedSteps.contains(step);
                        break;
                    }
                    ++it;
                }
                list.clear();
            }
            if (newStepSelected) {
                this.firePropertyChange(PROPERTY_TRACKERPANEL_SELECTEDPOINT, prevPoint, point);
                this.selectedSteps.isModified = false;
                return;
            }
        }
        boolean bl2 = prevPointChanged = this.currentState != null && prevPoint != null && prevPoint != point && prevPoint != this.newlyMarkedPoint && (prevPoint.x != this.pointState.x || prevPoint.y != this.pointState.y);
        if (this.selectedPoint == null) {
            this.newlyMarkedPoint = null;
        }
        if (stepsChanged || prevPointChanged) {
            boolean trackEdit = false;
            boolean coordsEdit = false;
            if (prevPointChanged && prevPoint != null) {
                trackEdit = prevPoint.isTrackEditTrigger() && this.getSelectedTrack() != null;
                coordsEdit = prevPoint.isCoordsEditTrigger();
            } else {
                boolean bl3 = trackEdit = this.selectedSteps.getTracks().length == 1;
            }
            if (trackEdit && coordsEdit) {
                Undo.postTrackAndCoordsEdit(this.getSelectedTrack(), this.currentState, this.currentCoords);
            } else if (trackEdit) {
                if (stepsChanged) {
                    if (!this.selectedSteps.isModified) {
                        this.selectedSteps.clear();
                    }
                } else {
                    Undo.postTrackEdit(this.getSelectedTrack(), this.currentState);
                }
            } else if (coordsEdit) {
                Undo.postCoordsEdit(this, this.currentState);
            } else if (prevPoint != null && prevPoint.isStepEditTrigger()) {
                Undo.postStepEdit(this.selectedStep, this.currentState);
            } else if (prevPoint instanceof LineProfileStep.LineEnd) {
                prevPoint.setTrackEditTrigger(true);
            }
        }
        if (this.selectedStep != null) {
            this.selectedStep.repaint();
        }
        if (point == null) {
            this.selectedStep = null;
            this.selectingPanelID = null;
            this.currentState = null;
            this.currentCoords = null;
        } else {
            Step step = null;
            TTrack track = null;
            ArrayList<TTrack> list = this.getTracks();
            int it = 0;
            int n = list.size();
            while (it < n) {
                track = list.get(it);
                step = track.getStep(point, this);
                if (step != null) break;
                ++it;
            }
            this.selectedStep = step;
            if (step == null) {
                boolean ignore;
                boolean bl4 = ignore = this.autoTracker != null && this.autoTracker.getWizard().isVisible() && (point instanceof AutoTracker.Corner || point instanceof AutoTracker.Handle || point instanceof AutoTracker.Target);
                if (!ignore) {
                    this.setSelectedTrack(null);
                }
            } else {
                this.setSelectedTrack(track);
                step.repaint();
                if (prevPoint != point) {
                    boolean trackEdit = point.isTrackEditTrigger();
                    boolean coordsEdit = point.isCoordsEditTrigger();
                    this.pointState.setLocation(point);
                    if (trackEdit && coordsEdit) {
                        this.currentState = new XMLControlElement(track);
                        this.currentCoords = new XMLControlElement(this.getCoords());
                    } else if (trackEdit) {
                        this.currentState = new XMLControlElement(track);
                        if (!this.selectedSteps.contains(step) && !this.selectedSteps.isModified) {
                            this.selectedSteps.clear();
                        }
                    } else if (coordsEdit) {
                        this.currentState = new XMLControlElement(this.getCoords());
                    } else if (point.isStepEditTrigger()) {
                        this.currentState = new XMLControlElement(step);
                    }
                }
            }
            this.selectingPanelID = this.panelID;
            this.requestFocusInWindow();
        }
        if (this.selectedStep != null) {
            this.selectedSteps.add(this.selectedStep);
        }
        this.selectedSteps.isModified = false;
        this.firePropertyChange(PROPERTY_TRACKERPANEL_SELECTEDPOINT, prevPoint, point);
    }

    public Integer getSelectingPanelID() {
        return this.selectingPanelID;
    }

    public TPoint getSelectedPoint() {
        return this.selectedPoint;
    }

    public Step getSelectedStep() {
        return this.selectedStep;
    }

    public void setMagnification(double magnification) {
        MainTView view;
        Dimension d;
        if (magnification == 0.0 || Double.isNaN(magnification)) {
            return;
        }
        double prevZoom = this.getMagnification();
        Dimension prevSize = this.getPreferredSize();
        Point p1 = new TPoint(0.0, 0.0).getScreenPosition(this);
        if (prevSize.width == 1 && prevSize.height == 1) {
            double w = this.getImageWidth();
            double h = this.getImageHeight();
            Point p2 = new TPoint(w, h).getScreenPosition(this);
            prevSize.width = p2.x - p1.x;
            prevSize.height = p2.y - p1.y;
        }
        if (magnification < 0.0) {
            d = new Dimension(1, 1);
        } else {
            this.zoom = Math.min(Math.max(magnification, 0.1), 20.0);
            int w = (int)(this.imageWidth * this.zoom);
            int h = (int)(this.imageHeight * this.zoom);
            d = new Dimension(w, h);
        }
        this.setPreferredSize(d);
        this.firePropertyChange(PROPERTY_TRACKERPANEL_MAGNIFICATION, (Object)prevZoom, (Object)this.getMagnification());
        MainTView mainTView = view = this.getTFrame() == null ? null : this.getTFrame().getMainView(this);
        if (view != null) {
            view.scrollPane.revalidate();
            view.scrollToZoomCenter(this.getPreferredSize(), prevSize, p1);
            this.eraseAll();
        }
        this.zoomBox.hide();
    }

    public double getMagnification() {
        if (this.getPreferredSize().width == 1) {
            double w = this.getImageWidth();
            double h = this.getImageHeight();
            Dimension size = this.getSize();
            return Math.min((double)size.width / w, (double)size.height / h);
        }
        return this.zoom;
    }

    @Override
    public void setImageWidth(double w) {
        this.setImageSize(w, this.getImageHeight());
    }

    @Override
    public void setImageHeight(double h) {
        this.setImageSize(this.getImageWidth(), h);
    }

    public void setImageSize(double w, double h) {
        super.setImageWidth(w);
        super.setImageHeight(h);
        TMat mat = this.getMat();
        if (mat != null) {
            mat.refresh();
        }
        if (this.getPreferredSize().width > 10) {
            this.setMagnification(this.getMagnification());
        }
        this.eraseAll();
        TFrame.repaintT(this);
        this.firePropertyChange(PROPERTY_TRACKERPANEL_SIZE, null, null);
    }

    public ClipInspector setClipSettingsVisible(Boolean vis) {
        VideoClip clip = this.getPlayer().getVideoClip();
        ClipControl clipControl = this.getPlayer().getClipControl();
        TFrame frame = this.getTFrame();
        ClipInspector inspector = clip.getClipInspector(clipControl, frame);
        if ((vis == null || vis == Boolean.FALSE) && inspector.isVisible()) {
            inspector.setVisible(false);
            return inspector;
        }
        if (vis == Boolean.FALSE) {
            return inspector;
        }
        FontSizer.setFonts(inspector, FontSizer.getLevel());
        inspector.pack();
        final TToolBar toolbar = this.getToolBar(true);
        if (!inspector.isPositioned) {
            inspector.isPositioned = true;
            Rectangle rect = this.getVisibleRect();
            Point p = frame.getMainView((TrackerPanel)this).scrollPane.getLocationOnScreen();
            int x = p.x + (rect.width - inspector.getBounds().width) / 2;
            int y = p.y + (rect.height - inspector.getBounds().height) / 2;
            inspector.setLocation(x, y);
            ComponentAdapter clipSettingsListener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    toolbar.refresh("clip settings hidden");
                }
            };
            inspector.addComponentListener(clipSettingsListener);
        }
        inspector.initialize();
        inspector.setVisible(true);
        toolbar.refresh("clip settings shown");
        return inspector;
    }

    public void setScrollPane(JScrollPane scroller) {
        this.scrollPane = scroller;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unitIncrement = this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (orientation == 0) {
            return visibleRect.width - unitIncrement;
        }
        return visibleRect.height - unitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.scrollPane == null) {
            return true;
        }
        Dimension panelDim = this.getPreferredSize();
        Rectangle viewRect = this.scrollPane.getViewport().getViewRect();
        return viewRect.width > panelDim.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.scrollPane == null) {
            return true;
        }
        Dimension panelDim = this.getPreferredSize();
        Rectangle viewRect = this.scrollPane.getViewport().getViewRect();
        return viewRect.height > panelDim.height;
    }

    public boolean isUnitsVisible() {
        return this.unitsVisible && this.lengthUnit != null && this.massUnit != null;
    }

    public void setUnitsVisible(boolean visible) {
        if (visible == this.unitsVisible) {
            return;
        }
        this.unitsVisible = visible;
        this.refreshTrackBar();
        this.coordStringBuilder.setUnitsAndPatterns(this.getSelectedTrack(), "x", "y");
        if (this.getSelectedPoint() != null) {
            this.getSelectedPoint().showCoordinates(this);
        }
        this.firePropertyChange(PROPERTY_TRACKERPANEL_UNITS, false, true);
    }

    public String getMassUnit() {
        return this.massUnit;
    }

    public boolean setMassUnit(String unit) {
        if (unit != null) {
            unit = unit.trim();
        }
        if ("".equals(unit)) {
            unit = null;
        }
        if (this.massUnit != null && this.massUnit.equals(unit)) {
            return false;
        }
        if (this.massUnit == null && unit == null) {
            return false;
        }
        try {
            Double.parseDouble(unit);
            return false;
        }
        catch (Exception exception) {
            this.massUnit = unit;
            this.refreshTrackBar();
            this.firePropertyChange(PROPERTY_TRACKERPANEL_UNITS, false, true);
            return true;
        }
    }

    public String getLengthUnit() {
        return this.lengthUnit;
    }

    public boolean setLengthUnit(String unit) {
        if (unit != null) {
            unit = unit.trim();
        }
        if ("".equals(unit)) {
            unit = null;
        }
        if (this.lengthUnit != null && this.lengthUnit.equals(unit)) {
            return false;
        }
        if (this.lengthUnit == null && unit == null) {
            return false;
        }
        try {
            Double.parseDouble(unit);
            return false;
        }
        catch (Exception exception) {
            this.lengthUnit = unit;
            this.refreshTrackBar();
            this.coordStringBuilder.setUnitsAndPatterns(this.getSelectedTrack(), "x", "y");
            if (this.getSelectedPoint() != null) {
                this.getSelectedPoint().showCoordinates(this);
            }
            this.firePropertyChange(PROPERTY_TRACKERPANEL_UNITS, false, true);
            return true;
        }
    }

    @Override
    public boolean setTimeUnit(String unit) {
        if (super.setTimeUnit(unit)) {
            this.refreshTrackBar();
            VideoClip clip = this.getPlayer().getVideoClip();
            ClipControl clipControl = this.getPlayer().getClipControl();
            TFrame frame = this.getTFrame();
            ClipInspector inspector = clip.getClipInspector(clipControl, frame);
            inspector.setTimeUnit(unit);
            this.firePropertyChange(PROPERTY_TRACKERPANEL_UNITS, false, true);
            return true;
        }
        return false;
    }

    public String getUnits(TTrack track, String var) {
        if (!this.isUnitsVisible()) {
            return "";
        }
        String dimensions = TTrack.getVariableDimensions(track, var);
        if (dimensions == null) {
            return "";
        }
        String sq = dimensions.endsWith("TT") ? "\u00b2" : "";
        String sp = " ";
        switch (dimensions) {
            case "T": {
                return String.valueOf(sp) + this.timeUnit;
            }
            case "M": {
                return String.valueOf(sp) + this.massUnit;
            }
            case "L": {
                return String.valueOf(sp) + this.lengthUnit;
            }
            case "L/T": 
            case "L/TT": {
                return String.valueOf(sp) + this.lengthUnit + "/" + this.timeUnit + sq;
            }
            case "ML/T": 
            case "ML/TT": {
                return String.valueOf(sp) + this.massUnit + "\u00b7" + this.lengthUnit + "/" + this.timeUnit + sq;
            }
            case "MLL/TT": {
                return String.valueOf(sp) + this.massUnit + "\u00b7" + this.lengthUnit + sq + "/" + this.timeUnit + sq;
            }
            case "A/T": 
            case "A/TT": {
                TFrame frame = this.getTFrame();
                String angUnit = frame != null && frame.isAnglesInRadians() ? "" : "\u00b0";
                return String.valueOf(sp) + angUnit + "/" + this.timeUnit + sq;
            }
        }
        return "";
    }

    @Override
    public boolean isShowCoordinates() {
        return this.showCoordinates && this.getSelectedPoint() == null;
    }

    @Override
    public void setMessage(String msg) {
        if (!OSPRuntime.isJS && !OSPRuntime.isMac()) {
            super.setMessage(msg);
        }
    }

    @Deprecated
    protected void importData(String dataString, Object source) {
        this.importDataAsync(dataString, source, null);
    }

    public void importDataAsync(String dataString, Object source, Runnable whenDone) {
        if (dataString == null) {
            if (this.isAutoPaste) {
                return;
            }
            JOptionPane.showMessageDialog(this.frame, TrackerRes.getString("TrackerPanel.Dialog.NoData.Message"), TrackerRes.getString("TrackerPanel.Dialog.NoData.Title"), 2);
            return;
        }
        DatasetManager[] datasetManager = DataTool.parseData(dataString, null);
        if (datasetManager == null) {
            String path = dataString;
            this.importDataAsync(ResourceLoader.getString(path), path, whenDone);
            return;
        }
        DataTrack dt = this.loadIntoDataTrack(datasetManager[0], source, this.isAutoPaste);
        if (dt instanceof ParticleDataTrack) {
            ((ParticleDataTrack)dt).prevDataString = dataString;
        }
        if (whenDone != null) {
            whenDone.run();
        }
    }

    private DataTrack loadIntoDataTrack(DatasetManager data, Object source, boolean reloadOnly) {
        if (data == null) {
            return null;
        }
        ParticleDataTrack dataTrack = ParticleDataTrack.getTrackForData(data, this);
        try {
            if (dataTrack == null && !reloadOnly) {
                dataTrack = new ParticleDataTrack(data, source);
                dataTrack.setColorToDefault(this.getDrawablesTemp(PointMass.class).size());
                this.clearTemp();
                this.addTrack(dataTrack);
                this.setSelectedPoint(null);
                this.selectedSteps.clear();
                this.setSelectedTrack(dataTrack);
                dataTrack.getDataClip().setClipLength(-1);
                VideoClip videoClip = this.getPlayer().getVideoClip();
                dataTrack.setStartFrame(videoClip.getStartFrameNumber());
                dataTrack.firePropertyChange("data", null, null);
                dataTrack.getModelBuilder().setVisible(true);
                ParticleDataTrack dt = dataTrack;
                EventQueue.invokeLater(() -> dt.firePropertyChange("data", null, null));
            } else if (dataTrack != null && (dataTrack.isAutoPasteEnabled() || !this.isAutoPaste)) {
                dataTrack.setData(data);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.Exception.Message")) + ":\n" + e.getClass().getSimpleName() + ": " + e.getMessage(), TrackerRes.getString("TrackerPanel.Dialog.Exception.Title"), 2);
            OSPLog.warning(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage());
            dataTrack = null;
        }
        return dataTrack;
    }

    protected void refreshTrackData(int mode) {
        boolean auto = this.isAutoRefresh;
        this.isAutoRefresh = true;
        this.firePropertyChange("data", (Object)mode, null);
        this.isAutoRefresh = auto;
    }

    @Override
    protected void refreshDecimalSeparators() {
        DataTool tool;
        super.refreshDecimalSeparators();
        if (this.coordStringBuilder != null) {
            this.coordStringBuilder.refreshDecimalSeparators();
        }
        if (this.getSelectedPoint() != null) {
            this.getSelectedPoint().showCoordinates(this);
        }
        ArrayList<TTrack> tracks = this.getTracksTemp();
        int i = 0;
        int n = tracks.size();
        while (i < n) {
            tracks.get(i).refreshDecimalSeparators();
            ++i;
        }
        tracks.clear();
        this.refreshTrackData(0x830000);
        if (this.modelBuilder != null) {
            this.modelBuilder.repaint();
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.repaint();
        }
        if ((tool = DataTool.getTool(false)) != null && this.getTFrame() != null && this.frame.getSelectedPanel() == this) {
            tool.refreshDecimalSeparators();
        }
        ArrayList<TapeMeasure> tapes = this.getDrawablesTemp(TapeMeasure.class);
        int i2 = 0;
        int n2 = tapes.size();
        while (i2 < n2) {
            TapeMeasure tape = tapes.get(i2);
            tape.repaint(this.panelID);
            ++i2;
        }
        tapes.clear();
        ArrayList<Protractor> prots = this.getDrawablesTemp(Protractor.class);
        int i3 = 0;
        int n3 = prots.size();
        while (i3 < n3) {
            Protractor p = prots.get(i3);
            p.repaint(this.panelID);
            ++i3;
        }
        prots.clear();
    }

    protected MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        if (!Tracker.allowMenuRefresh) {
            return null;
        }
        if (this.getTFrame() == null) {
            return super.getPopupMenu();
        }
        MainTView mainView = this.getTFrame().getMainView(this);
        return mainView.getPopupMenu();
    }

    protected JPopupMenu getPopup() {
        return this.popup != null ? this.popup : (this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean vis) {
                if (!vis) {
                    TrackerPanel.this.zoomBox.hide();
                }
                super.setVisible(vis);
            }
        });
    }

    public UnitsDialog getUnitsDialog() {
        if (this.unitsDialog == null) {
            this.unitsDialog = new UnitsDialog(this);
            this.unitsDialog.setFontLevel(FontSizer.getLevel());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.unitsDialog.getBounds().width) / 2;
            int y = (dim.height - this.unitsDialog.getBounds().height) / 2;
            this.unitsDialog.setLocation(x, y);
        } else {
            this.unitsDialog.setFontLevel(FontSizer.getLevel());
        }
        return this.unitsDialog;
    }

    public AttachmentDialog getAttachmentDialog(TTrack track) {
        if (this.attachmentDialog == null) {
            this.attachmentDialog = new AttachmentDialog(track);
            this.attachmentDialog.setFontLevel(FontSizer.getLevel());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.attachmentDialog.getBounds().width) / 2;
            int y = (dim.height - this.attachmentDialog.getBounds().height) / 2;
            this.attachmentDialog.setLocation(x, y);
        } else {
            this.attachmentDialog.setFontLevel(FontSizer.getLevel());
            this.attachmentDialog.setMeasuringTool(track);
        }
        return this.attachmentDialog;
    }

    public PasteDataDialog getPasteDataDialog() {
        if (this.pasteDataDialog == null) {
            this.pasteDataDialog = new PasteDataDialog(this);
        }
        this.pasteDataDialog.setFontLevel(FontSizer.getLevel());
        return this.pasteDataDialog;
    }

    public PlotGuestDialog getPlotGuestDialog(TrackPlottingPanel plot) {
        if (this.guestsDialog == null) {
            this.guestsDialog = new PlotGuestDialog(this);
            this.guestsDialog.setPlot(plot);
            FontSizer.setFonts(this.guestsDialog, FontSizer.getLevel());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.guestsDialog.getBounds().width) / 2;
            int y = (dim.height - this.guestsDialog.getBounds().height) / 2;
            this.guestsDialog.setLocation(x, y);
        } else {
            this.guestsDialog.setPlot(plot);
            FontSizer.setFonts(this.guestsDialog, FontSizer.getLevel());
        }
        this.guestsDialog.pack();
        return this.guestsDialog;
    }

    protected FunctionTool getDataBuilder() {
        if (this.dataBuilder == null) {
            this.dataBuilder = new TrackDataBuilder(this);
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("panel", this);
            this.dataBuilder.addPropertyChangeListener("function", this);
            this.dataBuilder.addPropertyChangeListener("description", this);
            this.dataBuilder.addPropertyChangeListener("ft_visible", this);
            this.dataBuilder.setFontLevel(FontSizer.getLevel());
        }
        return this.dataBuilder;
    }

    protected DerivativeAlgorithmDialog getAlgorithmDialog() {
        if (this.algorithmDialog == null) {
            this.algorithmDialog = new DerivativeAlgorithmDialog(this);
            this.algorithmDialog.setFontLevel(FontSizer.getLevel());
        }
        return this.algorithmDialog;
    }

    protected String getNextName(String name, String connector) {
        String p = String.valueOf(name) + connector;
        ArrayList<TTrack> list = this.getTracksTemp();
        int n = list.size();
        String proposed = null;
        int j = 0;
        while (j < 10) {
            int i = 65;
            while (i <= 90 && proposed == null) {
                proposed = String.valueOf(p) + (char)i;
                int k = 0;
                while (k < j) {
                    proposed = String.valueOf(proposed) + (char)i;
                    ++k;
                }
                int it = 0;
                while (it < n) {
                    if (proposed.equals(list.get(it).getName())) {
                        proposed = null;
                        break;
                    }
                    ++it;
                }
                ++i;
            }
            ++j;
        }
        this.clearTemp();
        return proposed;
    }

    protected void restoreViews() {
        TFrame frame = this.getTFrame();
        if (frame != null) {
            int n = frame.getMaximizedView();
            switch (n) {
                case -1: {
                    return;
                }
                case 4: {
                    this.getTrackBar((boolean)true).maximizeButton.doClick(0);
                    break;
                }
                default: {
                    TViewChooser viewChooser = frame.getViewChoosers(this)[n];
                    viewChooser.restore();
                }
            }
        }
    }

    protected boolean setCursorForMarking(boolean invert, InputEvent e) {
        if (this.isClipAdjusting() || Tracker.isZoomInCursor(this.getCursor()) || Tracker.isZoomOutCursor(this.getCursor())) {
            return false;
        }
        boolean markable = false;
        boolean marking = false;
        this.selectedTrack = this.getSelectedTrack();
        int n = this.getFrameNumber();
        if (this.selectedTrack != null) {
            if (this.selectedTrack instanceof MarkingRequired) {
                MarkingRequired tool = (MarkingRequired)((Object)this.selectedTrack);
                invert = invert && !tool.requiresMarking();
            }
            markable = !(this.selectedTrack.isStepComplete(n) && !invert || this.selectedTrack.isLocked() || this.popup != null && this.popup.isVisible());
            marking = markable && (this.selectedTrack.isMarkByDefault() || invert);
        }
        Interactive iad = this.getTracksTemp().isEmpty() || this.mouseEvent == null ? null : this.getInteractive();
        this.clearTemp();
        if (marking) {
            this.setMouseCursor(this.selectedTrack.getMarkingCursor(e));
            if (Tracker.showHints) {
                String msg = null;
                switch (this.selectedTrack.ttype) {
                    case 5: {
                        msg = this.selectedTrack.getStep(n) != null ? "PointMass.Remarking.Hint" : (this.selectedTrack.isMarkByDefault() ? "PointMass.Hint.Automarking" : "PointMass.Hint.Marking");
                        break;
                    }
                    case 9: {
                        msg = this.selectedTrack.getStep(n) == null ? "Vector.Hint.Marking" : "Vector.Remarking.Hint";
                        break;
                    }
                    case 7: {
                        msg = "RGBRegion.Hint.Marking";
                        break;
                    }
                    case 3: {
                        msg = "LineProfile.Hint.Marking";
                    }
                }
                if (msg != null) {
                    this.setMessage(TrackerRes.getString(msg));
                }
            } else {
                this.setMessage("");
            }
        } else if (iad instanceof TPoint) {
            this.setMouseCursor(Cursor.getPredefinedCursor(12));
            ArrayList<TTrack> list = this.getTracksTemp();
            int it = 0;
            int ni = list.size();
            while (it < ni) {
                TTrack track = list.get(it);
                Step step = track.getStep((TPoint)iad, this);
                if (step != null) {
                    this.setMessage(track.getMessage());
                    break;
                }
                ++it;
            }
            this.clearTemp();
        } else {
            this.setMouseCursor(Cursor.getDefaultCursor());
            this.getExportableTracks();
            if (Tracker.showHints && this.selectedTrack != null) {
                this.setMessage(this.selectedTrack.getMessage());
            } else if (!Tracker.startupHintShown || this.getVideo() != null || this.exportableTracks != null && !this.exportableTracks.isEmpty()) {
                Tracker.startupHintShown = false;
                if (!Tracker.showHints) {
                    this.setMessage("");
                } else if (this.getVideo() == null) {
                    this.setMessage(TrackerRes.getString("TrackerPanel.NoVideo.Hint"));
                } else if (this.hasToolBar() && this.getToolBar((boolean)true).notYetCalibrated) {
                    if (this.getVideo().getWidth() == 720.0 && this.getVideo().getFilterStack().isEmpty()) {
                        this.setMessage(TrackerRes.getString("TrackerPanel.DVVideo.Hint"));
                    } else if (this.getPlayer().getVideoClip().isDefaultState()) {
                        this.setMessage(TrackerRes.getString("TrackerPanel.SetClip.Hint"));
                    } else {
                        this.setMessage(TrackerRes.getString("TrackerPanel.CalibrateVideo.Hint"));
                    }
                } else if (this.getAxes() != null && this.getAxes().notyetShown) {
                    this.setMessage(TrackerRes.getString("TrackerPanel.ShowAxes.Hint"));
                } else if (this.exportableTracks == null || this.exportableTracks.isEmpty()) {
                    this.setMessage(TrackerRes.getString("TrackerPanel.NoTracks.Hint"));
                } else {
                    this.setMessage("");
                }
            }
        }
        return marking;
    }

    private boolean isClipAdjusting() {
        return this.getPlayer() != null && this.getPlayer().getVideoClip().isAdjusting();
    }

    protected void handleKeyPress(KeyEvent e) {
        if (e.getKeyCode() == 112) {
            TFrame frame = this.getTFrame();
            if (frame != null) {
                String key = null;
                if (this.selectedTrack == null) {
                    key = "help";
                } else {
                    switch (this.selectedTrack.ttype) {
                        case 0: {
                            key = "calibration";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            key = "axes";
                            break;
                        }
                        case 3: {
                            key = "profile";
                            break;
                        }
                        case 4: {
                            key = "offset";
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 5: {
                            key = this.selectedTrack instanceof CenterOfMass ? "cm" : (this.selectedTrack instanceof ParticleModel ? "particle" : "pointmass");
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            key = "rgbregion";
                            break;
                        }
                        case 8: {
                            key = "tape";
                            break;
                        }
                        case 9: {
                            String string = key = this.selectedTrack instanceof VectorSum ? "vectorsum" : "vector";
                        }
                    }
                }
                if (key != null) {
                    frame.showHelp(key, 0);
                }
            }
            return;
        }
        if (e.getKeyCode() == 32) {
            Step step;
            TTrack track = this.getSelectedTrack();
            if (track != null && (step = this.getSelectedStep()) != null && (step = e.isControlDown() || e.isShiftDown() ? track.getPreviousVisibleStep(step, this) : track.getNextVisibleStep(step, this)) != null) {
                TPoint p = step.getDefaultPoint();
                p.showCoordinates(this);
                this.setSelectedPoint(p);
            }
            return;
        }
        if (e.getKeyCode() == 127) {
            if (this.selectedPoint != null && this.selectingPanelID == this.panelID) {
                this.deletePoint(this.selectedPoint);
            } else {
                this.deleteSelectedSteps();
            }
            return;
        }
        double delta = e.isShiftDown() ? 10 : 1;
        double dx = 0.0;
        double dy = 0.0;
        switch (e.getKeyCode()) {
            case 38: {
                dy = -delta;
                break;
            }
            case 40: {
                dy = delta;
                break;
            }
            case 39: {
                dx = delta;
                break;
            }
            case 37: {
                dx = -delta;
            }
        }
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        this.selectedSteps.setChanged(true);
        for (Step step : this.selectedSteps) {
            TPoint point = step.points[0];
            if (point == this.selectedPoint) continue;
            Point p = point.getScreenPosition(this);
            p.setLocation((double)p.x + dx, (double)p.y + dy);
            point.setScreenPosition(p.x, p.y, this, e);
        }
        if (this.selectedPoint != null) {
            Point p = this.selectedPoint.getScreenPosition(this);
            p.setLocation((double)p.x + dx, (double)p.y + dy);
            this.selectedPoint.setScreenPosition(p.x, p.y, this, e);
        }
        if (this.selectedPoint != null) {
            this.selectedPoint.showCoordinates(this);
        } else {
            this.setMessage("", 0);
        }
        if (this.selectedStep == null) {
            TFrame.repaintT(this);
        }
    }

    public Set<String> getEnabled() {
        return this.enabled == null ? (this.enabled = new TreeSet<String>()) : this.enabled;
    }

    public void setEnabled(Set<String> enable) {
        if (enable != null) {
            this.enabled = this.getEnabled();
            this.enabled.clear();
            this.enabled.addAll(enable);
            ++this.enabledCount;
        }
    }

    public boolean isEnabled(String key) {
        if (key == null) {
            return false;
        }
        return this.getEnabled().contains(key);
    }

    public void setEnabled(String key, boolean enable) {
        if (key == null) {
            return;
        }
        if (enable) {
            this.getEnabled().add(key);
        } else {
            this.getEnabled().remove(key);
        }
    }

    public boolean isCreateTracksEnabled() {
        return this.isEnabled("new.pointMass") || this.isEnabled("new.cm") || this.isEnabled("new.vector") || this.isEnabled("new.vectorSum") || this.isEnabled("new.lineProfile") || this.isEnabled("new.RGBRegion") || this.isEnabled("new.tapeMeasure") || this.isEnabled("new.protractor") || this.isEnabled("new.circleFitter") || this.isEnabled("new.analyticParticle") || this.isEnabled("new.dynamicParticle") || this.isEnabled("new.dynamicTwoBody") || this.isEnabled("new.dataTrack");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean doSnap = false;
        boolean isAdjusting = false;
        String name = e.getPropertyName();
        if (Tracker.timeLogEnabled) {
            Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " property change " + name);
        }
        block43 : switch (name) {
            case "size": {
                super.propertyChange(e);
                this.getTFrame().holdPainting(false);
                this.notifyLoadingComplete();
                break;
            }
            case "asyncVideoReady": {
                if (this.loader == null || ((Loader)this.loader).clip.getVideo() != e.getSource()) {
                    return;
                }
                super.propertyChange(e);
                this.getTFrame().holdPainting(false);
                this.notifyLoadingComplete();
                break;
            }
            case "step": 
            case "steps": {
                TPoint p;
                TTrack track = (TTrack)e.getSource();
                if (e.getOldValue() != TTrack.HINT_STEPS_SELECTED) {
                    track.invalidateData(Boolean.FALSE);
                }
                if (!track.isDependent()) {
                    this.changed = true;
                }
                if (track == this.getSelectedTrack() && (p = this.getSelectedPoint()) != null) {
                    p.showCoordinates(this);
                }
                TFrame.repaintT(this);
                if (name != "steps") break;
                this.refreshTrackBar();
                break;
            }
            case "mass": {
                this.firePropertyChange("mass", null, null);
                break;
            }
            case "name": {
                this.refreshNotesDialog();
                break;
            }
            case "footprint": {
                Footprint footprint = (Footprint)e.getNewValue();
                if (!(footprint instanceof ArrowFootprint)) break;
                this.firePropertyChange("mass", null, null);
                break;
            }
            case "videoclip": {
                ImageCoordSystem oldCoords = this.coords;
                this.coords.removePropertyChangeListener(this);
                super.propertyChange(e);
                this.coords.addPropertyChangeListener(this);
                this.firePropertyChange("coords", oldCoords, this.coords);
                this.firePropertyChange(PROPERTY_TRACKERPANEL_VIDEO, null, null);
                TMat mat = this.getMat();
                if (mat != null) {
                    mat.invalidate();
                }
                if (this.video != null) {
                    this.video.setProperty("measure", null);
                    if (this.video instanceof SmoothPlayable) {
                        ((SmoothPlayable)((Object)this.video)).setSmoothPlay(!Tracker.isXuggleFast);
                    }
                }
                doSnap = true;
                this.changed = true;
                break;
            }
            case "stepnumber": {
                this.setSelectedPoint(null);
                this.selectedSteps.clear();
                if (this.getVideo() != null && !this.getVideo().getFilterStack().isEmpty()) {
                    ArrayList<Filter> filters = this.getVideo().getFilterStack().getFilters();
                    int i = 0;
                    int n = filters.size();
                    while (i < n) {
                        Filter next = filters.get(i);
                        if (next instanceof SumFilter) {
                            ((SumFilter)next).addNextImage();
                        }
                        ++i;
                    }
                }
                TFrame.repaintT(this);
                VideoGrabber grabber = VideoGrabber.VIDEO_CAPTURE_TOOL;
                if (grabber != null && ((VideoCaptureTool)grabber).isVisible() && ((VideoCaptureTool)grabber).isRecording()) {
                    EventQueue.invokeLater(() -> VideoGrabber.getTool().addFrame(this.getMattedImage()));
                }
                boolean invertCursor = this.isShiftKeyDown;
                this.setCursorForMarking(invertCursor, null);
                this.firePropertyChange(PROPERTY_TRACKERPANEL_STEPNUMBER, null, e.getNewValue());
                doSnap = true;
                break;
            }
            case "coords": {
                this.coords.removePropertyChangeListener(this);
                this.coords = (ImageCoordSystem)e.getNewValue();
                this.coords.addPropertyChangeListener(this);
                this.firePropertyChange("coords", null, this.coords);
                this.firePropertyChange("transform", null, null);
                doSnap = true;
                break;
            }
            case "image": {
                this.firePropertyChange(PROPERTY_TRACKERPANEL_IMAGE, null, null);
                TMenuBar mbar = this.getMenuBar(false);
                if (mbar != null) {
                    mbar.checkMatSize();
                }
                TFrame.repaintT(this);
                this.changed = true;
                break;
            }
            case "filterChanged": {
                Filter filter = (Filter)e.getNewValue();
                String prevState = (String)e.getOldValue();
                XMLControlElement control = new XMLControlElement(prevState);
                Undo.postFilterEdit(this, filter, control);
                break;
            }
            case "videoVisible": {
                this.firePropertyChange(PROPERTY_TRACKERPANEL_VIDEOVISIBLE, null, null);
                break;
            }
            case "transform": {
                this.changed = true;
                doSnap = true;
                ArrayList<TTrack> tracks = this.getUserTracks();
                int i = 0;
                while (true) {
                    if (i >= tracks.size()) {
                        this.firePropertyChange("transform", null, null);
                        break block43;
                    }
                    tracks.get((int)i).dataValid = false;
                    ++i;
                }
            }
            case "locked": {
                this.firePropertyChange("locked", null, null);
                break;
            }
            case "playing": {
                if (((Boolean)e.getNewValue()).booleanValue()) break;
                ArrayList<ParticleModel> list = this.getDrawablesTemp(ParticleModel.class);
                int m = 0;
                int n = list.size();
                while (true) {
                    if (m >= n) {
                        list.clear();
                        break block43;
                    }
                    list.get(m).refreshDerivsIfNeeded();
                    ++m;
                }
            }
            case "adjusting": {
                isAdjusting = true;
            }
            case "starttime": 
            case "startframe": 
            case "frameduration": 
            case "stepcount": 
            case "stepsize": {
                this.changed = true;
                if (this.modelBuilder != null) {
                    this.modelBuilder.refreshSpinners();
                }
                if (this.getMat() != null) {
                    this.getMat().invalidate();
                }
                if (this.getVideo() != null) {
                    this.getVideo().setProperty("measure", null);
                }
                this.firePropertyChange("data", e.getOldValue(), isAdjusting ? e.getNewValue() : null);
                this.firePropertyChange(name, e.getSource(), name == "adjusting" ? e.getNewValue() : null);
                if (this.getSelectedPoint() != null) {
                    this.getSelectedPoint().showCoordinates(this);
                    TFrame frame = this.getTFrame();
                    if (frame != null) {
                        this.refreshTrackBar();
                    }
                }
                ArrayList<TTrack> list = this.getUserTracks();
                int it = 0;
                int ni = list.size();
                while (true) {
                    if (it >= ni) {
                        TFrame.repaintT(this);
                        break block43;
                    }
                    list.get(it).erase(this.panelID);
                    ++it;
                }
            }
            case "framecount": {
                if (this.getVideo() != null || this.modelBuilder == null) break;
                this.modelBuilder.refreshSpinners();
                break;
            }
            case "description": 
            case "function": {
                this.changed = true;
                this.firePropertyChange("function", null, e.getNewValue());
                break;
            }
            case "panel": {
                TTrack track;
                if (e.getSource() != this.modelBuilder) break;
                FunctionPanel panel = (FunctionPanel)e.getNewValue();
                if (panel != null && (track = this.getTrack(panel.getName())) != null) {
                    ParticleModel model = (ParticleModel)track;
                    this.modelBuilder.setSpinnerStartFrame(model.getStartFrame());
                    int end = model.getEndFrame();
                    if (end == Integer.MAX_VALUE) {
                        end = this.getPlayer().getVideoClip().getLastFrameNumber();
                    }
                    this.modelBuilder.setSpinnerEndFrame(end);
                }
                this.modelBuilder.refreshSpinners();
                String title = TrackerRes.getString("TrackerPanel.ModelBuilder.Title");
                panel = this.modelBuilder.getSelectedPanel();
                if (panel != null && (track = this.getTrack(panel.getName())) != null) {
                    String type = track.getClass().getSimpleName();
                    title = String.valueOf(title) + ": " + TrackerRes.getString(String.valueOf(type) + ".Builder.Title");
                }
                this.modelBuilder.setTitle(title);
                break;
            }
            case "model_start": {
                ParticleModel model = (ParticleModel)e.getSource();
                if (!model.getName().equals(this.getModelBuilder().getSelectedName())) break;
                this.modelBuilder.setSpinnerStartFrame(e.getNewValue());
                break;
            }
            case "model_end": {
                ParticleModel model = (ParticleModel)e.getSource();
                if (!model.getName().equals(this.getModelBuilder().getSelectedName())) break;
                int end = (Integer)e.getNewValue();
                if (end == Integer.MAX_VALUE) {
                    end = this.getPlayer().getVideoClip().getLastFrameNumber();
                }
                this.modelBuilder.setSpinnerEndFrame(end);
                break;
            }
            case "format": {
                this.firePropertyChange("format", null, null);
                break;
            }
            case "radian_angles": {
                this.firePropertyChange("radian_angles", null, e.getNewValue());
                break;
            }
            case "fixed_origin": 
            case "fixed_angle": 
            case "fixed_scale": {
                this.changed = true;
                this.firePropertyChange(name, e.getOldValue(), e.getNewValue());
                break;
            }
            case "ft_visible": {
                if (e.getSource() != this.dataBuilder) break;
                this.dataToolVisible = (Boolean)e.getNewValue();
                break;
            }
            case "filter_visible": {
                this.setSelectedPoint(null);
                this.selectedSteps.clear();
                break;
            }
            case "perspective": {
                PerspectiveFilter filt1;
                PerspectiveTrack trk;
                if (e.getNewValue() != null) {
                    PerspectiveFilter filt = (PerspectiveFilter)e.getNewValue();
                    PerspectiveTrack track = new PerspectiveTrack(filt);
                    this.addTrack(track);
                    break;
                }
                if (e.getOldValue() == null || (trk = PerspectiveTrack.filterMap.get(filt1 = (PerspectiveFilter)e.getOldValue())) == null) break;
                this.removeTrack(trk);
                trk.dispose();
                filt1.setVideoPanel(null);
                break;
            }
            case "backbutton": 
            case "stepbutton": 
            case "slider": 
            case "outframe": 
            case "inframe": {
                if (!Tracker.showHints) break;
                Tracker.startupHintShown = false;
                String msg = "";
                if (e.getNewValue() == Boolean.TRUE) {
                    switch (name) {
                        case "stepbutton": {
                            msg = TrackerRes.getString("VideoPlayer.Step.Hint");
                            break;
                        }
                        case "backbutton": {
                            msg = TrackerRes.getString("VideoPlayer.Back.Hint");
                            break;
                        }
                        case "slider": {
                            msg = TrackerRes.getString("VideoPlayer.Slider.Hint");
                            break;
                        }
                        case "inframe": {
                            msg = TrackerRes.getString("VideoPlayer.StartFrame.Hint");
                            break;
                        }
                        case "outframe": {
                            msg = TrackerRes.getString("VideoPlayer.EndFrame.Hint");
                            break;
                        }
                    }
                }
                this.setMessage(msg);
                break;
            }
        }
        if (doSnap) {
            int n = this.getFrameNumber();
            this.getSnapPoint().setXY(this.coords.getOriginX(n), this.coords.getOriginY(n));
        }
        if (Tracker.timeLogEnabled) {
            Tracker.logTime("end TrackerPanel property change " + name);
        }
    }

    @Override
    public void setImageBorder(double borderFraction) {
        super.setImageBorder(borderFraction);
        this.defaultImageBorder = this.getImageBorder();
    }

    @Override
    public String getFilePath() {
        if (this.defaultSavePath == null) {
            return super.getFilePath();
        }
        return this.defaultSavePath;
    }

    @Override
    public void scale() {
        Rectangle mat = this.getMatBounds();
        if (mat != null) {
            this.xOffset = mat.x;
            this.yOffset = mat.y;
        }
        super.scale();
        if (!this.pixelTransform.equals(this.prevPixelTransform)) {
            if (this.prevPixelTransform == null) {
                this.prevPixelTransform = new AffineTransform();
            }
            this.getPixelTransform(this.prevPixelTransform);
            this.eraseAll();
        }
        if (this.trackControl == null && this.getTFrame() != null) {
            this.trackControl = TrackControl.getControl(this);
        }
    }

    @Override
    public void setMouseCursor(Cursor cursor) {
        if (PencilDrawer.isDrawing(this) && cursor == Cursor.getPredefinedCursor(12)) {
            return;
        }
        if (cursor != Cursor.getPredefinedCursor(1) && !Tracker.isZoomInCursor(cursor) && !Tracker.isZoomOutCursor(cursor)) {
            super.setMouseCursor(cursor);
        }
    }

    @Override
    public void setFontLevel(int level) {
        Video video2;
        super.setFontLevel(level);
        if (this.getTFrame() == null) {
            return;
        }
        List<TView> views = this.frame.getTViews(this.panelID, -1, null);
        int i = views.size();
        while (--i >= 0) {
            views.get(i).refresh();
        }
        TMenuBar menubar = this.getMenuBar(false);
        FontSizer.setFonts(menubar, level);
        this.getTrackBar(true).setFontLevel(level);
        this.refreshTrackBar();
        ArrayList<TTrack> list = this.getTracksTemp();
        int it = 0;
        int n = list.size();
        while (it < n) {
            list.get(it).setFontLevel(level);
            ++it;
        }
        TrackControl.getControl(this).refresh();
        if (this.modelBuilder != null) {
            this.modelBuilder.setFontLevel(level);
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(level);
        }
        if (this.autoTracker != null) {
            this.autoTracker.getWizard().setFontLevel(level);
        }
        if (this.attachmentDialog != null) {
            this.attachmentDialog.setFontLevel(level);
        }
        PencilDrawer drawer = PencilDrawer.getDrawer(this);
        if (drawer.drawingControl != null && drawer.drawingControl.isVisible()) {
            drawer.drawingControl.setFontLevel(level);
        }
        if ((video2 = this.getVideo()) != null) {
            ArrayList<Filter> filters = video2.getFilterStack().getFilters();
            int i2 = 0;
            int n2 = filters.size();
            while (i2 < n2) {
                Filter filter = filters.get(i2);
                JDialog inspector = filter.getInspector();
                if (inspector != null) {
                    FontSizer.setFonts(inspector, level);
                    if (filter instanceof BaselineFilter) {
                        BaselineFilter bf = (BaselineFilter)filter;
                        bf.resizeThumbnail();
                    } else {
                        inspector.pack();
                    }
                }
                ++i2;
            }
        }
        if (this.algorithmDialog != null) {
            this.algorithmDialog.setFontLevel(level);
        }
    }

    @Override
    public boolean isZoomEvent(MouseEvent e) {
        return super.isZoomEvent(e) || Tracker.isZoomInCursor(this.getCursor());
    }

    @Override
    public Interactive getInteractive() {
        boolean isMarking;
        TTrack track = this.getSelectedTrack();
        boolean bl = isMarking = track != null && this.cursorType == track.getMarkingCursorType(this.mouseEvent);
        if (isMarking) {
            return null;
        }
        if (track != null) {
            Interactive o = null;
            if (track != this.getAxes() && !this.calibrationTools.contains(track) && (o = track.findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY())) != null) {
                return o;
            }
            if ((track.isDependent() || track == this.getAxes()) && (o = this.getAxes().findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY())) != null) {
                return o;
            }
        }
        return super.getInteractive();
    }

    @Override
    public XYCoordinateStringBuilder getXYCoordinateStringBuilder(TPoint point) {
        return this.coordStringBuilder;
    }

    protected BufferedImage getMattedImage() {
        if (this.renderedImage == null || this.renderedImage.getWidth() != this.getWidth() || this.renderedImage.getHeight() != this.getHeight()) {
            this.renderedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        this.render(this.renderedImage);
        Rectangle2D rect = this.getMat().getDrawingBounds();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        if (this.mattedImage == null || this.mattedImage.getWidth() != w || this.mattedImage.getHeight() != h) {
            this.mattedImage = new BufferedImage(w, h, 1);
        }
        Graphics g = this.mattedImage.getGraphics();
        g.drawImage(this.renderedImage, (int)(-rect.getX()), (int)(-rect.getY()), null);
        return this.mattedImage;
    }

    protected void deletePoint(TPoint pt) {
        ArrayList<TTrack> list = this.getTracks();
        int it = 0;
        int n = list.size();
        while (it < n) {
            TTrack track = list.get(it);
            Step step = track.getStep(pt, this);
            if (step != null) {
                step = track.deleteStep(step.n);
                if (step == null) {
                    return;
                }
                this.setSelectedPoint(null);
                this.selectedSteps.clear();
                this.hideMouseBox();
                return;
            }
            ++it;
        }
    }

    protected void deleteSelectedSteps() {
        ArrayList<Object[]> changes = new ArrayList<Object[]>();
        int nMin = Integer.MAX_VALUE;
        int nMax = -1;
        ArrayList<TTrack> list = this.getTracks();
        int it = 0;
        int ni = list.size();
        while (it < ni) {
            TTrack track = list.get(it);
            boolean isChanged = false;
            XMLControlElement control = new XMLControlElement(track);
            for (Step step : this.selectedSteps) {
                if (step.getTrack() != track) continue;
                if (track.isLocked()) {
                    step.erase();
                    continue;
                }
                int n = step.getFrameNumber();
                track.steps.setStep(n, null);
                for (String columnName : track.textColumnNames) {
                    String[] entries = track.textColumnEntries.get(columnName);
                    if (entries.length <= n) continue;
                    entries[n] = null;
                }
                AutoTracker autoTracker = this.getAutoTracker(false);
                if (autoTracker != null && autoTracker.getTrack() == track) {
                    autoTracker.delete(n);
                }
                nMin = Math.min(nMin, n);
                nMax = Math.max(nMax, n);
                isChanged = true;
            }
            if (isChanged) {
                changes.add(new Object[]{track, control});
                if (track.ttype == 5) {
                    VideoClip clip = this.getPlayer().getVideoClip();
                    int startFrame = Math.max(nMin - 2 * clip.getStepSize(), clip.getStartFrameNumber());
                    int stepCount = 4 + (nMax - nMin) / clip.getStepSize();
                    ((PointMass)track).updateDerivatives(startFrame, stepCount);
                }
                track.fireStepsChanged();
            }
            ++it;
        }
        this.selectedSteps.clear();
        if (!changes.isEmpty()) {
            Undo.postMultiTrackEdit(changes);
        }
    }

    @Override
    protected void scale(ArrayList<Drawable> drawables) {
        if (this.drawingInImageSpace) {
            if (this.getPreferredSize().width < 2) {
                super.setImageBorder(this.defaultImageBorder);
            } else {
                double w = this.getMagnification() * this.imageWidth;
                double wBorder = ((double)this.getWidth() - w) * 0.5 / w;
                double h = this.getMagnification() * this.imageHeight;
                double hBorder = ((double)this.getHeight() - h) * 0.5 / h;
                double border = Math.min(wBorder, hBorder);
                super.setImageBorder(Math.max(border, this.defaultImageBorder));
            }
        }
        super.scale(drawables);
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean justScroll;
        if (!this.isPaintable()) {
            return;
        }
        boolean bl = justScroll = this.zoomCenter != null && this.isShowing() && this.getTFrame() != null && (this.scrollPane.getVerticalScrollBar().isVisible() || this.scrollPane.getHorizontalScrollBar().isVisible());
        if (justScroll) {
            Rectangle rect = this.scrollPane.getViewport().getViewRect();
            int x = this.zoomCenter.x - rect.width / 2;
            int y = this.zoomCenter.y - rect.height / 2;
            rect.setLocation(x, y);
            this.zoomCenter = null;
            this.scrollRectToVisible(rect);
            return;
        }
        super.paintComponent(g);
        this.showFilterInspectors();
    }

    protected static double getDefaultImageWidth() {
        return 640.0;
    }

    protected static double getDefaultImageHeight() {
        return 480.0;
    }

    public TFrame getTFrame() {
        Container c;
        if (this.frame == null && (c = this.getTopLevelAncestor()) instanceof TFrame) {
            this.frame = (TFrame)c;
        }
        return this.frame;
    }

    protected AutoTracker getAutoTracker(boolean forceNew) {
        if (this.autoTracker == null && forceNew) {
            this.autoTracker = new AutoTracker(this);
            AutoTracker.Wizard wizard = this.autoTracker.getWizard();
            FontSizer.setFonts(wizard);
        }
        return this.autoTracker;
    }

    protected TreeMap<String, String> getFormatPatterns(int ttype) {
        TreeMap<String, String> patterns = this.formatPatterns[ttype];
        if (patterns == null) {
            patterns = new TreeMap();
            this.formatPatterns[ttype] = patterns;
            TreeMap<String, String> defaultPatterns = TTrack.getDefaultFormatPatterns(ttype);
            if (defaultPatterns != null) {
                patterns.putAll(defaultPatterns);
            }
            ArrayList<String> vars = TTrack.getAllVariables(ttype);
            int i = 0;
            int n = vars.size();
            while (i < n) {
                String v = vars.get(i);
                if (!patterns.containsKey(v)) {
                    patterns.put(v, "");
                }
                ++i;
            }
        }
        return patterns;
    }

    protected void setInitialFormatPatterns() {
        ArrayList<TTrack> list = this.getTracksTemp();
        int it = 0;
        int n = list.size();
        while (it < n) {
            list.get(it).setInitialFormatPatterns(this);
            ++it;
        }
        list.clear();
    }

    @Override
    public void dispose() {
        ClipInspector ci;
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.frame != null) {
            this.removePropertyChangeListener("datafile", this.frame);
            this.removePropertyChangeListener(PROPERTY_TRACKERPANEL_VIDEO, this.frame);
        }
        if (this.coords != null) {
            this.coords.removePropertyChangeListener(this);
        }
        this.selectedPoint = null;
        this.selectedStep = null;
        this.selectedTrack = null;
        if (this.mouseHandler != null) {
            this.mouseHandler.selectedTrack = null;
            this.mouseHandler.selectedPoint = null;
            this.mouseHandler.iad = null;
        }
        this.clearFilters();
        this.setTransferHandler(null);
        this.setScrollPane(null);
        ArrayList<TTrack> tracks = this.getTracks();
        this.clear(false);
        for (TTrack track : tracks) {
            track.dispose();
        }
        VideoPlayer player = this.getPlayer();
        ClipInspector clipInspector = ci = player == null ? null : player.getVideoClip().getClipInspector();
        if (ci != null) {
            ci.dispose();
        }
        if (this.video != null) {
            this.video.dispose();
            this.video = null;
        }
        this.coordinateStrBuilder = null;
        if (this.selectedSteps != null) {
            this.selectedSteps.dispose();
        }
        this.selectedSteps = null;
        this.offscreenImage = null;
        this.workingImage = null;
        if (player != null) {
            VideoClip clip = player.getVideoClip();
            clip.removePropertyChangeListener(player);
            clip.removeListener(this);
            ClipControl clipControl = player.getClipControl();
            clipControl.removePropertyChangeListener(player);
            player.removeActionListener(this);
            player.removeFrameListener(this);
            player.stop();
            this.remove(player);
            player.dispose();
            player = null;
        }
        if (this.video != null) {
            this.video.removeListener(this);
        }
        for (TTrack track : TTrack.getValues()) {
            this.removePropertyChangeListener(track);
            track.removeListener(this);
        }
        if (this.autoTracker != null) {
            this.autoTracker.dispose();
            this.autoTracker = null;
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.removePropertyChangeListener("panel", this);
            this.modelBuilder.dispose();
            this.modelBuilder = null;
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.removePropertyChangeListener("panel", this);
            this.dataBuilder.removePropertyChangeListener("function", this);
            this.dataBuilder.removePropertyChangeListener("description", this);
            this.dataBuilder.removePropertyChangeListener("ft_visible", this);
            this.dataBuilder.dispose();
            this.dataBuilder = null;
        }
        if (this.attachmentDialog != null) {
            this.attachmentDialog.dispose();
            this.attachmentDialog = null;
        }
        if (this.algorithmDialog != null) {
            this.algorithmDialog.dispose();
            this.algorithmDialog = null;
        }
        if (this.guestsDialog != null) {
            this.guestsDialog.dispose();
            this.guestsDialog = null;
        }
        PencilDrawer.dispose(this);
        if (TFrame.haveExportDialog && ExportDataDialog.dataExporter != null && ExportDataDialog.dataExporter.panelID == this.panelID) {
            ExportDataDialog.dataExporter.clear();
        }
        if (TFrame.haveExportDialog && ExportVideoDialog.videoExporter != null && ExportVideoDialog.videoExporter.panelID == this.panelID) {
            ExportVideoDialog.videoExporter.clear();
        }
        if (TFrame.haveExportDialog) {
            ExportZipDialog.clear(this);
        }
        if (this.numberFormatDialog != null) {
            this.numberFormatDialog.dispose();
            this.numberFormatDialog = null;
        }
        this.filterClasses.clear();
        this.selectingPanelID = null;
        this.frame = null;
        this.renderedImage = null;
        this.mattedImage = null;
        if (this.frame != null) {
            this.frame.disposeOf(this);
        }
        this.frame = null;
        this.removeAll();
        ArrayList<TTrack> list = this.getDrawables(TTrack.class);
        int it = 0;
        int n = list.size();
        while (it < n) {
            TTrack track = list.get(it);
            track.dispose();
            ++it;
        }
        super.dispose();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    protected void setTrackName(TTrack track, String newName, boolean postEdit) {
        ArrayList<Drawable> drawables = this.getDrawablesNoClone();
        int i = 0;
        int n = drawables.size();
        while (i < n) {
            String nextName;
            Drawable next = drawables.get(i);
            if (next != track && next instanceof TTrack && newName.equals(nextName = ((TTrack)next).getName())) {
                Toolkit.getDefaultToolkit().beep();
                String s = "\"" + newName + "\" ";
                this.badNameLabel.setText(String.valueOf(s) + TrackerRes.getString("TTrack.Dialog.Name.BadName"));
                TTrack.NameDialog nameDialog = track.getNameDialog();
                nameDialog.getContentPane().add((Component)this.badNameLabel, "South");
                nameDialog.pack();
                nameDialog.setVisible(true);
                return;
            }
            ++i;
        }
        XMLControlElement control = new XMLControlElement(new TrackProperties(track));
        track.setName(newName);
        if (postEdit) {
            Undo.postTrackDisplayEdit(track, control);
        }
        if (TTrack.nameDialog != null) {
            TTrack.nameDialog.setVisible(false);
            TTrack.nameDialog.getContentPane().remove(this.badNameLabel);
        }
        if (this.frame != null) {
            this.frame.refreshMenus(this, "TrackerPanel.setTrackName");
        }
    }

    protected void showFilterInspectors() {
        if (this.visibleFilters != null && this.visibleFilters.size() > 0) {
            TFrame frame = this.getTFrame();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            for (Filter filter : this.visibleFilters.keySet()) {
                Point p = this.visibleFilters.get(filter);
                JDialog inspector = filter.getInspector();
                inspector.setVisible(true);
                int x = Math.max(p.x + (frame == null ? 0 : frame.getLocation().x), 0);
                x = Math.min(x, dim.width - inspector.getWidth());
                int y = Math.max(p.y + (frame == null ? 0 : frame.getLocation().y), 0);
                y = Math.min(y, dim.height - inspector.getHeight());
                inspector.setLocation(x, y);
            }
            this.visibleFilters.clear();
            this.visibleFilters = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public boolean isAutoRefresh() {
        return this.isAutoRefresh && Tracker.allowDataRefresh;
    }

    public void setAutoRefresh(boolean b) {
        if (Tracker.allowDataRefresh) {
            this.isAutoRefresh = b;
        }
    }

    public JPopupMenu updateMainPopup() {
        JPopupMenu popup = this.getPopup();
        try {
            Interactive iad = this.getInteractive();
            if (iad instanceof TPoint) {
                TPoint p = (TPoint)iad;
                TTrack track = null;
                Step step = null;
                for (TTrack t : this.getTracksTemp()) {
                    step = t.getStep(p, this);
                    if (step == null) continue;
                    track = t;
                    break;
                }
                this.clearTemp();
                if (step != null) {
                    Step prev = this.selectedStep;
                    this.selectedStep = step;
                    if (track instanceof ParticleDataTrack) {
                        popup = ((ParticleDataTrack)track).getPointMenu(this).getPopupMenu();
                    } else if (track != null) {
                        popup = track.getMenu(this, new JMenu()).getPopupMenu();
                    }
                    this.selectedStep = prev;
                    this.getZoomBox().setVisible(false);
                    JPopupMenu jPopupMenu = popup;
                    return jPopupMenu;
                }
            } else if (iad instanceof TTrack) {
                TTrack track = (TTrack)iad;
                switch (track.ttype) {
                    case 8: {
                        popup = ((TapeMeasure)track).getInputFieldPopup();
                        break;
                    }
                    case 6: {
                        popup = ((Protractor)track).getInputFieldPopup();
                        break;
                    }
                    default: {
                        popup = track.getMenu(this, null).getPopupMenu();
                    }
                }
                this.getZoomBox().setVisible(false);
                JPopupMenu jPopupMenu = popup;
                return jPopupMenu;
            }
            popup.removeAll();
            JMenuItem item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ZoomIn"));
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackerPanel.this.getTFrame().getMainView(TrackerPanel.this).zoomIn(false);
                }
            });
            item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ZoomOut"));
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackerPanel.this.getTFrame().getMainView(TrackerPanel.this).zoomOut(false);
                }
            });
            item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ZoomToFit"));
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackerPanel.this.setMagnification(-1.0);
                }
            });
            DrawingPanel.ZoomBox zoomBox = this.getZoomBox();
            if (zoomBox.isDragged() && this.isStepsInZoomBox()) {
                popup.addSeparator();
                item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.Select"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackerPanel.this.handleStepsInZoomBox(true);
                    }
                });
                popup.add(item);
                item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.Deselect"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackerPanel.this.handleStepsInZoomBox(false);
                    }
                });
                popup.add(item);
            }
            if (this.isEnabled("button.clipSettings")) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                item = new JMenuItem(String.valueOf(MediaRes.getString("ClipInspector.Title")) + "...");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TFrame frame;
                        ClipControl clipControl;
                        VideoClip clip = TrackerPanel.this.getPlayer().getVideoClip();
                        ClipInspector inspector = clip.getClipInspector(clipControl = TrackerPanel.this.getPlayer().getClipControl(), frame = TrackerPanel.this.getTFrame());
                        if (inspector.isVisible()) {
                            return;
                        }
                        FontSizer.setFonts(inspector, FontSizer.getLevel());
                        inspector.pack();
                        Point p0 = new JFrame().getLocation();
                        Point loc = inspector.getLocation();
                        if (loc.x == p0.x && loc.y == p0.y) {
                            Rectangle rect = TrackerPanel.this.getVisibleRect();
                            Point p = frame.getMainView((TrackerPanel)TrackerPanel.this).scrollPane.getLocationOnScreen();
                            int x = p.x + (rect.width - inspector.getBounds().width) / 2;
                            int y = p.y + (rect.height - inspector.getBounds().height) / 2;
                            inspector.setLocation(x, y);
                        }
                        inspector.initialize();
                        inspector.setVisible(true);
                        TrackerPanel.this.getTFrame().getMainView(TrackerPanel.this).refresh();
                    }
                });
                popup.add(item);
            }
            if (this.isEnabled("edit.copyImage")) {
                popup.addSeparator();
                AbstractAction copyImageAction = new AbstractAction(TrackerRes.getString("TMenuBar.Menu.CopyImage")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BufferedImage image = new TrackerIO.ComponentImage(TrackerPanel.this).getImage();
                        DrawingPanel.ZoomBox zoomBox = TrackerPanel.this.getZoomBox();
                        if (zoomBox.isDragged()) {
                            Rectangle zRect = zoomBox.reportZoom();
                            BufferedImage image2 = new BufferedImage(zRect.width, zRect.height, image.getType());
                            Graphics2D g = image2.createGraphics();
                            g.drawImage((Image)image, -zRect.x, -zRect.y, null);
                            TrackerIO.copyImage(image2);
                        } else {
                            TrackerIO.copyImage(image);
                        }
                    }
                };
                JMenuItem copyImageItem = new JMenuItem(copyImageAction);
                popup.add(copyImageItem);
                AbstractAction snapshotAction = new AbstractAction(DisplayRes.getString("DisplayPanel.Snapshot_menu_item")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackerPanel.this.snapshot();
                    }
                };
                JMenuItem snapshotItem = new JMenuItem(snapshotAction);
                popup.add(snapshotItem);
            }
            TMenuBar.refreshPopup(this, "MainTView.popup", popup);
            JMenuItem propertiesItem = new JMenuItem(this.actions.get("aboutVideo"));
            popup.addSeparator();
            propertiesItem.setText(TrackerRes.getString("TActions.AboutVideo"));
            popup.add(propertiesItem);
            if (this.isEnabled("file.print")) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(this.actions.get("print"));
            }
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            JMenuItem helpItem = new JMenuItem(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
            helpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TFrame frame = TrackerPanel.this.getTFrame();
                    if (frame != null) {
                        frame.showHelp("GUI", 0);
                    }
                }
            });
            popup.add(helpItem);
            JPopupMenu jPopupMenu = popup;
            return jPopupMenu;
        }
        finally {
            FontSizer.setFonts(popup, FontSizer.getLevel());
        }
    }

    private void handleStepsInZoomBox(boolean add) {
        DrawingPanel.ZoomBox zoomBox = this.getZoomBox();
        Rectangle zRect = zoomBox.reportZoom();
        ArrayList<TTrack> tracks = this.getTracks();
        HashSet<TTrack> changedTracks = new HashSet<TTrack>();
        for (TTrack track : tracks) {
            if (!track.isVisible() || track.getClass() != PointMass.class || !((PointMass)track).isPositionVisible()) continue;
            Step[] stepArray = track.getSteps();
            int n = stepArray.length;
            int n2 = 0;
            while (n2 < n) {
                TPoint p;
                Step step = stepArray[n2];
                if (step != null && track.isStepVisible(step, this) && (p = step.getPoints()[0]) != null && !Double.isNaN(p.getX()) && zRect.contains(p.getScreenPosition(this))) {
                    changedTracks.add(track);
                    if (add) {
                        this.selectedSteps.add(step);
                    } else {
                        this.selectedSteps.remove(step);
                    }
                    step.erase();
                }
                ++n2;
            }
        }
        if (add && this.selectedSteps.size() == 1) {
            Step step = this.selectedSteps.toArray(new Step[1])[0];
            this.setSelectedPoint(step.points[0]);
        } else if (this.selectedSteps.size() > 1) {
            this.setSelectedPoint(null);
        }
        for (TTrack track : changedTracks) {
            track.fireStepsChanged();
        }
    }

    protected boolean isStepsInZoomBox() {
        DrawingPanel.ZoomBox zoomBox = this.getZoomBox();
        Rectangle zRect = zoomBox.reportZoom();
        ArrayList<TTrack> tracks = this.getTracks();
        for (TTrack track : tracks) {
            if (!track.isVisible() || track.getClass() != PointMass.class || !((PointMass)track).isPositionVisible()) continue;
            Step[] stepArray = track.getSteps();
            int n = stepArray.length;
            int n2 = 0;
            while (n2 < n) {
                TPoint p;
                Step step = stepArray[n2];
                if (step != null && (p = step.getPoints()[0]) != null && !Double.isNaN(p.getX()) && zRect.contains(p.getScreenPosition(this))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setVideoVisible(boolean visible) {
        if (this.video == null || visible == this.video.isVisible()) {
            return;
        }
        this.video.setVisible(visible);
        this.getPlayer().getClipControl().videoVisible = visible;
        this.setVideo(this.video);
    }

    public boolean isPaintable() {
        return this.getTopLevelAncestor() != null && this.isVisible() && this.getHeight() > 0 && !this.getIgnoreRepaint() && this.getTFrame() != null && this.frame.isPaintable() && !this.isClipAdjusting();
    }

    @Override
    public void repaint() {
        if (!this.isPaintable()) {
            return;
        }
        super.repaint();
    }

    @Override
    public void repaint(long time, int x, int y, int w, int h) {
        if (!this.isPaintable()) {
            return;
        }
        super.repaint(time, x, y, w, h);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public void notifyLoadingComplete() {
        this.setIgnoreRepaint(false);
        this.firePropertyChange(PROPERTY_TRACKERPANEL_LOADED, null, null);
    }

    public void taintEnabled() {
        ++this.enabledCount;
    }

    public int getEnabledCount() {
        return this.enabledCount;
    }

    public void clearTainted() {
        this.tainted = false;
        this.dirty = null;
    }

    public void doPaste(String data) {
        if (data != null && !this.pasteXML(data, false)) {
            this.importDataAsync(data, null, null);
        }
    }

    public void doAutoPaste(String dataString) throws Exception {
        if (dataString != null && !this.pasteXML(dataString, true)) {
            this.isAutoPaste = true;
            this.importDataAsync(dataString, null, null);
            this.isAutoPaste = false;
        }
    }

    public void initialize(FileDropHandler fileDropHandler) {
        if (fileDropHandler == null) {
            if (this.trackControlX != Integer.MIN_VALUE) {
                TrackControl tc = TrackControl.getControl(this);
                tc.wasVisible = true;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = Math.max(this.getTFrame().getLocation().x + this.trackControlX, 0);
                x = Math.min(x, dim.width - tc.getWidth());
                int y = Math.max(this.getTFrame().getLocation().y + this.trackControlY, 0);
                y = Math.min(y, dim.height - tc.getHeight());
                tc.setLocation(x, y);
                tc.positioned = true;
            }
            this.mouseHandler = new TMouseHandler();
            this.setInteractiveMouseHandler(this.mouseHandler);
            this.showFilterInspectors();
            this.setInitialFormatPatterns();
            return;
        }
        this.setTransferHandler(fileDropHandler);
        if (this.getMat() == null) {
            this.addDrawable(new TMat(this));
        }
        if (this.getAxes() == null) {
            CoordAxes axes = new CoordAxes();
            axes.setVisible(false);
            this.addTrack(axes);
        }
        this.addFilter(DeinterlaceFilter.class);
        this.addFilter(GhostFilter.class);
        this.addFilter(StrobeFilter.class);
        this.addFilter(DarkGhostFilter.class);
        this.addFilter(NegativeFilter.class);
        this.addFilter(GrayScaleFilter.class);
        this.addFilter(LogFilter.class);
        this.addFilter(BrightnessFilter.class);
        this.addFilter(BaselineFilter.class);
        this.addFilter(SumFilter.class);
        this.addFilter(ResizeFilter.class);
        this.addFilter(RotateFilter.class);
        this.addFilter(PerspectiveFilter.class);
        this.addFilter(RadialDistortionFilter.class);
    }

    public <T extends Drawable> ArrayList<T> getDrawablesTemp(Class<T> type) {
        if (this.tempA == null) {
            this.tempA = new ArrayList();
        }
        if (!this.tempA.isEmpty()) {
            this.tempA.clear();
        }
        return type == null ? null : this.getDrawables(type, true, null, this.tempA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TTrack> T getTrackByName(Class<T> type, String name) {
        ArrayList arrayList = this.drawableList;
        synchronized (arrayList) {
            int i = 0;
            int n = this.drawableList.size();
            while (i < n) {
                Drawable d = (Drawable)this.drawableList.get(i);
                if (type.isInstance(d) && name.equals(((TTrack)d).getName())) {
                    return (T)((TTrack)d);
                }
                ++i;
            }
            return null;
        }
    }

    public void clearTemp() {
        if (this.tempA != null) {
            this.tempA.clear();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (OSPRuntime.isJS) {
            OSPRuntime.setJSClipboardPasteListener(this, this.frame.getDataDropHandler());
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.unTracked()) {
            return;
        }
        this.getMat();
        super.paint(g);
    }

    public void cloneNamed(String name) {
        TTrack track = this.getTrack(name);
        if (track == null) {
            return;
        }
        int n = 1;
        try {
            String number = name.substring(name.length() - 1);
            n = Integer.parseInt(number) + 1;
            name = name.substring(0, name.length() - 1);
        }
        catch (Exception number) {
            // empty catch block
        }
        HashSet<String> names = new HashSet<String>();
        for (TTrack next : this.getTracksTemp()) {
            names.add(next.getName());
        }
        this.clearTemp();
        try {
            while (names.contains(String.valueOf(name) + n)) {
                ++n;
            }
        }
        catch (Exception next) {
            // empty catch block
        }
        XMLControlElement control = new XMLControlElement(track);
        control.setValue("name", String.valueOf(name) + n);
        this.pasteXML(control.toXML(), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean pasteXML(String data, boolean reloadOnly) {
        if (reloadOnly) {
            return false;
        }
        if (data.trim().startsWith("<object class=")) {
            data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + data;
        }
        try {
            XMLControlElement control = new XMLControlElement();
            control.readXML(data);
            Class<?> type = control.getObjectClass();
            if (type == null || control.failedToRead()) {
                return false;
            }
            if (TrackerPanel.class.isAssignableFrom(type)) {
                control.loadObject(this);
                return true;
            }
            if (ImageCoordSystem.class.isAssignableFrom(type)) {
                XMLControlElement state = new XMLControlElement(this.getCoords());
                control.loadObject(this.getCoords());
                Undo.postCoordsEdit(this, state);
                return true;
            }
            if (TTrack.class.isAssignableFrom(type)) {
                if (!reloadOnly) {
                    TTrack track = (TTrack)control.loadObject(null);
                    this.addTrack(track);
                    this.setSelectedTrack(track);
                    return true;
                }
                ArrayList<TTrack> tracks = this.getTracksTemp();
                int k = 0;
                while (k < tracks.size()) {
                    TTrack track = tracks.get(k);
                    if (track.getName().equals(control.getString("name"))) {
                        TrackChooserTView.ignoreRefresh = true;
                        control.loadObject(track);
                        track.erase();
                        TrackChooserTView.ignoreRefresh = false;
                        track.firePropertyChange("steps", TTrack.HINT_STEP_ADDED_OR_REMOVED, null);
                        return true;
                    }
                    ++k;
                }
            }
            if (!VideoClip.class.isAssignableFrom(type)) return false;
            VideoClip clip = (VideoClip)control.loadObject(null);
            VideoClip prev = this.getPlayer().getVideoClip();
            XMLControl state = Undo.getXMLControl(prev);
            state = new XMLControlElement(state.toXML());
            this.getPlayer().setVideoClip(clip);
            Undo.postVideoReplace(this, state);
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void checkAndClearTracks() {
        int i;
        ArrayList<String> xml = new ArrayList<String>();
        boolean locked = false;
        ArrayList<Drawable> keepers = this.getSystemDrawables();
        for (TTrack track : this.getTracksTemp()) {
            if (keepers.contains(track)) continue;
            xml.add(new XMLControlElement(track).toXML());
            boolean bl = locked = locked || track.isLocked() && !track.isDependent();
        }
        this.clearTemp();
        if (locked && (i = JOptionPane.showConfirmDialog(this, TrackerRes.getString("TActions.Dialog.DeleteLockedTracks.Message"), TrackerRes.getString("TActions.Dialog.DeleteLockedTracks.Title"), 0, 2)) != 0) {
            return;
        }
        Undo.postTrackClear(this, xml);
        this.clearTracks();
    }

    protected void reload() {
        File file = this.getDataFile();
        if (file == null) {
            return;
        }
        TrackChooserTView.ignoreRefresh = true;
        XMLControlElement control = new XMLControlElement(file);
        if (control.failedToRead()) {
            return;
        }
        List<XMLProperty> proplist = control.getPropsRaw();
        int i = 0;
        while (i < proplist.size()) {
            XMLProperty prop = proplist.get(i);
            if (prop.getPropertyName().equals("tracks")) {
                ArrayList<TTrack> tracks = this.getTracks();
                XMLControl[] trackcontrols = prop.getChildControls();
                int j = 0;
                while (j < trackcontrols.length) {
                    block12: {
                        XMLControl tcon = trackcontrols[j];
                        boolean found = false;
                        int k = 0;
                        while (k < tracks.size()) {
                            ParticleDataTrack pdt;
                            TTrack track = tracks.get(k);
                            String name = tcon.getString("name");
                            boolean match = track.getName().equals(name);
                            if (track.getClass().getSimpleName().equals("ParticleDataTrack") && (pdt = (ParticleDataTrack)track).getName().startsWith(name) && (pdt.getSource() == null || !pdt.getSource().getClass().getSimpleName().equals("ParticleDataTrack"))) {
                                match = true;
                            }
                            if (match) {
                                found = true;
                                tcon.loadObject(track);
                                track.erase();
                                track.firePropertyChange("steps", TTrack.HINT_STEP_ADDED_OR_REMOVED, null);
                                break block12;
                            }
                            ++k;
                        }
                        if (!found) {
                            TTrack track = (TTrack)tcon.loadObject(null);
                            this.addTrack(track);
                            TViewChooser[] choosers = this.frame.getViewChoosers(this);
                            int[] views = this.frame.getSelectedViewTypes(this);
                            int k2 = 0;
                            while (k2 < choosers.length) {
                                choosers[k2].setSelectedViewType(views[k2]);
                                ++k2;
                            }
                        }
                    }
                    ++j;
                }
            } else if (prop.getPropertyName().equals("coords")) {
                ImageCoordSystem coords = this.getCoords();
                XMLControl coordsControl = prop.getChildControls()[0];
                coordsControl.loadObject(coords);
            }
            ++i;
        }
        TrackChooserTView.ignoreRefresh = false;
        TFrame.repaintT(this);
    }

    public void openURLFromDialog() {
        String input = GUIUtils.showInputDialog(this.getTFrame(), String.valueOf(TrackerRes.getString("TActions.Dialog.OpenURL.Message")) + ":                             ", TrackerRes.getString("TActions.Dialog.OpenURL.Title"), -1, null);
        if (input == null || input.trim().equals("")) {
            return;
        }
        Resource res = ResourceLoader.getResource(input.toString().trim());
        if (res == null || res.getURL() == null) {
            JOptionPane.showMessageDialog(this.getTFrame(), String.valueOf(TrackerRes.getString("TActions.Dialog.URLResourceNotFound.Message")) + "\n\"" + input.toString().trim() + "\"", TrackerRes.getString("TActions.Dialog.URLResourceNotFound.Title"), 0);
            return;
        }
        this.setSelectedPoint(null);
        this.selectedSteps.clear();
        this.setMouseCursor(Cursor.getPredefinedCursor(3));
        TFrame frame = this.getTFrame();
        if (frame != null) {
            frame.removeEmptyTabIfTabCountGreaterThan(0);
            frame.doOpenURL(res.getURL().toExternalForm());
        }
    }

    public void toggleAxesVisible() {
        CoordAxes axes = this.getAxes();
        if (axes == null) {
            return;
        }
        boolean visible = !axes.isVisible();
        axes.setVisible(visible);
        this.setSelectedPoint(null);
        this.selectedSteps.clear();
        this.hideMouseBox();
        if (visible) {
            if (this.getSelectedTrack() == null) {
                this.setSelectedTrack(axes);
            }
        } else if (this.getSelectedTrack() == axes) {
            this.setSelectedTrack(null);
        }
    }

    public void addVideoFilter(String type) {
        Video video2 = this.getVideo();
        if (video2 == null) {
            return;
        }
        this.setVideoVisible(true);
        FilterStack filterStack = video2.getFilterStack();
        Filter filter = null;
        Map<String, Class<? extends Filter>> filterClasses = this.getFilters();
        Class<? extends Filter> filterClass = filterClasses.get(type);
        if (filterClass != null) {
            try {
                filter = filterClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (filter != null) {
                filterStack.addFilter(filter);
                filter.setVideoPanel(this);
                JDialog inspector = filter.getInspector();
                if (inspector != null) {
                    inspector.setVisible(true);
                }
            }
            TFrame.repaintT(this);
        }
    }

    @Override
    protected void offerReloadVM(String ext, String message) {
        int i = 0;
        while (i < TrackerIO.XUGGLE_VIDEO_EXTENSIONS.length) {
            if (TrackerIO.XUGGLE_VIDEO_EXTENSIONS[i].equals(ext)) {
                message = String.valueOf(message) + "<br><br>" + MediaRes.getString("VideoIO.Dialog.WrongVM.Message.Fix1");
                message = String.valueOf(message) + "<br>" + MediaRes.getString("VideoIO.Dialog.WrongVM.Message.Fix2");
                if (JOptionPane.showConfirmDialog(null, new VideoIO.EditorPaneMessage(message = String.valueOf(message) + "<br><br>" + MediaRes.getString("VideoIO.Dialog.WrongVM.Message.Restart")), MediaRes.getString("VideoIO.Dialog.UnsupportedVideo.Title"), 0) == 0) {
                    SwingUtilities.invokeLater(() -> {
                        try {
                            this.frame.getPrefsDialog().relaunch64Bit();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
            ++i;
        }
    }

    void refreshTrackBar() {
        TTrackBar tbar;
        if (this.frame != null && (tbar = this.getTrackBar(false)) != null) {
            tbar.refresh();
        }
    }

    public void onLoaded() {
        TToolBar tbar;
        if (this.showTrackControlDelayed && this.isShowing()) {
            this.showTrackControlDelayed = false;
            TrackControl tc = TrackControl.getControl(this);
            tc.setVisible(tc.wasVisible);
        }
        if ((tbar = this.getToolBar(true)) != null) {
            JButton button = tbar.notesButton;
            TTrack track = this.getSelectedTrack();
            if (!this.hideDescriptionWhenLoaded && (track == null ? this.getDescription() != null && this.getDescription().trim().length() != 0 : track.getDescription() != null && track.getDescription().trim().length() > 0)) {
                this.getToolBar(true).doNotesAction();
            } else if (button.isSelected()) {
                button.setSelected(false);
            }
        }
    }

    public String getTabName() {
        return this.frame == null ? "<removed>" : this.getTFrame().getTabTitle(this.getTFrame().getTab(this.panelID));
    }

    public void onBlocked() {
        if (this.trackControl != null) {
            boolean vis = this.trackControl.wasVisible;
            this.trackControl.setVisible(false);
            this.trackControl.wasVisible = vis;
        }
        if (this.modelBuilder != null) {
            TrackerPanel tp = this.frame.getTrackerPanelForID(this.panelID);
            boolean vis = tp.isModelBuilderVisible;
            this.modelBuilder.setVisible(false);
            tp.isModelBuilderVisible = vis;
        }
    }

    public void addListeners(String[] names, PropertyChangeListener listener) {
        int i = names.length;
        while (--i >= 0) {
            this.addPropertyChangeListener(names[i], listener);
        }
    }

    public void removeListeners(String[] names, PropertyChangeListener listener) {
        int i = names.length;
        while (--i >= 0) {
            this.removePropertyChangeListener(names[i], listener);
        }
    }

    public void refreshNotesDialog() {
        if (this.frame != null) {
            this.frame.updateNotesDialog(this);
        }
    }

    public static void main(String[] args) {
        Tracker.main(args);
    }

    public TrackerPanel ref(Object o) {
        return this;
    }

    public TrackerPanel getMainPanel() {
        return this;
    }

    public void refreshMenus(String why) {
        this.frame.refreshMenus(this, why);
    }

    protected boolean unTracked() {
        return this.hasTrackBar() && this.getTrackBar(true).getComponentCount() == 0;
    }

    boolean hasToolBar() {
        return this.frame != null && this.frame.getToolBar(this.panelID, false) != null;
    }

    boolean hasMenuBar() {
        return this.frame != null && this.frame.getMenuBar(this.panelID, false) != null;
    }

    boolean hasTrackBar() {
        return this.frame != null && this.frame.getTrackBar(this.panelID, false) != null;
    }

    public TMenuBar getMenuBar(boolean forceNew) {
        return this.frame == null ? null : this.frame.getMenuBar(this.panelID, forceNew);
    }

    public TToolBar getToolBar(boolean forceNew) {
        return this.frame.getToolBar(this.panelID, forceNew);
    }

    public TTrackBar getTrackBar(boolean forceNew) {
        return this.frame == null ? null : this.frame.getTrackBar(this.panelID, forceNew);
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.panelID + " " + this.title + "]";
    }

    public void finalize() {
        System.out.println("-------HOORAY!!!!!!!----finalized!------------ " + this);
        OSPLog.finalized(this);
    }

    public Rectangle getMatBounds() {
        TMat mat = this.getMat();
        return mat == null ? null : mat.getBounds();
    }

    static class Loader
    extends VideoPanel.Loader
    implements XML.ObjectLoader {
        private TrackerIO.AsyncLoader asyncloader;

        Loader() {
        }

        public static XML.ObjectLoader getLoader() {
            return new Loader();
        }

        @Override
        public Object createObject(XMLControl control) {
            return new TrackerPanel(null, null);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TrackerPanel trackerPanel = (TrackerPanel)obj;
            this.asyncloader = (TrackerIO.AsyncLoader)((XMLControlElement)control).getData();
            this.asyncloader.setLoader(this);
            this.control = (XMLControlElement)control;
            switch (trackerPanel.progress) {
                case 0: {
                    String fileVersion;
                    trackerPanel.frame = this.asyncloader.getFrame();
                    if (trackerPanel.frame != null) {
                        trackerPanel.frame.holdPainting(true);
                    }
                    trackerPanel.dividerLocs = (double[])control.getObject("dividers");
                    trackerPanel.trackControlX = control.getInt("track_control_x");
                    trackerPanel.trackControlY = control.getInt("track_control_y");
                    trackerPanel.infoX = control.getInt("info_x");
                    trackerPanel.infoY = control.getInt("info_y");
                    if (control.getPropertyNamesRaw().contains("width")) {
                        trackerPanel.setImageWidth(control.getDouble("width"));
                    }
                    if (control.getPropertyNamesRaw().contains("height")) {
                        trackerPanel.setImageHeight(control.getDouble("height"));
                    }
                    trackerPanel.setMagnification(control.getDouble(TrackerPanel.PROPERTY_TRACKERPANEL_MAGNIFICATION));
                    if (control.getPropertyNamesRaw().contains("center_x")) {
                        int x = control.getInt("center_x");
                        int y = control.getInt("center_y");
                        trackerPanel.zoomCenter = new Point(x, y);
                    }
                    if ((fileVersion = control.getString("semantic_version")) != null && !OSPRuntime.isJS) {
                        int result = 0;
                        try {
                            result = Tracker.compareVersions(fileVersion, "6.3.3");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (result > 0 && trackerPanel.frame != null) {
                            JOptionPane.showMessageDialog(trackerPanel, String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.Version.Message1")) + " " + fileVersion + " " + TrackerRes.getString("TrackerPanel.Dialog.Version.Message2") + "\n" + TrackerRes.getString("TrackerPanel.Dialog.Version.Message3") + " (" + "6.3.3" + ")." + "\n\n" + TrackerRes.getString("TrackerPanel.Dialog.Version.Message4") + " https://" + Tracker.trackerWebsite + ".", TrackerRes.getString("TrackerPanel.Dialog.Version.Title"), 1);
                        }
                    }
                    trackerPanel.progress = 5;
                    break;
                }
                case 5: {
                    Configuration config;
                    String[][] patterns;
                    trackerPanel.hideDescriptionWhenLoaded = control.getBoolean("hide_description");
                    String desc = control.getString("description");
                    if (desc != null) {
                        trackerPanel.setDescription(desc);
                    }
                    trackerPanel.author = control.getString("author");
                    trackerPanel.contact = control.getString("contact");
                    if (control.getPropertyNamesRaw().contains("length_unit")) {
                        trackerPanel.lengthUnit = control.getString("length_unit");
                    }
                    if (control.getPropertyNamesRaw().contains("mass_unit")) {
                        trackerPanel.massUnit = control.getString("mass_unit");
                    }
                    if (control.getPropertyNamesRaw().contains("units_visible")) {
                        trackerPanel.unitsVisible = control.getBoolean("units_visible");
                    }
                    if ((patterns = (String[][])control.getObject("number_formats")) != null) {
                        int ip = 0;
                        while (ip < patterns.length) {
                            String[] next = patterns[ip];
                            int ttype = TTrack.getBaseTypeInt(next[0]);
                            if (ttype >= 0) {
                                TreeMap<String, String> patternMap = trackerPanel.getFormatPatterns(ttype);
                                int i = 1;
                                while (i < next.length) {
                                    patternMap.put(next[i++], next[i++]);
                                }
                            }
                            ++ip;
                        }
                    }
                    if ((config = (Configuration)control.getObject("configuration")) != null) {
                        trackerPanel.enabled = config.enabled;
                    }
                    List<XMLProperty> props = control.getPropsRaw();
                    trackerPanel.selectedViewsProperty = null;
                    trackerPanel.customViewsProperty = null;
                    int n = 0;
                    int i = props.size();
                    while (--i >= 0 && n < 3) {
                        XMLProperty prop = props.get(i);
                        switch (prop.getPropertyName()) {
                            case "selected_views": {
                                trackerPanel.selectedViewsProperty = prop;
                                ++n;
                                break;
                            }
                            case "selected_view_types": {
                                trackerPanel.selectedViewTypesProperty = prop;
                                ++n;
                                break;
                            }
                            case "selected_track_views": {
                                trackerPanel.selectedTrackViewsProperty = prop;
                                ++n;
                                break;
                            }
                            case "views": {
                                trackerPanel.customViewsProperty = prop;
                                ++n;
                            }
                        }
                    }
                    trackerPanel.progress = 10;
                    break;
                }
                default: {
                    super.loadObject(control, obj);
                }
            }
            return trackerPanel;
        }

        @Override
        public void finalizeLoading() {
            TrackerPanel trackerPanel = (TrackerPanel)this.videoPanel;
            if (trackerPanel.progress < 80) {
                return;
            }
            this.videoPanel.setLoader(null);
            switch (trackerPanel.progress) {
                case 80: {
                    XMLControl child;
                    Video video2 = this.finalizeClip();
                    if (video2 != null) {
                        FilterStack stack = video2.getFilterStack();
                        ArrayList<Filter> filters = stack.getFilters();
                        int i = 0;
                        int n = filters.size();
                        while (i < n) {
                            Filter filter = filters.get(i);
                            filter.setVideoPanel(trackerPanel);
                            if (filter.inspectorX != Integer.MIN_VALUE) {
                                filter.inspectorVisible = true;
                                if (trackerPanel.visibleFilters == null) {
                                    trackerPanel.visibleFilters = new HashMap<Filter, Point>();
                                }
                                Point p = new Point(filter.inspectorX, filter.inspectorY);
                                trackerPanel.visibleFilters.put(filter, p);
                            }
                            ++i;
                        }
                    }
                    if ((child = this.control.getChildControl("clipcontrol")) != null) {
                        child.loadObject(trackerPanel.getPlayer().getClipControl());
                    }
                    trackerPanel.progress = 85;
                    break;
                }
                case 85: {
                    XMLControl child = this.control.getChildControl("toolbar");
                    if (child != null && trackerPanel.frame != null) {
                        TToolBar toolbar = new TToolBar(trackerPanel);
                        child.loadObject(toolbar);
                        trackerPanel.frame.setToolBar(trackerPanel, toolbar);
                    }
                    if ((child = this.control.getChildControl("coords")) != null) {
                        ImageCoordSystem coords = trackerPanel.getCoords();
                        child.loadObject(coords);
                        int n = trackerPanel.getFrameNumber();
                        trackerPanel.getSnapPoint().setXY(coords.getOriginX(n), coords.getOriginY(n));
                    }
                    trackerPanel.progress = 90;
                    break;
                }
                case 90: {
                    ArrayList tracks = (ArrayList)ArrayList.class.cast(this.control.getObject("tracks"));
                    if (tracks == null) {
                        trackerPanel.progress = 95;
                        break;
                    }
                    int i = 0;
                    int n = tracks.size();
                    while (i < n) {
                        trackerPanel.addTrack((TTrack)tracks.get(i));
                        ++i;
                    }
                    trackerPanel.progress = 92;
                    break;
                }
                case 92: {
                    ArrayList drawings;
                    ArrayList<TTrack> traks = trackerPanel.getTracks();
                    int i = 0;
                    int n = traks.size();
                    while (i < n) {
                        traks.get(i).initialize(trackerPanel);
                        ++i;
                    }
                    ArrayList scenes = (ArrayList)this.control.getObject("drawing_scenes");
                    if (scenes != null) {
                        PencilDrawer drawer = PencilDrawer.getDrawer(trackerPanel);
                        drawer.setDrawingsVisible(this.control.getBoolean("drawings_visible"), false);
                        drawer.setScenes(scenes);
                    }
                    if ((drawings = (ArrayList)this.control.getObject("drawings")) != null) {
                        PencilDrawer drawer = PencilDrawer.getDrawer(trackerPanel);
                        drawer.setDrawingsVisible(this.control.getBoolean("drawings_visible"), false);
                        drawer.clearScenes(false);
                        int i2 = 0;
                        int n2 = drawings.size();
                        while (i2 < n2) {
                            drawer.addDrawingtoSelectedScene((PencilDrawing)drawings.get(i2));
                            ++i2;
                        }
                    }
                    trackerPanel.progress = 95;
                    break;
                }
                case 95: {
                    String name;
                    String rfName = this.control.getString("referenceframe");
                    if (rfName != null) {
                        trackerPanel.setReferenceFrame(rfName);
                    }
                    trackerPanel.setSelectedTrack((name = this.control.getString(TrackerPanel.PROPERTY_TRACKERPANEL_SELECTEDTRACK)) == null ? null : trackerPanel.getTrack(name));
                    trackerPanel.progress = 100;
                }
            }
            if (trackerPanel.progress == 100) {
                if (this.asyncloader != null) {
                    this.asyncloader.finalized(trackerPanel);
                }
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            this.asyncloader = null;
            super.dispose();
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DataTool tool;
            TFrame frame;
            TTrack track;
            boolean writeNullFinalArrayElements = XMLPropertyElement.defaultWriteNullFinalArrayElements;
            XMLPropertyElement.defaultWriteNullFinalArrayElements = false;
            TrackerPanel trackerPanel = (TrackerPanel)obj;
            control.setValue("semantic_version", "6.3.3");
            control.setValue("width", trackerPanel.getImageWidth());
            control.setValue("height", trackerPanel.getImageHeight());
            double zoom = trackerPanel.getPreferredSize().width > 10 ? trackerPanel.getMagnification() : -1.0;
            control.setValue(TrackerPanel.PROPERTY_TRACKERPANEL_MAGNIFICATION, zoom);
            if (trackerPanel.getTFrame() != null) {
                MainTView mainView = trackerPanel.getTFrame().getMainView(trackerPanel);
                Rectangle rect = mainView.scrollPane.getViewport().getViewRect();
                control.setValue("center_x", (int)rect.getCenterX());
                control.setValue("center_y", (int)rect.getCenterY());
            }
            if (trackerPanel.hideDescriptionWhenLoaded) {
                control.setValue("hide_description", true);
            }
            if (!trackerPanel.description.trim().equals("")) {
                control.setValue("description", trackerPanel.description);
            }
            if (trackerPanel.author != null) {
                control.setValue("author", trackerPanel.author);
            }
            if (trackerPanel.contact != null) {
                control.setValue("contact", trackerPanel.contact);
            }
            control.setValue("videoclip", trackerPanel.getPlayer().getVideoClip());
            control.setValue("clipcontrol", trackerPanel.getPlayer().getClipControl());
            ImageCoordSystem coords = trackerPanel.getCoords();
            while (coords instanceof ReferenceFrame) {
                ReferenceFrame refFrame = (ReferenceFrame)coords;
                track = refFrame.getOriginTrack();
                control.setValue("referenceframe", track.getName());
                coords = refFrame.getCoords();
            }
            control.setValue("coords", coords);
            String[][] customPatterns = Loader.getSaveCustomFormatPatterns(trackerPanel);
            if (customPatterns.length > 0) {
                control.setValue("number_formats", customPatterns);
            }
            control.setValue("length_unit", trackerPanel.lengthUnit);
            control.setValue("mass_unit", trackerPanel.massUnit);
            control.setValue("units_visible", trackerPanel.unitsVisible);
            control.setValue("tracks", trackerPanel.getTracksToSave());
            track = trackerPanel.getSelectedTrack();
            if (track != null) {
                control.setValue(TrackerPanel.PROPERTY_TRACKERPANEL_SELECTEDTRACK, track.getName());
            }
            if (PencilDrawer.hasDrawings(trackerPanel)) {
                PencilDrawer drawer = PencilDrawer.getDrawer(trackerPanel);
                control.setValue("drawing_scenes", drawer.scenes);
                control.setValue("drawings_visible", drawer.areDrawingsVisible());
            }
            if (!Tracker.isDefaultConfiguration(trackerPanel.getEnabled()) && trackerPanel.isEnabled("config.saveWithData")) {
                control.setValue("configuration", new Configuration(trackerPanel));
            }
            if ((frame = trackerPanel.getTFrame()) != null) {
                int y;
                int x;
                double[] dividerLocations = new double[4];
                int w = 0;
                int[] order = TFrame.isPortraitLayout() ? TFrame.PORTRAIT_DIVIDER_ORDER : TFrame.DEFAULT_ORDER;
                int i = 0;
                while (i < dividerLocations.length) {
                    JSplitPane pane = frame.getSplitPane(trackerPanel, i);
                    if (i == 0) {
                        w = pane.getMaximumDividerLocation();
                    }
                    int max = i == 3 ? w : pane.getMaximumDividerLocation();
                    double loc = Math.min(1.0, 1.0 * (double)pane.getDividerLocation() / (double)max);
                    dividerLocations[order[i]] = frame.getConvertedDividerLoc(order[i], loc);
                    ++i;
                }
                control.setValue("dividers", dividerLocations);
                TView[][] customViews = frame.getTViews(trackerPanel, true);
                int i2 = 0;
                while (i2 < customViews.length) {
                    if (customViews[i2] != null) {
                        control.setValue("views", customViews);
                        break;
                    }
                    ++i2;
                }
                int[] selectedViewTypes = frame.getSelectedViewTypes(trackerPanel);
                control.setValue("selected_view_types", selectedViewTypes);
                String selectedTrackViews = frame.getSelectedTrackViews(trackerPanel);
                control.setValue("selected_track_views", selectedTrackViews);
                TToolBar toolbar = trackerPanel.getToolBar(true);
                control.setValue("toolbar", toolbar);
                TrackControl tc = trackerPanel.trackControl;
                if (tc != null && tc.isVisible()) {
                    x = tc.getLocation().x - frame.getLocation().x;
                    y = tc.getLocation().y - frame.getLocation().y;
                    control.setValue("track_control_x", x);
                    control.setValue("track_control_y", y);
                }
                if (frame.notesVisible()) {
                    x = frame.getNotesDialog().getLocation().x - frame.getLocation().x;
                    y = frame.getNotesDialog().getLocation().y - frame.getLocation().y;
                    control.setValue("info_x", x);
                    control.setValue("info_y", y);
                }
            }
            if ((tool = DataTool.getTool(false)) != null) {
                ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
                List<DataToolTab> tools2 = tool.getTabs();
                int n = tools2.size();
                if (n > 0) {
                    ArrayList<TTrack> tracks = trackerPanel.getTracks();
                    int i = 0;
                    while (i < n) {
                        DataToolTab tab = tools2.get(i);
                        for (TTrack next : tracks) {
                            DatasetManager data = next.getData(trackerPanel);
                            if (!tab.isOwnedBy(data)) continue;
                            tab.setOwner(next.getName(), data);
                            for (TTrack tt : tracks) {
                                tab.saveOwnedColumnNames(tt.getName(), tt.getData(trackerPanel));
                            }
                            tabs.add(tab);
                        }
                        ++i;
                    }
                    if (!tabs.isEmpty()) {
                        DataToolTab[] tabArray = tabs.toArray(new DataToolTab[tabs.size()]);
                        control.setValue("datatool_tabs", tabArray);
                    }
                }
            }
            XMLPropertyElement.defaultWriteNullFinalArrayElements = writeNullFinalArrayElements;
        }

        private static String[][] getSaveCustomFormatPatterns(TrackerPanel panel) {
            String path = PointMass.class.getName();
            path = path.substring(0, path.lastIndexOf(".") + 1);
            ArrayList<String[]> formats = new ArrayList<String[]>();
            TreeMap<String, String>[] dpatterns = TTrack.getDefaultFormatPatterns();
            int ttype = 0;
            int n = dpatterns.length;
            while (ttype < n) {
                TreeMap<String, String> defaultPatterns = dpatterns[ttype];
                if (defaultPatterns != null) {
                    String pattern;
                    String defaultPattern;
                    TreeMap<String, String> patterns = panel.getFormatPatterns(ttype);
                    ArrayList<String> customPatterns = new ArrayList<String>();
                    String type = TTrack.getBaseTrackName(ttype);
                    for (String name : defaultPatterns.keySet()) {
                        defaultPattern = defaultPatterns.get(name);
                        if (defaultPattern.equals(pattern = patterns.get(name))) continue;
                        if (customPatterns.isEmpty()) {
                            customPatterns.add(String.valueOf(path) + type);
                        }
                        customPatterns.add(name);
                        customPatterns.add(pattern == null ? "" : pattern);
                    }
                    for (String name : patterns.keySet()) {
                        defaultPattern = defaultPatterns.get(name);
                        if (defaultPattern == null) {
                            defaultPattern = "";
                        }
                        if ((pattern = patterns.get(name)).equals(defaultPattern) || customPatterns.contains(name)) continue;
                        if (customPatterns.isEmpty()) {
                            customPatterns.add(String.valueOf(path) + type);
                        }
                        customPatterns.add(name);
                        customPatterns.add(pattern);
                    }
                    if (!customPatterns.isEmpty()) {
                        formats.add(customPatterns.toArray(new String[customPatterns.size()]));
                    }
                }
                ++ttype;
            }
            return (String[][])formats.toArray((T[])new String[formats.size()][]);
        }
    }

    private class TMouseController
    extends InteractivePanel.IADMouseController {
        private TMouseController() {
            super(TrackerPanel.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (TrackerPanel.this.getSelectedPoint() != null) {
                TrackerPanel.this.getSelectedPoint().showCoordinates(TrackerPanel.this);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            if (PencilDrawer.isDrawing(TrackerPanel.this)) {
                TrackerPanel.this.setMouseCursor(PencilDrawer.getDrawer(TrackerPanel.this).getPencilCursor());
            } else {
                TrackerPanel.this.setMouseCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            TrackerPanel.this.isShiftKeyDown = false;
            if (TrackerPanel.this.getSelectedPoint() == null) {
                TrackerPanel.this.setMessage(null, 0);
            }
            TrackerPanel.this.setMouseCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
        }
    }
}

