/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.StepSet;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.IncrementallyLoadable;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;

public class Undo {
    protected static Map<Integer, Undo> undomap = new HashMap<Integer, Undo>();
    protected UndoableEditSupport undoSupport;
    protected MyUndoManager undoManager;
    private TFrame frame;
    private Integer panelID;

    private Undo(TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.undoManager = new MyUndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        XML.setLoader(TrackProperties.class, TrackProperties.getLoader());
    }

    public static boolean canUndo(TrackerPanel panel) {
        return Undo.getUndo((TrackerPanel)panel).undoManager.canUndo();
    }

    public static String getUndoDescription(TrackerPanel panel) {
        String desc = TrackerRes.getString("TMenuBar.MenuItem.Undo");
        UndoableEdit edit = Undo.getUndo((TrackerPanel)panel).undoManager.getUndoEdit();
        if (edit != null) {
            desc = String.valueOf(desc) + " " + edit.getPresentationName();
        }
        return desc;
    }

    public static void undo(TrackerPanel panel) {
        UndoableEdit lastEdit;
        if (!Undo.getUndo((TrackerPanel)panel).undoManager.canRedo() && (lastEdit = Undo.getUndo((TrackerPanel)panel).undoManager.getUndoEdit()) != null && lastEdit instanceof TrackEdit) {
            TrackEdit trackEdit = (TrackEdit)lastEdit;
            String name = trackEdit.trackName;
            TTrack track = panel.getTrack(name);
            if (track != null) {
                trackEdit.redo = new XMLControlElement(track).toXML();
            }
        }
        Undo.getUndo((TrackerPanel)panel).undoManager.undo();
        panel.refreshMenus("Undo.refreshMenus");
        panel.repaint();
    }

    public static boolean canRedo(TrackerPanel panel) {
        return Undo.getUndo((TrackerPanel)panel).undoManager.canRedo();
    }

    public static String getRedoDescription(TrackerPanel panel) {
        String desc = TrackerRes.getString("TMenuBar.MenuItem.Redo");
        UndoableEdit edit = Undo.getUndo((TrackerPanel)panel).undoManager.getRedoEdit();
        if (edit != null) {
            desc = String.valueOf(desc) + " " + edit.getPresentationName();
        }
        return desc;
    }

    public static void redo(TrackerPanel panel) {
        Undo.getUndo((TrackerPanel)panel).undoManager.redo();
        panel.refreshMenus("Undo.refreshMenus");
        panel.repaint();
    }

    protected static void postTrackDelete(TTrack track) {
        TrackerPanel panel = track.tp;
        if (panel == null) {
            return;
        }
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        TrackDelete edit = undo.new TrackDelete(panel, track);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postTrackClear(TrackerPanel panel, List<String> xml) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        TrackClear edit = undo.new TrackClear(panel, xml);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postTrackEdit(TTrack track, XMLControl control) {
        TrackerPanel panel = track.tp;
        if (panel == null) {
            return;
        }
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        TrackEdit edit = undo.new TrackEdit(track, control);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postMultiTrackEdit(ArrayList<Object[]> tracksAndXMLControls) {
        if (tracksAndXMLControls == null || tracksAndXMLControls.size() == 0) {
            return;
        }
        TTrack track = (TTrack)tracksAndXMLControls.get(0)[0];
        TrackerPanel panel = track.tp;
        if (panel == null) {
            return;
        }
        AbstractUndoableEdit edit = null;
        for (Object[] next : tracksAndXMLControls) {
            track = (TTrack)next[0];
            XMLControl control = (XMLControl)next[1];
            if (edit == null) {
                Undo undo = Undo.getUndo(panel);
                undo.getClass();
                edit = undo.new TrackEdit(track, control);
                continue;
            }
            Undo undo = Undo.getUndo(panel);
            undo.getClass();
            TrackEdit trackEdit = undo.new TrackEdit(track, control);
            Undo undo2 = Undo.getUndo(panel);
            undo2.getClass();
            edit = undo2.new CompoundEdit(trackEdit, edit);
        }
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postStepEdit(Step step, XMLControl control) {
        TrackerPanel panel = step.getTrack().tp;
        if (panel == null) {
            return;
        }
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        StepEdit edit = undo.new StepEdit(step, control);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postStepSetEdit(StepSet steps, XMLControl control) {
        TEdit edit;
        TrackerPanel panel = steps.panel();
        TTrack track = null;
        boolean singleTrack = true;
        for (Step step : steps) {
            if (step.getTrack() == null) continue;
            if (track == null) {
                track = step.getTrack();
                continue;
            }
            if (track == step.getTrack()) continue;
            singleTrack = false;
            break;
        }
        if (track != null && singleTrack) {
            Undo undo = Undo.getUndo(panel);
            undo.getClass();
            edit = undo.new TrackEdit(track, control);
        } else {
            Undo undo = Undo.getUndo(panel);
            undo.getClass();
            edit = undo.new StepSetEdit(steps, control);
        }
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        steps.setChanged(false);
        steps.clear();
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postCoordsEdit(TrackerPanel panel, XMLControl control) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        CoordsEdit edit = undo.new CoordsEdit(panel, control);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postTrackAndCoordsEdit(TTrack track, XMLControl trackControl, XMLControl coordsControl) {
        TrackerPanel panel = track.tp;
        if (panel == null) {
            return;
        }
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        CoordsEdit edit1 = undo.new CoordsEdit(panel, coordsControl);
        Undo undo2 = Undo.getUndo(panel);
        undo2.getClass();
        TrackEdit edit2 = undo2.new TrackEdit(track, trackControl);
        Undo undo3 = Undo.getUndo(panel);
        undo3.getClass();
        CompoundEdit compound = undo3.new CompoundEdit(edit1, edit2);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(compound);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postImageVideoEdit(TrackerPanel panel, String[] paths, int index, int step, boolean added) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        ImageVideoEdit edit = undo.new ImageVideoEdit(panel, paths, index, step, added);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postVideoReplace(TrackerPanel panel, XMLControl control) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        VideoReplace edit = undo.new VideoReplace(panel, control);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postFilterDelete(TrackerPanel panel, Filter filter) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        FilterDelete edit = undo.new FilterDelete(panel, filter);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postFilterEdit(TrackerPanel panel, Filter filter, XMLControl control) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        FilterEdit edit = undo.new FilterEdit(panel, filter, control);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postFilterClear(TrackerPanel panel, List<String> xml) {
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        FilterClear edit = undo.new FilterClear(panel, xml);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    protected static void postTrackDisplayEdit(TTrack track, XMLControl control) {
        TrackerPanel panel = track.tp;
        if (panel == null) {
            return;
        }
        Undo undo = Undo.getUndo(panel);
        undo.getClass();
        TrackDisplayEdit edit = undo.new TrackDisplayEdit(track, control);
        Undo.getUndo((TrackerPanel)panel).undoSupport.postEdit(edit);
        panel.refreshMenus("Undo.refreshMenus");
    }

    private static Undo getUndo(TrackerPanel panel) {
        Undo undo = undomap.get(panel.getID());
        if (undo == null) {
            undo = new Undo(panel);
            undomap.put(panel.getID(), undo);
        }
        return undo;
    }

    public static XMLControl getXMLControl(VideoClip clip) {
        XMLControlElement control = new XMLControlElement(clip);
        if (clip.getVideo() != null) {
            String fullpath = (String)clip.getVideo().getProperty("absolutePath");
            XMLControl child = control.getChildControl("video");
            if (child != null) {
                child.setValue("absolutePath", fullpath);
            }
        }
        return control;
    }

    protected TrackerPanel panel() {
        return this.frame == null ? null : this.frame.getTrackerPanelForID(this.panelID);
    }

    protected class CompoundEdit
    extends AbstractUndoableEdit {
        UndoableEdit editA;
        UndoableEdit editB;

        protected CompoundEdit(UndoableEdit edit1, UndoableEdit edit2) {
            this.editA = edit1;
            this.editB = edit2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.editA.undo();
            this.editB.undo();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.editA.redo();
            this.editB.redo();
        }

        @Override
        public String getPresentationName() {
            return this.editA.getPresentationName();
        }
    }

    protected class CoordsEdit
    extends TEdit {
        private CoordsEdit(TrackerPanel panel, XMLControl control) {
            super(panel, panel.getCoords(), control);
        }

        @Override
        protected void load(String xml) {
            XMLControlElement control = new XMLControlElement(xml);
            ImageCoordSystem coords = Undo.this.panel().getCoords();
            control.loadObject(coords);
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Edit")) + " " + TrackerRes.getString("TMenuBar.Menu.Coords");
        }
    }

    protected class FilterClear
    extends AbstractUndoableEdit {
        List<String> xml;

        private FilterClear(TrackerPanel trackerPanel, List<String> xml) {
            this.xml = xml;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            TrackerPanel panel = Undo.this.panel();
            Video video2 = panel.getVideo();
            if (video2 != null) {
                for (String next : this.xml) {
                    XMLControlElement control = new XMLControlElement(next);
                    Filter filter = (Filter)control.loadObject(null);
                    filter.setVideoPanel(panel);
                    video2.getFilterStack().addFilter(filter);
                    if (filter.inspectorX == Integer.MIN_VALUE) continue;
                    filter.inspectorVisible = true;
                    if (panel.visibleFilters == null) {
                        panel.visibleFilters = new HashMap<Filter, Point>();
                    }
                    Point p = new Point(filter.inspectorX, filter.inspectorY);
                    panel.visibleFilters.put(filter, p);
                }
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            TrackerPanel panel = Undo.this.panel();
            Video video2 = panel.getVideo();
            if (video2 != null) {
                FilterStack stack = video2.getFilterStack();
                for (Filter filter : stack.getFilters()) {
                    PerspectiveTrack track = PerspectiveTrack.filterMap.get(filter);
                    if (track == null) continue;
                    panel.removeTrack(track);
                    track.dispose();
                }
                stack.clear();
            }
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Clear")) + " " + TrackerRes.getString("TMenuBar.MenuItem.VideoFilters");
        }
    }

    protected class FilterDelete
    extends AbstractUndoableEdit {
        String xml;
        int i;
        Filter filter;
        String filterName;

        private FilterDelete(TrackerPanel trackerPanel, Filter filter) {
            this.xml = new XMLControlElement(filter).toXML();
            this.i = Undo.this.panel().getVideo().getFilterStack().lastIndexRemoved();
            this.filterName = filter.getClass().getSimpleName();
            int j = this.filterName.indexOf("Filter");
            if (j > 0 && j < this.filterName.length() - 1) {
                this.filterName = this.filterName.substring(0, j);
            }
            this.filterName = MediaRes.getString("VideoFilter." + this.filterName);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            TrackerPanel panel = Undo.this.panel();
            Video video2 = panel.getVideo();
            if (video2 != null) {
                XMLControlElement control = new XMLControlElement(this.xml);
                this.filter = (Filter)control.loadObject(null);
                this.filter.setVideoPanel(panel);
                video2.getFilterStack().insertFilter(this.filter, this.i);
                if (this.filter.inspectorX != Integer.MIN_VALUE) {
                    this.filter.inspectorVisible = true;
                    if (panel.visibleFilters == null) {
                        panel.visibleFilters = new HashMap<Filter, Point>();
                    }
                    Point p = new Point(this.filter.inspectorX, this.filter.inspectorY);
                    panel.visibleFilters.put(this.filter, p);
                }
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            Video video2 = Undo.this.panel().getVideo();
            if (video2 != null) {
                this.filter.setVideoPanel(null);
                TMenuBar menubar = Undo.this.panel().getMenuBar(true);
                menubar.refreshing = true;
                video2.getFilterStack().removeFilter(this.filter);
                menubar.refreshing = false;
                this.i = video2.getFilterStack().lastIndexRemoved();
                this.filter = null;
            }
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Delete")) + " " + TrackerRes.getString("Undo.Description.Filter");
        }
    }

    protected class FilterEdit
    extends TEdit {
        int filterIndex;
        int frameNumber;
        String filterType;

        private FilterEdit(TrackerPanel panel, Filter filter, XMLControl control) {
            super(panel, filter, control);
            this.filterIndex = panel.getVideo().getFilterStack().getFilters().indexOf(filter);
            this.frameNumber = panel.getFrameNumber();
            this.filterType = filter.getClass().getSimpleName();
            int j = this.filterType.indexOf("Filter");
            if (j > 0 && j < this.filterType.length() - 1) {
                this.filterType = this.filterType.substring(0, j);
            }
            this.filterType = MediaRes.getString("VideoFilter." + this.filterType);
        }

        @Override
        protected void load(String xml) {
            XMLControlElement control = new XMLControlElement(xml);
            TrackerPanel panel = Undo.this.panel();
            Video video2 = panel.getVideo();
            if (video2 != null) {
                ArrayList<Filter> filters = video2.getFilterStack().getFilters();
                if (this.filterIndex < 0 || this.filterIndex >= filters.size()) {
                    return;
                }
                Filter filter = filters.get(this.filterIndex);
                control.loadObject(filter);
                JDialog inspector = filter.getInspector();
                if (inspector != null) {
                    inspector.setVisible(true);
                }
                VideoClip clip = panel.getPlayer().getVideoClip();
                panel.getPlayer().setStepNumber(clip.frameToStep(this.frameNumber));
            }
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Edit")) + " " + this.filterType;
        }
    }

    protected class ImageVideoEdit
    extends AbstractUndoableEdit {
        String[] paths;
        int n;
        int step;
        boolean added;

        private ImageVideoEdit(TrackerPanel panel, String[] imagePaths, int index, int step, boolean added) {
            this.paths = imagePaths;
            this.n = index;
            this.step = step;
            this.added = added;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.added) {
                this.removeImages();
            } else {
                this.addImages();
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            if (this.added) {
                this.addImages();
            } else {
                this.removeImages();
            }
        }

        private void addImages() {
            if (this.paths == null || this.paths.length == 0) {
                return;
            }
            try {
                int index = this.n;
                int i = 0;
                while (i < this.paths.length) {
                    String path = this.paths[i];
                    if (path != null) {
                        TrackerPanel panel = Undo.this.panel();
                        ImageVideo imageVid = (ImageVideo)panel.getVideo();
                        imageVid.insert(path, index, false);
                        VideoClip clip = panel.getPlayer().getVideoClip();
                        clip.setStepCount(imageVid.getFrameCount());
                        int step = panel.getPlayer().getVideoClip().frameToStep(index++);
                        panel.getPlayer().setStepNumber(step);
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private void removeImages() {
            TrackerPanel panel = Undo.this.panel();
            if (panel.getVideo() instanceof ImageVideo) {
                ImageVideo imageVid = (ImageVideo)panel.getVideo();
                int i = 0;
                while (i < this.paths.length) {
                    imageVid.remove(this.n);
                    ++i;
                }
                int len = imageVid.getFrameCount();
                VideoClip clip = panel.getPlayer().getVideoClip();
                clip.setStepCount(len);
                panel.getPlayer().setStepNumber(this.step);
            }
        }

        @Override
        public String getPresentationName() {
            if (this.added) {
                return String.valueOf(TrackerRes.getString("Undo.Description.Add")) + " " + TrackerRes.getString("Undo.Description.Images");
            }
            return String.valueOf(TrackerRes.getString("Undo.Description.Remove")) + " " + TrackerRes.getString("Undo.Description.Images");
        }
    }

    static class MyUndoManager
    extends UndoManager {
        MyUndoManager() {
        }

        public UndoableEdit getUndoEdit() {
            return this.editToBeUndone();
        }

        public UndoableEdit getRedoEdit() {
            return this.editToBeRedone();
        }
    }

    protected class StepEdit
    extends TEdit {
        Step step;
        String trackType;

        private StepEdit(Step step, XMLControl control) {
            super(step.getTrack().tp, step, control);
            this.step = step;
            String s = step.getTrack().getClass().getSimpleName();
            this.trackType = TrackerRes.getString(String.valueOf(s) + ".Name");
            if (this.trackType.startsWith("!")) {
                this.trackType = s;
            }
        }

        @Override
        protected void load(String xml) {
            XMLControlElement control = new XMLControlElement(xml);
            control.loadObject(this.step);
            this.step.erase();
            Undo.this.panel().refreshTrackBar();
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Edit")) + " " + this.trackType;
        }
    }

    protected class StepSetEdit
    extends TEdit {
        private StepSetEdit(StepSet steps, XMLControl control) {
            super(steps.panel(), steps, control);
        }

        @Override
        protected void load(String xml) {
            XMLControlElement control = new XMLControlElement(xml);
            StepSet steps = new StepSet(this.frame, this.panelID);
            control.loadObject(steps);
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Edit")) + " " + TrackerRes.getString("Undo.Description.Steps");
        }
    }

    protected abstract class TEdit
    extends AbstractUndoableEdit {
        String undo;
        String redo;
        protected TFrame frame;
        protected Integer panelID;

        protected TEdit(TrackerPanel panel, Object obj, XMLControl control) {
            this.frame = panel.getTFrame();
            this.panelID = panel.getID();
            this.undo = control.toXML();
            control = new XMLControlElement(obj);
            this.redo = control.toXML();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.load(this.undo);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.load(this.redo);
        }

        abstract void load(String var1);
    }

    protected class TrackClear
    extends AbstractUndoableEdit {
        List<String> xml;

        private TrackClear(TrackerPanel trackerPanel, List<String> xml) {
            this.xml = xml;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Iterator<String> it = this.xml.iterator();
            TrackerPanel panel = Undo.this.panel();
            while (it.hasNext()) {
                XMLControlElement control = new XMLControlElement(it.next());
                TTrack track = (TTrack)control.loadObject(null);
                panel.addTrack(track);
            }
            panel.requestFocus();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            Undo.this.panel().clearTracks();
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Clear")) + " " + TrackerRes.getString("Undo.Description.Tracks");
        }
    }

    protected class TrackDelete
    extends AbstractUndoableEdit {
        String xml;
        int trackID;
        String trackType;

        private TrackDelete(TrackerPanel panel, TTrack track) {
            XMLControlElement control = new XMLControlElement(track);
            this.xml = control.toXML();
            String s = track.getClass().getSimpleName();
            this.trackType = TrackerRes.getString(String.valueOf(s) + ".Name");
            if (this.trackType.startsWith("!")) {
                this.trackType = s;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            XMLControlElement control = new XMLControlElement(this.xml);
            TTrack track = (TTrack)control.loadObject(null);
            TrackerPanel panel = Undo.this.panel();
            panel.addTrack(track);
            this.trackID = track.getID();
            panel.requestFocus();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            TTrack track = TTrack.getTrack(this.trackID);
            track.delete(false);
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Delete")) + " " + this.trackType;
        }
    }

    protected class TrackDisplayEdit
    extends TEdit {
        String undoName;
        String redoName;
        String trackName;
        String trackType;

        private TrackDisplayEdit(TTrack track, XMLControl control) {
            super(track.tp, new TrackProperties(track), control);
            control = new XMLControlElement(this.undo);
            TrackProperties props = (TrackProperties)control.loadObject(null);
            this.undoName = track.getName();
            this.redoName = props.name;
            String s = track.getClass().getSimpleName();
            this.trackType = TrackerRes.getString(String.valueOf(s) + ".Name");
            if (this.trackType.startsWith("!")) {
                this.trackType = s;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            this.trackName = this.undoName;
            super.undo();
        }

        @Override
        public void redo() throws CannotUndoException {
            this.trackName = this.redoName;
            super.redo();
        }

        @Override
        protected void load(String xml) {
            XMLControlElement control = new XMLControlElement(xml);
            TrackProperties props = (TrackProperties)control.loadObject(null);
            TTrack track = Undo.this.panel().getTrack(this.trackName);
            if (track == null) {
                return;
            }
            track.setName(props.name);
            if (props.colors != null) {
                if (props.colors.length == 1) {
                    track.setColor(props.colors[0]);
                } else if (track instanceof ParticleDataTrack) {
                    ((ParticleDataTrack)track).setAllColors(props.colors);
                }
            }
            if (props.footprints != null) {
                if (props.footprints.length == 1) {
                    track.setFootprint(props.footprints[0]);
                } else if (track instanceof ParticleDataTrack) {
                    ((ParticleDataTrack)track).setAllFootprints(props.footprints);
                }
            }
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Edit")) + " " + this.trackType;
        }
    }

    protected class TrackEdit
    extends TEdit {
        String trackName;
        String trackType;
        boolean isTextColumn;

        private TrackEdit(TTrack track, XMLControl control) {
            super(track.tp, track, control);
            this.isTextColumn = false;
            this.isTextColumn = control.getBoolean("isTextColumn");
            this.trackName = track.getName();
            String s = track.getClass().getSimpleName();
            this.trackType = TrackerRes.getString(String.valueOf(s) + ".Name");
            if (this.trackType.startsWith("!")) {
                this.trackType = s;
            }
        }

        @Override
        protected void load(String xml) {
            XMLControlElement control = new XMLControlElement(xml);
            TTrack track = Undo.this.panel().getTrack(this.trackName);
            if (track == null) {
                return;
            }
            TrackChooserTView.ignoreRefresh = true;
            control.loadObject(track);
            track.erase();
            TrackChooserTView.ignoreRefresh = false;
            if (this.isTextColumn) {
                track.firePropertyChange("text_column", null, null);
            } else {
                track.firePropertyChange("steps", TTrack.HINT_STEP_ADDED_OR_REMOVED, null);
            }
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Edit")) + " " + this.trackType;
        }
    }

    protected class VideoReplace
    extends TEdit {
        private VideoReplace(TrackerPanel panel, XMLControl control) {
            super(panel, panel.getPlayer().getVideoClip(), control);
            this.redo = Undo.getXMLControl(panel.getPlayer().getVideoClip()).toXML();
        }

        @Override
        public void undo() throws CannotUndoException {
            Video video2 = Undo.this.panel().getVideo();
            if (video2 instanceof ImageVideo) {
                ((ImageVideo)video2).saveInvalidImages();
            }
            this.redo = Undo.getXMLControl(Undo.this.panel().getPlayer().getVideoClip()).toXML();
            super.undo();
        }

        @Override
        public void redo() throws CannotUndoException {
            Video video2 = Undo.this.panel().getVideo();
            if (video2 instanceof ImageVideo) {
                ((ImageVideo)video2).saveInvalidImages();
            }
            this.undo = Undo.getXMLControl(Undo.this.panel().getPlayer().getVideoClip()).toXML();
            super.redo();
        }

        @Override
        protected void load(String xml) {
            TrackerPanel panel = Undo.this.panel();
            Video video2 = panel.getVideo();
            if (video2 != null) {
                TActions.clearFiltersAction(panel, false);
            }
            XMLControlElement control = new XMLControlElement(xml);
            VideoClip clip = (VideoClip)control.loadObject(null);
            Video newVid = clip.getVideo();
            if (VideoIO.loadIncrementally && newVid != null && newVid instanceof IncrementallyLoadable) {
                control.loadObject(clip);
            }
            panel.getPlayer().setVideoClip(clip);
            video2 = panel.getVideo();
            if (video2 != null) {
                for (Filter filter : video2.getFilterStack().getFilters()) {
                    filter.setVideoPanel(panel);
                    if (filter.inspectorX == Integer.MIN_VALUE) continue;
                    filter.inspectorVisible = true;
                    if (panel.visibleFilters == null) {
                        panel.visibleFilters = new HashMap<Filter, Point>();
                    }
                    Point p = new Point(filter.inspectorX, filter.inspectorY);
                    panel.visibleFilters.put(filter, p);
                }
            }
        }

        @Override
        public String getPresentationName() {
            return String.valueOf(TrackerRes.getString("Undo.Description.Replace")) + " " + TrackerRes.getString("Undo.Description.Video");
        }
    }
}

