/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class UnitsDialog
extends JDialog {
    static final Color _RED = new Color(255, 160, 180);
    private TFrame frame;
    private Integer panelID;
    private JLabel lengthLabel;
    private JLabel massLabel;
    private JLabel timeLabel;
    private ArrayList<JLabel> labels;
    private JButton closeButton;
    private JRadioButton degreesButton;
    private JRadioButton radiansButton;
    private JCheckBox visibleCheckbox;
    private JTextField lengthUnitField;
    private JTextField massUnitField;
    private JTextField timeUnitField;
    private TitledBorder unitsBorder;
    private TitledBorder angleBorder;

    public UnitsDialog(TrackerPanel trackerPanel) {
        super(JOptionPane.getFrameForComponent(trackerPanel), true);
        this.panelID = trackerPanel.getID();
        this.frame = trackerPanel.getTFrame();
        this.createGUI();
        this.refreshGUI();
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEtchedBorder());
        this.setContentPane(contentPane);
        this.lengthLabel = new JLabel();
        this.lengthLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.lengthLabel.setHorizontalAlignment(11);
        this.massLabel = new JLabel();
        this.massLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.massLabel.setHorizontalAlignment(11);
        this.timeLabel = new JLabel();
        this.timeLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.timeLabel.setHorizontalAlignment(11);
        this.labels = new ArrayList();
        this.labels.add(this.lengthLabel);
        this.labels.add(this.massLabel);
        this.labels.add(this.timeLabel);
        this.lengthUnitField = new UnitField(5);
        this.massUnitField = new UnitField(5);
        this.timeUnitField = new UnitField(5);
        this.degreesButton = new JRadioButton();
        this.radiansButton = new JRadioButton();
        AbstractAction angleUnitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UnitsDialog.this.frame.isAnglesInRadians() == UnitsDialog.this.radiansButton.isSelected()) {
                    return;
                }
                UnitsDialog.this.frame.setAnglesInRadians(UnitsDialog.this.radiansButton.isSelected());
            }
        };
        this.degreesButton.setAction(angleUnitAction);
        this.radiansButton.setAction(angleUnitAction);
        ButtonGroup group = new ButtonGroup();
        group.add(this.degreesButton);
        group.add(this.radiansButton);
        this.degreesButton.setSelected(!this.frame.isAnglesInRadians());
        this.radiansButton.setSelected(this.frame.isAnglesInRadians());
        this.visibleCheckbox = new JCheckBox();
        this.visibleCheckbox.setSelected(this.frame.getTrackerPanelForID(this.panelID).isUnitsVisible());
        this.visibleCheckbox.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitsDialog.this.frame.getTrackerPanelForID(UnitsDialog.this.panelID).setUnitsVisible(UnitsDialog.this.visibleCheckbox.isSelected());
                UnitsDialog.this.refreshGUI();
            }
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitsDialog.this.setVisible(false);
            }
        });
        this.unitsBorder = BorderFactory.createTitledBorder("");
        this.angleBorder = BorderFactory.createTitledBorder("");
        Box box = Box.createVerticalBox();
        box.setBorder(this.unitsBorder);
        contentPane.add((Component)box, "North");
        JPanel panel = new JPanel();
        panel.add(this.lengthLabel);
        panel.add(this.lengthUnitField);
        box.add(panel);
        panel = new JPanel();
        panel.add(this.massLabel);
        panel.add(this.massUnitField);
        box.add(panel);
        panel = new JPanel();
        panel.add(this.timeLabel);
        panel.add(this.timeUnitField);
        box.add(panel);
        panel = new JPanel();
        panel.add(this.visibleCheckbox);
        box.add(panel);
        panel = new JPanel();
        panel.setBorder(this.angleBorder);
        panel.add(this.degreesButton);
        panel.add(this.radiansButton);
        contentPane.add((Component)panel, "Center");
        panel = new JPanel();
        panel.add(this.closeButton);
        contentPane.add((Component)panel, "South");
    }

    protected void refreshGUI() {
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        this.setTitle(TrackerRes.getString("UnitsDialog.Title"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        this.lengthLabel.setText(TrackerRes.getString("NumberFormatSetter.Help.Dimensions.2"));
        this.massLabel.setText(TrackerRes.getString("NumberFormatSetter.Help.Dimensions.4"));
        this.lengthUnitField.setText(panel.lengthUnit);
        this.massUnitField.setText(panel.massUnit);
        this.timeUnitField.setText(panel.getTimeUnit());
        this.timeLabel.setText(TrackerRes.getString("NumberFormatSetter.Help.Dimensions.3"));
        this.degreesButton.setText(TrackerRes.getString("TMenuBar.MenuItem.Degrees"));
        this.radiansButton.setText(TrackerRes.getString("TMenuBar.MenuItem.Radians"));
        this.degreesButton.setSelected(!this.frame.isAnglesInRadians());
        this.radiansButton.setSelected(this.frame.isAnglesInRadians());
        this.unitsBorder.setTitle(TrackerRes.getString("UnitsDialog.Border.LMT.Text"));
        this.angleBorder.setTitle(TrackerRes.getString("NumberFormatSetter.TitledBorder.Units.Text"));
        boolean hasLengthUnit = panel.lengthUnit != null;
        boolean hasMassUnit = panel.massUnit != null;
        this.visibleCheckbox.setText(TrackerRes.getString("UnitsDialog.Checkbox.Visible.Text"));
        this.visibleCheckbox.setSelected(panel.isUnitsVisible());
        this.visibleCheckbox.setEnabled(hasLengthUnit && hasMassUnit);
        this.visibleCheckbox.setToolTipText(hasLengthUnit && hasMassUnit ? TrackerRes.getString("UnitsDialog.Checkbox.Visible.Tooltip") : TrackerRes.getString("UnitsDialog.Checkbox.Visible.Disabled.Tooltip"));
        this.lengthUnitField.setBackground(hasLengthUnit ? Color.WHITE : _RED);
        this.lengthUnitField.setToolTipText(hasLengthUnit ? null : TrackerRes.getString("UnitsDialog.Field.Undefined.Tooltip"));
        this.massUnitField.setBackground(hasMassUnit ? Color.WHITE : _RED);
        this.massUnitField.setToolTipText(hasMassUnit ? null : TrackerRes.getString("UnitsDialog.Field.Undefined.Tooltip"));
        this.timeUnitField.setBackground(Color.WHITE);
        this.labels.add(this.lengthLabel);
        this.labels.add(this.massLabel);
        this.labels.add(this.timeLabel);
        int w = 0;
        for (JLabel next : this.labels) {
            next.setPreferredSize(null);
            w = Math.max(w, next.getPreferredSize().width + 1);
        }
        Dimension labelSize = this.lengthLabel.getPreferredSize();
        labelSize.width = w;
        for (JLabel next : this.labels) {
            next.setPreferredSize(labelSize);
        }
        this.pack();
        TFrame.repaintT(this);
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        this.refreshGUI();
        this.pack();
    }

    private void setUnit(UnitField field) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (field == this.lengthUnitField) {
            trackerPanel.setLengthUnit(field.getText());
            this.refreshGUI();
        } else if (field == this.massUnitField) {
            trackerPanel.setMassUnit(field.getText());
            this.refreshGUI();
        } else if (field == this.timeUnitField) {
            trackerPanel.setTimeUnit(field.getText());
            this.refreshGUI();
        }
    }

    class UnitField
    extends JTextField {
        UnitField(int len) {
            super(len);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        UnitsDialog.this.setUnit(UnitField.this);
                    } else {
                        UnitField.this.setBackground(Color.yellow);
                    }
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (UnitField.this.getBackground() == Color.yellow) {
                        UnitsDialog.this.setUnit(UnitField.this);
                    }
                }
            });
        }
    }
}

