/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class Upgrader {
    TFrame frame;
    JDialog upgradeDialog;
    JLabel downloadLabel;
    JLabel relaunchLabel;
    String upgradeURL;
    String trackerJarName;

    public Upgrader(TFrame tFrame) {
        this.frame = tFrame;
    }

    public void upgrade() {
        this.getUpgradeDialog();
        boolean[] failed = new boolean[1];
        int responseCode = 0;
        this.upgradeURL = this.getUpgradeURL();
        this.trackerJarName = "tracker-" + Tracker.newerVersion + ".jar";
        if (this.upgradeURL != null && Tracker.trackerHome != null) {
            String upgradeFile = String.valueOf(this.upgradeURL) + this.trackerJarName;
            try {
                URL url = new URL(upgradeFile);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                responseCode = huc.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (responseCode != 200) {
            failed[0] = true;
        } else if (OSPRuntime.isWindows()) {
            this.upgradeWindows(failed);
        } else if (OSPRuntime.isMac()) {
            this.upgradeOSX(failed);
        } else if (OSPRuntime.isLinux()) {
            this.upgradeLinux(failed);
        }
        if (failed[0]) {
            this.closeUpgradeDialog();
            String websiteurl = "https://" + Tracker.trackerWebsite;
            OSPDesktop.displayURL(websiteurl);
        }
    }

    private void upgradeWindows(final boolean[] failed) {
        final String upgradeInstallerName = "TrackerUpgrade-" + Tracker.newerVersion + "-windows-x64-installer.exe";
        final String upgradeInstallerURL = String.valueOf(this.upgradeURL) + upgradeInstallerName;
        int responseCode = 0;
        try {
            URL url = new URL(upgradeInstallerURL);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            responseCode = huc.getResponseCode();
        }
        catch (Exception url) {
            // empty catch block
        }
        if (responseCode == 200) {
            File downloadDir = OSPRuntime.getDownloadDir();
            if ((downloadDir = this.chooseDownloadDirectory(this.frame, downloadDir)) == null) {
                return;
            }
            if (!downloadDir.exists()) {
                OSPLog.warning("download directory does not exist: " + downloadDir);
                failed[0] = true;
            } else {
                final File downloads = downloadDir;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        File installer = new File(downloads, upgradeInstallerName);
                        Upgrader.this.downloadLabel.setText(String.valueOf(TrackerRes.getString("TTrackBar.Dialog.Relaunch.DownloadLabel.Upgrade.Text")) + " " + installer.getPath() + ".");
                        Upgrader.this.relaunchLabel.setText(TrackerRes.getString("TTrackBar.Dialog.Relaunch.RelaunchLabel.Upgrade.Text"));
                        Upgrader.this.upgradeDialog.pack();
                        Upgrader.this.upgradeDialog.setLocationRelativeTo(Upgrader.this.frame);
                        Upgrader.this.upgradeDialog.setVisible(true);
                        String attempted = installer.getPath();
                        installer = ResourceLoader.download(upgradeInstallerURL, installer, true);
                        Upgrader.this.closeUpgradeDialog();
                        if (installer != null && installer.exists()) {
                            int ans = JOptionPane.showConfirmDialog(Upgrader.this.frame, String.valueOf(TrackerRes.getString("Upgrader.Dialog.Downloaded.Message1")) + " " + XML.NEW_LINE + TrackerRes.getString("Upgrader.Dialog.Downloaded.Message2") + XML.NEW_LINE, TrackerRes.getString("TTrackBar.Dialog.Download.Title"), 2, 1);
                            if (ans != 0) {
                                return;
                            }
                            try {
                                ArrayList<String> cmd = new ArrayList<String>();
                                cmd.add("cmd");
                                cmd.add("/c");
                                cmd.add(installer.getPath());
                                cmd.add("--tracker-home");
                                cmd.add(Tracker.trackerHome);
                                String message = "";
                                for (String next : cmd) {
                                    message = String.valueOf(message) + next + " ";
                                }
                                OSPLog.info("executing command: " + message);
                                ProcessBuilder builder = new ProcessBuilder(cmd);
                                Process p = builder.start();
                                if (Upgrader.this.isAlive(p)) {
                                    Tracker.preferredTrackerJar = null;
                                    Tracker.savePreferences();
                                    TActions.exitAction(null);
                                    return;
                                }
                                OSPLog.warning("failed to launch upgrade installer");
                                failed[0] = true;
                            }
                            catch (Exception ex) {
                                OSPLog.warning("exception: " + ex);
                                failed[0] = true;
                            }
                        } else {
                            OSPLog.warning("failed to download upgrade installer");
                            failed[0] = true;
                        }
                        if (failed[0]) {
                            Upgrader.this.showDownloadFailure(attempted);
                            Upgrader.this.closeUpgradeDialog();
                            String websiteurl = "https://" + Tracker.trackerWebsite;
                            OSPDesktop.displayURL(websiteurl);
                        }
                    }
                };
                new Thread(runner).start();
            }
        } else {
            int ans = JOptionPane.showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("TTrackBar.Dialog.Download.Message1")) + " " + Tracker.trackerHome + "." + XML.NEW_LINE + TrackerRes.getString("TTrackBar.Dialog.Download.Message2") + XML.NEW_LINE, TrackerRes.getString("TTrackBar.Dialog.Download.Title"), 2, 1);
            if (ans != 0) {
                return;
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    Upgrader.this.downloadLabel.setText(String.valueOf(TrackerRes.getString("TTrackBar.Dialog.Relaunch.DownloadLabel.Text")) + " " + Tracker.trackerHome + ".");
                    Upgrader.this.relaunchLabel.setText(TrackerRes.getString("TTrackBar.Dialog.Relaunch.RelaunchLabel.Text"));
                    Upgrader.this.upgradeDialog.pack();
                    Upgrader.this.upgradeDialog.setLocationRelativeTo(Upgrader.this.frame);
                    Upgrader.this.upgradeDialog.setVisible(true);
                    File jarFile = new File(Tracker.trackerHome, Upgrader.this.trackerJarName);
                    String attempted = jarFile.getPath();
                    final String jarURL = String.valueOf(Upgrader.this.upgradeURL) + Upgrader.this.trackerJarName;
                    jarFile = ResourceLoader.download(jarURL, jarFile, true);
                    String starterName = "Tracker.exe";
                    String starterURL = String.valueOf(Upgrader.this.upgradeURL) + starterName;
                    int responseCode = 0;
                    try {
                        URL url = new URL(starterURL);
                        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                        responseCode = huc.getResponseCode();
                    }
                    catch (Exception url) {
                        // empty catch block
                    }
                    if (responseCode == 200) {
                        File starterTarget = new File(Tracker.trackerHome, starterName);
                        ResourceLoader.download(starterURL, starterTarget, true);
                    }
                    if (jarFile != null && jarFile.exists()) {
                        final String jarPath = jarFile.getAbsolutePath();
                        final ArrayList filenames = new ArrayList();
                        Upgrader.this.frame.saveAllTabs(false, new Function<Integer, Void>(){

                            @Override
                            public Void apply(Integer panelID) {
                                String fileName;
                                String path;
                                TrackerPanel trackerPanel = (this).Upgrader.this.frame.getTrackerPanelForID(panelID);
                                File datafile = trackerPanel.getDataFile();
                                if (datafile == null && (path = trackerPanel.openedFromPath) != null) {
                                    datafile = new File(path);
                                }
                                if (datafile != null && !filenames.contains(fileName = datafile.getAbsolutePath())) {
                                    filenames.add(fileName);
                                }
                                return null;
                            }
                        }, new Runnable(){

                            @Override
                            public void run() {
                                String[] args = filenames.isEmpty() ? null : filenames.toArray(new String[0]);
                                System.setProperty("PREFERRED_TRACKER_JAR", jarPath);
                                System.setProperty("TRACKER_NEW_VERSION", jarURL);
                                TrackerStarter.relaunch(args, false);
                            }
                        }, new Runnable(){

                            @Override
                            public void run() {
                                Upgrader.this.closeUpgradeDialog();
                            }
                        });
                    } else {
                        OSPLog.warning("failed to download new version");
                        failed[0] = true;
                    }
                    if (failed[0]) {
                        Upgrader.this.showDownloadFailure(attempted);
                        Upgrader.this.closeUpgradeDialog();
                        String websiteurl = "https://" + Tracker.trackerWebsite;
                        OSPDesktop.displayURL(websiteurl);
                    }
                }
            };
            new Thread(runner).start();
        }
    }

    private void upgradeOSX(final boolean[] failed) {
        final String dmgFileName = "TrackerUpgrade-" + Tracker.newerVersion + "-osx-installer.dmg";
        final String dmgURL = String.valueOf(this.upgradeURL) + dmgFileName;
        int responseCode = 0;
        try {
            URL url = new URL(dmgURL);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            responseCode = huc.getResponseCode();
        }
        catch (Exception url) {
            // empty catch block
        }
        if (responseCode == 200) {
            File parent;
            File downloadDir = OSPRuntime.getDownloadDir();
            if ((downloadDir = this.chooseDownloadDirectory(this.frame, downloadDir)) == null) {
                return;
            }
            if (!downloadDir.exists() && (parent = downloadDir.getParentFile()) != null && parent.getName().equals(downloadDir.getName())) {
                downloadDir = parent;
            }
            if (!downloadDir.exists()) {
                OSPLog.warning("download directory does not exist: " + downloadDir);
                failed[0] = true;
            } else {
                final File downloads = downloadDir;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        File dmgFile = new File(downloads, dmgFileName);
                        String appName = "TrackerUpgrade-" + Tracker.newerVersion + "-osx-installer.app";
                        Upgrader.this.downloadLabel.setText(String.valueOf(TrackerRes.getString("TTrackBar.Dialog.Relaunch.DownloadLabel.Upgrade.Text")) + " " + dmgFile.getPath() + ".");
                        Upgrader.this.relaunchLabel.setText("");
                        Upgrader.this.upgradeDialog.pack();
                        Upgrader.this.upgradeDialog.setLocationRelativeTo(Upgrader.this.frame);
                        Upgrader.this.upgradeDialog.setVisible(true);
                        String attempted = dmgFile.getPath();
                        dmgFile = ResourceLoader.download(dmgURL, dmgFile, true);
                        if (dmgFile != null && dmgFile.exists()) {
                            String path = dmgFile.getPath();
                            ArrayList<String> cmd = new ArrayList<String>();
                            cmd.add("hdiutil");
                            cmd.add("attach");
                            cmd.add("-noverify");
                            cmd.add("-autoopen");
                            cmd.add(path);
                            try {
                                ProcessBuilder builder = new ProcessBuilder(cmd);
                                Process p = builder.start();
                                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                StringBuilder blder = new StringBuilder();
                                String line = null;
                                while ((line = reader.readLine()) != null) {
                                    blder.append(line);
                                }
                                String output = blder.toString();
                                String[] chunks = output.split("\t");
                                p.waitFor();
                                Upgrader.this.closeUpgradeDialog();
                                if (chunks.length > 1) {
                                    String volume = chunks[chunks.length - 1];
                                    File installer = new File(volume, appName);
                                    cmd = new ArrayList();
                                    cmd.add("open");
                                    cmd.add(installer.getCanonicalPath());
                                    try {
                                        builder = new ProcessBuilder(cmd);
                                        p = builder.start();
                                    }
                                    catch (Exception ex) {
                                        OSPLog.warning("exception: " + ex);
                                        failed[0] = true;
                                    }
                                    p.waitFor();
                                    TrackerPanel trackerPanel = Upgrader.this.frame.getSelectedPanel();
                                    TActions.exitAction(trackerPanel);
                                    return;
                                }
                                OSPLog.warning("failed to mount upgrade installer");
                            }
                            catch (Exception ex) {
                                OSPLog.warning("exception: " + ex);
                            }
                            failed[0] = true;
                        } else {
                            OSPLog.warning("failed to download upgrade installer");
                            failed[0] = true;
                        }
                        if (failed[0]) {
                            Upgrader.this.showDownloadFailure(attempted);
                            Upgrader.this.closeUpgradeDialog();
                            String websiteurl = "https://" + Tracker.trackerWebsite;
                            OSPDesktop.displayURL(websiteurl);
                        }
                    }
                };
                new Thread(runner).start();
            }
        } else {
            OSPLog.warning("no upgrade installer found on server");
            failed[0] = true;
        }
    }

    private void upgradeLinux(final boolean[] failed) {
        final String runFileName = "TrackerUpgrade-" + Tracker.newerVersion + "-linux-x64-installer.run";
        final String fileURL = String.valueOf(this.upgradeURL) + runFileName;
        int responseCode = 0;
        try {
            URL url = new URL(fileURL);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            responseCode = huc.getResponseCode();
        }
        catch (Exception url) {
            // empty catch block
        }
        if (responseCode == 200) {
            File downloadDir = OSPRuntime.getDownloadDir();
            if ((downloadDir = this.chooseDownloadDirectory(this.frame, downloadDir)) == null) {
                return;
            }
            if (!downloadDir.exists()) {
                OSPLog.warning("download directory does not exist: " + downloadDir);
                failed[0] = true;
            } else {
                final File downloads = downloadDir;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        Upgrader.this.downloadLabel.setText(String.valueOf(TrackerRes.getString("TTrackBar.Dialog.Relaunch.DownloadLabel.Upgrade.Text")) + " " + downloads.getPath() + "/" + runFileName + ".");
                        Upgrader.this.relaunchLabel.setText("");
                        FontSizer.setFonts(Upgrader.this.upgradeDialog, FontSizer.getLevel());
                        Upgrader.this.upgradeDialog.pack();
                        Upgrader.this.upgradeDialog.setLocationRelativeTo(Upgrader.this.frame);
                        Upgrader.this.upgradeDialog.setVisible(true);
                        File installer = new File(downloads, runFileName);
                        String attempted = installer.getPath();
                        installer = ResourceLoader.download(fileURL, installer, true);
                        Upgrader.this.closeUpgradeDialog();
                        if (installer != null && installer.exists()) {
                            installer.setExecutable(true, false);
                            final JTextField field = new JTextField(10);
                            field.setBackground(Color.white);
                            field.setEditable(false);
                            field.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mousePressed(MouseEvent e) {
                                    field.selectAll();
                                }
                            });
                            String cmd = "sudo " + installer.getPath();
                            cmd = String.valueOf(cmd) + " --tracker-home " + Tracker.trackerHome;
                            OSPLog.info("execution command: " + cmd);
                            field.setText(cmd);
                            JPanel panel = new JPanel(new BorderLayout());
                            JLabel label1 = new JLabel(TrackerRes.getString("Upgrader.Dialog.Downloaded.Message1"));
                            label1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
                            JLabel label2 = new JLabel(TrackerRes.getString("Upgrader.Dialog.Downloaded.Linux.Message2"));
                            label2.setBorder(BorderFactory.createEmptyBorder(4, 0, 10, 4));
                            JLabel label3 = new JLabel(TrackerRes.getString("Upgrader.Dialog.Downloaded.Linux.Message3"));
                            label3.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 4));
                            Box box = Box.createVerticalBox();
                            box.add(label1);
                            box.add(label2);
                            box.add(field);
                            box.add(label3);
                            panel.add((Component)box, "North");
                            int ans = JOptionPane.showConfirmDialog(Upgrader.this.frame, panel, TrackerRes.getString("TTrackBar.Dialog.Download.Title"), 2, 1);
                            if (ans != 0) {
                                return;
                            }
                            TrackerPanel trackerPanel = Upgrader.this.frame.getSelectedPanel();
                            TActions.exitAction(trackerPanel);
                            return;
                        }
                        OSPLog.warning("failed to download upgrade installer");
                        failed[0] = true;
                        if (failed[0]) {
                            Upgrader.this.showDownloadFailure(attempted);
                            Upgrader.this.closeUpgradeDialog();
                            String websiteurl = "https://" + Tracker.trackerWebsite;
                            OSPDesktop.displayURL(websiteurl);
                        }
                    }
                };
                new Thread(runner).start();
            }
        } else {
            OSPLog.warning("no upgrade installer found on server");
            failed[0] = true;
        }
    }

    private void closeUpgradeDialog() {
        if (this.upgradeDialog != null) {
            this.upgradeDialog.setVisible(false);
            this.upgradeDialog.dispose();
            this.upgradeDialog = null;
        }
    }

    private File chooseDownloadDirectory(Component parent, File likely) {
        JFileChooser chooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                if (this.getSelectedFile().isFile()) {
                    return;
                }
                super.approveSelection();
            }
        };
        chooser.setDialogTitle(TrackerRes.getString("TTrackBar.Chooser.DownloadDirectory"));
        chooser.setFileSelectionMode(1);
        FileFilter folderFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.getName().endsWith(".app")) {
                    return false;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
            }
        };
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(folderFilter);
        chooser.setCurrentDirectory(new File(likely.getParent()));
        chooser.setSelectedFile(likely);
        if (OSPRuntime.isMac()) {
            chooser.updateUI();
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int result = chooser.showDialog(parent, TrackerRes.getString("Dialog.Button.OK"));
        if (result == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    protected String getUpgradeURL() {
        return "https://opensourcephysics.github.io/tracker-website/installers/upgrade/";
    }

    private JDialog getUpgradeDialog() {
        if (this.upgradeDialog == null) {
            this.upgradeDialog = new JDialog((Frame)this.frame, false);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEtchedBorder());
            this.upgradeDialog.setContentPane(panel);
            this.upgradeDialog.setTitle(TrackerRes.getString("TTrackBar.Dialog.Relaunch.Title.Text"));
            Box box = Box.createVerticalBox();
            this.upgradeDialog.getContentPane().add(box);
            this.downloadLabel = new JLabel();
            this.downloadLabel.setBorder(BorderFactory.createEmptyBorder(10, 6, 6, 6));
            box.add(this.downloadLabel);
            this.relaunchLabel = new JLabel();
            this.relaunchLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 16, 6));
        }
        return this.upgradeDialog;
    }

    private void showDownloadFailure(String target) {
        String message = String.valueOf(TrackerRes.getString("Upgrader.Dialog.DownloadFailed.Message")) + " " + target;
        JOptionPane.showMessageDialog(this.frame, message, TrackerRes.getString("Upgrader.Dialog.DownloadFailed.Title"), 0);
    }

    private boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

