/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

public class Vector
extends TTrack {
    protected static final String[] dataVariables = new String[]{"t", "x", "y", "mag", Tracker.THETA, "x_{tail}", "y_{tail}", "step", "frame"};
    protected static final String[] formatVariables = new String[]{"t", "xy", Tracker.THETA};
    protected static final String[] fieldVariables = new String[]{"t", "x", "y", "mag", Tracker.THETA};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected JMenuItem tailsToOriginItem = new JMenuItem();
    protected JCheckBoxMenuItem labelsVisibleItem;
    protected static final Map<Integer, Boolean> visMap;

    static {
        formatMap.put("t", new String[]{"t"});
        formatMap.put("xy", new String[]{"x", "y", "mag", "x_{tail}", "y_{tail}"});
        formatMap.put(Tracker.THETA, new String[]{Tracker.THETA});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put("t", TrackerRes.getString("Vector.Data.Description.0"));
        formatDescriptionMap.put("xy", TrackerRes.getString("Vector.Description.Magnitudes"));
        formatDescriptionMap.put(Tracker.THETA, TrackerRes.getString("Vector.Data.Description.4"));
        allVariables = Vector.createAllVariables(dataVariables, null);
        visMap = new HashMap<Integer, Boolean>();
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "Vector";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (vars[1].equals(variable) || vars[2].equals(variable) || vars[3].equals(variable) || vars[5].equals(variable) || vars[6].equals(variable) || names[1].equals(variable)) {
            return "L";
        }
        if (vars[7].equals(variable) || vars[8].equals(variable)) {
            return "I";
        }
        return null;
    }

    public Vector() {
        super(9);
        this.defaultColors = new Color[]{Color.magenta, Color.cyan, Color.blue, Color.red};
        this.setFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setTrailVisible(true);
        this.setAutoAdvance(true);
        this.setName(TrackerRes.getString("Vector.New.Name"));
        this.setProperty("xVarPlot0", dataVariables[0]);
        this.setProperty("yVarPlot0", dataVariables[1]);
        this.setProperty("xVarPlot1", dataVariables[0]);
        this.setProperty("yVarPlot1", dataVariables[2]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("Vector.Unmarked.Hint");
        this.magLabel.setText("mag");
        AbstractAction xyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector.this.setXYComponents();
                ((NumberField)e.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter xyFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Vector.this.setXYComponents();
            }
        };
        AbstractAction magAngleAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector.this.setMagnitudeAngle();
                ((NumberField)e.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter magAngleFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Vector.this.setMagnitudeAngle();
            }
        };
        this.xField.addActionListener(xyAction);
        this.yField.addActionListener(xyAction);
        this.xField.addFocusListener(xyFocusListener);
        this.yField.addFocusListener(xyFocusListener);
        this.magField.addActionListener(magAngleAction);
        this.angleField.addActionListener(magAngleAction);
        this.magField.addFocusListener(magAngleFocusListener);
        this.angleField.addFocusListener(magAngleFocusListener);
        this.tailsToOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TPoint p = Vector.this.tp.getSnapPoint();
                Step[] steps = Vector.this.getSteps();
                int i = 0;
                while (i < steps.length) {
                    if (steps[i] != null) {
                        VectorStep v = (VectorStep)steps[i];
                        if (v.chain != null) {
                            v.chain.clear();
                        }
                        v.attach(null);
                        v.attach(p);
                    }
                    ++i;
                }
                Vector.this.tp.repaint();
            }
        });
        this.labelsVisibleItem = new JCheckBoxMenuItem(TrackerRes.getString("Vector.MenuItem.Label"));
        this.labelsVisibleItem.setSelected(true);
        this.labelsVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Step[] steps = Vector.this.getSteps();
                int i = 0;
                while (i < steps.length) {
                    if (steps[i] != null) {
                        VectorStep step = (VectorStep)steps[i];
                        step.setLabelVisible(Vector.this.labelsVisibleItem.isSelected());
                        step.erase();
                    }
                    ++i;
                }
                Vector.this.repaint();
            }
        });
    }

    @Override
    public Step createStep(int n, double x, double y) {
        VectorStep step = (VectorStep)this.getStep(n);
        if (step == null) {
            return this.createStep(n, x, y, 0.0, 0.0);
        }
        XMLControlElement state = new XMLControlElement(step);
        step.tip.setXY(x, y);
        Undo.postStepEdit(step, state);
        return step;
    }

    public Step createStep(int n, double x, double y, double xc, double yc) {
        if (this.locked) {
            return null;
        }
        VectorStep step = (VectorStep)this.getStep(n);
        step = new VectorStep(this, n, x, y, xc, yc, 0);
        step.setFirePropertyChangeEvents(true);
        this.steps.setStep(n, step);
        step.setFootprint(this.getFootprint());
        this.firePropertyChange("step", HINT_STEP_ADDED_OR_REMOVED, new Integer(n));
        return step;
    }

    @Override
    public int getStepLength() {
        return VectorStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 2;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (panel instanceof TrackerPanel) {
            if (!this.isVectorsVisible((TrackerPanel)panel)) {
                return;
            }
            super.draw(panel, _g);
        }
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            VectorStep step = (VectorStep)steps[i];
            if (step != null) {
                step.setTipEnabled(!this.isLocked());
            }
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "adjusting": {
                this.refreshDataLater = (Boolean)e.getNewValue();
                if (this.refreshDataLater) break;
                this.firePropertyChange("data", null, null);
            }
        }
        super.propertyChange(e);
    }

    @Override
    protected void setMarking(boolean marking) {
        super.setMarking(marking);
        this.repaint(this.tp.getID());
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel) {
        if (this.refreshDataLater || trackerPanel == null || data == null) {
            return;
        }
        this.dataFrames.clear();
        VideoPlayer player = trackerPanel.getPlayer();
        VideoClip clip = player.getVideoClip();
        ImageCoordSystem coords = trackerPanel.getCoords();
        int count = 8;
        Step[] stepArray = this.getSteps();
        int len = stepArray.length;
        double[][] validData = new double[count + 1][len];
        int pt = 0;
        int i = 0;
        while (i < len) {
            int frame;
            VectorStep step = (VectorStep)stepArray[i];
            if (step != null && clip.includesFrame(frame = step.getFrameNumber())) {
                double t;
                int n;
                int stepNumber = clip.frameToStep(frame);
                if (!(player.getStepTime(n) < 0.0) && !((t = player.getStepTime(stepNumber) / 1000.0) < 0.0)) {
                    double xcomp = step.getXComponent();
                    double ycomp = step.getYComponent();
                    double wxc = coords.imageToWorldXComponent(frame, xcomp, ycomp);
                    double wyc = coords.imageToWorldYComponent(frame, xcomp, ycomp);
                    Point2D tailPosition = step.getTail().getWorldPosition(trackerPanel);
                    validData[0][pt] = wxc;
                    validData[1][pt] = wyc;
                    validData[2][pt] = Math.sqrt(wxc * wxc + wyc * wyc);
                    validData[3][pt] = Math.atan2(wyc, wxc);
                    validData[4][pt] = tailPosition.getX();
                    validData[5][pt] = tailPosition.getY();
                    validData[6][pt] = stepNumber;
                    validData[7][pt] = frame;
                    validData[8][pt] = t;
                    this.dataFrames.add(frame);
                    ++pt;
                }
            }
            ++i;
        }
        this.clearColumns(data, count, dataVariables, "Vector.Data.Description.", validData, pt);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = super.findInteractive(panel, xpix, ypix);
        if (ia == null) {
            TPoint p = this.tp.getSelectedPoint();
            if (p != null) {
                if (p instanceof VectorStep.Handle) {
                    this.partName = TrackerRes.getString("Vector.Handle.Name");
                    this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                    this.hint = TrackerRes.getString("Vector.HandleSelected.Hint");
                } else {
                    this.partName = TrackerRes.getString("Vector.Tip.Name");
                    this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                    this.hint = TrackerRes.getString("Vector.TipSelected.Hint");
                }
            } else {
                this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = this.getStep(this.tp.getFrameNumber()) == null ? TrackerRes.getString("Vector.Unmarked.Hint") : TrackerRes.getString("Vector.Remark.Hint");
            }
            return null;
        }
        if (ia instanceof VectorStep.Handle) {
            VectorStep.Handle handle = (VectorStep.Handle)ia;
            this.partName = TrackerRes.getString("Vector.Handle.Name");
            this.hint = handle.isShort() ? TrackerRes.getString("Vector.ShortHandle.Hint") : TrackerRes.getString("Vector.Handle.Hint");
        } else {
            this.partName = TrackerRes.getString("Vector.Tip.Name");
            this.hint = TrackerRes.getString("Vector.Tip.Hint");
        }
        return ia;
    }

    public void setLabelsVisible(boolean visible) {
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            VectorStep step = (VectorStep)steps[i];
            if (step != null) {
                step.setLabelVisible(visible);
                step.setRolloverVisible(!visible);
            }
            ++i;
        }
    }

    public boolean isLabelsVisible() {
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            VectorStep step = (VectorStep)steps[i];
            if (step != null) {
                return step.isLabelVisible();
            }
            ++i;
        }
        return false;
    }

    public void setVectorsVisible(TrackerPanel panel, boolean visible) {
        Step step;
        if (visible == this.isVectorsVisible(panel)) {
            return;
        }
        visMap.put(panel.getID(), visible);
        if (!visible && (step = panel.getSelectedStep()) != null && step == this.getStep(step.getFrameNumber())) {
            panel.setSelectedPoint(null);
            panel.selectedSteps.clear();
        }
    }

    public boolean isVectorsVisible(TrackerPanel trackerPanel) {
        Boolean vis = visMap.get((trackerPanel = trackerPanel.getMainPanel()).getID());
        if (vis == null) {
            vis = Boolean.TRUE;
            visMap.put(trackerPanel.getID(), vis);
        }
        return vis;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        if (trackerPanel.isEnabled("track.delete")) {
            this.removeDeleteTrackItem(menu);
        }
        if (trackerPanel.isEnabled("track.autoAdvance") || trackerPanel.isEnabled("track.markByDefault")) {
            TMenuBar.checkAddMenuSep(menu);
            if (trackerPanel.isEnabled("track.autoAdvance")) {
                menu.add(this.autoAdvanceItem);
            }
            if (trackerPanel.isEnabled("track.markByDefault")) {
                menu.add(this.markByDefaultItem);
            }
        }
        TMenuBar.checkAddMenuSep(menu);
        this.tailsToOriginItem.setText(TrackerRes.getString("Vector.MenuItem.ToOrigin"));
        menu.add(this.tailsToOriginItem);
        if (trackerPanel.isEnabled("track.delete")) {
            TMenuBar.checkAddMenuSep(menu);
            TPoint p = trackerPanel.getSelectedPoint();
            Step step = this.getStep(p, trackerPanel);
            this.deleteStepItem.setEnabled(step != null);
            menu.add(this.deleteStepItem);
            menu.add(this.clearStepsItem);
            menu.add(this.deleteTrackItem);
        }
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        return list;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        this.xLabel.setText(dataVariables[1]);
        this.yLabel.setText(dataVariables[2]);
        this.magLabel.setText(dataVariables[3]);
        this.angleLabel.setText(dataVariables[4]);
        this.xField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
        this.yField.setUnits(trackerPanel.getUnits(this, dataVariables[2]));
        this.magField.setUnits(trackerPanel.getUnits(this, dataVariables[3]));
        ArrayList<Component> list = super.getToolbarPointComponents(trackerPanel, point);
        list.add(this.stepSeparator);
        list.add(this.stepLabel);
        list.add(this.stepValueLabel);
        list.add(this.tSeparator);
        list.add(this.xLabel);
        list.add(this.xField);
        list.add(this.xSeparator);
        list.add(this.yLabel);
        list.add(this.yField);
        list.add(this.ySeparator);
        list.add(this.magLabel);
        list.add(this.magField);
        list.add(this.magSeparator);
        list.add(this.angleLabel);
        list.add(this.angleField);
        list.add(this.angleSeparator);
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
        this.magField.setEnabled(!this.isLocked());
        this.angleField.setEnabled(!this.isLocked());
        return list;
    }

    @Override
    public String toString() {
        return String.valueOf(TrackerRes.getString("Vector.Name")) + " \"" + this.name + "\"";
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        if (this.numberFields.isEmpty()) {
            this.numberFields.put(dataVariables[0], new NumberField[]{this.tField});
            this.numberFields.put(dataVariables[1], new NumberField[]{this.xField});
            this.numberFields.put(dataVariables[2], new NumberField[]{this.yField});
            this.numberFields.put(dataVariables[3], new NumberField[]{this.magField});
            this.numberFields.put(dataVariables[4], new NumberField[]{this.angleField});
        }
        return this.numberFields;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private void setXYComponents() {
        TPoint p = this.tp.getSelectedPoint();
        VectorStep step = (VectorStep)this.getStep(p, this.tp);
        if (step != null) {
            ImageCoordSystem coords = this.tp.getCoords();
            int n = this.tp.getFrameNumber();
            double x = coords.worldToImageXComponent(n, this.xField.getValue(), this.yField.getValue());
            double y = coords.worldToImageYComponent(n, this.xField.getValue(), this.yField.getValue());
            step.setXYComponents(x, y);
            x = coords.imageToWorldXComponent(n, step.getXComponent(), step.getYComponent());
            y = coords.imageToWorldYComponent(n, step.getXComponent(), step.getYComponent());
            this.xField.setValue(x);
            this.yField.setValue(y);
            this.magField.setValue(Math.sqrt(x * x + y * y));
            double theta = Math.atan2(y, x);
            this.angleField.setValue(theta);
            p.showCoordinates(this.tp);
        }
    }

    private void setMagnitudeAngle() {
        double theta = this.angleField.getValue();
        double xval = this.magField.getValue() * Math.cos(theta);
        double yval = this.magField.getValue() * Math.sin(theta);
        TPoint p = this.tp.getSelectedPoint();
        VectorStep step = (VectorStep)this.getStep(p, this.tp);
        if (step != null) {
            ImageCoordSystem coords = this.tp.getCoords();
            int n = this.tp.getFrameNumber();
            double x = coords.worldToImageXComponent(n, xval, yval);
            double y = coords.worldToImageYComponent(n, xval, yval);
            step.setXYComponents(x, y);
            x = coords.imageToWorldXComponent(n, step.getXComponent(), step.getYComponent());
            y = coords.imageToWorldYComponent(n, step.getXComponent(), step.getYComponent());
            this.xField.setValue(x);
            this.yField.setValue(y);
            this.magField.setValue(Math.sqrt(x * x + y * y));
            theta = Math.atan2(y, x);
            this.angleField.setValue(theta);
            p.showCoordinates(this.tp);
        }
    }

    public static class FrameData {
        double x;
        double y;
        double xc;
        double yc;
        boolean independent;

        FrameData() {
        }

        FrameData(VectorStep v, boolean dependent) {
            this.x = v.getTail().getX();
            this.y = v.getTail().getY();
            this.xc = v.getXComponent();
            this.yc = v.getYComponent();
            this.independent = !dependent;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            control.setValue("xtail", data.x);
            control.setValue("ytail", data.y);
            if (data.independent) {
                control.setValue("xcomponent", data.xc);
                control.setValue("ycomponent", data.yc);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            double x = control.getDouble("xcomponent");
            if (!Double.isNaN(x)) {
                data.xc = x;
                data.yc = control.getDouble("ycomponent");
            }
            data.x = control.getDouble("xtail");
            data.y = control.getDouble("ytail");
            return obj;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Vector vec = (Vector)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            Step[] steps = vec.getSteps();
            FrameData[] data = new FrameData[steps.length];
            int n = 0;
            while (n < steps.length) {
                if (steps[n] != null) {
                    VectorStep v = (VectorStep)steps[n];
                    data[n] = new FrameData(v, vec.isDependent());
                }
                ++n;
            }
            control.setValue("framedata", data);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Vector();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Vector vec = (Vector)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            FrameData[] data = (FrameData[])control.getObject("framedata");
            if (data != null) {
                boolean locked = vec.isLocked();
                vec.setLocked(false);
                int n = 0;
                while (n < data.length) {
                    if (data[n] == null) {
                        vec.steps.setStep(n, null);
                    } else {
                        vec.createStep(n, data[n].x, data[n].y, data[n].xc, data[n].yc);
                    }
                    ++n;
                }
                vec.setLocked(locked);
            }
            return obj;
        }
    }
}

