/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensourcephysics.cabrillo.tracker.VectorStep;

public class VectorChain
extends ArrayList<VectorStep> {
    protected VectorChain(VectorStep start) {
        if (this.isAllowed(start)) {
            start.chain = this;
            super.add(start);
        }
    }

    public VectorChain(VectorStep start, VectorStep end) {
        if (this.isAllowed(start) && this.isAllowed(end)) {
            start.chain = this;
            super.add(start);
            this.add(end);
        }
    }

    public VectorStep getEnd() {
        return (VectorStep)this.get(this.size() - 1);
    }

    public VectorStep getStart() {
        return (VectorStep)this.get(0);
    }

    public VectorStep removeEnd() {
        if (this.size() == 0) {
            return null;
        }
        VectorStep end = this.getEnd();
        end.chain = null;
        end.attach(null);
        super.remove(this.size() - 1);
        return end;
    }

    public VectorChain breakAt(VectorStep vector) {
        if (vector.chain != this || vector == this.getStart()) {
            return null;
        }
        if (vector == this.getEnd()) {
            this.removeEnd();
            return null;
        }
        ArrayList<VectorStep> list = this.remove(vector);
        VectorChain chain = new VectorChain(vector);
        int i = 1;
        while (i < list.size()) {
            chain.add(list.get(i));
            ++i;
        }
        return chain;
    }

    @Override
    public void clear() {
        for (VectorStep link : this) {
            link.chain = null;
            link.attach(null);
        }
        super.clear();
    }

    @Override
    public boolean add(VectorStep vector) {
        if (vector.getChain() != null) {
            return this.add(vector.getChain());
        }
        if (this.isAllowed(vector)) {
            VectorStep end = this.getEnd();
            vector.attach(end.getVisibleTip());
            vector.chain = this;
            super.add(vector);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(VectorChain chain) {
        if (chain == this) {
            return false;
        }
        ArrayList<VectorStep> vectors = chain.remove(chain.getStart());
        this.addAll((Collection<? extends VectorStep>)vectors);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends VectorStep> c) {
        boolean added = false;
        Iterator<? extends VectorStep> it = c.iterator();
        while (it.hasNext()) {
            boolean bl = added = this.add(it.next()) || added;
        }
        return added;
    }

    @Override
    public void add(int index, VectorStep v) {
    }

    @Override
    public VectorStep remove(int index) {
        return null;
    }

    @Override
    public boolean remove(Object obj) {
        return false;
    }

    @Override
    public void removeRange(int from, int to) {
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends VectorStep> c) {
        return false;
    }

    @Override
    public VectorStep set(int index, VectorStep obj) {
        return null;
    }

    protected boolean isAllowed(VectorStep vector) {
        if (vector.getChain() != null) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        Class<?> endClass = this.getEnd().getTrack().getClass();
        return endClass.equals(vector.getTrack().getClass());
    }

    protected ArrayList<VectorStep> remove(VectorStep vector) {
        ArrayList<VectorStep> list = new ArrayList<VectorStep>();
        int length = this.size();
        int i = this.indexOf(vector);
        while (i < length) {
            list.add(0, this.removeEnd());
            ++i;
        }
        return list;
    }
}

