/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.VectorChain;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class VectorStep
extends Step
implements PropertyChangeListener {
    protected static boolean pointSnapEnabled = true;
    protected static boolean vectorSnapEnabled = true;
    protected static double snapDistance = 8.0;
    private static Map<Integer, List<VectorStep>> vectors = new HashMap<Integer, List<VectorStep>>();
    protected TPoint tipPoint = new TPoint();
    protected TPoint tailPoint = new TPoint();
    protected TPoint tail;
    protected TPoint tip;
    protected TPoint middle;
    protected Handle handle;
    protected VisibleTip visibleTip;
    protected int dx;
    protected int dy;
    protected boolean tipEnabled = true;
    protected Map<Integer, Shape> tipShapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> shaftShapes = new HashMap<Integer, Shape>();
    protected TPoint attachmentPoint;
    protected VectorChain chain;
    protected boolean brandNew = true;
    protected boolean firePropertyChangeEvents = false;
    protected boolean labelVisible = true;
    protected boolean rolloverVisible = false;
    protected boolean valid;
    protected Map<Integer, OSPRuntime.TextLayout> textLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
    protected Map<Integer, Rectangle> layoutBounds = new HashMap<Integer, Rectangle>();

    public VectorStep(TTrack track, int n, double x, double y, double xc, double yc) {
        this(track, n, x, y, xc, yc, 0);
    }

    public VectorStep(TTrack track, int n, double x, double y, double xc, double yc, int type) {
        super(track, n);
        this.type = type;
        this.tail = new Handle(x, y);
        this.middle = new TPoint(x, y){

            @Override
            public int getFrameNumber(VideoPanel vidPanel) {
                return VectorStep.this.n;
            }
        };
        this.tip = new Tip(x, y);
        this.handle = new Handle(x, y);
        this.handle.setStepEditTrigger(true);
        this.visibleTip = new VisibleTip(x, y);
        this.points = new TPoint[]{this.tip, this.tail, this.handle, this.visibleTip, this.middle};
        this.screenPoints = new Point[VectorStep.getLength()];
        this.tip.setLocation(x + xc, y + yc);
    }

    public TPoint getTip() {
        return this.tip;
    }

    public TPoint getTail() {
        return this.tail;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public TPoint getVisibleTip() {
        return this.visibleTip;
    }

    public void setXComponent(double x) {
        this.tip.setX(this.tail.getX() + x);
    }

    public void setYComponent(double y) {
        this.tip.setY(this.tail.getY() + y);
    }

    public void setXYComponents(double x, double y) {
        this.tip.setXY(this.tail.getX() + x, this.tail.getY() + y);
    }

    public double getXComponent() {
        return this.tip.getX() - this.tail.getX();
    }

    public double getYComponent() {
        return this.tip.getY() - this.tail.getY();
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean visible) {
        this.labelVisible = visible;
    }

    public boolean isRolloverVisible() {
        return this.rolloverVisible;
    }

    public void setRolloverVisible(boolean visible) {
        this.rolloverVisible = visible;
    }

    public static void setPointSnapEnabled(boolean enabled) {
        pointSnapEnabled = enabled;
    }

    public static boolean isPointSnapEnabled() {
        return pointSnapEnabled;
    }

    public static void setVectorSnapEnabled(boolean enabled) {
        vectorSnapEnabled = enabled;
    }

    public static boolean isVectorSnapEnabled() {
        return vectorSnapEnabled;
    }

    public void snap(TrackerPanel trackerPanel) {
        TPoint p = null;
        if (pointSnapEnabled) {
            TTrack track = this.getTrack();
            if (track.ttype == 5 && (p = ((PositionStep)track.getStep(this.n)).getPosition()).distance(this.tail) < snapDistance) {
                this.attach(p);
                return;
            }
            p = trackerPanel.getSnapPoint();
            CoordAxes axes = trackerPanel.getAxes();
            if ((this.brandNew || axes != null && axes.isVisible()) && p.distance(this.tail) < snapDistance) {
                this.attach(p);
                return;
            }
        }
        if (vectorSnapEnabled) {
            if (this.getTrack() instanceof VectorSum) {
                return;
            }
            List<VectorStep> c = vectors.get(trackerPanel.getID());
            if (c != null) {
                int i = 0;
                int n = c.size();
                while (i < n) {
                    VectorStep vec = c.get(i);
                    if (vec.valid && vec != this && this.getTrack().isStepVisible(vec, trackerPanel) && !((p = vec.getVisibleTip()).distance(this.tail) > snapDistance)) {
                        VectorChain chain = vec.getChain();
                        if (chain == null) {
                            chain = new VectorChain(vec);
                            chain.add(this);
                            break;
                        }
                        if (chain.getEnd() == vec) {
                            chain.add(this);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public VectorChain getChain() {
        return this.chain;
    }

    public void attach(TPoint pt) {
        if (this.attachmentPoint != null) {
            this.attachmentPoint.removePropertyChangeListener(this);
        }
        this.attachmentPoint = pt;
        if (pt != null) {
            pt.addPropertyChangeListener(this);
            if (pt.getX() != this.tail.getX() || pt.getY() != this.tail.getY()) {
                this.tail.setXY(pt.getX(), pt.getY());
            }
        }
    }

    public TPoint getAttachmentPoint() {
        return this.attachmentPoint;
    }

    public void setTipEnabled(boolean enabled) {
        this.tipEnabled = enabled;
    }

    public boolean isTipEnabled() {
        return this.tipEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (panel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)panel;
            Graphics2D g = (Graphics2D)_g;
            if (this.brandNew && !trackerPanel.isWorldPanel()) {
                this.snap(trackerPanel);
                this.brandNew = false;
            }
            super.draw(trackerPanel, g);
            List<VectorStep> c = vectors.get(trackerPanel.getID());
            if (c == null) {
                c = new ArrayList<VectorStep>();
                vectors.put(trackerPanel.getID(), c);
            }
            if (!c.contains(this)) {
                c.add(this);
            }
            if (this.labelVisible) {
                OSPRuntime.TextLayout layout = this.textLayouts.get(trackerPanel.getID());
                Point p = this.getLayoutPosition(trackerPanel, layout);
                Paint gpaint = g.getPaint();
                Font gfont = g.getFont();
                g.setPaint(this.footprint.getColor());
                g.setFont(TFrame.textLayoutFont);
                layout.draw(g, p.x, p.y);
                g.setPaint(gpaint);
                g.setFont(gfont);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        Point origin = trackerPanel.getSnapPoint().getScreenPosition(trackerPanel);
        if (hitRect.contains(origin)) {
            return null;
        }
        Shape hitShape = this.shaftShapes.get(trackerPanel.getID());
        if (hitShape != null && hitShape.intersects(hitRect)) {
            if (this.rolloverVisible && !this.labelVisible) {
                this.labelVisible = true;
                this.repaint();
            }
            if (!trackerPanel.getMouseEvent().isAltDown() && !trackerPanel.getMouseEvent().isShiftDown()) {
                return this.handle;
            }
        }
        if (this.tipEnabled && (hitShape = this.tipShapes.get(trackerPanel.getID())) != null && hitShape.intersects(hitRect)) {
            return this.visibleTip;
        }
        if (this.rolloverVisible && this.labelVisible) {
            this.labelVisible = false;
            this.repaint();
        }
        return null;
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            VideoClip clip;
            WorldTView.WorldPanel world;
            this.tip.setLocation(this.tip.getX(), this.tip.getY());
            this.middle.center(this.visibleTip, this.tail);
            selection = trackerPanel.getSelectedPoint();
            Point p = null;
            this.valid = true;
            int n = 0;
            while (n < this.points.length) {
                this.valid = this.valid && !Double.isNaN(this.points[n].getX()) && !Double.isNaN(this.points[n].getY());
                this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                if (selection == this.points[n]) {
                    p = this.screenPoints[n];
                }
                ++n;
            }
            if (trackerPanel.isWorldPanel() && this.attachmentPoint == (world = (WorldTView.WorldPanel)trackerPanel).getSnapPoint()) {
                Point origin = world.getSnapPoint().getScreenPosition(world);
                this.dx = origin.x - this.screenPoints[1].x;
                this.dy = origin.y - this.screenPoints[1].y;
                int n2 = 0;
                while (n2 < this.screenPoints.length) {
                    this.screenPoints[n2].x += this.dx;
                    this.screenPoints[n2].y += this.dy;
                    ++n2;
                }
                if (p != null) {
                    p.x += this.dx;
                    p.y += this.dy;
                }
            }
            TrackerPanel panel = trackerPanel.getMainPanel();
            boolean xMass = panel.getToolBar((boolean)true).xMassButton.isSelected();
            TTrack track = this.getTrack();
            String s = String.valueOf(track.getName()) + " ";
            if (track.ttype == 5) {
                PointMass m = (PointMass)track;
                if (m.isVelocity(this)) {
                    s = xMass ? String.valueOf(TrackerRes.getString("VectorStep.Label.Momentum")) + " " : String.valueOf(TrackerRes.getString("VectorStep.Label.Velocity")) + " ";
                } else if (m.isAcceleration(this)) {
                    String string = s = xMass ? String.valueOf(TrackerRes.getString("VectorStep.Label.NetForce")) + " " : String.valueOf(TrackerRes.getString("VectorStep.Label.Acceleration")) + " ";
                }
            }
            if ((clip = trackerPanel.getPlayer().getVideoClip()).getStepCount() != 1) {
                s = String.valueOf(s) + clip.frameToStep(this.getFrameNumber());
            }
            OSPRuntime.TextLayout layout = new OSPRuntime.TextLayout(s, TFrame.textLayoutFont);
            this.textLayouts.put(trackerPanel.getID(), layout);
            Point lp = this.getLayoutPosition(trackerPanel, layout);
            Rectangle bounds = this.layoutBounds.get(trackerPanel.getID());
            if (bounds == null) {
                bounds = new Rectangle();
                this.layoutBounds.put(trackerPanel.getID(), bounds);
            }
            Rectangle2D rect = layout.getBounds();
            bounds.setRect(lp.x, (double)lp.y - rect.getHeight(), rect.getWidth(), rect.getHeight());
            mark = this.footprint.getMark(this.screenPoints);
            if (p != null) {
                transform.setToTranslation(p.x, p.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                final Color color = this.footprint.getColor();
                final Mark stepMark = mark;
                final MultiShape selectedShape = new MultiShape(transform.createTransformedShape(selectionShape)).andStroke(selectionStroke);
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        stepMark.draw(g, highlighted);
                        Paint gpaint = g.getPaint();
                        g.setPaint(color);
                        selectedShape.draw(g);
                        g.setPaint(gpaint);
                    }
                };
            }
            final Mark theMark = mark;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    if (!VectorStep.this.valid) {
                        return;
                    }
                    theMark.draw(g, highlighted);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
            if (this.valid) {
                Shape[] shapes = this.footprint.getHitShapes();
                this.tipShapes.put(trackerPanel.getID(), shapes[0]);
                this.shaftShapes.put(trackerPanel.getID(), shapes[2]);
            }
        }
        return mark;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.attachmentPoint) {
            this.tail.setXY(this.attachmentPoint.getX(), this.attachmentPoint.getY());
        }
    }

    public void setFirePropertyChangeEvents(boolean fireEvents) {
        this.firePropertyChangeEvents = fireEvents;
    }

    @Override
    public VectorStep clone() {
        VectorStep step = (VectorStep)super.clone();
        if (step != null) {
            TPoint[] tPointArray = step.points;
            VectorStep vectorStep = step;
            vectorStep.getClass();
            tPointArray[0] = step.tip = vectorStep.new Tip(this.tip.getX(), this.tip.getY());
            TPoint[] tPointArray2 = step.points;
            VectorStep vectorStep2 = step;
            vectorStep2.getClass();
            tPointArray2[1] = step.tail = vectorStep2.new Handle(this.tail.getX(), this.tail.getY());
            TPoint[] tPointArray3 = step.points;
            VectorStep vectorStep3 = step;
            vectorStep3.getClass();
            step.handle = vectorStep3.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray3[2] = step.handle;
            TPoint[] tPointArray4 = step.points;
            VectorStep vectorStep4 = step;
            vectorStep4.getClass();
            step.visibleTip = vectorStep4.new VisibleTip(this.visibleTip.getX(), this.visibleTip.getY());
            tPointArray4[3] = step.visibleTip;
            step.points[4] = step.middle = new TPoint(this.middle.getX(), this.middle.getY()){

                @Override
                public int getFrameNumber(VideoPanel vidPanel) {
                    return VectorStep.this.n;
                }
            };
            step.tipShapes = new HashMap<Integer, Shape>();
            step.shaftShapes = new HashMap<Integer, Shape>();
            step.textLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
            step.layoutBounds = new HashMap<Integer, Rectangle>();
            step.setFirePropertyChangeEvents(this.firePropertyChangeEvents);
        }
        return step;
    }

    @Override
    public String toString() {
        return "VectorStep " + this.n + " [" + format.format(this.tail.x) + ", " + format.format(this.tail.y) + ", " + format.format(this.getXComponent()) + ", " + format.format(this.getYComponent()) + "]";
    }

    private Point getLayoutPosition(TrackerPanel trackerPanel, OSPRuntime.TextLayout layout) {
        Point p = this.middle.getScreenPosition(trackerPanel);
        if (trackerPanel.isWorldPanel() && this.attachmentPoint == ((WorldTView.WorldPanel)trackerPanel).getSnapPoint()) {
            p.x += this.dx;
            p.y += this.dy;
        }
        Rectangle2D bounds = layout.getBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.tipPoint.setLocation(this.tip);
        this.tailPoint.setLocation(this.tail);
        if (!trackerPanel.isDrawingInImageSpace()) {
            AffineTransform at = trackerPanel.getCoords().getToWorldTransform(this.n);
            at.transform(this.tipPoint, this.tipPoint);
            this.tipPoint.y = -this.tipPoint.y;
            at.transform(this.tailPoint, this.tailPoint);
            this.tailPoint.y = -this.tailPoint.y;
        }
        double cos = this.tailPoint.cos(this.tipPoint);
        double sin = this.tailPoint.sin(this.tipPoint);
        double d = 4.0 + Math.abs(w * sin / 2.0) + Math.abs(h * cos / 2.0);
        if (cos >= 0.0) {
            p.setLocation((int)((double)p.x - d * sin - w / 2.0), (int)((double)p.y - d * cos + h / 2.0));
        } else {
            p.setLocation((int)((double)p.x + d * sin - w / 2.0), (int)((double)p.y + d * cos + h / 2.0));
        }
        return p;
    }

    public static int getLength() {
        return 5;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class Handle
    extends Step.Handle {
        public Handle(double x, double y) {
            super(x, y);
            this.setStepEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            double dx = x - this.getX();
            double dy = y - this.getY();
            VectorStep.this.tail.setLocation(VectorStep.this.tail.getX() + dx, VectorStep.this.tail.getY() + dy);
            VectorStep.this.tip.setLocation(VectorStep.this.tip.getX() + dx, VectorStep.this.tip.getY() + dy);
            this.setLocation(x, y);
            if (VectorStep.this.attachmentPoint != null && VectorStep.this.attachmentPoint.distance(VectorStep.this.tail) > 1.0) {
                if (VectorStep.this.chain != null && VectorStep.this.attachmentPoint instanceof VisibleTip) {
                    VectorStep.this.chain.breakAt(VectorStep.this);
                } else {
                    VectorStep.this.attach(null);
                }
            }
            if (VectorStep.this.firePropertyChangeEvents) {
                VectorStep.this.getTrack().firePropertyChange("step", null, new Integer(VectorStep.this.n));
            }
            VectorStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return VectorStep.this.n;
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            VectorStep.this.tip.showCoordinates(vidPanel);
            super.showCoordinates(vidPanel);
        }

        public void snap(TrackerPanel trackerPanel) {
            VectorStep.this.snap(trackerPanel);
        }

        @Override
        public void setPositionOnLine(int xScreen, int yScreen, TrackerPanel trackerPanel) {
            this.setPositionOnLine(xScreen, yScreen, trackerPanel, VectorStep.this.visibleTip, VectorStep.this.tail);
            VectorStep.this.repaint();
        }

        public boolean isShort() {
            return VectorStep.this.tip.distanceSq(VectorStep.this.tail) < 25.0;
        }

        @Override
        public boolean isStepEditTrigger() {
            if (VectorStep.this.getTrack().ttype == 5) {
                return false;
            }
            return super.isStepEditTrigger();
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            boolean snap;
            VectorStep step = (VectorStep)obj;
            boolean bl = snap = step.attachmentPoint != null;
            if (snap) {
                control.setValue("snap", snap);
            }
            control.setValue("xtail", step.getTail().x);
            control.setValue("ytail", step.getTail().y);
            TTrack track = step.getTrack();
            if (track.ttype != 5 && !track.isDependent()) {
                control.setValue("xtip", step.getTip().x);
                control.setValue("ytip", step.getTip().y);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            VectorStep step = (VectorStep)obj;
            double x = control.getDouble("xtail");
            double y = control.getDouble("ytail");
            step.getTail().setXY(x, y);
            TTrack track = step.getTrack();
            if (track.ttype != 5 && !track.isDependent()) {
                x = control.getDouble("xtip");
                y = control.getDouble("ytip");
                step.getTip().setXY(x, y);
            }
            if (control.getBoolean("snap")) {
                step.snap(step.getTrack().tp);
            }
            return obj;
        }
    }

    class Tip
    extends TPoint {
        public Tip(double x, double y) {
            super(x, y);
        }

        @Override
        public void setLocation(double x, double y) {
            super.setLocation(x, y);
            VectorStep.this.visibleTip.setVisibleTipLocation();
        }

        @Override
        public void setXY(double x, double y) {
            TTrack track = VectorStep.this.getTrack();
            if (track.isLocked()) {
                return;
            }
            super.setXY(x, y);
            if (VectorStep.this.firePropertyChangeEvents) {
                track.firePropertyChange("step", null, new Integer(VectorStep.this.n));
            }
            VectorStep.this.repaint();
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            vidPanel.hideMouseBox();
            ImageCoordSystem coords = vidPanel.getCoords();
            double x = coords.imageToWorldXComponent(VectorStep.this.n, VectorStep.this.getXComponent(), VectorStep.this.getYComponent());
            double y = coords.imageToWorldYComponent(VectorStep.this.n, VectorStep.this.getXComponent(), VectorStep.this.getYComponent());
            TTrack track = VectorStep.this.getTrack();
            if (track.ttype == 5) {
                TrackerPanel trackerPanel = (TrackerPanel)vidPanel;
                PointMass m = (PointMass)track;
                if (m.isVelocity(VectorStep.this)) {
                    double dt = vidPanel.getPlayer().getStepTime(1) / 1000.0;
                    x /= dt;
                    y /= dt;
                } else if (m.isAcceleration(VectorStep.this)) {
                    double dt = vidPanel.getPlayer().getStepTime(1) / 1000.0;
                    x /= dt * dt;
                    y /= dt * dt;
                }
                if (trackerPanel.getToolBar((boolean)true).xMassButton.isSelected()) {
                    x = m.getMass() * x;
                    y = m.getMass() * y;
                }
            }
            NumberField[] fields = track.getNumberFieldsForStep(VectorStep.this);
            fields[0].setValue(x);
            fields[1].setValue(y);
            fields[2].setValue(Math.sqrt(x * x + y * y));
            double theta = Math.atan2(y, x);
            fields[3].setValue(theta);
            super.showCoordinates(vidPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return VectorStep.this.n;
        }
    }

    class VisibleTip
    extends TPoint {
        public VisibleTip(double x, double y) {
            super(x, y);
            this.setStepEditTrigger(true);
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            VectorStep.this.tip.showCoordinates(vidPanel);
            super.showCoordinates(vidPanel);
        }

        public VectorStep getStep() {
            return VectorStep.this;
        }

        public void setVisibleTipLocation() {
            double stretch = 1.0;
            if (VectorStep.this.footprint instanceof ArrowFootprint) {
                ArrowFootprint arrow = (ArrowFootprint)VectorStep.this.footprint;
                stretch = arrow.getStretch();
            }
            double x = VectorStep.this.getTail().getX() + stretch * (VectorStep.this.getTip().getX() - VectorStep.this.getTail().getX());
            double y = VectorStep.this.getTail().getY() + stretch * (VectorStep.this.getTip().getY() - VectorStep.this.getTail().getY());
            this.setLocation(x, y);
        }

        @Override
        public void setXY(double x, double y) {
            double stretch = 1.0;
            if (VectorStep.this.footprint instanceof ArrowFootprint) {
                ArrowFootprint arrow = (ArrowFootprint)VectorStep.this.footprint;
                stretch = arrow.getStretch();
            }
            double xx = VectorStep.this.getTail().getX() + (x - VectorStep.this.getTail().getX()) / stretch;
            double yy = VectorStep.this.getTail().getY() + (y - VectorStep.this.getTail().getY()) / stretch;
            VectorStep.this.tip.setXY(xx, yy);
        }

        @Override
        public void setLocation(double x, double y) {
            int i;
            super.setLocation(x, y);
            VectorChain chain = VectorStep.this.chain;
            if (chain != null && (i = chain.indexOf(VectorStep.this)) < chain.size() - 1) {
                VectorStep vec = (VectorStep)chain.get(i + 1);
                vec.getTail().setXY(x, y);
                return;
            }
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return VectorStep.this.n;
        }
    }
}

