/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.VectorSumInspector;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;

public class VectorSum
extends Vector {
    protected Vector[] vectors;
    protected ArrayList<String> vectorNames = new ArrayList();
    protected JMenuItem inspectorItem;
    protected Map<Integer, TPoint> tails = new HashMap<Integer, TPoint>();
    protected VectorSumInspector inspector;

    public VectorSum() {
        this(new Vector[0]);
    }

    public VectorSum(Vector[] vectors) {
        this.defaultColors = new Color[]{new Color(51, 204, 51)};
        this.setName(TrackerRes.getString("VectorSum.New.Name"));
        this.setFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.defaultFootprint = this.getFootprint();
        Footprint[] footprint = this.getFootprints();
        int i = 0;
        while (i < footprint.length) {
            if (footprint[i] instanceof ArrowFootprint) {
                ArrowFootprint arrow = (ArrowFootprint)footprint[i];
                arrow.setDashArray(LineFootprint.DASHED_LINE);
            }
            ++i;
        }
        this.vectors = vectors;
        this.setColor(this.defaultColors[0]);
        i = 0;
        while (i < vectors.length) {
            vectors[i].addPropertyChangeListener("step", this);
            ++i;
        }
        this.locked = true;
        if (vectors.length == 0) {
            this.hint = TrackerRes.getString("VectorSum.Empty.Hint");
        }
        this.update();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (!this.initialized) {
            this.initialize((TrackerPanel)panel);
        }
        super.draw(panel, _g);
    }

    @Override
    public void initialize(TrackerPanel panel) {
        if (this.initialized) {
            return;
        }
        int i = 0;
        int ni = this.vectorNames.size();
        while (i < ni) {
            String name = this.vectorNames.get(i);
            Vector v = this.tp.getTrackByName(Vector.class, name);
            if (v != null) {
                this.addVector(v);
            }
            ++i;
        }
        this.vectorNames.clear();
        this.initialized = true;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = super.findInteractive(panel, xpix, ypix);
        this.hint = ia instanceof VectorStep.Handle ? TrackerRes.getString("Vector.Handle.Hint") : (this.vectors.length == 0 ? TrackerRes.getString("CenterOfMass.Empty.Hint") : null);
        return ia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVector(Vector vec) {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            int i = 0;
            while (i < this.vectors.length) {
                if (this.vectors[i] == vec) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Vector[] newVectors = new Vector[this.vectors.length + 1];
            System.arraycopy(this.vectors, 0, newVectors, 0, this.vectors.length);
            newVectors[this.vectors.length] = vec;
            this.vectors = newVectors;
            vec.addPropertyChangeListener("step", this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVector(Vector vec) {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            int i = 0;
            while (i < this.vectors.length) {
                if (this.vectors[i] == vec) {
                    vec.removePropertyChangeListener("step", this);
                    Vector[] newVectors = new Vector[this.vectors.length - 1];
                    System.arraycopy(this.vectors, 0, newVectors, 0, i);
                    System.arraycopy(this.vectors, i + 1, newVectors, i, newVectors.length - i);
                    this.vectors = newVectors;
                    break;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector[] getVectors() {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Vector[])this.vectors.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Vector vec) {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            int i = 0;
            while (true) {
                if (i >= this.vectors.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (this.vectors[i] == vec) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++i;
            }
        }
    }

    @Override
    public Step createStep(int n, double x, double y, double xc, double yc) {
        if (this.isLocked()) {
            this.tails.put(new Integer(n), new TPoint(x, y));
            this.update(n);
            return this.getStep(n);
        }
        return super.createStep(n, x, y, xc, yc);
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        if (this.inspector != null && this.inspector.isVisible()) {
            this.inspector.setVisible(true);
        }
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public boolean isStepComplete(int n) {
        return true;
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("track", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("track", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "track": {
                if (e.getOldValue() == null) break;
                TTrack track = (TTrack)e.getOldValue();
                if (track.ttype != 9) break;
                this.removeVector((Vector)track);
                break;
            }
            case "step": {
                if (!(e.getSource() instanceof Vector)) break;
                int n = (Integer)e.getNewValue();
                this.update(n);
                return;
            }
        }
        super.propertyChange(e);
    }

    @Override
    public void dispose() {
        super.dispose();
        Vector[] vectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            Vector v = vectorArray[n2];
            if (v != null) {
                v.removePropertyChangeListener("step", this);
            }
            ++n2;
        }
        this.vectors = new Vector[0];
        if (this.inspector != null) {
            this.inspector.dispose();
        }
    }

    private void update() {
        int length = this.getSteps().length;
        int n = 0;
        while (n < length) {
            this.update(n);
            ++n;
        }
    }

    private void update(int n) {
        if (this.vectors.length == 0) {
            this.locked = false;
            VectorStep deletedStep = (VectorStep)this.deleteStep(n);
            if (deletedStep != null) {
                deletedStep.attach(null);
                this.repaintStep(deletedStep);
            }
            this.locked = true;
            return;
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < this.vectors.length) {
            VectorStep step = (VectorStep)this.vectors[i].getStep(n);
            if (step == null) {
                if (this.getStep(n) != null) {
                    this.locked = false;
                    VectorStep deletedStep = (VectorStep)this.deleteStep(n);
                    this.tails.put(new Integer(n), deletedStep.getTail());
                    deletedStep.attach(null);
                    this.repaintStep(deletedStep);
                    this.locked = true;
                }
                return;
            }
            x += step.getXComponent();
            y += step.getYComponent();
            ++i;
        }
        VectorStep step = (VectorStep)this.getStep(n);
        if (step == null) {
            this.locked = false;
            VectorStep newStep = null;
            Integer i2 = new Integer(n);
            TPoint tail = this.tails.get(i2);
            if (tail != null) {
                newStep = (VectorStep)this.createStep(n, tail.getX(), tail.getY(), x, y);
                this.tails.remove(i2);
            } else {
                newStep = (VectorStep)this.createStep(n, 0.0, 0.0, x, y);
                newStep.attach(this.tp.getSnapPoint());
            }
            newStep.setTipEnabled(false);
            newStep.setDefaultPointIndex(2);
            this.repaintStep(newStep);
            this.locked = true;
        } else {
            this.locked = false;
            step.setXYComponents(x, y);
            this.locked = true;
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        this.inspectorItem = new JMenuItem(TrackerRes.getString("VectorSum.MenuItem.Inspector"));
        this.inspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorSumInspector inspector = VectorSum.this.getInspector();
                inspector.updateDisplay();
                inspector.setVisible(true);
            }
        });
        return this.assembleMenu(super.getMenu(trackerPanel, menu0), this.inspectorItem);
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        ArrayList<Component> list = super.getToolbarPointComponents(trackerPanel, point);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        return list;
    }

    @Override
    public String toString() {
        return String.valueOf(TrackerRes.getString("VectorSum.Name")) + " \"" + this.name + "\"";
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public VectorSumInspector getInspector() {
        if (this.inspector == null) {
            this.inspector = new VectorSumInspector(this);
            this.inspector.setLocation(200, 200);
        }
        return this.inspector;
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            VectorSum sum = (VectorSum)obj;
            ArrayList<String> list = new ArrayList<String>();
            Vector[] vectors = sum.getVectors();
            int i = 0;
            while (i < vectors.length) {
                list.add(vectors[i].getName());
                ++i;
            }
            control.setValue("vectors", list);
            XML.getLoader(Vector.class).saveObject(control, obj);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new VectorSum();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            VectorSum sum = (VectorSum)obj;
            XML.getLoader(Vector.class).loadObject(control, obj);
            ArrayList names = (ArrayList)ArrayList.class.cast(control.getObject("vectors"));
            Iterator it = names.iterator();
            while (it.hasNext()) {
                sum.vectorNames.add(it.next().toString());
            }
            return obj;
        }
    }
}

