/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.tools.FontSizer;

public class VectorSumInspector
extends JDialog
implements PropertyChangeListener {
    protected TFrame frame;
    protected Integer panelID;
    protected VectorSum sum;
    protected JButton okButton;
    protected JPanel mainPanel;
    protected JPanel checkboxPanel;
    protected JPanel sumPanel;
    protected ActionListener listener;
    protected boolean isVisible;

    public VectorSumInspector(VectorSum sum) {
        super(JOptionPane.getFrameForComponent(sum.tp), false);
        this.sum = sum;
        this.frame = sum.tframe;
        this.panelID = sum.tp.getID();
        if (this.panelID != null) {
            sum.tp.addPropertyChangeListener("track", this);
            if (this.frame != null) {
                this.frame.addPropertyChangeListener("tab", this);
            }
        }
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorSumInspector.this.updateSum();
            }
        };
        this.setTitle(String.valueOf(TrackerRes.getString("VectorSumInspector.Title")) + " \"" + sum.getName() + "\"");
        this.setResizable(false);
        this.createGUI();
        this.initialize();
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            FontSizer.setFonts(this, FontSizer.getLevel());
            this.pack();
        }
        super.setVisible(vis);
        this.isVisible = vis;
    }

    public void initialize() {
        this.updateDisplay();
    }

    @Override
    public void dispose() {
        this.checkboxPanel.removeAll();
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            trackerPanel.removePropertyChangeListener("track", this);
            ArrayList<Vector> list = trackerPanel.getDrawablesTemp(Vector.class);
            int k = 0;
            int n = list.size();
            while (k < n) {
                list.get(k).removeListenerNCF(this);
                ++k;
            }
            list.clear();
            if (this.frame != null) {
                this.frame.removePropertyChangeListener("tab", this);
            }
            this.panelID = null;
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("tab")) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            if (!this.frame.isRemovingAll() && trackerPanel != null && e.getNewValue() == trackerPanel) {
                this.setVisible(this.isVisible);
            } else {
                boolean vis = this.isVisible;
                this.setVisible(false);
                this.isVisible = vis;
            }
        } else {
            this.updateDisplay();
        }
    }

    protected void updateDisplay() {
        this.setTitle(String.valueOf(TrackerRes.getString("VectorSumInspector.Title")) + " \"" + this.sum.getName() + "\"");
        this.checkboxPanel.removeAll();
        ArrayList<Vector> list = this.frame.getTrackerPanelForID(this.panelID).getDrawablesTemp(Vector.class);
        int k = 0;
        int n = list.size();
        while (k < n) {
            Vector v = list.get(k);
            v.removeListenerNCF(this);
            v.addListenerNCF(this);
            if (!(v instanceof VectorSum)) {
                JCheckBoxMenuItem checkbox = new JCheckBoxMenuItem(v.getName(), v.getFootprint().getIcon(21, 16));
                if (this.sum.contains(v)) {
                    checkbox.setSelected(true);
                }
                checkbox.addActionListener(this.listener);
                this.checkboxPanel.add(checkbox);
            }
            ++k;
        }
        list.clear();
        FontSizer.setFonts(this.checkboxPanel, FontSizer.getLevel());
        this.pack();
        TFrame.repaintT(this);
    }

    private void createGUI() {
        JPanel inspectorPanel = new JPanel(new BorderLayout());
        this.setContentPane(inspectorPanel);
        this.mainPanel = new JPanel(new GridLayout(1, 0));
        Border etched = BorderFactory.createEtchedBorder();
        TitledBorder title = BorderFactory.createTitledBorder(etched, TrackerRes.getString("VectorSumInspector.Border.Title"));
        this.mainPanel.setBorder(title);
        inspectorPanel.add((Component)this.mainPanel, "Center");
        this.checkboxPanel = new JPanel(new GridLayout(0, 1));
        this.mainPanel.add(this.checkboxPanel);
        this.sumPanel = new JPanel(new GridLayout(0, 2));
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorSumInspector.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel(new GridLayout(1, 3));
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        inspectorPanel.add((Component)buttonbar, "South");
        Box box = Box.createHorizontalBox();
        buttonbar.add(box);
        buttonbar.add(this.okButton);
        box = Box.createHorizontalBox();
        buttonbar.add(box);
    }

    private void updateSum() {
        Component[] checkboxes = this.checkboxPanel.getComponents();
        int i = 0;
        while (i < checkboxes.length) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i];
            Vector v = this.getVector(checkbox.getActionCommand());
            if (checkbox.isSelected() && !this.sum.contains(v)) {
                this.sum.addVector(v);
                v.setVisible(true);
            }
            if (!checkbox.isSelected() && this.sum.contains(v)) {
                this.sum.removeVector(v);
            }
            ++i;
        }
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            if (trackerPanel.getSelectedTrack() == this.sum && trackerPanel.getSelectedPoint() != null) {
                trackerPanel.getSelectedPoint().showCoordinates(trackerPanel);
            }
            TFrame.repaintT(trackerPanel);
        }
    }

    private Vector getVector(String name) {
        return this.panelID == null ? null : this.frame.getTrackerPanelForID(this.panelID).getTrackByName(Vector.class, name);
    }
}

