/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;

public class WorldGrid
implements Trackable {
    private static final float[] DASHED_LINE = new float[]{1.0f, 8.0f};
    private static final float[] DOTTED_LINE = new float[]{2.0f, 2.0f};
    private static Stroke dashed;
    private static Stroke dotted;
    private static int defaultAlpha;
    private static Color defaultColor;
    ArrayList<Line2D> dashedLines = new ArrayList();
    ArrayList<Line2D> dottedLines = new ArrayList();
    TPoint[] viewCorners = new TPoint[]{new TPoint(), new TPoint(), new TPoint(), new TPoint()};
    Point2D[] worldCorners = new Point2D[4];
    TPoint[] lineEnds = new TPoint[]{new TPoint(), new TPoint()};
    double[] minMaxWorldValues = new double[4];
    int[] minMaxIndices = new int[4];
    boolean showMajorX = true;
    boolean showMinorX = true;
    boolean showMajorY = true;
    boolean showMinorY = true;
    private int alpha = defaultAlpha;
    private Color lineColor = defaultColor;
    private boolean visible;

    static {
        defaultAlpha = 128;
        defaultColor = new Color(128, 128, 128, defaultAlpha);
    }

    public WorldGrid() {
        dashed = new BasicStroke(2.0f, 0, 0, 8.0f, DASHED_LINE, 0.0f);
        dotted = new BasicStroke(2.0f, 0, 0, 8.0f, DOTTED_LINE, 0.0f);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible || !this.showMajorX && !this.showMajorY) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.getMark(trackerPanel).draw(g2, false);
    }

    protected Mark getMark(TrackerPanel trackerPanel) {
        Line2D.Double line;
        ArrayList<Line2D> lines;
        boolean isMajor;
        int n = trackerPanel.getFrameNumber();
        double xOrigin = trackerPanel.getCoords().getOriginX(n);
        double yOrigin = trackerPanel.getCoords().getOriginY(n);
        double xWorldOrigin = trackerPanel.getCoords().imageToWorldX(n, xOrigin, yOrigin);
        double yWorldOrigin = trackerPanel.getCoords().imageToWorldY(n, xOrigin, yOrigin);
        Rectangle rect = trackerPanel.getVisibleRect();
        int i = 0;
        while (i < 4) {
            switch (i) {
                case 0: {
                    this.viewCorners[i].setScreenPosition(rect.x, rect.y, trackerPanel);
                    break;
                }
                case 1: {
                    this.viewCorners[i].setScreenPosition(rect.x + rect.width, rect.y, trackerPanel);
                    break;
                }
                case 2: {
                    this.viewCorners[i].setScreenPosition(rect.x, rect.y + rect.height, trackerPanel);
                    break;
                }
                default: {
                    this.viewCorners[i].setScreenPosition(rect.x + rect.width, rect.y + rect.height, trackerPanel);
                }
            }
            this.worldCorners[i] = this.viewCorners[i].getWorldPosition(trackerPanel);
            if (i == 0) {
                this.minMaxWorldValues[0] = this.minMaxWorldValues[1] = this.worldCorners[i].getX();
                this.minMaxWorldValues[2] = this.minMaxWorldValues[3] = this.worldCorners[i].getY();
            } else {
                this.minMaxWorldValues[0] = Math.min(this.minMaxWorldValues[0], this.worldCorners[i].getX());
                this.minMaxWorldValues[1] = Math.max(this.minMaxWorldValues[1], this.worldCorners[i].getX());
                this.minMaxWorldValues[2] = Math.min(this.minMaxWorldValues[2], this.worldCorners[i].getY());
                this.minMaxWorldValues[3] = Math.max(this.minMaxWorldValues[3], this.worldCorners[i].getY());
            }
            ++i;
        }
        int lineCount = Math.min(60, rect.width / 25);
        double delta = (this.minMaxWorldValues[1] - this.minMaxWorldValues[0]) / (double)lineCount;
        double pow = 1.0;
        while (pow * 10.0 < delta) {
            pow *= 10.0;
        }
        while (pow > delta) {
            pow /= 10.0;
        }
        double significand = delta / pow;
        int minorSpacing = 10;
        int majorSpacing = 100;
        if (significand < 2.0) {
            minorSpacing = 2;
            majorSpacing = 10;
        } else if (significand < 5.0) {
            minorSpacing = 5;
            majorSpacing = 10;
        }
        delta = (double)minorSpacing * pow;
        int i2 = 0;
        while (i2 < 4) {
            this.minMaxIndices[i2] = (int)(this.minMaxWorldValues[i2] / delta);
            ++i2;
        }
        this.dashedLines.clear();
        this.dottedLines.clear();
        if (this.showMajorX) {
            i2 = this.minMaxIndices[0] - 1;
            while (i2 < this.minMaxIndices[1] + 1) {
                boolean bl = isMajor = i2 * minorSpacing % majorSpacing == 0;
                if (isMajor || this.showMinorX) {
                    lines = isMajor ? this.dottedLines : this.dashedLines;
                    double x = (double)i2 * delta;
                    line = new Line2D.Double();
                    lines.add(line);
                    this.lineEnds[0].setWorldPosition(x, yWorldOrigin, trackerPanel);
                    this.lineEnds[1].setWorldPosition(x, this.minMaxWorldValues[3], trackerPanel);
                    line.setLine(this.lineEnds[0].getScreenPosition(trackerPanel), this.lineEnds[1].getScreenPosition(trackerPanel));
                    line = new Line2D.Double();
                    lines.add(line);
                    this.lineEnds[1].setWorldPosition(x, this.minMaxWorldValues[2], trackerPanel);
                    line.setLine(this.lineEnds[0].getScreenPosition(trackerPanel), this.lineEnds[1].getScreenPosition(trackerPanel));
                }
                ++i2;
            }
        }
        if (this.showMajorY) {
            i2 = this.minMaxIndices[2] - 1;
            while (i2 < this.minMaxIndices[3] + 1) {
                boolean bl = isMajor = i2 * minorSpacing % majorSpacing == 0;
                if (isMajor || this.showMinorY) {
                    lines = isMajor ? this.dottedLines : this.dashedLines;
                    double y = (double)i2 * delta;
                    line = new Line2D.Double();
                    lines.add(line);
                    this.lineEnds[0].setWorldPosition(xWorldOrigin, y, trackerPanel);
                    this.lineEnds[1].setWorldPosition(this.minMaxWorldValues[0], y, trackerPanel);
                    line.setLine(this.lineEnds[0].getScreenPosition(trackerPanel), this.lineEnds[1].getScreenPosition(trackerPanel));
                    line = new Line2D.Double();
                    lines.add(line);
                    this.lineEnds[1].setWorldPosition(this.minMaxWorldValues[1], y, trackerPanel);
                    line.setLine(this.lineEnds[0].getScreenPosition(trackerPanel), this.lineEnds[1].getScreenPosition(trackerPanel));
                }
                ++i2;
            }
        }
        Shape[] dashLines = this.dashedLines.toArray(new Line2D[this.dashedLines.size()]);
        Object[] dashStrokes = new Stroke[dashLines.length];
        Arrays.fill(dashStrokes, dashed);
        final MultiShape dashMultiShape = new MultiShape(dashLines).andStroke((Stroke[])dashStrokes);
        Shape[] dotLines = this.dottedLines.toArray(new Line2D[this.dottedLines.size()]);
        Object[] dotStrokes = new Stroke[dotLines.length];
        Arrays.fill(dotStrokes, dotted);
        final MultiShape dotMultiShape = new MultiShape(dotLines).andStroke((Stroke[])dotStrokes);
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setPaint(WorldGrid.this.lineColor);
                if (OSPRuntime.setRenderingHints) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                dashMultiShape.draw(g2);
                dotMultiShape.draw(g2);
                g2.dispose();
            }
        };
    }

    public Color getColor() {
        return this.lineColor;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.lineColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        alpha = Math.min(alpha, 255);
        this.alpha = alpha = Math.max(alpha, 0);
        this.setColor(this.lineColor);
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isCustom() {
        return !defaultColor.equals(this.lineColor);
    }

    public void setMajorXGridVisible(boolean visible) {
        this.showMajorX = visible;
    }

    public void setMinorXGridVisible(boolean visible) {
        this.showMinorX = visible;
    }

    public void setMajorYGridVisible(boolean visible) {
        this.showMajorY = visible;
    }

    public void setMinorYGridVisible(boolean visible) {
        this.showMinorY = visible;
    }
}

