/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.Ruler;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class WorldRuler
extends Ruler {
    private static final int DEFAULT_DROPEND_SIZE = 12;
    private static final int MIN_RULER_LABEL_SPACING = 50;
    private HashMap<Integer, Line2D> hitLines = new HashMap();
    private int dropEndSize = 12;

    public WorldRuler(TapeMeasure tape) {
        super(tape);
        this.setLineSpacing(8.0);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel, int n) {
        if (trackerPanel.isWorldPanel()) {
            return null;
        }
        this.refreshStrokes();
        this.format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        TPoint pt0 = this.track.getStep(n).getPoints()[0];
        TPoint pt1 = this.track.getStep(n).getPoints()[1];
        double length = pt0.distance(pt1);
        double tapeSin = pt0.sin(pt1);
        double tapeCos = pt0.cos(pt1);
        Point screen0 = pt0.getScreenPosition(trackerPanel);
        Point screen1 = pt1.getScreenPosition(trackerPanel);
        double screenLength = screen0.distance(screen1);
        Point2D world0 = pt0.getWorldPosition(trackerPanel);
        Point2D world1 = pt1.getWorldPosition(trackerPanel);
        double worldLength = world0.distance(world1);
        double zoomFactor = trackerPanel.getXPixPerUnit();
        double delta = this.rulerLineSpacing / (zoomFactor * this.track.tp.getCoords().getScaleX(n));
        double power = 1.0;
        while (power * 10.0 < delta) {
            power *= 10.0;
        }
        while (power > delta) {
            power /= 10.0;
        }
        double significand = delta / power;
        int spacing = significand <= 2.0 ? 2 : (significand <= 5.0 ? 5 : 10);
        delta = (double)spacing * power;
        int majorSpacing = spacing == 2 ? 25 : 10;
        int halfSpacing = spacing == 5 ? 2 : 5;
        int i = 0;
        while (i < this.lines.size()) {
            ((ArrayList)this.lines.get(i)).clear();
            ++i;
        }
        this.labelMarks.clear();
        int inset = this.rulerSize > 0.0 ? this.insetPerLevel : -this.insetPerLevel;
        int gap = this.rulerSize > 0.0 ? this.lineGap : -this.lineGap;
        double formatMinValue = (double)majorSpacing * delta;
        double coordsCos = this.track.tp.getCoords().getCosine(n);
        double coordsSin = this.track.tp.getCoords().getSine(n);
        int prevLabelIndex = 0;
        double factor = FontSizer.getFactor();
        int lineCount = (int)Math.round(worldLength / delta) + 1;
        int i2 = 0;
        while (i2 < lineCount) {
            int level;
            int n2 = i2 % majorSpacing == 0 ? 0 : (level = i2 % halfSpacing == 0 ? 1 : 2);
            if (lineCount - 1 < majorSpacing && level > 0) {
                --level;
                formatMinValue = (double)halfSpacing * delta;
            }
            ArrayList drawLines = (ArrayList)this.lines.get(level);
            double lineLength = this.rulerSize - (double)(inset * level);
            double x = world0.getX() + (double)i2 * delta * coordsCos;
            double y = world0.getY() - (double)i2 * delta * coordsSin;
            Line2D.Double line = new Line2D.Double();
            drawLines.add(line);
            this.utilityPoint.setWorldPosition(x, y, trackerPanel);
            Point base = this.utilityPoint.getScreenPosition(trackerPanel);
            boolean isLineFootprint = this.track.getFootprint().getClass() == LineFootprint.class;
            int drop = this.rulerSize > 0.0 ? this.dropEndSize : -this.dropEndSize;
            double bottom = i2 == 0 && isLineFootprint ? base.y + drop : base.y - gap;
            ((Line2D)line).setLine(base.x, bottom, base.x, (double)(base.y - gap) - lineLength);
            if (level == 0) {
                double screenDelta = (double)(i2 - prevLabelIndex) * delta * screenLength / worldLength;
                if (i2 == 0 || screenDelta > factor * 50.0) {
                    String s = this.getFormattedValue((double)i2 * delta, formatMinValue);
                    s = String.valueOf(s) + trackerPanel.getUnits(this.track, TapeMeasure.dataVariables[1]);
                    double offset = this.rulerSize > 0.0 ? (double)gap + lineLength + factor * (double)this.labelGap : (double)gap + lineLength - factor * (double)this.labelGap;
                    Ruler.Label label = new Ruler.Label(s, base.x, (double)base.y - offset);
                    label.rotation = tapeCos < 0.0 ? Double.valueOf(Math.PI) : null;
                    this.labelMarks.add(label);
                    prevLabelIndex = i2;
                }
            }
            if (i2 == lineCount - 1 && isLineFootprint) {
                line = new Line2D.Double();
                ((ArrayList)this.lines.get(0)).add(line);
                x = world0.getX() + worldLength * coordsCos;
                y = world0.getY() - worldLength * coordsSin;
                this.utilityPoint.setWorldPosition(x, y, trackerPanel);
                base = this.utilityPoint.getScreenPosition(trackerPanel);
                ((Line2D)line).setLine(base.x, base.y + drop, base.x, base.y);
            }
            ++i2;
        }
        Line2D hitLine = this.getHitLine(n);
        double hitDistScreen = this.rulerSize >= 0.0 ? (double)this.lineGap + this.rulerSize : this.rulerSize - (double)this.lineGap;
        this.utilityPoint.setWorldPosition(world0.getX(), world0.getY(), trackerPanel);
        Point base = this.utilityPoint.getScreenPosition(trackerPanel);
        hitLine.setLine(base.x, (double)base.y - hitDistScreen, (double)base.x + screenLength, (double)base.y - hitDistScreen);
        Shape hitDrawShape = (Shape)hitLine.clone();
        Point p = pt0.getScreenPosition(trackerPanel);
        double theta = pt0.angle(pt1);
        this.transform.setToRotation(theta, p.x, p.y);
        double hitDist = hitDistScreen * length / screenLength;
        this.utilityPoint.setLocation(pt0.x - hitDist * tapeSin, pt0.y - hitDist * tapeCos);
        p.setLocation(this.utilityPoint.getScreenPosition(trackerPanel));
        this.utilityPoint.setLocation(pt1.x - hitDist * tapeSin, pt1.y - hitDist * tapeCos);
        hitLine.setLine(p, this.utilityPoint.getScreenPosition(trackerPanel));
        int i3 = 0;
        while (i3 < this.lines.size()) {
            ArrayList drawLines = (ArrayList)this.lines.get(i3);
            Shape[] lineArray = drawLines.toArray(new Line2D[drawLines.size()]);
            Object[] lineStrokes = new Stroke[lineArray.length];
            Arrays.fill(lineStrokes, this.strokes[i3]);
            this.multiShapes[i3] = new MultiShape(lineArray).andStroke((Stroke[])lineStrokes).transform(this.transform);
            ++i3;
        }
        final MultiShape hitMultiShape = new MultiShape(hitDrawShape).andStroke(this.dashedStroke).transform(this.transform);
        final MultiShape[] myShapes = Arrays.copyOf(this.multiShapes, this.multiShapes.length);
        final AffineTransform myTransform = new AffineTransform(this.transform);
        final Ruler.Label[] myLabels = this.labelMarks.toArray(new Ruler.Label[this.labelMarks.size()]);
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Graphics2D g2 = (Graphics2D)g.create();
                if (OSPRuntime.setRenderingHints) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                int i = 0;
                while (i < myShapes.length) {
                    g2.setPaint(WorldRuler.this.colors[i]);
                    myShapes[i].draw(g2);
                    ++i;
                }
                g2.setPaint(WorldRuler.this.colors[0]);
                if (WorldRuler.this.hitShapeVisible) {
                    hitMultiShape.draw(g2);
                }
                AffineTransform t = g2.getTransform();
                t.concatenate(myTransform);
                g2.setTransform(t);
                int i2 = 0;
                while (i2 < myLabels.length) {
                    myLabels[i2].draw(g2);
                    ++i2;
                }
                g2.dispose();
            }
        };
    }

    private Line2D getHitLine(int frameNumber) {
        Line2D hitLine = this.hitLines.get(frameNumber);
        if (hitLine == null) {
            hitLine = new Line2D.Double();
            this.hitLines.put(frameNumber, hitLine);
        }
        return hitLine;
    }

    @Override
    protected Interactive findInteractive(TrackerPanel trackerPanel, Rectangle hitRect) {
        Ruler.Handle hit = null;
        int n = trackerPanel.getFrameNumber();
        if (this.getHitLine(n).intersects(hitRect)) {
            hit = this.getHandle();
        }
        return hit;
    }

    @Override
    protected void setHandleXY(double x, double y) {
        Ruler.Handle handle = this.getHandle();
        handle.setLocation(x, y);
        if (this.track.tp != null && this.track.tp.getSelectedPoint() == handle) {
            int n = this.track.tp.getFrameNumber();
            Point p = new Point(handle.getScreenPosition(this.track.tp));
            double dist = this.getScreenDistanceToBase(p);
            boolean isLeft = this.isLeft(this.track.getStep(n).getPoints()[0], this.track.getStep(this.track.tp.getFrameNumber()).getPoints()[1], handle);
            this.setRulerSize(isLeft ? (double)this.lineGap - dist : dist - (double)this.lineGap);
            Point2D end = this.getHitLine(n).getP1();
            dist = p.distance(end);
            if (this.previousDistFromLineEnd == null) {
                this.previousDistFromLineEnd = dist;
                this.previousLineSpacing = this.rulerLineSpacing;
                this.previousAngle = Math.atan2((double)p.y - end.getY(), (double)p.x - end.getX());
            } else {
                double delta = dist - this.previousDistFromLineEnd;
                double angle = Math.atan2((double)p.y - end.getY(), (double)p.x - end.getX());
                if (Math.abs(angle - this.previousAngle) > 1.0) {
                    delta = -delta;
                }
                this.setLineSpacing(this.previousLineSpacing + (double)((int)(delta / 3.0)));
            }
            this.track.repaint();
        }
    }
}

