/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.PencilScene;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMat;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.ZoomTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class WorldTView
extends ZoomTView {
    protected static final Icon WORLDVIEW_ICON = Tracker.getResourceIcon("axes.gif", true);
    private static final String[] panelProps = new String[]{"size", "stepnumber", "video", "image", "videovisible", "magnification", "transform", "data"};
    protected static final double ZOOM_MIN = 0.25;
    protected static final double ZOOM_MAX = 8.0;
    private static Point viewLoc = new Point();
    private static Point mousePtRelativeToViewRect = new Point();
    private Integer worldPanelID;
    protected JLabel worldViewLabel;
    protected TButton zoomButton;
    private AbstractAction zoomAction;

    public WorldTView(TrackerPanel panel) {
        super(new WorldPanel(panel));
        WorldPanel worldPanel = (WorldPanel)super.getTrackerPanel();
        this.worldPanelID = worldPanel.getID();
        worldPanel.view = this;
        Icon zoomIcon = Tracker.getResourceIcon("zoom.gif", true);
        this.zoomAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle rect = WorldTView.this.scrollPane.getViewport().getViewRect();
                WorldTView.this.zoomCenter.setLocation(rect.x + rect.width / 2, rect.y + rect.height / 2);
                String name = e.getActionCommand();
                if (name.equals("auto")) {
                    WorldTView.this.worldPanel().setMagnification(-1.0);
                } else {
                    double mag = Double.parseDouble(name);
                    WorldTView.this.worldPanel().setMagnification(mag / 100.0);
                }
            }
        };
        this.zoomButton = new TButton(zoomIcon){

            @Override
            protected JPopupMenu getPopup() {
                return WorldTView.this.refreshZoomPopup(new JPopupMenu());
            }
        };
        this.worldViewLabel = new JLabel();
        this.worldViewLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 0));
        this.toolbarComponents.add(this.worldViewLabel);
        this.toolbarComponents.add(Box.createHorizontalStrut(8));
        this.toolbarComponents.add(this.zoomButton);
    }

    @Override
    protected boolean doResized() {
        if (!super.doResized()) {
            return false;
        }
        TrackerPanel trackerPanel = this.worldPanel().getMainPanel();
        trackerPanel.eraseAll();
        this.refreshZoomButton();
        TFrame.repaintT(this.worldPanel());
        return true;
    }

    @Override
    protected void doMouseDragged(MouseEvent e) {
        Rectangle rect = this.scrollPane.getViewport().getViewRect();
        Dimension dim = new Dimension();
        this.scrollPane.getViewport().getView().getSize(dim);
        int dx = WorldTView.mousePtRelativeToViewRect.x - e.getPoint().x + rect.x;
        int dy = WorldTView.mousePtRelativeToViewRect.y - e.getPoint().y + rect.y;
        if (e.isAltDown()) {
            this.zoomCenter.setLocation(e.getPoint());
            boolean zoomed = false;
            if (dy - dx > 4) {
                this.zoomIn(true);
                zoomed = true;
            } else if (dx - dy > 4) {
                this.zoomOut(true);
                zoomed = true;
            }
            if (zoomed) {
                viewLoc.setLocation(rect.getLocation());
                mousePtRelativeToViewRect.setLocation(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
            }
            return;
        }
        int x = Math.max(0, WorldTView.viewLoc.x + dx);
        x = Math.min(x, dim.width - rect.width);
        int y = Math.max(0, WorldTView.viewLoc.y + dy);
        y = Math.min(y, dim.height - rect.height);
        if (x != rect.x || y != rect.y) {
            this.worldPanel().setMouseCursor(Tracker.grabCursor);
            rect.x = x;
            rect.y = y;
            this.worldPanel().scrollRectToVisible(rect);
        } else {
            viewLoc.setLocation(rect.getLocation());
            mousePtRelativeToViewRect.setLocation(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
        }
    }

    @Override
    protected void doMouseReleased(MouseEvent e) {
        this.worldPanel().setMouseCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected void doMousePressed(MouseEvent e) {
        this.zoomCenter.setLocation(e.getPoint());
        Rectangle rect = this.scrollPane.getViewport().getViewRect();
        this.worldPanel().setMouseCursor(Tracker.grabCursor);
        viewLoc.setLocation(rect.getLocation());
        mousePtRelativeToViewRect.setLocation(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
    }

    @Override
    protected void refreshZoomButton() {
        Runnable runner = new Runnable(){

            @Override
            public synchronized void run() {
                if (WorldTView.this.worldPanel() == null) {
                    return;
                }
                WorldTView.this.scrollPane.getViewport().setView(WorldTView.this.worldPanel());
                Dimension full = WorldTView.this.worldPanel().getFullSize();
                Dimension dim = WorldTView.this.worldPanel().getSize();
                double zoom = Math.min(100 * dim.height / full.height, 100 * dim.width / full.width);
                WorldTView.this.zoomButton.setText(String.valueOf(TToolBar.zoomFormat.format(zoom)) + "%");
                if (zoom > 105.0 * WorldTView.this.worldPanel().getMagnification()) {
                    WorldTView.this.worldPanel().setMagnification(-1.0);
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected JPopupMenu refreshZoomPopup(JPopupMenu popup) {
        popup.removeAll();
        JMenuItem item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ToFit"));
        item.setActionCommand("auto");
        item.addActionListener(this.zoomAction);
        popup.add(item);
        popup.addSeparator();
        int i = 0;
        int nz = TrackerPanel.ZOOM_LEVELS.length;
        while (i < nz) {
            if (!(TrackerPanel.ZOOM_LEVELS[i] > 8.0) && !(TrackerPanel.ZOOM_LEVELS[i] < 0.25)) {
                int n = (int)(100.0 * TrackerPanel.ZOOM_LEVELS[i]);
                String m = String.valueOf(n);
                item = new JMenuItem(String.valueOf(m) + "%");
                item.setActionCommand(m);
                item.addActionListener(this.zoomAction);
                popup.add(item);
            }
            ++i;
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    public BufferedImage render(BufferedImage image) {
        return this.worldPanel().render(image);
    }

    @Override
    public void refresh() {
        if (!this.isViewPaneVisible()) {
            return;
        }
        this.worldViewLabel.setText(TrackerRes.getString("TFrame.View.World"));
        this.worldPanel().refresh();
    }

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.worldPanel() != null) {
            this.worldPanel().cleanup();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.worldPanel().dispose();
        this.worldPanelID = null;
    }

    @Override
    public boolean isCustomState() {
        Dimension dim = this.worldPanel().getPreferredSize();
        return dim.width > 1;
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.worldPanel().getMainPanel();
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.World");
    }

    @Override
    public Icon getViewIcon() {
        return WORLDVIEW_ICON;
    }

    @Override
    public int getViewType() {
        return 2;
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        this.worldViewLabel.setText(TrackerRes.getString("TFrame.View.World"));
        this.refreshZoomButton();
        return super.getToolBarComponents();
    }

    @Override
    public Dimension getSize() {
        return this.scrollPane.getViewport().getExtentSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.propertyChangeImpl(e);
    }

    private void propertyChangeImpl(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "track": {
                if (e.getOldValue() != null) {
                    TTrack removed = (TTrack)e.getOldValue();
                    removed.removePropertyChangeListener("color", this);
                    removed.removePropertyChangeListener("visible", this);
                }
                this.refresh();
                break;
            }
            case "clear": {
                for (TTrack track : TTrack.getValues()) {
                    track.removePropertyChangeListener("color", this);
                    track.removePropertyChangeListener("visible", this);
                }
                this.refresh();
                break;
            }
            case "videovisible": 
            case "stepnumber": 
            case "color": 
            case "image": 
            case "video": 
            case "visible": {
                TFrame.repaintT(this.worldPanel());
                break;
            }
            case "data": 
            case "size": 
            case "transform": {
                this.refresh();
                break;
            }
            default: {
                System.err.println("WoldTView.propertyChange " + e.getPropertyName() + " " + e.getSource());
            }
            case "magnification": 
        }
    }

    private WorldPanel worldPanel() {
        return (WorldPanel)this.frame.getTrackerPanelForID(this.worldPanelID);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            WorldTView view = (WorldTView)obj;
            control.setValue("zoom", view.worldPanel().getMagnification());
            Rectangle rect = view.scrollPane.getViewport().getViewRect();
            int[] rectData = new int[]{rect.x, rect.y, rect.width, rect.height};
            control.setValue("viewrect", rectData);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            WorldTView view = (WorldTView)obj;
            if (control.getPropertyNamesRaw().contains("zoom")) {
                view.worldPanel().setMagnification(control.getDouble("zoom"));
                int[] d = (int[])control.getObject("viewrect");
                Rectangle rect = new Rectangle(d[0], d[1], d[2], d[3]);
                view.worldPanel().scrollRectToVisible(rect);
            }
            return obj;
        }
    }

    static class WorldPanel
    extends TrackerPanel {
        protected JMenuItem copyImageItem;
        protected JMenuItem printItem;
        protected JMenuItem helpItem;
        protected Integer mainPanelID;
        protected double zoomFactor = 0.25;
        protected Rectangle scrollRect = new Rectangle();
        protected WorldTView view;

        private WorldPanel(TrackerPanel panel) {
            super(panel.frame, panel);
            this.mainPanelID = panel.getID();
            this.cleanup();
            TrackerPanel trackerPanel = this.getMainPanel();
            trackerPanel.addListeners(panelProps, this);
            for (TTrack track : trackerPanel.getTracks()) {
                track.addPropertyChangeListener("color", this);
            }
            this.setPlayerVisible(false);
            this.setDrawingInImageSpace(false);
            this.setShowCoordinates(false);
        }

        @Override
        public void setMagnification(double magnification) {
            Dimension d;
            if (magnification == 0.0 || Double.isNaN(magnification)) {
                return;
            }
            Dimension prevSize = this.getPreferredSize();
            Point p1 = new TPoint(0.0, 0.0).getScreenPosition(this);
            if (prevSize.width == 1 && prevSize.height == 1) {
                double w = this.getImageWidth();
                double h = this.getImageHeight();
                Point p2 = new TPoint(w, h).getScreenPosition(this);
                prevSize.width = p2.x - p1.x;
                prevSize.height = p2.y - p1.y;
            }
            if (magnification < 0.0) {
                d = new Dimension(1, 1);
            } else {
                this.zoom = Math.min(Math.max(magnification, 0.1), 20.0);
                int w = (int)(this.imageWidth * this.zoom);
                int h = (int)(this.imageHeight * this.zoom);
                d = new Dimension(w, h);
            }
            this.setPreferredSize(d);
            if (this.view != null) {
                this.view.scrollPane.revalidate();
                this.view.scrollToZoomCenter(this.getPreferredSize(), prevSize, p1);
                this.eraseAll();
            }
        }

        public Dimension getFullSize() {
            int w = (int)this.getImageWidth();
            int h = (int)this.getImageHeight();
            return new Dimension(w, h);
        }

        @Override
        protected void setGUI() {
            this.setPreferredSize(new Dimension(1, 1));
        }

        @Override
        protected void setMouseListeners() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        this.createWorldPopup();
                        popup.show(this, e.getX(), e.getY());
                    }
                }
            });
            this.setInteractiveMouseHandler(null);
        }

        protected void createWorldPopup() {
            this.getPopup().removeAll();
            this.getMenuItems();
            TrackerPanel trackerPanel = this.getMainPanel();
            if (trackerPanel.isEnabled("edit.copyImage")) {
                this.copyImageItem.setText(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
                this.popup.add(this.copyImageItem);
                this.popup.add(this.snapshotItem);
            }
            if (trackerPanel.isEnabled("file.print")) {
                if (this.popup.getComponentCount() > 0) {
                    this.popup.addSeparator();
                }
                this.printItem.setText(TrackerRes.getString("TActions.Action.Print"));
                this.popup.add(this.printItem);
            }
            if (this.popup.getComponentCount() > 0) {
                this.popup.addSeparator();
            }
            this.helpItem.setText(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
            this.popup.add(this.helpItem);
            FontSizer.setFonts(this.popup, FontSizer.getLevel());
        }

        protected void getMenuItems() {
            if (this.copyImageItem != null) {
                return;
            }
            AbstractAction copyImageAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.copyImage("clipboard");
                }
            };
            this.copyImageItem = new JMenuItem(copyImageAction);
            AbstractAction printAction = new AbstractAction(TrackerRes.getString("TActions.Action.Print")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.copyImage("print");
                }
            };
            this.printItem = new JMenuItem(printAction);
            this.helpItem = new JMenuItem();
            this.helpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (frame != null) {
                        frame.showHelp("worldview", 0);
                    }
                }
            });
            this.snapshotItem = this.getSnapshotItem(new DrawingPanel.PopupmenuListener(this));
        }

        protected void copyImage(String where) {
            TrackerIO.ComponentImage img = new TrackerIO.ComponentImage(this);
            switch (where) {
                case "clipboard": {
                    img.copyToClipboard();
                    break;
                }
                case "print": {
                    img.print();
                }
            }
        }

        public void refresh() {
            TrackerPanel trackerPanel = this.getMainPanel();
            CoordAxes axes = trackerPanel.getAxes();
            if (axes != null) {
                axes.updateListenerVisible(this);
            }
            if (!trackerPanel.calibrationTools.isEmpty()) {
                for (TTrack next : trackerPanel.getTracks()) {
                    if (!trackerPanel.calibrationTools.contains(next)) continue;
                    next.updateListenerVisible(this);
                }
            }
            for (Drawable next : this.getDrawables()) {
                if (!(next instanceof TTrack)) continue;
                TTrack track = (TTrack)next;
                track.erase(this.panelID);
            }
            TFrame.repaintT(this);
        }

        @Override
        public TrackerPanel getMainPanel() {
            return this.frame.getTrackerPanelForID(this.mainPanelID);
        }

        @Override
        public TPoint getSnapPoint() {
            return this.getMainPanel().getSnapPoint();
        }

        @Override
        public TTrack getSelectedTrack() {
            return this.getMainPanel().getSelectedTrack();
        }

        @Override
        public void setSelectedTrack(TTrack track) {
            if (this.mainPanelID != null) {
                this.getMainPanel().setSelectedTrack(track);
            }
        }

        @Override
        public ArrayList<Drawable> getDrawables() {
            if (this.mainPanelID == null) {
                return super.getDrawables();
            }
            TrackerPanel trackerPanel = this.getMainPanel();
            ArrayList<Drawable> list = trackerPanel.getDrawables();
            list.addAll(super.getDrawables());
            list.removeAll(trackerPanel.getDrawablesTemp(PencilScene.class));
            trackerPanel.clearTemp();
            TMat mat = trackerPanel.getMat();
            if (mat != null && list.get(0) != mat) {
                list.remove(mat);
                list.add(0, mat);
            }
            return list;
        }

        @Override
        public VideoPlayer getPlayer() {
            return this.mainPanelID == null ? super.getPlayer() : this.getMainPanel().getPlayer();
        }

        @Override
        public ImageCoordSystem getCoords() {
            return this.mainPanelID == null ? super.getCoords() : this.getMainPanel().getCoords();
        }

        @Override
        protected boolean unTracked() {
            return false;
        }

        @Override
        public Interactive getInteractive() {
            return null;
        }

        public void cleanup() {
            if (this.mainPanelID != null) {
                this.getMainPanel().removeListeners(panelProps, this);
                for (TTrack t : TTrack.getValues()) {
                    t.removePropertyChangeListener("color", this);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (this.view != null) {
                this.view.propertyChangeImpl(e);
            }
        }

        @Override
        public void dispose() {
            this.cleanup();
            this.title = this.getMainPanel().getTitle();
            if (this.mainPanelID != null) {
                TrackerPanel trackerPanel = this.getMainPanel();
                trackerPanel.removePropertyChangeListener("clear", this);
                trackerPanel.removePropertyChangeListener("function", this);
                this.mainPanelID = null;
            }
            this.frame.deallocatePanelID(this.panelID);
            super.dispose();
        }

        public WorldTView getWorldView() {
            return this.view;
        }

        public boolean isActive() {
            if (this.view == null) {
                return false;
            }
            return TViewChooser.isSelectedView(this.view) && this.view.isViewPaneVisible();
        }
    }
}

