/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;

public class ZoomTView
extends TView {
    protected JScrollPane scrollPane;
    protected Rectangle scrollRect = new Rectangle();
    protected Point zoomCenter = new Point();
    protected MouseAdapter mouseAdapter;
    protected KeyAdapter keyAdapter;
    protected Dimension dim;
    protected Dimension lastDim = new Dimension();
    protected ComponentAdapter resizeListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            ZoomTView.this.doResized();
        }
    };

    public ZoomTView(TrackerPanel panel) {
        super(panel);
        this.init();
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.addComponentListener(this.resizeListener);
        panel.addComponentListener(this.resizeListener);
        SwingUtilities.replaceUIActionMap(this.scrollPane, null);
        this.add((Component)this.scrollPane, "Center");
        panel.setPlayerVisible(false);
        this.scrollPane.setViewportView(panel);
        panel.setScrollPane(this.scrollPane);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ZoomTView.this.doMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ZoomTView.this.doMouseReleased(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ZoomTView.this.doMouseDragged(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ZoomTView.this.doMouseWheel(e);
            }
        };
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ZoomTView.this.doKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ZoomTView.this.doKeyRelease(e);
            }
        };
        panel.addMouseListener(this.mouseAdapter);
        panel.addMouseMotionListener(this.mouseAdapter);
        panel.addMouseWheelListener(this.mouseAdapter);
        panel.addKeyListener(this.keyAdapter);
    }

    protected void doKeyPressed(KeyEvent e) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        TButton z = trackerPanel.getToolBar((boolean)true).zoomButton;
        int d = trackerPanel.getSelectedPoint() == null ? 10 : 0;
        Rectangle rect = this.scrollPane.getViewport().getViewRect();
        switch (e.getKeyCode()) {
            case 90: {
                if (e.isControlDown()) break;
                z.setSelected(true);
                break;
            }
            case 18: {
                break;
            }
            case 33: {
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                if (e.isShiftDown()) {
                    int n = trackerPanel.getPlayer().getStepNumber() - 5;
                    trackerPanel.getPlayer().setStepNumber(n);
                    break;
                }
                trackerPanel.getPlayer().back();
                break;
            }
            case 34: {
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                if (e.isShiftDown()) {
                    int n = trackerPanel.getPlayer().getStepNumber() + 5;
                    trackerPanel.getPlayer().setStepNumber(n);
                    break;
                }
                trackerPanel.getPlayer().step();
                break;
            }
            case 36: {
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                trackerPanel.getPlayer().setStepNumber(0);
                break;
            }
            case 35: {
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                VideoClip clip = trackerPanel.getPlayer().getVideoClip();
                trackerPanel.getPlayer().setStepNumber(clip.getStepCount() - 1);
                break;
            }
            case 38: {
                rect.y -= d;
                trackerPanel.scrollRectToVisible(rect);
                break;
            }
            case 40: {
                rect.y += d;
                trackerPanel.scrollRectToVisible(rect);
                break;
            }
            case 39: {
                rect.x += d;
                trackerPanel.scrollRectToVisible(rect);
                break;
            }
            case 37: {
                rect.x -= d;
                trackerPanel.scrollRectToVisible(rect);
                break;
            }
            case 65: {
                if (!Tracker.enableAutofill || PointMass.isAutoKeyDown) break;
                PointMass.isAutoKeyDown = true;
                TTrack track = trackerPanel.getSelectedTrack();
                if (track == null || track.ttype != 5) break;
                PointMass m = (PointMass)trackerPanel.getSelectedTrack();
                m.setAutoFill(!m.isAutofill);
                trackerPanel.getSelectedTrack().repaint(this.panelID);
            }
        }
        if (z.isSelected()) {
            trackerPanel.setCursor(e.isAltDown() ? Tracker.getZoomOutCursor() : Tracker.getZoomInCursor());
        }
    }

    protected void doKeyRelease(final KeyEvent e) {
        final TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        TButton z = panel.getToolBar((boolean)true).zoomButton;
        if (e.getKeyCode() == 90) {
            z.setSelected(false);
            panel.setCursor(Cursor.getDefaultCursor());
        }
        if (e.getKeyCode() == 65) {
            PointMass.isAutoKeyDown = false;
        }
        if (z.isSelected()) {
            Runnable runner = new Runnable(){

                @Override
                public synchronized void run() {
                    panel.setCursor(e.isAltDown() ? Tracker.getZoomOutCursor() : Tracker.getZoomInCursor());
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    protected void doMousePressed(MouseEvent e) {
        this.zoomCenter.setLocation(e.getPoint());
    }

    protected void doMouseReleased(MouseEvent e) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (Tracker.isZoomOutCursor(trackerPanel.getCursor())) {
            this.zoomOut(false);
        } else if (Tracker.isZoomInCursor(trackerPanel.getCursor())) {
            this.zoomIn(false);
        }
    }

    protected void doMouseDragged(MouseEvent e) {
    }

    protected void doMouseWheel(MouseWheelEvent e) {
        boolean zoom;
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        boolean invert = e.isControlDown() && !e.isShiftDown();
        boolean bl = zoom = !Tracker.scrubMouseWheel && !invert || Tracker.scrubMouseWheel && invert;
        if (zoom) {
            this.zoomCenter.setLocation(e.getPoint());
        }
        int n = panel.getPlayer().getStepNumber();
        if (e.getWheelRotation() > 0) {
            if (zoom) {
                this.zoomOut(true);
            } else if (e.isAltDown()) {
                panel.getPlayer().setStepNumber(n - 10);
            } else {
                panel.getPlayer().back();
            }
        } else if (zoom) {
            this.zoomIn(true);
        } else if (e.isAltDown()) {
            panel.getPlayer().setStepNumber(n + 10);
        } else {
            panel.getPlayer().step();
        }
    }

    protected boolean doResized() {
        if (!this.getTopLevelAncestor().isVisible()) {
            return false;
        }
        this.dim = this.scrollPane.getViewport().getView().getSize(this.dim);
        if (this.dim.equals(this.lastDim)) {
            return false;
        }
        this.lastDim.setSize(this.dim);
        return true;
    }

    JPopupMenu getPopupMenu() {
        if (!Tracker.allowMenuRefresh) {
            return null;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (Tracker.isZoomInCursor(trackerPanel.getCursor()) || Tracker.isZoomOutCursor(trackerPanel.getCursor())) {
            return null;
        }
        return trackerPanel.updateMainPopup();
    }

    public void setZoomCenter(int x, int y) {
        this.zoomCenter.setLocation(x, y);
    }

    public void scrollToZoomCenter(Dimension size, Dimension prevSize, Point panelLoc) {
        if (this.zoomCenter.x == 0 && this.zoomCenter.y == 0) {
            return;
        }
        double xRatio = size.getWidth() / prevSize.getWidth();
        double yRatio = size.getHeight() / prevSize.getHeight();
        Rectangle rect = this.scrollPane.getViewport().getViewRect();
        if (prevSize.width < rect.width || prevSize.height < rect.height) {
            rect.setLocation((int)(-xRatio * (double)panelLoc.x), (int)(-yRatio * (double)panelLoc.y));
        }
        double x = (double)rect.x + (xRatio - 1.0) * this.zoomCenter.getX();
        double y = (double)rect.y + (yRatio - 1.0) * this.zoomCenter.getY();
        rect.setLocation((int)x, (int)y);
        this.scrollRect.setBounds(rect);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.scrollRectToVisible(this.scrollRect);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                TrackerPanel panel = ZoomTView.this.frame.getTrackerPanelForID(ZoomTView.this.panelID);
                Rectangle rect = ZoomTView.this.scrollPane.getViewport().getViewRect();
                if (!rect.equals(ZoomTView.this.scrollRect)) {
                    panel.scrollRectToVisible(ZoomTView.this.scrollRect);
                }
                panel.eraseAll();
                TFrame.repaintT(panel);
                ZoomTView.this.refreshZoomButton();
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected void refreshZoomButton() {
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        if (panel.getClass() == TrackerPanel.class) {
            panel.getToolBar(true).refreshZoomButton();
        }
    }

    @Override
    public void refresh() {
        this.init();
    }

    @Override
    public void init() {
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        panel.removePropertyChangeListener("track", this);
        panel.removePropertyChangeListener("clear", this);
        panel.addPropertyChangeListener("track", this);
        panel.addPropertyChangeListener("clear", this);
        for (TTrack track : panel.getTracksTemp()) {
            track.removePropertyChangeListener("color", this);
            track.addPropertyChangeListener("color", this);
        }
        panel.clearTemp();
    }

    @Override
    public void cleanup() {
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        panel.removePropertyChangeListener("track", this);
        panel.removePropertyChangeListener("clear", this);
        for (TTrack t : TTrack.getValues()) {
            t.removePropertyChangeListener("color", this);
        }
    }

    @Override
    public void dispose() {
        this.cleanup();
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (trackerPanel != null) {
            trackerPanel.clearTemp();
            trackerPanel.removeMouseListener(this.mouseAdapter);
            trackerPanel.removeMouseWheelListener(this.mouseAdapter);
            trackerPanel.removeKeyListener(this.keyAdapter);
            trackerPanel.setScrollPane(null);
        }
        this.mouseAdapter = null;
        this.keyAdapter = null;
        this.scrollPane.removeComponentListener(this.resizeListener);
        this.resizeListener = null;
        this.scrollPane.setViewportView(null);
        this.scrollPane = null;
        this.removeAll();
        trackerPanel = null;
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    @Override
    public String getViewName() {
        return "";
    }

    @Override
    public Icon getViewIcon() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "clear": 
            case "track": {
                this.refresh();
                break;
            }
            case "color": {
                TFrame.repaintT(this);
            }
        }
    }

    public void zoomIn(boolean step) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        DrawingPanel.ZoomBox zoomBox = trackerPanel.getZoomBox();
        double m1 = trackerPanel.getMagnification();
        double m2 = TrackerPanel.ZOOM_STEP * m1;
        if (step) {
            double dm = Math.sqrt(TrackerPanel.ZOOM_STEP);
            int i = 0;
            while (i < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[i] < m2 * dm && TrackerPanel.ZOOM_LEVELS[i] > m2 / dm) {
                    m2 = TrackerPanel.ZOOM_LEVELS[i];
                    break;
                }
                ++i;
            }
        } else if (!zoomBox.isDragged()) {
            int i = 0;
            while (i < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[i] >= m2 && TrackerPanel.ZOOM_LEVELS[i] < m2 * 2.0) {
                    m2 = TrackerPanel.ZOOM_LEVELS[i];
                    break;
                }
                ++i;
            }
            if (m2 > TrackerPanel.ZOOM_LEVELS[TrackerPanel.ZOOM_LEVELS.length - 1]) {
                m2 = 20.0;
            }
        } else {
            Rectangle vRect = this.scrollPane.getViewport().getViewRect();
            Rectangle zRect = zoomBox.reportZoom();
            Dimension tDim = trackerPanel.getPreferredSize();
            Point p1 = new TPoint(0.0, 0.0).getScreenPosition(trackerPanel);
            if (tDim.width == 1 && tDim.height == 1) {
                double w = trackerPanel.getImageWidth();
                double h = trackerPanel.getImageHeight();
                Point p2 = new TPoint(w, h).getScreenPosition(trackerPanel);
                tDim.width = p2.x - p1.x;
                tDim.height = p2.y - p1.y;
            }
            Rectangle tRect = new Rectangle(p1.x, p1.y, tDim.width, tDim.height);
            if (1.0 * (double)vRect.width / (double)tDim.width < 1.0) {
                tRect.x = -vRect.x;
            }
            if (1.0 * (double)vRect.height / (double)tDim.height < 1.0) {
                tRect.y = -vRect.y;
            }
            zRect = zRect.intersection(tRect);
            double fX = 1.0 * (double)vRect.width / (double)zRect.width;
            double fY = 1.0 * (double)vRect.height / (double)zRect.height;
            double xyRatio = fX / fY;
            double factor = xyRatio < 1.0 ? fX : fY;
            m2 = m1 * factor;
            double dm = 1.011;
            int i = 0;
            while (i < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[i] < m2 * dm && TrackerPanel.ZOOM_LEVELS[i] > m2 / dm) {
                    m2 = TrackerPanel.ZOOM_LEVELS[i];
                    factor = m2 / m1;
                    break;
                }
                ++i;
            }
            if (factor * (double)tDim.width > (double)vRect.width || factor * (double)tDim.height > (double)vRect.height) {
                if (xyRatio < 1.0) {
                    zRect.height = (int)((double)zRect.height / xyRatio);
                    zRect.y -= (int)(0.5 * (double)zRect.height * (1.0 - xyRatio));
                    zRect.y = Math.max(zRect.y, tRect.y);
                    zRect.y = Math.min(zRect.y, tRect.y + tRect.height - zRect.height);
                } else {
                    zRect.width = (int)((double)zRect.width * xyRatio);
                    zRect.x -= (int)(0.5 * (double)zRect.width * (1.0 - 1.0 / xyRatio));
                    zRect.x = Math.max(zRect.x, tRect.x);
                    zRect.x = Math.min(zRect.x, tRect.x + tRect.width - zRect.width);
                }
                boolean small = m1 * (double)tDim.width < (double)vRect.width && m1 * (double)tDim.height < (double)vRect.height;
                double d = small ? 0.0 : m1 * (double)p1.x / (m2 - m1);
                double x = m2 * (double)zRect.x / (m2 - m1) + d;
                d = small ? 0.0 : m1 * (double)p1.y / (m2 - m1);
                double y = m2 * (double)zRect.y / (m2 - m1) + d;
                this.zoomCenter.setLocation(x, y);
            }
        }
        trackerPanel.setMagnification(m2);
    }

    public void zoomOut(boolean step) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        double m1 = trackerPanel.getMagnification();
        double m2 = m1 / TrackerPanel.ZOOM_STEP;
        if (step) {
            double dm = Math.sqrt(TrackerPanel.ZOOM_STEP);
            int i = 0;
            while (i < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[i] < m2 * dm && TrackerPanel.ZOOM_LEVELS[i] > m2 / dm) {
                    m2 = TrackerPanel.ZOOM_LEVELS[i];
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[i] <= m2 && TrackerPanel.ZOOM_LEVELS[i] > m2 / 2.0) {
                    m2 = TrackerPanel.ZOOM_LEVELS[i];
                    break;
                }
                ++i;
            }
            if (m2 < TrackerPanel.ZOOM_LEVELS[0]) {
                m2 = 0.1;
            }
        }
        trackerPanel.setMagnification(m2);
    }

    @Override
    public int getViewType() {
        return -1;
    }
}

