/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.analytics;

import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.opensourcephysics.tools.Resource;

public class DownloadCounter {
    static String dataFile = "download_counts.csv";
    static String NEW_LINE = System.getProperty("line.separator", "\n");

    public static void main(String[] args) throws AWTException {
        Toolkit.getDefaultToolkit().beep();
        Robot robot = new Robot();
        boolean increase = true;
        StringBuffer buffer = new StringBuffer();
        buffer.append(DownloadCounter.getDateAndTime());
        dataFile = "C:\\Users\\dobro\\Documents\\Tracker\\Analytics\\" + dataFile;
        String[] filenames = DownloadCounter.getFileNames(dataFile);
        int j = 0;
        while (j < filenames.length) {
            increase = !increase;
            Point p = MouseInfo.getPointerInfo().getLocation();
            int x = increase ? p.x + 1 : p.x - 1;
            int y = increase ? p.y + 1 : p.y - 1;
            robot.mouseMove(x, y);
            String count = DownloadCounter.getDownloadCount(filenames[j]);
            buffer.append("\t" + count);
            ++j;
        }
        String contents = DownloadCounter.read(dataFile);
        contents = String.valueOf(contents) + buffer.toString();
        DownloadCounter.write(contents, dataFile);
        Toolkit.getDefaultToolkit().beep();
    }

    static String[] getFileNames(String dataFile) {
        File file = new File(dataFile);
        try {
            String[] split;
            BufferedReader in = new BufferedReader(new FileReader(file));
            String firstLine = in.readLine();
            in.close();
            if (firstLine != null && (split = firstLine.split("\t")).length > 0) {
                String[] fileNames = new String[split.length - 1];
                System.arraycopy(split, 1, fileNames, 0, fileNames.length);
                return fileNames;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String[0];
    }

    static String read(String fileName) {
        File file = new File(fileName);
        StringBuffer buffer = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            buffer = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                buffer.append(String.valueOf(line) + NEW_LINE);
                line = in.readLine();
            }
            in.close();
            return buffer.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    static void write(String contents, String fileName) {
        File file = new File(fileName);
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName("UTF-8");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, charset);
            BufferedWriter writer = new BufferedWriter(out);
            writer.write(contents);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String getDateAndTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Calendar cal = Calendar.getInstance();
        return sdf.format(cal.getTime());
    }

    static String getDownloadCount(String filename) {
        String path = "https://physlets.org/tracker/installers/download.php?file=" + filename + "__read";
        try {
            URL url = new URL(path);
            Resource res = new Resource(url);
            return res.getString().trim();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

