/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.analytics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.opensourcephysics.tools.Resource;

public class TrackerCountReader
extends JFrame {
    private String NEW_LINE = System.getProperty("line.separator", "\n");
    private String launchListPage = "list_";
    private String downloadListFile = "list__list";
    private String launchClearPage = "clear_";
    private String downloadClearFile = "clear__clear";
    private String launchPHPPath = "https://physlets.org/tracker/counter/counter.php?page=";
    private String downloadPHPPath = "https://physlets.org/tracker/installers/download.php?file=";
    private String[] actions = new String[]{"read launch counts", "read downloads", "version", "list launch log failures", "list download failures", "clear launch log failures", "clear download failures", "test launch log", "test downloads"};
    private String[] versions = new String[]{"all", "6.", "5.", "4.", "6.3.3", "6.3.2", "6.3.1", "6.3.0", "6.2.0", "6.1.7", "6.1.6", "6.1.5", "6.1.4", "6.1.3", "6.1.2", "6.1.1", "6.1.0", "6.0.10", "6.0.9", "6.0.8", "6.0.7", "6.0.6", "6.0.5", "6.0.4", "6.0.3", "6.0.2", "6.0.1", "6.0.0", "5.5.0", "5.4.0", "5.3.7", "5.3.6", "5.3.5", "5.3.4", "5.3.3", "5.3.2", "5.3.1", "5.3.0", "5.2.10", "5.2.9", "5.2.8", "5.2.7", "5.2.6", "5.2.5", "5.2.4", "5.2.3", "5.2.2", "5.1.5", "5.1.4", "5.1.3", "5.1.2", "5.1.1", "5.1.0", "5.0.7", "5.0.6", "5.0.5", "5.0.4", "5.0.3", "5.0.2", "5.0.1", "5.0.0", "4.11.0", "4.10.0", "4.9.8", "4.97", "4.96", "4.95", "4.94", "4.93", "4.92", "4.91", "4.90"};
    private String[] OSs = new String[]{"all", "windows", "osx", "linux"};
    private String[] engines = new String[]{"all", "Xuggle", "none"};
    JComboBox<String> actionDropdown;
    JComboBox<String> versionDropdown;
    JComboBox<String> osDropdown;
    JComboBox<String> engineDropdown;
    JLabel actionLabel;
    JLabel versionLabel;
    JLabel osLabel;
    JLabel engineLabel;
    JTextArea textArea;
    JButton sendButton;

    private TrackerCountReader() {
        super("Tracker Count Reader");
        this.setDefaultCloseOperation(3);
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.actionLabel = new JLabel("Action");
        this.versionLabel = new JLabel("Version");
        this.osLabel = new JLabel("OS");
        this.engineLabel = new JLabel("Engine");
        this.actionDropdown = new JComboBox<String>(this.actions);
        this.versionDropdown = new JComboBox<String>(this.versions);
        this.osDropdown = new JComboBox<String>(this.OSs);
        this.engineDropdown = new JComboBox<String>(this.engines);
        this.actionDropdown.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.versionDropdown.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.osDropdown.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.engineDropdown.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        Box actionBox = Box.createVerticalBox();
        actionBox.add(this.leftJustify(this.actionLabel));
        actionBox.add(this.actionDropdown);
        Box versionBox = Box.createVerticalBox();
        versionBox.add(this.leftJustify(this.versionLabel));
        versionBox.add(this.versionDropdown);
        Box osBox = Box.createVerticalBox();
        osBox.add(this.leftJustify(this.osLabel));
        osBox.add(this.osDropdown);
        Box engineBox = Box.createVerticalBox();
        engineBox.add(this.leftJustify(this.engineLabel));
        engineBox.add(this.engineDropdown);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(4, 7, 2, 7));
        box.add(actionBox);
        box.add(versionBox);
        box.add(osBox);
        box.add(engineBox);
        this.sendButton = new JButton("Send");
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerCountReader.this.send();
            }
        });
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)box, "North");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        buttonPanel.add((Component)this.sendButton, "North");
        top.add((Component)buttonPanel, "South");
        contentPane.add((Component)top, "North");
        this.textArea = new JTextArea();
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TrackerCountReader.this.textArea.setForeground(Color.RED.darker());
            }
        });
        JScrollPane scroller = new JScrollPane(this.textArea);
        scroller.setPreferredSize(new Dimension(200, 400));
        contentPane.add((Component)scroller, "Center");
        this.pack();
    }

    private void send() {
        ArrayList<String> vers;
        if (this.textArea.getForeground().equals(Color.RED.darker())) {
            String text = this.textArea.getText().trim();
            String result = this.send(this.launchPHPPath, text);
            this.textArea.setForeground(Color.BLACK);
            this.textArea.setText(result);
            return;
        }
        String[] ver = null;
        String[] os = null;
        String[] eng = null;
        String action = this.actionDropdown.getSelectedItem().toString();
        if (action.contains("list")) {
            String result = null;
            if (action.contains("launch")) {
                result = this.send(this.launchPHPPath, this.launchListPage);
                if ("".equals(result)) {
                    result = "(no launch log failures)";
                }
            } else {
                result = this.send(this.downloadPHPPath, this.downloadListFile);
                if ("".equals(result)) {
                    result = "(no download failures)";
                }
            }
            this.textArea.setForeground(Color.BLACK);
            this.textArea.setText(result);
            return;
        }
        if (action.equals("version")) {
            this.textArea.setForeground(Color.BLACK);
            this.textArea.setText(this.send(this.launchPHPPath, "version"));
            return;
        }
        if (action.contains("clear")) {
            String result = null;
            if (action.contains("launch")) {
                result = this.send(this.launchPHPPath, this.launchClearPage);
                if ("".equals(result)) {
                    result = "(cleared launch log failures)";
                }
            } else {
                result = this.send(this.downloadPHPPath, this.downloadClearFile);
                if ("".equals(result)) {
                    result = "(cleared download failures)";
                }
            }
            this.textArea.setForeground(Color.BLACK);
            this.textArea.setText(result);
            return;
        }
        if (this.versionDropdown.getSelectedItem().equals("all")) {
            vers = new ArrayList<String>();
            int i = 0;
            while (i < this.versions.length) {
                if (this.versions[i].length() >= 4) {
                    vers.add(this.versions[i]);
                }
                ++i;
            }
            ver = vers.toArray(new String[vers.size()]);
        } else if (this.versionDropdown.getSelectedItem().equals("4.") || this.versionDropdown.getSelectedItem().equals("5.") || this.versionDropdown.getSelectedItem().equals("6.")) {
            vers = new ArrayList();
            String s = this.versionDropdown.getSelectedItem().toString();
            int i = 0;
            while (i < this.versions.length) {
                if (this.versions[i].startsWith(s) && !this.versions[i].equals(s)) {
                    vers.add(this.versions[i]);
                }
                ++i;
            }
            ver = vers.toArray(new String[vers.size()]);
        } else {
            ver = new String[]{this.versionDropdown.getSelectedItem().toString()};
        }
        if (this.osDropdown.getSelectedItem().equals("all")) {
            os = new String[this.OSs.length - 1];
            int i = 0;
            while (i < os.length) {
                os[i] = this.OSs[i + 1];
                ++i;
            }
        } else {
            os = new String[]{this.osDropdown.getSelectedItem().toString()};
        }
        if (this.engineDropdown.getSelectedItem().equals("all")) {
            eng = new String[this.engines.length - 1];
            int i = 0;
            while (i < eng.length) {
                eng[i] = this.engines[i + 1];
                ++i;
            }
        } else {
            eng = new String[]{this.engineDropdown.getSelectedItem().toString()};
        }
        String result = this.send(this.actionDropdown.getSelectedItem().toString(), ver, os, eng);
        this.textArea.setForeground(Color.BLACK);
        String command = this.versionDropdown.getSelectedItem() + "_" + this.osDropdown.getSelectedItem();
        if (!action.contains("download")) {
            command = String.valueOf(command) + "_" + this.engineDropdown.getSelectedItem();
        }
        this.textArea.setText(String.valueOf(action) + " " + command + ": " + result);
    }

    private String send(String path, String command) {
        try {
            URL url = new URL(String.valueOf(path) + command);
            Resource res = new Resource(url);
            return res.getString().trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String send(String action, String[] ver, String[] os, String[] eng) {
        int counts = 0;
        String commands = "";
        int i = 0;
        while (i < ver.length) {
            int j = 0;
            while (j < os.length) {
                block25: {
                    String osname;
                    block21: {
                        int n;
                        String command;
                        String ext;
                        String suffix;
                        block23: {
                            block24: {
                                block22: {
                                    if (!action.contains("test") && !action.contains("read") || !action.contains("download")) break block21;
                                    suffix = action.contains("read") ? "__read" : "_test";
                                    osname = os[j];
                                    String string = osname.equals("windows") ? ".exe" : (ext = osname.equals("osx") ? ".dmg" : ".run");
                                    if (osname.equals("osx")) {
                                        int k = 0;
                                        while (k < this.versions.length) {
                                            if (this.versions[k].equals(ver[i])) break;
                                            if (this.versions[k].equals("5.1.3")) {
                                                ext = ".zip";
                                                break;
                                            }
                                            ++k;
                                        }
                                    }
                                    if (osname.equals("linux")) {
                                        String string2 = osname = ver[i].startsWith("6") ? "linux-64bit" : "linux-32bit";
                                        if (ver[i].startsWith("6.2") || ver[i].startsWith("6.3")) {
                                            osname = "linux-x64";
                                        }
                                    }
                                    command = "Tracker-" + ver[i] + "-" + osname + "-installer" + ext;
                                    if (!ver[i].equals("6.0.0") || !osname.equals(this.OSs[1])) break block22;
                                    command = "Tracker-" + ver[i] + "-" + osname + "-64bit-installer" + ext;
                                    break block23;
                                }
                                if (!ver[i].startsWith("6") || !osname.equals(this.OSs[1])) break block24;
                                command = "Tracker-" + ver[i] + "-" + osname + "-x64-installer" + ext;
                                break block23;
                            }
                            if (ver[i].startsWith("5.2") && !osname.equals(this.OSs[2]) || ver[i].startsWith("5.3") && !osname.equals(this.OSs[2]) || ver[i].startsWith("5.4") && !osname.equals(this.OSs[2])) break block25;
                        }
                        String result = this.send(this.downloadPHPPath, String.valueOf(command) + suffix);
                        commands = String.valueOf(commands) + this.NEW_LINE + command + ": " + result;
                        if (action.contains("read")) {
                            try {
                                result = result.replaceAll(",", "");
                                n = Integer.parseInt(result);
                                counts += n;
                            }
                            catch (NumberFormatException e) {
                                return "failed to parse " + result;
                            }
                        }
                        if (!osname.contains("linux") || ver[i].startsWith("6")) break block25;
                        command = "Tracker-" + ver[i] + "-linux-64bit-installer" + ext;
                        result = this.send(this.downloadPHPPath, String.valueOf(command) + suffix);
                        commands = String.valueOf(commands) + this.NEW_LINE + command + ": " + result;
                        if (action.contains("read")) {
                            try {
                                result = result.replaceAll(",", "");
                                n = Integer.parseInt(result);
                                counts += n;
                            }
                            catch (NumberFormatException e) {
                                return "failed to parse " + result;
                            }
                        }
                        break block25;
                    }
                    int k = 0;
                    while (k < eng.length) {
                        osname = os[j];
                        if (osname.equals("osx")) {
                            osname = "macosx";
                        }
                        String command = "read_" + ver[i] + "_" + osname + "_" + eng[k];
                        if (action.contains("test")) {
                            command = "log_" + ver[i] + "_" + osname + "_" + eng[k] + "test";
                        }
                        String result = this.send(this.launchPHPPath, command);
                        commands = String.valueOf(commands) + this.NEW_LINE + ver[i] + "_" + osname + "_" + eng[k] + ": " + result;
                        if (action.contains("read")) {
                            try {
                                result = result.replaceAll(",", "");
                                int n = Integer.parseInt(result);
                                counts += n;
                            }
                            catch (NumberFormatException e) {
                                return "failed to parse " + result;
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        String s = String.valueOf(counts);
        if (action.contains("test")) {
            s = action.contains("launch") ? "launch log attempts" : "download attempts";
        }
        if (ver.length > 1 || os.length > 1 || eng.length > 1) {
            s = String.valueOf(s) + this.NEW_LINE + commands;
        }
        return s;
    }

    private Component leftJustify(Component c) {
        Box b = Box.createHorizontalBox();
        b.add(c);
        b.add(Box.createHorizontalGlue());
        b.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        return b;
    }

    public static void main(String[] args) {
        TrackerCountReader app = new TrackerCountReader();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - app.getBounds().width) / 2;
        int y = (dim.height - app.getBounds().height) / 2;
        app.setLocation(x, y);
        app.setVisible(true);
    }
}

