/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.deploy;

import java.awt.Desktop;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;

public class OSXServices {
    String status;
    Tracker tracker;
    ProxyHandler proxy;

    public String getStatus() {
        return this.status;
    }

    public OSXServices() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        this.proxy = new ProxyHandler(null);
        this.proxy.isDesktop = true;
        boolean success = false;
        Desktop desktop = Desktop.getDesktop();
        try {
            Class<?> openFileHandlerClass = Class.forName("java.awt.desktop.OpenFilesHandler", true, classLoader);
            Object proxyHandler = Proxy.newProxyInstance(classLoader, new Class[]{openFileHandlerClass}, (InvocationHandler)this.proxy);
            Method m = desktop.getClass().getDeclaredMethod("setOpenFileHandler", openFileHandlerClass);
            m.invoke((Object)desktop, proxyHandler);
            Class<?> eventClass = Class.forName("java.awt.desktop.OpenFilesEvent", true, classLoader);
            this.proxy.getFilesMethod = eventClass.getDeclaredMethod("getFiles", null);
            success = true;
        }
        catch (Exception ex) {
            this.proxy.isDesktop = false;
        }
        if (!success) {
            try {
                Class<?> appClass = Class.forName("com.apple.eawt.Application", true, classLoader);
                Method m = appClass.getDeclaredMethod("getApplication", null);
                Object application = m.invoke(null, null);
                Class<?> openFileHandlerClass = Class.forName("com.apple.eawt.OpenFilesHandler", true, classLoader);
                Object proxyHandler = Proxy.newProxyInstance(classLoader, new Class[]{openFileHandlerClass}, (InvocationHandler)this.proxy);
                m = application.getClass().getDeclaredMethod("setOpenFileHandler", openFileHandlerClass);
                m.invoke(application, proxyHandler);
                Class<?> eventClass = Class.forName("com.apple.eawt.AppEvent$OpenFilesEvent", true, classLoader);
                this.proxy.getFilesMethod = eventClass.getMethod("getFiles", null);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.status = success ? "TrackerStarter OSXServices running " + (this.proxy.isDesktop ? "java desktop" : "apple") : "TrackerStarter OSXServices failed both java desktop and apple";
    }

    public OSXServices(Tracker app) {
        Class<?> quitResponseClass;
        this.tracker = app;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        this.proxy = new ProxyHandler(this.tracker);
        this.proxy.isDesktop = true;
        boolean success = false;
        Desktop desktop = Desktop.getDesktop();
        try {
            Class<?> aboutHandlerClass = Class.forName("java.awt.desktop.AboutHandler", true, classLoader);
            Class<?> quitHandlerClass = Class.forName("java.awt.desktop.QuitHandler", true, classLoader);
            Class<?> prefsHandlerClass = Class.forName("java.awt.desktop.PreferencesHandler", true, classLoader);
            Object proxyHandler = Proxy.newProxyInstance(classLoader, new Class[]{aboutHandlerClass, quitHandlerClass, prefsHandlerClass}, (InvocationHandler)this.proxy);
            Method m = desktop.getClass().getDeclaredMethod("setAboutHandler", aboutHandlerClass);
            m.invoke((Object)desktop, proxyHandler);
            m = desktop.getClass().getDeclaredMethod("setQuitHandler", quitHandlerClass);
            m.invoke((Object)desktop, proxyHandler);
            m = desktop.getClass().getDeclaredMethod("setPreferencesHandler", prefsHandlerClass);
            m.invoke((Object)desktop, proxyHandler);
            Class<?> taskClass = Class.forName("java.awt.Taskbar", true, classLoader);
            m = taskClass.getDeclaredMethod("getTaskbar", null);
            Object taskbar = m.invoke(null, null);
            m = taskClass.getDeclaredMethod("setIconImage", Image.class);
            m.invoke(taskbar, Tracker.TRACKER_ICON_256.getImage());
            quitResponseClass = Class.forName("java.awt.desktop.QuitResponse", true, classLoader);
            this.proxy.cancelQuitMethod = quitResponseClass.getDeclaredMethod("cancelQuit", null);
            this.proxy.performQuitMethod = quitResponseClass.getDeclaredMethod("performQuit", null);
            success = true;
        }
        catch (Exception ex) {
            this.proxy.isDesktop = false;
        }
        if (!this.proxy.isDesktop) {
            try {
                Class<?> appClass = Class.forName("com.apple.eawt.Application", true, classLoader);
                Method m = appClass.getDeclaredMethod("getApplication", null);
                Object application = m.invoke(null, null);
                Class<?> aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler", true, classLoader);
                Class<?> quitHandlerClass = Class.forName("com.apple.eawt.QuitHandler", true, classLoader);
                Class<?> prefsHandlerClass = Class.forName("com.apple.eawt.PreferencesHandler", true, classLoader);
                Object proxyHandler = Proxy.newProxyInstance(classLoader, new Class[]{aboutHandlerClass, quitHandlerClass, prefsHandlerClass}, (InvocationHandler)this.proxy);
                m = appClass.getDeclaredMethod("setAboutHandler", aboutHandlerClass);
                m.invoke(application, proxyHandler);
                m = appClass.getDeclaredMethod("setQuitHandler", quitHandlerClass);
                m.invoke(application, proxyHandler);
                m = appClass.getDeclaredMethod("setPreferencesHandler", prefsHandlerClass);
                m.invoke(application, proxyHandler);
                m = appClass.getDeclaredMethod("setDockIconImage", Image.class);
                m.invoke(application, Tracker.TRACKER_ICON_256.getImage());
                quitResponseClass = Class.forName("com.apple.eawt.QuitResponse", true, classLoader);
                this.proxy.cancelQuitMethod = quitResponseClass.getDeclaredMethod("cancelQuit", null);
                this.proxy.performQuitMethod = quitResponseClass.getDeclaredMethod("performQuit", null);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.status = success ? "\nTracker OSXServices running " + (this.proxy.isDesktop ? "java desktop" : "apple") : "\nTracker OSXServices failed both java desktop and apple";
    }

    public static class ProxyHandler
    implements InvocationHandler {
        Tracker tracker;
        boolean isDesktop;
        Method getFilesMethod;
        Method cancelQuitMethod;
        Method performQuitMethod;

        ProxyHandler(Tracker app) {
            this.tracker = app;
        }

        @Override
        public Object invoke(Object proxy, Method m, final Object[] args) throws Throwable {
            try {
                if (m.getName().equals("handleAbout")) {
                    Tracker.showAboutTracker();
                } else if (m.getName().equals("handlePreferences")) {
                    if (this.tracker != null) {
                        TFrame frame = this.tracker.getFrame();
                        frame.showPrefsDialog();
                    }
                } else if (m.getName().equals("openFiles")) {
                    List files = (List)this.getFilesMethod.invoke(args[0], null);
                    String[] launchArgs = new String[files.size()];
                    int i = 0;
                    while (i < launchArgs.length) {
                        launchArgs[i] = ((File)files.get(i)).getAbsolutePath();
                        ++i;
                    }
                    TrackerStarter.launchTracker(launchArgs);
                } else if (m.getName().equals("handleQuitRequestWith")) {
                    TFrame frame;
                    if (this.tracker != null && (frame = this.tracker.getFrame()) != null) {
                        frame.saveAllTabs(false, null, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    performQuitMethod.invoke(args[1], null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    cancelQuitMethod.invoke(args[1], null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    this.performQuitMethod.invoke(args[1], null);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("invocation exception: " + e.getMessage());
            }
            return null;
        }
    }
}

