/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.deploy;

import java.io.File;
import java.io.FilenameFilter;

public class TrackerJarFilter
implements FilenameFilter {
    @Override
    public boolean accept(File dir, String name) {
        String fileName = this.getName(name).toLowerCase();
        if (!fileName.endsWith(".jar")) {
            return false;
        }
        if (fileName.equals("tracker.jar")) {
            return true;
        }
        if (fileName.startsWith("tracker-")) {
            String[] intArray;
            String version = fileName.substring(8);
            int len = version.length();
            version = version.substring(0, len - 4);
            String snapshot = "-snapshot";
            int n = version.toLowerCase().indexOf(snapshot);
            if (n > -1) {
                version = version.substring(0, n);
            }
            if ((intArray = version.split("\\.")).length <= 4) {
                try {
                    int i = 0;
                    while (i < intArray.length) {
                        Integer.parseInt(intArray[i].trim());
                        ++i;
                    }
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Double.parseDouble(version);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private String getName(String path) {
        if (path == null) {
            return "";
        }
        int i = path.lastIndexOf("/");
        if (i == -1) {
            i = path.lastIndexOf("\\");
        }
        if (i != -1) {
            return path.substring(i + 1);
        }
        return path;
    }
}

