/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.deploy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerJarFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.JREFinder;
import org.opensourcephysics.tools.ResourceLoader;

public class TrackerStarter {
    public static final String PREFERRED_TRACKER_JAR = "PREFERRED_TRACKER_JAR";
    public static final String PREFERRED_MEMORY_SIZE = "PREFERRED_MEMORY_SIZE";
    public static final String TRACKER_RELAUNCH = "TRACKER_RELAUNCH";
    public static final String TRACKER_NEW_VERSION = "TRACKER_NEW_VERSION";
    public static final String NEW_INSTALL = "NEW_INSTALL";
    public static final String LOG_FILE_NAME = "tracker_start.log";
    public static final String LOG_DIAGNOSTICS_NAME = "tracker_start_diagnostics.log";
    public static final int DEFAULT_MEMORY_SIZE = 1024;
    public static final int MINIMUM_MEMORY_SIZE = 64;
    public static final String PREFS_FILE_NAME = "tracker.prefs";
    public static final int INDEX_XUGGLE_57 = 0;
    public static final int INDEX_XUGGLE_34 = 1;
    static String newline = "\n";
    static String encoding = "UTF-8";
    static String exceptions = "";
    static String xuggleWarning;
    static String ffmpegWarning;
    static String starterWarning;
    static String trackerHome;
    static String userHome;
    static String javaHome;
    static String xuggleHome;
    static String userDocuments;
    static String startLogPath;
    static FilenameFilter trackerJarFilter;
    static File codeBaseDir;
    static File starterJarFile;
    static File xuggleServerJar;
    static File xuggleJar;
    static String preferredVersionString;
    static String trackerJarPath;
    static int memorySize;
    static int preferredMemorySize;
    static String[] executables;
    static String logText;
    static String javaCommand;
    static String preferredVM;
    static String[] bundledVMs;
    static String snapshot;
    static boolean debug;
    static boolean log;
    static boolean relaunching;
    static boolean launching;
    static boolean isNewInstall;
    static int port;
    static Thread launchThread;
    static Thread exitThread;
    static boolean abortExit;
    static int exitCounter;
    public static int xuggleVersionIndex;
    public static final String[][] XUGGLE_JAR_NAMES;
    public static FileFilter xuggleFileFilter;
    static HashMap<String, Boolean> usesXuggleServer;

    static {
        trackerJarFilter = new TrackerJarFilter();
        logText = "";
        javaCommand = "java";
        snapshot = "-snapshot";
        debug = false;
        log = true;
        relaunching = false;
        launching = false;
        isNewInstall = false;
        port = 12321;
        exitCounter = 0;
        XUGGLE_JAR_NAMES = new String[][]{{"xuggle-xuggler-server-all", "slf4j-api"}, {"xuggle-xuggler", "slf4j-api", "logback-classic", "logback-core"}};
        xuggleFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String[] xuggleNames = XUGGLE_JAR_NAMES[xuggleVersionIndex];
                int i = 0;
                while (i < xuggleNames.length) {
                    if (file.getName().startsWith(xuggleNames[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        usesXuggleServer = new HashMap();
        newline = System.getProperty("line.separator", "\n");
        try {
            URL url = TrackerStarter.class.getProtectionDomain().getCodeSource().getLocation();
            URI uri = url.toURI();
            String path = uri.toString();
            if (path.startsWith("jar:")) {
                path = path.substring(4, path.length());
            }
            uri = new URI(path);
            starterJarFile = new File(uri);
            codeBaseDir = starterJarFile.getParentFile();
            OSPRuntime.setLaunchJarPath(starterJarFile.getAbsolutePath());
        }
        catch (Exception ex) {
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
        try {
            userHome = OSPRuntime.getUserHome();
            javaHome = System.getProperty("java.home");
            userDocuments = OSPRuntime.isWindows() ? new JFileChooser().getFileSystemView().getDefaultDirectory().toString() : String.valueOf(userHome) + "/Documents";
            if (!new File(userDocuments).exists()) {
                userDocuments = null;
            }
        }
        catch (Exception ex) {
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
    }

    public static void main(final String[] args) {
        relaunching = false;
        logText = "";
        TrackerStarter.logMessage("launch initiated by user");
        if (OSPRuntime.isMac()) {
            launchThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String className = "org.opensourcephysics.cabrillo.tracker.deploy.OSXServices";
                    try {
                        Class<?> OSXClass = Class.forName(className);
                        Constructor<?> constructor = OSXClass.getConstructor(new Class[0]);
                        Object OSXServices2 = constructor.newInstance(new Object[0]);
                        Method m = OSXClass.getDeclaredMethod("getStatus", null);
                        Object status = m.invoke(OSXServices2, null);
                        TrackerStarter.logMessage("" + status);
                    }
                    catch (Exception ex) {
                        TrackerStarter.logMessage("OSXServices failed");
                    }
                    catch (Error err) {
                        TrackerStarter.logMessage("OSXServices failed");
                    }
                    int i = 0;
                    while (launchThread != null && i < 5) {
                        try {
                            Thread.sleep(100L);
                            ++i;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (launchThread != null) {
                        TrackerStarter.launchTracker(args);
                    }
                }
            });
            launchThread.start();
        } else {
            TrackerStarter.launchTracker(args);
        }
    }

    public static void launchTracker(String[] args) {
        boolean usesServer;
        if (launching) {
            return;
        }
        launching = true;
        TrackerStarter.logMessage("TrackerStarter running in jre: " + javaHome);
        launchThread = null;
        if (args != null && args.length > 0 && (args[0].contains("tracker.jar") || args[0].contains("tracker-") && args[0].contains(".jar"))) {
            System.setProperty(PREFERRED_TRACKER_JAR, args[0]);
            System.setProperty(TRACKER_NEW_VERSION, args[0]);
            String[] newArgs = new String[args.length - 1];
            if (newArgs.length > 0) {
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                args = newArgs;
            } else {
                args = null;
            }
        }
        String argString = null;
        if (args != null && args.length > 0) {
            argString = "";
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                argString = String.valueOf(argString) + "\"" + next + "\" ";
                ++n2;
            }
        }
        TrackerStarter.logMessage("launching with main arguments: " + argString);
        try {
            trackerHome = TrackerStarter.findTrackerHome(true);
        }
        catch (Exception ex) {
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
        if (trackerHome == null) {
            TrackerStarter.exitGracefully(null);
        }
        try {
            xuggleHome = TrackerStarter.findXuggleHome(trackerHome, true);
            if (xuggleHome != null) {
                xuggleJar = new File(trackerHome, String.valueOf(XUGGLE_JAR_NAMES[1][0]) + ".jar");
                if (xuggleJar.exists()) {
                    TrackerStarter.logMessage("xuggle 3.4 found: " + xuggleJar);
                }
                if ((xuggleServerJar = new File(trackerHome, String.valueOf(XUGGLE_JAR_NAMES[0][0]) + ".jar")).exists()) {
                    TrackerStarter.logMessage("xuggle 5.7 found: " + xuggleServerJar);
                }
            }
        }
        catch (Exception ex) {
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
        TrackerStarter.loadPreferences();
        String jarPath = null;
        try {
            jarPath = TrackerStarter.getTrackerJarPath();
        }
        catch (Exception ex) {
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
        if (jarPath == null) {
            TrackerStarter.exitGracefully(null);
        }
        xuggleVersionIndex = (usesServer = TrackerStarter.usesXuggleServer(jarPath)) ? 0 : 1;
        String xuggleVers = usesServer ? "5.7" : "3.4";
        String source = XML.forwardSlash(xuggleHome);
        if (xuggleVersionIndex == 1) {
            source = String.valueOf(source) + "/share/java/jars";
        }
        if (TrackerStarter.copyXuggleJarsTo(trackerHome, source)) {
            TrackerStarter.logMessage("xuggle " + xuggleVers + " files up to date ");
        } else {
            TrackerStarter.logMessage("xuggle " + xuggleVers + " files missing or not up to date ");
        }
        boolean launched = true;
        try {
            memorySize = preferredMemorySize;
            TrackerStarter.startTracker(jarPath, args);
        }
        catch (Exception ex) {
            launched = false;
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
        catch (Error er) {
            launched = false;
            exceptions = String.valueOf(exceptions) + er.getClass().getSimpleName() + ": " + er.getMessage() + newline;
        }
        if (!launched) {
            TrackerStarter.exitGracefully(jarPath);
        }
    }

    public static void relaunch(final String[] args, boolean secondTry) {
        relaunching = secondTry;
        launching = false;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                TrackerStarter.logMessage("relaunch initiated by Tracker");
                TrackerStarter.launchTracker(args);
            }
        };
        new Thread(runner).start();
    }

    public static String findTrackerHome(boolean writeToLog) {
        if (trackerHome != null || OSPRuntime.isJS) {
            if (writeToLog) {
                TrackerStarter.logMessage("using trackerhome: " + trackerHome);
            }
            return trackerHome;
        }
        if (codeBaseDir != null) {
            if (writeToLog) {
                TrackerStarter.logMessage("TrackerStarter jar: " + starterJarFile);
            }
            try {
                String[] fileNames = codeBaseDir.list(trackerJarFilter);
                if (fileNames != null && fileNames.length > 0) {
                    trackerHome = codeBaseDir.getPath();
                    if (writeToLog) {
                        TrackerStarter.logMessage("code base accepted as trackerhome based on contents");
                    }
                }
            }
            catch (Exception ex) {
                exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
            }
        }
        if (trackerHome == null) {
            File file = new File(null, "tracker.jar");
            String dir = file.getAbsoluteFile().getParent();
            if (TrackerStarter.fileExists(file.getAbsolutePath())) {
                trackerHome = dir;
                if (writeToLog) {
                    TrackerStarter.logMessage("parent directory accepted as trackerhome based on contents");
                }
            }
        }
        if (trackerHome == null) {
            try {
                trackerHome = System.getenv("TRACKER_HOME");
            }
            catch (Exception ex) {
                exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
            }
            if (writeToLog) {
                TrackerStarter.logMessage("environment variable TRACKER_HOME: " + trackerHome);
            }
            if (trackerHome != null && !TrackerStarter.fileExists(trackerHome)) {
                trackerHome = null;
                if (writeToLog) {
                    TrackerStarter.logMessage("TRACKER_HOME directory no longer exists");
                }
            }
        }
        if (trackerHome == null) {
            trackerHome = (String)OSPRuntime.getPreference("TRACKER_HOME");
            if (writeToLog) {
                TrackerStarter.logMessage("osp.prefs TRACKER_HOME: " + trackerHome);
            }
            if (trackerHome != null && !TrackerStarter.fileExists(trackerHome)) {
                trackerHome = null;
                if (writeToLog) {
                    TrackerStarter.logMessage("TRACKER_HOME directory no longer exists");
                }
            }
        }
        if (writeToLog) {
            TrackerStarter.logMessage("using trackerhome: " + trackerHome);
        }
        return trackerHome;
    }

    public static XMLControl findPreferences() {
        if (OSPRuntime.isJS) {
            return null;
        }
        HashMap<File, XMLControl> controls = new HashMap<File, XMLControl>();
        File firstFileFound = null;
        File newestFileFound = null;
        long modified = 0L;
        int i = 0;
        while (i < 2) {
            XMLControlElement control;
            String prefsFileName = PREFS_FILE_NAME;
            if (i == 1) {
                prefsFileName = "." + prefsFileName;
            }
            for (String path : OSPRuntime.getDefaultSearchPaths()) {
                XMLControlElement control2;
                String prefsPath = new File(path, prefsFileName).getAbsolutePath();
                File file = new File(prefsPath);
                if (!file.exists() || (control2 = new XMLControlElement(file)).failedToRead() || !control2.getObjectClassName().endsWith("Preferences")) continue;
                if (file.lastModified() > modified + 50L) {
                    newestFileFound = file;
                    modified = file.lastModified();
                }
                controls.put(file, control2);
                if (firstFileFound != null) continue;
                firstFileFound = file;
            }
            File file = new File(prefsFileName);
            if (file.exists() && !(control = new XMLControlElement(file)).failedToRead() && control.getObjectClassName().endsWith("Preferences")) {
                if (file.lastModified() > modified + 50L) {
                    newestFileFound = file;
                    modified = file.lastModified();
                }
                controls.put(file, control);
                if (firstFileFound == null) {
                    firstFileFound = file;
                }
            }
            ++i;
        }
        if (newestFileFound != null && newestFileFound != firstFileFound) {
            ResourceLoader.copyAllFiles(newestFileFound, firstFileFound);
            controls.put(firstFileFound, (XMLControl)controls.get(newestFileFound));
        }
        if (firstFileFound != null) {
            XMLControl control = (XMLControl)controls.get(firstFileFound);
            control.setValue("prefsPath", firstFileFound.getAbsolutePath());
            return control;
        }
        return null;
    }

    public static String findXuggleHome(String trackerHome, boolean writeToLog) throws Exception {
        if (trackerHome != null) {
            File trackerHomeDir = new File(trackerHome);
            File f = new File(trackerHomeDir, "Xuggle");
            if (!f.exists() || !f.isDirectory()) {
                f = new File(trackerHomeDir.getParentFile(), "Xuggle");
            }
            if (!(f.exists() && f.isDirectory() || !OSPRuntime.isMac())) {
                f = new File("/usr/local/xuggler");
            }
            if (f.exists() && f.isDirectory()) {
                xuggleHome = f.getPath();
                if (writeToLog) {
                    TrackerStarter.logMessage("xugglehome found relative to trackerhome: " + xuggleHome);
                }
            }
        }
        if (xuggleHome == null) {
            xuggleHome = (String)OSPRuntime.getPreference("XUGGLE_HOME");
            if (writeToLog) {
                TrackerStarter.logMessage("osp.prefs XUGGLE_HOME: " + xuggleHome);
            }
            if (xuggleHome != null && !TrackerStarter.fileExists(xuggleHome)) {
                xuggleHome = null;
                if (writeToLog) {
                    TrackerStarter.logMessage("XUGGLE_HOME directory no longer exists");
                }
            }
        }
        if (xuggleHome == null) {
            try {
                xuggleHome = System.getenv("XUGGLE_HOME");
            }
            catch (Exception ex) {
                exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
            }
            if (writeToLog) {
                TrackerStarter.logMessage("environment variable XUGGLE_HOME: " + xuggleHome);
            }
            if (xuggleHome != null && !TrackerStarter.fileExists(xuggleHome)) {
                xuggleHome = null;
                if (writeToLog) {
                    TrackerStarter.logMessage("XUGGLE_HOME directory no longer exists");
                }
            }
        }
        if (xuggleHome == null) {
            throw new NullPointerException("xugglehome not found");
        }
        if (writeToLog) {
            TrackerStarter.logMessage("using xugglehome: " + xuggleHome);
        }
        return xuggleHome;
    }

    public static File getXuggleServerJar() {
        return xuggleServerJar;
    }

    public static String[] findBundledVMs() {
        if (bundledVMs != null) {
            return bundledVMs;
        }
        try {
            TrackerStarter.findTrackerHome(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (OSPRuntime.isWindows()) {
            File jre = JREFinder.getFinder().getDefaultJRE(64, trackerHome, false, "OpenJDK");
            String jrepath = jre == null ? null : jre.getPath();
            File jre32 = JREFinder.getFinder().getDefaultJRE(32, trackerHome, false, "OpenJDK");
            String jre32path = jre32 == null ? null : jre32.getPath();
            return new String[]{jrepath, jre32path};
        }
        if (OSPRuntime.isMac()) {
            File home = new File(trackerHome);
            String path = String.valueOf(home.getParent()) + "/runtime";
            File jre = JREFinder.getFinder().getDefaultJRE(64, path, false, null);
            return new String[]{jre == null ? null : jre.getPath()};
        }
        File jre = JREFinder.getFinder().getDefaultJRE(64, trackerHome, false, "OpenJDK");
        return new String[]{jre == null ? null : jre.getPath()};
    }

    private static void exitGracefully(String jarPath) {
        if (exitThread != null) {
            abortExit = true;
        }
        if (exceptions.equals("")) {
            exceptions = "None";
        }
        String startLogLine = "";
        if (startLogPath != null) {
            startLogLine = "For more information see " + startLogPath + newline;
        }
        if (jarPath != null) {
            JOptionPane.showMessageDialog(null, "Tracker could not be started due to the problem(s) listed below." + newline + "However, you may be able to start it by double-clicking the file" + newline + jarPath + "." + newline + newline + startLogLine + "For trouble-shooting or to download the latest installer," + newline + "please see https://opensourcephysics.github.io/tracker-website/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 6.3.3: Error Starting Tracker", 0);
        } else if (trackerHome == null) {
            if (codeBaseDir != null) {
                JOptionPane.showMessageDialog(null, "It appears you have an incomplete Tracker installation, since" + newline + "no directory named \"Tracker\" could be found and " + newline + "no tracker.jar or tracker-x.xx.jar file exists in " + newline + codeBaseDir + newline + newline + startLogLine + "For trouble-shooting or to download the latest installer," + newline + "please see https://https://opensourcephysics.github.io/tracker-website/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 6.3.3: Error Starting Tracker", 0);
            } else {
                JOptionPane.showMessageDialog(null, "It appears you have an incomplete Tracker installation, since" + newline + "no directory named \"Tracker\" could be found and " + newline + "no tracker.jar or tracker-x.xx.jar file exists in the current directory." + newline + newline + startLogLine + "For trouble-shooting or to download the latest installer," + newline + "please see https://https://opensourcephysics.github.io/tracker-website/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 6.3.3: Error Starting Tracker", 0);
            }
        } else {
            String jarHome = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : trackerHome;
            JOptionPane.showMessageDialog(null, "No tracker.jar or tracker-x.xx.jar was found in" + newline + jarHome + newline + newline + startLogLine + "For trouble-shooting or to download the latest installer," + newline + "please see https://https://opensourcephysics.github.io/tracker-website/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 6.3.3: Error Starting Tracker", 0);
        }
        TrackerStarter.writeUserLog();
        TrackerStarter.writeCodeBaseLog(LOG_FILE_NAME);
        OSPRuntime.exit();
        System.exit(0);
    }

    static boolean isNewInstall() {
        Object curVersion = OSPRuntime.getPreference("local_OSP_version");
        TrackerStarter.logMessage("local OSP version " + curVersion);
        if (curVersion == null) {
            return true;
        }
        String prev = curVersion.toString();
        String[] v1 = "6.3.3".split("\\.");
        String[] v2 = prev.split("\\.");
        int i = 0;
        while (i < 3) {
            int old;
            int current = Integer.parseInt(v1[i]);
            if (current > (old = Integer.parseInt(v2[i]))) {
                return true;
            }
            if (current < old) break;
            ++i;
        }
        return false;
    }

    private static void loadPreferences() {
        trackerJarPath = null;
        boolean loaded = false;
        XMLControl prefsXMLControl = TrackerStarter.findPreferences();
        boolean bl = isNewInstall = prefsXMLControl == null || TrackerStarter.isNewInstall();
        if (isNewInstall) {
            OSPRuntime.setPreference("local_OSP_version", "6.3.3");
            OSPRuntime.savePreferences();
            TrackerStarter.logMessage("a new Tracker version has been installed");
        }
        if (prefsXMLControl == null) {
            return;
        }
        String prefsPath = prefsXMLControl.getString("prefsPath");
        if (!prefsXMLControl.failedToRead()) {
            File javaFile;
            boolean useDefaultTrackerJar;
            TrackerStarter.logMessage("loading starter preferences from: " + prefsPath);
            String jar = null;
            String systemProperty = System.getProperty(PREFERRED_TRACKER_JAR);
            if (systemProperty != null) {
                loaded = true;
                trackerJarPath = systemProperty;
                jar = XML.getName(trackerJarPath);
                TrackerStarter.logMessage("system property PREFERRED_TRACKER_JAR = " + systemProperty);
            } else if (prefsXMLControl.getPropertyNamesRaw().contains("tracker_jar")) {
                loaded = true;
                jar = prefsXMLControl.getString("tracker_jar");
            }
            String versionStr = "6.3.3";
            boolean bl2 = useDefaultTrackerJar = jar == null;
            if (jar != null) {
                if (!jar.equals("tracker.jar")) {
                    String ver;
                    int dot = jar.indexOf(".jar");
                    versionStr = ver = jar.substring(8, dot);
                    int n = ver.toLowerCase().indexOf(snapshot);
                    if (n > -1) {
                        ver = ver.substring(0, n);
                    }
                    if (new OSPRuntime.Version(ver).isValid()) {
                        if (new File(trackerHome, jar).exists()) {
                            preferredVersionString = versionStr;
                            TrackerStarter.logMessage("preferred Tracker version: " + preferredVersionString);
                            useDefaultTrackerJar = false;
                        } else {
                            useDefaultTrackerJar = true;
                            TrackerStarter.logMessage("preferred Tracker not found: " + jar);
                        }
                    } else {
                        TrackerStarter.logMessage("version number not valid: " + ver);
                    }
                } else {
                    TrackerStarter.logMessage("preferred Tracker version: tracker.jar");
                }
            }
            if (isNewInstall) {
                useDefaultTrackerJar = true;
                if (jar != null && !"tracker.jar".equals(jar)) {
                    TrackerStarter.logMessage("new installation--preferred Tracker version ignored");
                }
                jar = "tracker.jar";
                preferredVersionString = null;
            }
            if (useDefaultTrackerJar) {
                if (jar == null) {
                    TrackerStarter.logMessage("no preferred Tracker version, using tracker.jar (presumed 6.3.3)");
                } else {
                    TrackerStarter.logMessage("using default tracker.jar (presumed 6.3.3)");
                }
            }
            String jarName = useDefaultTrackerJar ? "tracker.jar" : jar;
            String jarHome = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : trackerHome;
            String jarPath = new File(jarHome, jarName).getAbsolutePath();
            boolean requestXuggleServer = TrackerStarter.usesXuggleServer(jarPath);
            TrackerStarter.logMessage("preferred xuggle version: " + (requestXuggleServer ? "5.7 server" : "3.4"));
            preferredVM = null;
            if (prefsXMLControl.getPropertyNamesRaw().contains("java_vm")) {
                loaded = true;
                preferredVM = prefsXMLControl.getString("java_vm");
                TrackerStarter.logMessage("preferred java VM: " + preferredVM);
            }
            if (requestXuggleServer && xuggleServerJar != null && preferredVM != null && JREFinder.getFinder().is32BitVM(preferredVM)) {
                TrackerStarter.logMessage("preferred VM ignored since xuggle 5.7 requires a 64 bit java VM");
                preferredVM = null;
            }
            if (OSPRuntime.isWindows() && !requestXuggleServer && xuggleJar != null && preferredVM != null && !JREFinder.getFinder().is32BitVM(preferredVM)) {
                TrackerStarter.logMessage("preferred VM ignored since xuggle 3.4 requires a 32 bit java VM");
                preferredVM = null;
            }
            if (isNewInstall && preferredVM != null) {
                TrackerStarter.logMessage("new installation--preferred VM ignored");
                preferredVM = null;
            }
            if (preferredVM != null) {
                javaFile = OSPRuntime.getJavaFile(preferredVM);
                if (javaFile != null) {
                    javaCommand = XML.stripExtension(javaFile.getPath());
                } else {
                    TrackerStarter.logMessage("preferred java VM invalid");
                    preferredVM = null;
                }
            }
            if (preferredVM == null) {
                bundledVMs = TrackerStarter.findBundledVMs();
                if (requestXuggleServer && xuggleServerJar != null) {
                    if (bundledVMs[0] == null) {
                        File javaFile2;
                        File vm = JREFinder.getFinder().getDefaultJRE(64, trackerHome, true, null);
                        if (vm != null && (javaFile2 = OSPRuntime.getJavaFile(vm.getPath())) != null) {
                            TrackerStarter.logMessage("no bundled VM, using default VM: " + vm.getPath());
                            javaCommand = XML.stripExtension(javaFile2.getPath());
                        }
                    } else {
                        javaFile = OSPRuntime.getJavaFile(bundledVMs[0]);
                        if (javaFile != null) {
                            TrackerStarter.logMessage("using bundled VM: " + bundledVMs[0]);
                            javaCommand = XML.stripExtension(javaFile.getPath());
                        }
                    }
                } else if (!requestXuggleServer && xuggleJar != null) {
                    int bitness;
                    int index = OSPRuntime.isWindows() ? 1 : 0;
                    int n = bitness = OSPRuntime.isWindows() ? 32 : 64;
                    if (bundledVMs.length <= index || bundledVMs[index] == null) {
                        File javaFile3;
                        File vm = JREFinder.getFinder().getDefaultJRE(bitness, trackerHome, true, null);
                        if (vm != null && (javaFile3 = OSPRuntime.getJavaFile(vm.getPath())) != null) {
                            TrackerStarter.logMessage("no bundled VM, using default VM: " + vm.getPath());
                            javaCommand = XML.stripExtension(javaFile3.getPath());
                        }
                    } else {
                        File javaFile4 = OSPRuntime.getJavaFile(bundledVMs[index]);
                        if (javaFile4 != null) {
                            TrackerStarter.logMessage("using bundled VM: " + bundledVMs[index]);
                            javaCommand = XML.stripExtension(javaFile4.getPath());
                        }
                    }
                } else {
                    TrackerStarter.logMessage("no bundled java VM, using current VM");
                }
            }
            if (prefsXMLControl.getPropertyNamesRaw().contains("run")) {
                loaded = true;
                executables = (String[])prefsXMLControl.getObject("run");
                int i = 0;
                while (i < executables.length) {
                    String app = executables[i];
                    if (app != null) {
                        File runFile = new File(trackerHome, app);
                        if (!runFile.exists() && !(runFile = new File(app)).exists()) {
                            runFile = null;
                            TrackerStarter.logMessage("executable file not found: " + app);
                        }
                        if (runFile != null) {
                            try {
                                TrackerStarter.logMessage("executing " + runFile.getAbsolutePath());
                                ProcessBuilder pb = new ProcessBuilder(runFile.getAbsolutePath());
                                pb.directory(new File(trackerHome));
                                Process p = pb.start();
                                p.waitFor();
                            }
                            catch (Exception ex) {
                                TrackerStarter.logMessage("execution failed: " + ex.getClass().getSimpleName() + " " + ex.getMessage());
                            }
                        }
                    }
                    ++i;
                }
            }
            preferredMemorySize = 0;
            systemProperty = System.getProperty(PREFERRED_MEMORY_SIZE);
            if (systemProperty != null) {
                loaded = true;
                try {
                    preferredMemorySize = Integer.parseInt(systemProperty);
                    TrackerStarter.logMessage("system property PREFERRED_MEMORY_SIZE = " + systemProperty);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (prefsXMLControl.getPropertyNamesRaw().contains("memory_size")) {
                preferredMemorySize = prefsXMLControl.getInt("memory_size");
            }
            if (preferredMemorySize > 0) {
                TrackerStarter.logMessage("preferred memory size: " + preferredMemorySize + " MB");
            } else {
                preferredMemorySize = 1024;
                TrackerStarter.logMessage("using default memory size: " + preferredMemorySize + " MB");
            }
            if (!loaded) {
                TrackerStarter.logMessage("no starter preferences found in " + prefsPath);
            }
        }
    }

    public static String[] getXuggleJarNames(String jarpath) {
        xuggleVersionIndex = jarpath == null ? 0 : (TrackerStarter.usesXuggleServer(jarpath) ? 0 : 1);
        return XUGGLE_JAR_NAMES[xuggleVersionIndex];
    }

    private static String getTrackerJarPath() throws Exception {
        File file;
        String jarHome;
        String jarPath;
        block17: {
            if (trackerJarPath != null) {
                return trackerJarPath;
            }
            jarPath = null;
            String string = jarHome = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : trackerHome;
            if (OSPRuntime.isMac()) {
                TrackerStarter.logMessage("Mac OSX: looking for tracker jars in " + jarHome);
            } else if (OSPRuntime.isWindows()) {
                TrackerStarter.logMessage("Windows: looking for tracker jars in " + jarHome);
            } else {
                TrackerStarter.logMessage("Linux: looking for tracker jars in " + jarHome);
            }
            try {
                File dir = new File(jarHome);
                String[] fileNames = dir.list(trackerJarFilter);
                if (fileNames == null || fileNames.length <= 0) break block17;
                String s = "tracker jars found: ";
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    s = String.valueOf(s) + next + ", ";
                    ++n2;
                }
                TrackerStarter.logMessage(s.substring(0, s.length() - 2));
                String defaultJar = null;
                String numberedJar = null;
                OSPRuntime.Version newestVersion = null;
                int i = 0;
                while (i < fileNames.length) {
                    if ("tracker.jar".equals(fileNames[i].toLowerCase())) {
                        defaultJar = fileNames[i];
                    }
                    try {
                        OSPRuntime.Version v;
                        String vers = fileNames[i].substring(8);
                        String versionStr = vers = vers.substring(0, vers.length() - 4);
                        int n3 = vers.toLowerCase().indexOf(snapshot);
                        if (n3 > -1) {
                            vers = vers.substring(0, n3);
                        }
                        if ((v = new OSPRuntime.Version(vers)).isValid()) {
                            if (versionStr.equals(preferredVersionString)) {
                                File file2 = new File(jarHome, fileNames[i]);
                                TrackerStarter.logMessage("using tracker jar: " + file2.getAbsolutePath());
                                return file2.getAbsolutePath();
                            }
                            if (newestVersion == null || newestVersion.compareTo(v) < 0) {
                                newestVersion = v;
                                numberedJar = fileNames[i];
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                jarPath = defaultJar != null ? defaultJar : numberedJar;
            }
            catch (Exception ex) {
                exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
                TrackerStarter.logMessage(ex.toString());
                jarPath = "tracker.jar";
            }
        }
        if (jarPath != null && (file = new File(jarHome, jarPath)).exists()) {
            String path = XML.forwardSlash(file.getAbsolutePath());
            TrackerStarter.logMessage("using tracker jar: " + path);
            return path;
        }
        throw new NullPointerException("No Tracker jar files found in " + jarHome);
    }

    public static boolean copyXuggleJarsTo(String targetDir, String xuggleDir) {
        if (xuggleDir == null || targetDir == null) {
            return false;
        }
        File xuggleJarDir = new File(xuggleDir);
        xuggleVersionIndex = xuggleDir.contains("share/java/jars") ? 1 : 0;
        File[] xuggleJars = xuggleJarDir.listFiles(xuggleFileFilter);
        boolean upToDate = true;
        String[] xuggleNames = XUGGLE_JAR_NAMES[xuggleVersionIndex];
        int i = 0;
        while (i < xuggleNames.length) {
            File target;
            File xuggleFile = null;
            long modified = 0L;
            int j = 0;
            while (j < xuggleJars.length) {
                if (xuggleJars[j].getName().startsWith(xuggleNames[i]) && xuggleJars[j].lastModified() > modified) {
                    xuggleFile = xuggleJars[j];
                    modified = xuggleFile.lastModified();
                }
                ++j;
            }
            if (!(xuggleFile == null || (target = new File(targetDir, String.valueOf(xuggleNames[i]) + ".jar")).exists() && target.lastModified() >= modified)) {
                upToDate = ResourceLoader.copyFile(xuggleFile, target, 100000) && upToDate;
            }
            ++i;
        }
        return upToDate;
    }

    private static void startTracker(String jarPath, String[] args) throws Exception {
        Process process;
        int result;
        String newVersionURL = System.getProperty(TRACKER_NEW_VERSION);
        ArrayList<String> cmd = new ArrayList<String>();
        if (javaCommand.equals("java") && javaHome != null) {
            javaCommand = String.valueOf(XML.forwardSlash(javaHome)) + "/bin/java";
        }
        cmd.add(javaCommand);
        boolean isOpenjdk = javaCommand.contains("OpenJDK");
        File file = new File(trackerHome, "fontconfig.properties");
        boolean hasLocalFontConfig = file.exists();
        if (isOpenjdk && hasLocalFontConfig) {
            String s = "-Dsun.awt.fontconfig=" + file.getPath();
            cmd.add(s);
            TrackerStarter.logMessage("found fontconfig.properties at " + file.getPath());
        }
        if (memorySize > 0) {
            cmd.add("-Xms32m");
            cmd.add("-Xmx" + memorySize + "m");
        }
        if (OSPRuntime.isMac()) {
            cmd.add("-Xdock:name=Tracker");
        }
        cmd.add("-jar");
        cmd.add(jarPath);
        if (args != null && args.length > 0) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                if (next != null) {
                    cmd.add(next);
                }
                ++n2;
            }
        }
        ProcessBuilder builder = new ProcessBuilder(cmd);
        Map<String, String> env = builder.environment();
        if (memorySize < preferredMemorySize) {
            env.put("MEMORY_SIZE", String.valueOf(memorySize));
            TrackerStarter.logMessage("setting environment variable MEMORY_SIZE = " + String.valueOf(memorySize));
        } else {
            env.remove("MEMORY_SIZE");
        }
        env.remove("XUGGLE_WARNING");
        env.remove("FFMPEG_WARNING");
        if (starterWarning != null) {
            env.put("STARTER_WARNING", starterWarning);
        } else {
            env.remove("STARTER_WARNING");
        }
        if (trackerHome != null) {
            env.put("TRACKER_HOME", trackerHome);
            TrackerStarter.logMessage("setting TRACKER_HOME = " + trackerHome);
        }
        if (xuggleHome != null) {
            String subdir;
            env.put("XUGGLE_HOME", xuggleHome);
            TrackerStarter.logMessage("setting XUGGLE_HOME = " + xuggleHome);
            String string = subdir = OSPRuntime.isWindows() ? "bin" : "lib";
            if (xuggleJar.exists() && new File(xuggleHome, subdir).exists()) {
                String pathEnvironment = OSPRuntime.isWindows() ? "Path" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
                String xugglePath = String.valueOf(xuggleHome) + File.separator + subdir;
                String pathValue = env.get(pathEnvironment);
                if (pathValue == null) {
                    pathValue = "";
                }
                if (!pathValue.startsWith(xugglePath)) {
                    pathValue = String.valueOf(xugglePath) + File.pathSeparator + pathValue;
                }
                env.put(pathEnvironment, pathValue);
                TrackerStarter.logMessage("adding to " + pathEnvironment + ": " + (String)xugglePath);
            }
        }
        if (relaunching) {
            env.put(TRACKER_RELAUNCH, "true");
        } else {
            env.remove(TRACKER_RELAUNCH);
        }
        if (isNewInstall) {
            env.put(NEW_INSTALL, "true");
        } else {
            env.remove(NEW_INSTALL);
        }
        if (newVersionURL != null) {
            TrackerStarter.logMessage("setting TRACKER_NEW_VERSION = " + newVersionURL);
            env.put(TRACKER_NEW_VERSION, newVersionURL);
        } else {
            env.remove(TRACKER_NEW_VERSION);
        }
        String message = "";
        for (String next : cmd) {
            message = String.valueOf(message) + next + " ";
        }
        TrackerStarter.logMessage("executing command: " + message);
        TrackerStarter.writeCodeBaseLog(LOG_FILE_NAME);
        String prevLogText = System.getenv("START_LOG_TEXT");
        if (prevLogText != null) {
            logText = String.valueOf(prevLogText) + "\n" + logText;
        }
        env.put("START_LOG_TEXT", logText);
        startLogPath = TrackerStarter.writeUserLog();
        if (startLogPath != null) {
            env.put("START_LOG", startLogPath);
        }
        exitCounter = 0;
        if (exitThread == null) {
            exitThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    abortExit = false;
                    while (exitCounter < 20) {
                        try {
                            if (abortExit) {
                                return;
                            }
                            Thread.sleep(100L);
                            ++exitCounter;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    OSPRuntime.exit();
                    System.exit(0);
                }
            });
            exitThread.setDaemon(true);
            exitThread.start();
        }
        if ((result = (process = builder.start()).waitFor()) > 0) {
            String errors = "";
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String s = reader.readLine();
                while (s != null && s.length() > 0) {
                    errors = String.valueOf(errors) + "\n      " + s;
                    s = reader.readLine();
                }
                reader.close();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                s = reader.readLine();
                while (s != null && s.length() > 0) {
                    errors = String.valueOf(errors) + "\n      " + s;
                    s = reader.readLine();
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TrackerStarter.logMessage("failed to start with memory size " + memorySize + "MB due to the following errors:" + errors);
            if (errors.indexOf("heap") > -1) {
                if ((memorySize = (int)((double)memorySize * 0.95)) < 64) {
                    exceptions = String.valueOf(exceptions) + errors + newline;
                    TrackerStarter.exitGracefully(jarPath);
                }
                TrackerStarter.logMessage("try to start with smaller memory size " + memorySize + "MB");
                TrackerStarter.startTracker(jarPath, args);
            } else {
                exceptions = String.valueOf(exceptions) + errors + newline;
                TrackerStarter.exitGracefully(jarPath);
            }
        } else {
            OSPRuntime.exit();
            System.exit(0);
        }
    }

    private static String writeUserLog() {
        if ("".equals(logText) || trackerHome == null) {
            return null;
        }
        File file = null;
        File ospPrefsFile = OSPRuntime.getPreferencesFile();
        if (ospPrefsFile != null && ospPrefsFile.getParentFile().canWrite()) {
            file = new File(ospPrefsFile.getParentFile(), LOG_FILE_NAME);
        }
        if (file == null && userDocuments != null && new File(String.valueOf(userDocuments) + "/Tracker").canWrite()) {
            file = new File(String.valueOf(userDocuments) + "/Tracker", LOG_FILE_NAME);
        }
        if (file == null && new File(trackerHome).canWrite()) {
            file = new File(trackerHome, LOG_FILE_NAME);
        }
        if (file == null) {
            return null;
        }
        TrackerStarter.addLogHeader();
        TrackerStarter.logMessage("writing user start log to " + file.getAbsolutePath());
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName(encoding);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, charset);
            BufferedWriter writer = new BufferedWriter(out);
            writer.write(logText);
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static void addLogHeader() {
        if (!logText.startsWith("TrackerStarter")) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss  MMM dd yyyy");
            Calendar cal = Calendar.getInstance();
            logText = "TrackerStarter version 6.3.3  " + sdf.format(cal.getTime()) + newline + newline + logText;
        }
    }

    private static void writeCodeBaseLog(String fileName) {
        if (codeBaseDir != null && codeBaseDir.canWrite()) {
            TrackerStarter.addLogHeader();
            File file = new File(codeBaseDir, fileName);
            TrackerStarter.logMessage("writing code base start log " + file.getAbsolutePath());
            try {
                FileOutputStream stream = new FileOutputStream(file);
                Charset charset = Charset.forName(encoding);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, charset);
                BufferedWriter writer = new BufferedWriter(out);
                writer.write(logText);
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                TrackerStarter.logMessage("exception writing code base start log (access denied?)");
            }
        } else {
            TrackerStarter.logMessage("unable to write code base start log");
        }
    }

    public static boolean usesXuggleServer(String jarpath) {
        Boolean b = usesXuggleServer.get(jarpath = XML.forwardSlash(jarpath));
        if (b != null) {
            return b;
        }
        boolean usesServer = false;
        try {
            JarFile jarfile = new JarFile(jarpath);
            String classpath = OSPRuntime.getManifestAttribute(jarfile, "Class-Path");
            usesServer = classpath.contains("-server-");
            usesXuggleServer.put(jarpath, usesServer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return usesServer;
    }

    private static boolean fileExists(String path) {
        File file = new File(path);
        try {
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception ex) {
            exceptions = String.valueOf(exceptions) + ex.getClass().getSimpleName() + ": " + ex.getMessage() + newline;
        }
        catch (Error er) {
            exceptions = String.valueOf(exceptions) + er.getClass().getSimpleName() + ": " + er.getMessage() + newline;
        }
        return false;
    }

    public static void logMessage(String message) {
        if (log) {
            logText = String.valueOf(logText) + " - " + message + newline;
        }
        if (debug) {
            System.out.println(message);
        }
    }
}

