/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Dimension;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.Collection;
import javajs.async.SwingJSUtils;
import javax.swing.JFrame;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Util;

public abstract class AbstractAnimation
implements Animation,
Runnable,
SwingJSUtils.StateMachine {
    protected OSPFrame mainFrame;
    protected Control control;
    protected volatile Thread animationThread;
    protected int delayTime = 100;
    long t0 = System.currentTimeMillis();
    protected DecimalFormat sciFormat;
    protected DecimalFormat decimalFormat = this.sciFormat = Util.newDecimalFormat("0.00E0");
    SwingJSUtils.StateHelper stateHelper;
    private static final int STATE_INIT = 0;
    private static final int STATE_LOOP = 1;
    static final int STATE_DONE = 2;

    @Override
    public void setControl(Control control) {
        this.control = control;
        this.mainFrame = null;
        if (control != null) {
            if (control instanceof MainFrame) {
                this.mainFrame = ((MainFrame)((Object)control)).getMainFrame();
            }
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public void setDelayTime(int delay) {
        this.delayTime = delay;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public OSPFrame getMainFrame() {
        return this.mainFrame;
    }

    public int[] getMainFrameSize() {
        Dimension d = this.mainFrame.getSize();
        return new int[]{d.width, d.height};
    }

    public OSPApplication getOSPApp() {
        if (this.control instanceof MainFrame) {
            return ((MainFrame)((Object)this.control)).getOSPApp();
        }
        return null;
    }

    public void addChildFrame(JFrame frame) {
        if (this.mainFrame == null || frame == null) {
            return;
        }
        this.mainFrame.addChildFrame(frame);
    }

    public void clearChildFrames() {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.clearChildFrames();
    }

    public Collection<JFrame> getChildFrames() {
        return this.mainFrame.getChildFrames();
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void initializeAnimation() {
        this.control.clearMessages();
    }

    protected abstract void doStep();

    @Override
    public synchronized void stopAnimation() {
        if (this.stateHelper != null) {
            this.stateHelper.setState(2);
        }
        if (this.animationThread == null) {
            return;
        }
        Thread tempThread = this.animationThread;
        this.animationThread = null;
        if (this.stateHelper != null) {
            this.stateHelper.setState(2);
        }
        if (Thread.currentThread() == tempThread) {
            return;
        }
        try {
            tempThread.interrupt();
            if (!OSPRuntime.isJS) {
                tempThread.join(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isRunning() {
        return this.animationThread != null;
    }

    @Override
    public synchronized void stepAnimation() {
        if (this.animationThread != null) {
            this.stopAnimation();
            return;
        }
        this.doStep();
    }

    @Override
    public synchronized void startAnimation() {
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = new Thread(this);
        this.animationThread.setPriority(5);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
    }

    @Override
    public void resetAnimation() {
        if (this.animationThread != null) {
            this.stopAnimation();
        }
        this.control.clearMessages();
    }

    @Override
    public boolean stateLoop() {
        if (this.animationThread != null && !this.animationThread.isInterrupted() && this.stateHelper.isAlive()) {
            switch (this.stateHelper.getState()) {
                default: {
                    this.stateHelper.setState(1);
                    this.stateHelper.sleep(this.delayTime);
                    return true;
                }
                case 1: {
                    long currentTime = System.currentTimeMillis();
                    this.doStep();
                    int sleepTime = (int)Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - currentTime));
                    this.stateHelper.sleep(sleepTime);
                    return true;
                }
                case 2: 
            }
            return false;
        }
        return false;
    }

    @Override
    public void run() {
        this.stateHelper = new SwingJSUtils.StateHelper(this);
        this.stateHelper.setState(0);
        this.stateHelper.sleep(0);
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPAnimationLoader();
    }

    static class OSPAnimationLoader
    extends XMLLoader {
        OSPAnimationLoader() {
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ((Animation)obj).initializeAnimation();
            return obj;
        }
    }
}

