/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Dimension;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JFrame;
import org.opensourcephysics.controls.Calculation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.numerics.Util;

public abstract class AbstractCalculation
implements Calculation {
    protected OSPFrame mainFrame;
    protected Control control;
    protected DecimalFormat decimalFormat = Util.newDecimalFormat("0.00E0");

    @Override
    public void setControl(Control control) {
        this.control = control;
        this.mainFrame = null;
        if (control != null) {
            if (control instanceof MainFrame) {
                this.mainFrame = ((MainFrame)((Object)control)).getMainFrame();
            }
            control.setLockValues(true);
            this.resetCalculation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public OSPFrame getMainFrame() {
        return this.mainFrame;
    }

    public int[] getMainFrameSize() {
        Dimension d = this.mainFrame.getSize();
        return new int[]{d.width, d.height};
    }

    public void addChildFrame(JFrame frame) {
        if (this.mainFrame == null || frame == null) {
            return;
        }
        this.mainFrame.addChildFrame(frame);
    }

    public OSPApplication getOSPApp() {
        if (this.control instanceof MainFrame) {
            return ((MainFrame)((Object)this.control)).getOSPApp();
        }
        return null;
    }

    public void clearChildFrames() {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.clearChildFrames();
    }

    public Collection<JFrame> getChildFrames() {
        return this.mainFrame.getChildFrames();
    }

    @Override
    public abstract void calculate();

    @Override
    public void resetCalculation() {
        this.control.clearMessages();
        this.reset();
    }

    public void reset() {
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPCalculationLoader();
    }

    static class OSPCalculationLoader
    extends XMLLoader {
        OSPCalculationLoader() {
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ((Calculation)obj).calculate();
            return obj;
        }
    }
}

