/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Frame;
import java.util.Collection;
import javajs.async.SwingJSUtils;
import org.opensourcephysics.controls.AbstractAnimation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.GUIUtils;

public abstract class AbstractSimulation
extends AbstractAnimation
implements Simulation,
SwingJSUtils.StateMachine {
    protected SimControl control;
    protected boolean showStepsPerDisplay = false;
    protected int stepsPerDisplay = 1;
    protected int stepCounter = 0;
    private SwingJSUtils.StateHelper stateHelper;
    private static final int STATE_INIT = 0;
    private static final int STATE_LOOP = 1;
    private static final int STATE_DONE = 2;

    @Override
    public void setControl(Control control) {
        this.control = control instanceof SimControl ? (SimControl)control : new ShadowControl(control);
        ((AbstractAnimation)this).control = control;
        this.mainFrame = null;
        if (control != null) {
            if (control instanceof MainFrame) {
                this.mainFrame = ((MainFrame)((Object)control)).getMainFrame();
            }
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public void startRunning() {
    }

    public void stopRunning() {
    }

    @Override
    @Deprecated
    public void startAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.start();
        this.startRunning();
        super.startAnimation();
    }

    @Override
    public final void startSimulation() {
        this.startAnimation();
    }

    public void start() {
    }

    @Override
    @Deprecated
    public void stopAnimation() {
        super.stopAnimation();
        this.stopRunning();
        this.stop();
    }

    @Override
    public final void stopSimulation() {
        this.stopAnimation();
    }

    public void stop() {
    }

    @Override
    public final void stepAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.startRunning();
        super.stepAnimation();
        ++this.stepCounter;
        this.stopRunning();
        GUIUtils.repaintAnimatedFrames();
    }

    @Override
    @Deprecated
    public void initializeAnimation() {
        if (this.control == null) {
            return;
        }
        super.initializeAnimation();
        this.initialize();
        this.stepCounter = 0;
    }

    public int getStepCounter() {
        return this.stepCounter;
    }

    public void initialize() {
    }

    @Override
    @Deprecated
    public void resetAnimation() {
        if (this.control == null) {
            return;
        }
        super.resetAnimation();
        this.stepsPerDisplay = 1;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
        this.reset();
    }

    public void enableStepsPerDisplay(boolean enable) {
        this.showStepsPerDisplay = enable;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        } else {
            this.control.removeParameter("steps per display");
        }
    }

    public void setStepsPerDisplay(int num) {
        this.stepsPerDisplay = Math.max(num, 1);
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
    }

    public int getStepsPerDisplay() {
        return this.stepsPerDisplay;
    }

    public void reset() {
    }

    @Override
    public boolean stateLoop() {
        if (this.animationThread != null && !this.animationThread.isInterrupted() && this.stateHelper.isAlive()) {
            switch (this.stateHelper.getState()) {
                default: {
                    GUIUtils.setAnimatedFrameIgnoreRepaint(true);
                    this.stateHelper.setState(1);
                    this.stateHelper.sleep(this.delayTime);
                    return true;
                }
                case 1: {
                    long currentTime = System.currentTimeMillis();
                    int i = 0;
                    while (i < this.stepsPerDisplay) {
                        this.doStep();
                        ++i;
                    }
                    int sleepTime = (int)Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - currentTime));
                    GUIUtils.renderAnimatedFrames();
                    this.stateHelper.sleep(sleepTime);
                    return true;
                }
                case 2: 
            }
            GUIUtils.setAnimatedFrameIgnoreRepaint(false);
            return false;
        }
        return false;
    }

    @Override
    public void run() {
        this.stateHelper = new SwingJSUtils.StateHelper(this);
        this.stateHelper.setState(0);
        this.stateHelper.sleep(0);
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPSimulationLoader();
    }

    static class OSPSimulationLoader
    extends XMLLoader {
        OSPSimulationLoader() {
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ((Simulation)obj).initializeAnimation();
            return obj;
        }
    }

    private class ShadowControl
    implements SimControl {
        Control control;

        ShadowControl(Control control) {
            this.control = control;
        }

        @Override
        public void setAdjustableValue(String name, boolean val) {
            this.control.setValue(name, val);
        }

        @Override
        public void setAdjustableValue(String name, double val) {
            this.control.setValue(name, val);
        }

        @Override
        public void setAdjustableValue(String name, int val) {
            this.control.setValue(name, val);
        }

        @Override
        public void setAdjustableValue(String name, Object val) {
            this.control.setValue(name, val);
        }

        @Override
        public void removeParameter(String name) {
        }

        @Override
        public void setLockValues(boolean lock) {
            this.control.setLockValues(lock);
        }

        @Override
        public void setValue(String name, Object val) {
            this.control.setValue(name, val);
        }

        @Override
        public void setValue(String name, double val) {
            this.control.setValue(name, val);
        }

        @Override
        public void setValue(String name, int val) {
            this.control.setValue(name, val);
        }

        @Override
        public void setValue(String name, boolean val) {
            this.control.setValue(name, val);
        }

        @Override
        public int getInt(String name) {
            return this.control.getInt(name);
        }

        @Override
        public double getDouble(String name) {
            return this.control.getDouble(name);
        }

        @Override
        public Object getObject(String name) {
            return this.control.getObject(name);
        }

        @Override
        public String getString(String name) {
            return this.control.getString(name);
        }

        @Override
        public boolean getBoolean(String name) {
            return this.control.getBoolean(name);
        }

        @Override
        public Collection<String> getPropertyNames() {
            return this.control.getPropertyNames();
        }

        @Override
        public Collection<String> getPropertyNamesRaw() {
            return this.control.getPropertyNamesRaw();
        }

        @Override
        public void println(String s) {
            this.control.println(s);
        }

        @Override
        public void println() {
            this.control.println();
        }

        @Override
        public void print(String s) {
            this.control.print(s);
        }

        @Override
        public void clearMessages() {
            this.control.clearMessages();
        }

        @Override
        public void clearValues() {
            this.control.clearValues();
        }

        @Override
        public void calculationDone(String message) {
            this.control.calculationDone(message);
        }

        @Override
        public void setParameterToFixed(String name, boolean fixed) {
        }
    }
}

