/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.opensourcephysics.controls.Calculation;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControl;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;

public class CalculationControl
extends OSPControl {
    protected Calculation calculation;
    static final String resetToolTipText = ControlsRes.CALCULATION_RESET_TIP;
    static final String calcToolTipText = ControlsRes.CALCULATION_CALC_TIP;
    JButton calcBtn;
    JButton resetBtn;

    public CalculationControl(Calculation _calculation) {
        super(_calculation);
        this.calculation = _calculation;
        if (this.model != null) {
            String name = this.model.getClass().getName();
            this.setTitle(String.valueOf(name.substring(1 + name.lastIndexOf("."))) + " " + ControlsRes.getString("CalculationControl.Title"));
        }
        this.calcBtn = new JButton(ControlsRes.CALCULATION_CALC);
        this.calcBtn.setToolTipText(calcToolTipText);
        this.resetBtn = new JButton(ControlsRes.CALCULATION_RESET);
        this.resetBtn.setToolTipText(resetToolTipText);
        this.calcBtn.addActionListener(new CalcBtnListener());
        this.resetBtn.addActionListener(new ResetBtnListener());
        this.buttonPanel.add(this.calcBtn);
        this.buttonPanel.add(this.resetBtn);
        this.validate();
        this.pack();
    }

    @Override
    public OSPFrame getMainFrame() {
        return this;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        if (this.calcBtn == null) {
            return;
        }
        this.calcBtn.setText(ControlsRes.CALCULATION_CALC);
        this.resetBtn.setText(ControlsRes.CALCULATION_RESET);
    }

    public static CalculationControl createApp(Calculation model) {
        CalculationControl control = new CalculationControl(model);
        model.setControl(control);
        return control;
    }

    public static CalculationControl createApp(Calculation model, String[] xml) {
        CalculationControl control = CalculationControl.createApp(model);
        control.loadXML(xml);
        return control;
    }

    private class CalcBtnListener
    implements ActionListener {
        private CalcBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIUtils.clearDrawingFrameData(false);
            if (CalculationControl.this.calculation == null) {
                CalculationControl.this.println("The CalculationControl's model is null.");
                return;
            }
            CalculationControl.this.calculation.calculate();
            GUIUtils.showDrawingAndTableFrames();
        }
    }

    private class ResetBtnListener
    implements ActionListener {
        private ResetBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIUtils.clearDrawingFrameData(true);
            if (CalculationControl.this.calculation == null) {
                CalculationControl.this.println("The CalculationControl's model is null.");
                return;
            }
            CalculationControl.this.calculation.resetCalculation();
            if (CalculationControl.this.xmlDefault != null) {
                CalculationControl.this.xmlDefault.loadObject(CalculationControl.this.getOSPApp(), true, true);
            }
            CalculationControl.this.table.refresh();
        }
    }
}

