/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javajs.async.AsyncFileChooser;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.Calculation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

public abstract class ControlFrame
extends OSPFrame
implements Control {
    static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Object model;
    protected JMenuItem[] languageItems;
    protected JMenu languageMenu;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu displayMenu;
    protected JMenuItem readItem;
    protected JMenuItem clearItem;
    protected JMenuItem printFrameItem;
    protected JMenuItem saveFrameAsEPSItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem copyItem;
    protected JMenuItem inspectItem;
    protected JMenuItem sizeUpItem;
    protected JMenuItem sizeDownItem;
    protected OSPApplication ospApp;
    protected XMLControlElement xmlDefault;

    protected ControlFrame(String title) {
        super(title);
        this.createMenuBar();
        this.setName("controlFrame");
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        if (!OSPRuntime.appletMode) {
            this.setJMenuBar(menuBar);
        }
        this.fileMenu = new JMenu(ControlsRes.getString("ControlFrame.File"));
        this.editMenu = new JMenu(ControlsRes.getString("ControlFrame.Edit"));
        menuBar.add(this.fileMenu);
        menuBar.add(this.editMenu);
        this.readItem = new JMenuItem(ControlsRes.getString("ControlFrame.Load_XML"));
        this.saveAsItem = new JMenuItem(ControlsRes.getString("ControlFrame.Save_XML"));
        this.inspectItem = new JMenuItem(ControlsRes.getString("ControlFrame.Inspect_XML"));
        this.clearItem = new JMenuItem(ControlsRes.getString("ControlFrame.Clear_XML"));
        this.clearItem.setEnabled(false);
        this.copyItem = new JMenuItem(ControlsRes.getString("ControlFrame.Copy"));
        this.printFrameItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
        this.saveFrameAsEPSItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
        JMenu printMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        if (!OSPRuntime.isApplet) {
            this.fileMenu.add(this.readItem);
        }
        if (!OSPRuntime.isApplet) {
            this.fileMenu.add(this.saveAsItem);
        }
        this.fileMenu.add(this.inspectItem);
        this.fileMenu.add(this.clearItem);
        if (!OSPRuntime.isApplet) {
            this.fileMenu.add(printMenu);
        }
        printMenu.add(this.printFrameItem);
        printMenu.add(this.saveFrameAsEPSItem);
        this.editMenu.add(this.copyItem);
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, MENU_SHORTCUT_KEY_MASK));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.copy();
            }
        });
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.saveXML();
            }
        });
        this.inspectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.inspectXML();
            }
        });
        this.readItem.setAccelerator(KeyStroke.getKeyStroke(76, MENU_SHORTCUT_KEY_MASK));
        this.readItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.loadXML((String)null);
            }
        });
        this.clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlFrame.this.xmlDefault == null || ControlFrame.this.model == null) {
                    return;
                }
                ControlFrame.this.xmlDefault = null;
                ControlFrame.this.clearItem.setEnabled(false);
                if (ControlFrame.this.model instanceof Calculation) {
                    ((Calculation)ControlFrame.this.model).resetCalculation();
                    ((Calculation)ControlFrame.this.model).calculate();
                } else if (ControlFrame.this.model instanceof Animation) {
                    ((Animation)ControlFrame.this.model).stopAnimation();
                    ((Animation)ControlFrame.this.model).resetAnimation();
                    ((Animation)ControlFrame.this.model).initializeAnimation();
                }
                GUIUtils.repaintOSPFrames();
            }
        });
        this.printFrameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printComponent(ControlFrame.this);
            }
        });
        this.saveFrameAsEPSItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintUtils.saveComponentAsEPS(ControlFrame.this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.loadDisplayMenu();
        JMenu helpMenu = new JMenu(ControlsRes.getString("ControlFrame.Help"));
        menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(ControlsRes.getString("ControlFrame.About"));
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPRuntime.showAboutDialog(ControlFrame.this);
            }
        });
        helpMenu.add(aboutItem);
        JMenuItem sysItem = new JMenuItem(ControlsRes.getString("ControlFrame.System"));
        sysItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlUtils.showSystemProperties(true);
            }
        });
        helpMenu.add(sysItem);
        JMenuItem showItem = new JMenuItem(ControlsRes.getString("ControlFrame.Display_All_Frames"));
        showItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.showDrawingAndTableFrames();
            }
        });
        helpMenu.add(showItem);
        helpMenu.addSeparator();
        JMenuItem logItem = new JMenuItem(ControlsRes.getString("ControlFrame.Message_Log"));
        logItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.showLog();
            }
        });
        helpMenu.add(logItem);
        this.validate();
    }

    @Override
    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        this.displayMenu = super.loadDisplayMenu();
        if (this.displayMenu == null) {
            this.displayMenu = new JMenu();
            this.displayMenu.setText(ControlsRes.getString("ControlFrame.Display"));
            menuBar.add(this.displayMenu);
        }
        this.languageMenu = new JMenu();
        this.languageMenu.setText(ControlsRes.getString("ControlFrame.Language"));
        AbstractAction languageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String language = e.getActionCommand();
                OSPLog.finest("setting language to " + language);
                Locale[] locales = OSPRuntime.getInstalledLocales();
                int i = 0;
                while (i < locales.length) {
                    if (language.equals(locales[i].getDisplayName())) {
                        ToolsRes.setLocale(locales[i]);
                        return;
                    }
                    ++i;
                }
            }
        };
        Locale[] locales = OSPRuntime.getInstalledLocales();
        ButtonGroup languageGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[locales.length];
        int i = 0;
        while (i < locales.length) {
            this.languageItems[i] = new JRadioButtonMenuItem(locales[i].getDisplayName(locales[i]));
            this.languageItems[i].setActionCommand(locales[i].getDisplayName());
            this.languageItems[i].addActionListener(languageAction);
            this.languageMenu.add(this.languageItems[i]);
            languageGroup.add(this.languageItems[i]);
            ++i;
        }
        i = 0;
        while (i < locales.length) {
            if (locales[i].getLanguage().equals(ToolsRes.getLanguage())) {
                this.languageItems[i].setSelected(true);
            }
            ++i;
        }
        if (OSPRuntime.isAuthorMode() || !OSPRuntime.isLauncherMode()) {
            this.displayMenu.add(this.languageMenu);
        }
        JMenu fontMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        this.displayMenu.add(fontMenu);
        JMenuItem sizeUpItem = new JMenuItem(ControlsRes.getString("ControlFrame.Increase_Font_Size"));
        sizeUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSizer.levelUp();
            }
        });
        fontMenu.add(sizeUpItem);
        final JMenuItem sizeDownItem = new JMenuItem(ControlsRes.getString("ControlFrame.Decrease_Font_Size"));
        sizeDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSizer.levelDown();
            }
        });
        fontMenu.add(sizeDownItem);
        fontMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                sizeDownItem.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        return this.displayMenu;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.createMenuBar();
    }

    public void save() {
        ControlUtils.saveToFile(this, this);
    }

    public void readParameters() {
        ControlUtils.loadParameters(this, this);
    }

    public void copy() {
        OSPRuntime.copy(this.toString(), null);
    }

    public void saveXML() {
        AsyncFileChooser chooser = OSPRuntime.getChooser();
        if (chooser == null) {
            return;
        }
        String oldTitle = chooser.getDialogTitle();
        chooser.setDialogTitle(ControlsRes.getString("ControlFrame.Save_XML_Data"));
        chooser.setDialogTitle(oldTitle);
        int result = -1;
        try {
            result = ((JFileChooser)chooser).showSaveDialog(null);
        }
        catch (Throwable e) {
            System.err.println("InterruptedException in saveXML()().");
            e.printStackTrace();
        }
        chooser.setDialogTitle(oldTitle);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = String.valueOf(fileName) + ".xml";
                file = new File(fileName);
            }
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            XMLControlElement xml = new XMLControlElement(this.getOSPApp());
            xml.write(fileName);
        }
    }

    public void loadXML(String[] args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                this.loadXML(args[i]);
                ++i;
            }
        }
    }

    public void loadXML(XMLControlElement xml, boolean compatibleModel) {
        if (xml == null) {
            OSPLog.finer("XML data not found in ControlFrame loadXML method.");
            return;
        }
        if (OSPApplication.class.isAssignableFrom(xml.getObjectClass())) {
            this.ospApp = this.getOSPApp();
            this.ospApp.compatibleModel = compatibleModel;
            xml.loadObject(this.getOSPApp());
            this.ospApp.compatibleModel = false;
            if (this.model.getClass() == this.ospApp.getLoadedModelClass()) {
                this.xmlDefault = xml;
                this.clearItem.setEnabled(true);
            } else if (this.ospApp.getLoadedModelClass() != null) {
                this.xmlDefault = new XMLControlElement(this.getOSPApp());
                this.clearItem.setEnabled(true);
            } else {
                this.xmlDefault = null;
                this.clearItem.setEnabled(false);
                JOptionPane.showMessageDialog(this, "Model specified in file not found.", "Data not loaded.", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Data for: " + xml.getObjectClass() + ".", "OSP Application data not found.", 2);
        }
    }

    public void loadXML(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            this.loadXML();
            return;
        }
        this.loadXML(new XMLControlElement(fileName), false);
    }

    public void loadXML() {
        final AsyncFileChooser fc = OSPRuntime.getChooser();
        if (fc == null) {
            return;
        }
        final String oldTitle = fc.getDialogTitle();
        fc.showOpenDialog(this, new Runnable(){

            @Override
            public void run() {
                fc.setDialogTitle(oldTitle);
                File file = fc.getSelectedFile();
                if (file != null) {
                    ControlFrame.this.loadXML(new XMLControlElement(file), false);
                }
            }
        }, null);
    }

    public void inspectXML() {
        XMLControlElement xml = new XMLControlElement(this.getOSPApp());
        JDialog dialog = new JDialog(null, true);
        dialog.setTitle("XML Inspector");
        XMLTreePanel treePanel = new XMLTreePanel(xml);
        dialog.setContentPane(treePanel);
        dialog.setSize(new Dimension(600, 300));
        dialog.setVisible(true);
    }

    public OSPApplication getOSPApp() {
        if (this.ospApp == null) {
            this.ospApp = new OSPApplication(this, this.model);
        }
        return this.ospApp;
    }
}

