/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.tools.FontSizer;

public class ControlUtils {
    static DecimalFormat format2 = Util.newDecimalFormat("#0.00");
    static DecimalFormat format3 = Util.newDecimalFormat("#0.000");
    static DecimalFormat format4 = Util.newDecimalFormat("#0.0000");
    static DecimalFormat format_E2 = Util.newDecimalFormat("0.00E0");
    static DecimalFormat format_E3 = Util.newDecimalFormat("0.000E0");
    static DecimalFormat format_E4 = Util.newDecimalFormat("0.0000E0");
    protected static JFileChooser chooser;
    private static TextFrame sysPropFrame;

    public static String f2(double d) {
        return format2.format(d);
    }

    public static String f3(double d) {
        return format3.format(d);
    }

    public static String e2(double d) {
        return format_E2.format(d);
    }

    public static String e3(double d) {
        return format_E3.format(d);
    }

    public static String e4(double d) {
        return format_E4.format(d);
    }

    public static String f4(double d) {
        return format4.format(d);
    }

    private ControlUtils() {
    }

    public static JFrame showSystemProperties(boolean vis) {
        if (sysPropFrame == null) {
            sysPropFrame = new TextFrame(null, null);
            sysPropFrame.getTextPane().setText(ControlUtils.getSystemProperties());
            sysPropFrame.setSize(300, 400);
        }
        sysPropFrame.setVisible(vis);
        return sysPropFrame;
    }

    /*
     * Unable to fully structure code
     */
    public static String getSystemProperties() {
        block4: {
            buffer = new StringBuffer();
            try {
                sysProps = System.getProperties();
                i = 0;
                names = sysProps.propertyNames();
                while (names.hasMoreElements()) {
                    key = (String)names.nextElement();
                    buffer.append(String.valueOf(++i) + ". " + key + " = " + sysProps.getProperty(key) + "\n");
                }
                break block4;
            }
            catch (Exception e) {
                key = new String[]{"java.version", "java.vendor", "java.class.version", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator"};
                i = 0;
                ** while (i < key.length)
            }
lbl-1000:
            // 1 sources

            {
                buffer.append(String.valueOf(i) + ". " + key[i] + " = " + System.getProperty(key[i]) + "\n");
                ++i;
                continue;
            }
        }
        return buffer.toString();
    }

    public static void loadParameters(Control control, Component parent) {
        JFileChooser chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(chooser.getSelectedFile()));
                ControlUtils.readFile(control, inFile);
                inFile.close();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    public static void saveToFile(Object object, Component parent) {
        int selected;
        JFileChooser fileChooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int result = fileChooser.showSaveDialog(parent);
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists() && (selected = JOptionPane.showConfirmDialog(parent, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + " " + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(file);
            PrintWriter pw = new PrintWriter(fw);
            pw.print(object.toString());
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(parent, ControlsRes.getString("Dialog.SaveError.Message"), ControlsRes.getString("Dialog.SaveError.Title"), 0);
        }
    }

    public static void saveXML(Object obj) {
        int result = ControlUtils.getXMLFileChooser().showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + " " + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return;
            }
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = String.valueOf(fileName) + ".xml";
            }
            XMLControlElement xml = new XMLControlElement(obj);
            xml.write(fileName);
        }
    }

    public static JFileChooser getXMLFileChooser() {
        if (chooser != null) {
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            return chooser;
        }
        chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && (extension.equals("xml") || extension.equals("osp"));
            }

            @Override
            public String getDescription() {
                return "XML files";
            }
        };
        chooser.addChoosableFileFilter(filter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    private static void readFile(Control control, BufferedReader inFile) throws IOException {
        String nextLine = inFile.readLine();
        while (nextLine != null) {
            String par = ControlUtils.parseParameter(nextLine);
            if (par != null && !par.equals("")) {
                control.setValue(par, ControlUtils.parseValue(nextLine));
            }
            nextLine = inFile.readLine();
        }
    }

    private static String parseParameter(String aLine) {
        int index = aLine.indexOf(61);
        if (index < 1) {
            return null;
        }
        return aLine.substring(0, index).trim();
    }

    private static String parseValue(String aLine) {
        int index = aLine.indexOf(61);
        if (index >= aLine.length() - 1) {
            return "";
        }
        return aLine.substring(index + 1).trim();
    }
}

