/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Collection;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;

public class OSPApplication {
    Control control;
    Object model;
    Class<?> loadedControlClass;
    Class<?> loadedModelClass;
    boolean compatibleModel = false;

    public OSPApplication(Control control, Object model) {
        this.control = control;
        this.model = model;
    }

    public void setCompatibleModel(boolean b) {
        this.compatibleModel = b;
    }

    public Class<?> getLoadedModelClass() {
        return this.loadedModelClass;
    }

    public Class<?> getLoadedControlClass() {
        return this.loadedControlClass;
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPAppLoader();
    }

    static class OSPAppLoader
    implements XML.ObjectLoader {
        OSPAppLoader() {
        }

        @Override
        public void saveObject(XMLControl xmlControl, Object obj) {
            OSPApplication app = (OSPApplication)obj;
            xmlControl.setValue("control", app.control);
            xmlControl.setValue("model", app.model);
        }

        @Override
        public Object createObject(XMLControl xmlControl) {
            Object model = xmlControl.getObject("model");
            Control control = (Control)xmlControl.getObject("control");
            return new OSPApplication(control, model);
        }

        @Override
        public Object loadObject(XMLControl xmlControl, Object obj) {
            OSPApplication app = (OSPApplication)obj;
            app.loadedControlClass = null;
            app.loadedModelClass = null;
            XMLControlElement cControl = (XMLControlElement)xmlControl.getChildControl("control");
            XMLControlElement mControl = (XMLControlElement)xmlControl.getChildControl("model");
            if (cControl == null || mControl == null) {
                OSPLog.fine("OSP Application not loaded. An OSP application must have a model and a control.");
                return app;
            }
            Class<?> modelClass = mControl.getObjectClass();
            Class<?> controlClass = cControl.getObjectClass();
            if (modelClass == null || controlClass == null) {
                if (controlClass == null) {
                    OSPLog.fine("Object not loaded. Cannot find class for control.");
                }
                if (modelClass == null) {
                    OSPLog.fine("Object not loaded. Cannot find class for model.");
                }
                return app;
            }
            boolean compatibleModels = app.compatibleModel;
            if (app.model != null) {
                boolean loaderMatch = XML.getLoader(modelClass).getClass() == XML.getLoader(app.model.getClass()).getClass();
                compatibleModels = compatibleModels || modelClass == app.model.getClass() || modelClass.isAssignableFrom(app.model.getClass()) && loaderMatch;
            }
            app.loadedControlClass = controlClass;
            if (app.control != null && controlClass == app.control.getClass()) {
                cControl.loadObject(app.control);
            } else {
                cControl.loadObject(app.control, true, compatibleModels);
            }
            Collection<String> appNames = app.control.getPropertyNamesRaw();
            for (String name : cControl.getPropertyNamesRaw()) {
                if (appNames.contains(name)) continue;
                app.control.setValue(name, null);
            }
            app.loadedModelClass = modelClass;
            if (app.model != null && modelClass == app.model.getClass()) {
                mControl.loadObject(app.model);
            } else {
                mControl.loadObject(app.model, true, false);
            }
            GUIUtils.repaintOSPFrames();
            return app;
        }
    }
}

