/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class OSPCombo
extends JPopupMenu {
    protected String[] items;
    protected int selected;
    int row;
    int column;

    public OSPCombo(String[] choices, int initial) {
        this.items = choices;
        this.selected = initial;
    }

    public OSPCombo(String[] choices) {
        this(choices, 0);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public String[] getItems() {
        return this.items;
    }

    public void showPopup(final JTextField display) {
        AbstractAction selectAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int prev = OSPCombo.this.selected;
                OSPCombo.this.selected = Integer.parseInt(e.getActionCommand());
                display.setText(OSPCombo.this.items[OSPCombo.this.selected]);
                OSPCombo.this.firePropertyChange("index", prev, -1);
            }
        };
        this.removeAll();
        int i = 0;
        while (i < this.items.length) {
            String next = this.items[i].toString();
            JMenuItem item = new JMenuItem(next);
            item.setFont(display.getFont());
            item.addActionListener(selectAction);
            item.setActionCommand(String.valueOf(i));
            this.add(item);
            ++i;
        }
        int popupHeight = 8 + this.getComponentCount() * display.getHeight();
        this.setPopupSize(display.getWidth(), popupHeight);
        this.show(display, 0, display.getHeight());
    }

    @Override
    public String toString() {
        return this.items[this.selected];
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            OSPCombo combo = (OSPCombo)obj;
            control.setValue("items", combo.items);
            control.setValue("index", combo.selected);
        }

        @Override
        public Object createObject(XMLControl control) {
            String[] items = (String[])control.getObject("items");
            int index = control.getInt("index");
            return new OSPCombo(items, index);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            return obj;
        }
    }
}

