/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.opensourcephysics.controls.ControlFrame;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.DoubleArray;
import org.opensourcephysics.numerics.IntegerArray;
import org.opensourcephysics.tools.ToolsRes;

public class OSPControl
extends ControlFrame
implements PropertyChangeListener,
MainFrame {
    OSPControlTable table = new OSPControlTable(new XMLControlElement());
    JScrollPane controlScrollPane = new JScrollPane(this.table);
    JTextArea messageTextArea;
    JLabel clearLabel;
    JLabel messageLabel;
    JLabel inputLabel;
    JSplitPane splitPane;
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");

    public OSPControl(Object _model) {
        super(ControlsRes.getString("OSPControl.Default_Title"));
        this.model = _model;
        if (this.model != null) {
            if (OSPRuntime.loadTranslatorTool) {
                OSPRuntime.getTranslator().associate(this, this.model.getClass());
            }
            String name = this.model.getClass().getName();
            this.setTitle(String.valueOf(name.substring(1 + name.lastIndexOf("."))) + ControlsRes.getString("OSPControl.Controller"));
        }
        Font labelFont = new Font("Dialog", 1, 12);
        this.inputLabel = new JLabel(ControlsRes.getString("OSPControl.Input_Parameters"), 0);
        this.inputLabel.setFont(labelFont);
        this.messageTextArea = GUIUtils.newJTextArea();
        this.messageTextArea.setRows(5);
        this.messageTextArea.setColumns(5);
        JScrollPane messageScrollPane = new JScrollPane(this.messageTextArea);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.inputLabel, "North");
        topPanel.add((Component)this.controlScrollPane, "Center");
        this.buttonPanel.setVisible(true);
        topPanel.add((Component)this.buttonPanel, "South");
        JPanel clearPanel = new JPanel(new BorderLayout());
        clearPanel.addMouseListener(new ClearMouseAdapter());
        this.clearLabel = new JLabel(ControlsRes.getString("OSPControl.Clear"));
        this.clearLabel.setFont(new Font(this.clearLabel.getFont().getFamily(), 0, 9));
        this.clearLabel.setForeground(Color.black);
        clearPanel.add((Component)this.clearLabel, "West");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.messageLabel = new JLabel(ControlsRes.getString("OSPControl.Messages"), 0);
        this.messageLabel.setFont(labelFont);
        bottomPanel.add((Component)this.messageLabel, "North");
        bottomPanel.add((Component)messageScrollPane, "Center");
        bottomPanel.add((Component)clearPanel, "South");
        Container cp = this.getContentPane();
        this.splitPane = new JSplitPane(0, topPanel, bottomPanel);
        this.splitPane.setOneTouchExpandable(true);
        cp.add((Component)this.splitPane, "Center");
        this.messageTextArea.setEditable(false);
        this.controlScrollPane.setPreferredSize(new Dimension(350, 200));
        this.controlScrollPane.setMinimumSize(new Dimension(0, 50));
        messageScrollPane.setPreferredSize(new Dimension(350, 75));
        if (OSPRuntime.loadTranslatorTool && this.model != null) {
            OSPRuntime.getTranslator().associate(this.table, this.model.getClass());
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.init();
        ToolsRes.addPropertyChangeListener("locale", this);
    }

    @Override
    public OSPFrame getMainFrame() {
        return this;
    }

    @Override
    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu menu = super.loadDisplayMenu();
        if (OSPRuntime.loadTranslatorTool) {
            JMenuItem translateItem = new JMenuItem();
            translateItem.setText(ControlsRes.getString("OSPControl.Translate"));
            translateItem.addActionListener(e -> OSPRuntime.getTranslator().showProperties(this.model.getClass()));
            translateItem.setEnabled(OSPRuntime.isAuthorMode());
            this.languageMenu.add((Component)translateItem, 0);
        }
        if (this.languageMenu.getItemCount() > 1) {
            this.languageMenu.insertSeparator(1);
        }
        return menu;
    }

    @Override
    protected void refreshGUI() {
        if (this.messageLabel == null) {
            return;
        }
        super.refreshGUI();
        this.messageLabel.setText(ControlsRes.getString("OSPControl.Messages"));
        this.clearLabel.setText(ControlsRes.getString("OSPControl.Clear"));
        this.inputLabel.setText(ControlsRes.getString("OSPControl.Input_Parameters"));
        this.table.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("translation") || name.equals("locale")) {
            this.refreshGUI();
        } else {
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    protected void init() {
        this.splitPane.setDividerLocation(-1);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public Object getModel() {
        return this.model;
    }

    public void setDividerLocation(int loc) {
        this.splitPane.setDividerLocation(loc);
    }

    public void setEditable(String parameter, boolean editable) {
        this.table.setEditable(parameter, editable);
    }

    @Override
    public void setLockValues(boolean lock) {
        this.table.setLockValues(true);
    }

    @Override
    public String toString() {
        if (this.table == null) {
            return "";
        }
        return this.table.toString();
    }

    @Override
    public void setValue(String par, Object val) {
        this.table.setValue(par, val);
        if (OSPRuntime.isJS) {
            this.table.refresh();
        }
    }

    @Override
    public void setValue(String par, boolean val) {
        this.table.setValue(par, val);
        if (OSPRuntime.isJS) {
            this.table.refresh();
        }
    }

    @Override
    public void setValue(String par, double val) {
        this.table.setValue(par, Double.toString(val));
        if (OSPRuntime.isJS) {
            this.table.refresh();
        }
    }

    @Override
    public void setValue(String par, int val) {
        this.table.setValue(par, Integer.toString(val));
        if (OSPRuntime.isJS) {
            this.table.refresh();
        }
    }

    public void removeParameter(String par) {
        this.table.setValue(par, null);
    }

    @Override
    public double getDouble(String par) {
        return this.table.getDouble(par);
    }

    @Override
    public int getInt(String par) {
        return this.table.getInt(par);
    }

    @Override
    public Object getObject(String par) throws UnsupportedOperationException {
        return this.table.getObject(par);
    }

    @Override
    public String getString(String par) {
        return this.table.getString(par);
    }

    @Override
    public boolean getBoolean(String par) {
        return this.table.getBoolean(par);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.table.getPropertyNames();
    }

    @Override
    public Collection<String> getPropertyNamesRaw() {
        return this.table.getPropertyNamesRaw();
    }

    public JButton addButton(String methodName, String text) {
        return this.addButton(methodName, text, null, this.model);
    }

    public JButton addButton(String methodName, String text, String toolTipText) {
        return this.addButton(methodName, text, toolTipText, this.model);
    }

    public void addControlListener(String methodName) {
        this.addControlListener(methodName, this.model);
    }

    public void addControlListener(String methodName, final Object target) {
        Class[] parameters = new Class[]{String.class};
        try {
            final Method m = target.getClass().getMethod(methodName, parameters);
            this.table.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() != 0 || e.getColumn() != 1 || e.getFirstRow() < 0) {
                        return;
                    }
                    String name = OSPControl.this.table.getValueAt(e.getFirstRow(), 0).toString();
                    Object[] args = new Object[]{name};
                    try {
                        m.invoke(target, args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("The method " + methodName + "() does not exist.");
        }
    }

    @Override
    public void println(String s) {
        this.print(String.valueOf(s) + "\n");
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void print(String s) {
        OSPRuntime.postEvent(() -> this.messageTextArea.append(s));
    }

    @Override
    public void clearMessages() {
        OSPRuntime.postEvent(() -> this.messageTextArea.setText(""));
    }

    @Override
    public void clearValues() {
        this.table.clearValues();
    }

    @Override
    public void calculationDone(String message) {
        if (message != null) {
            this.println(message);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPControlLoader();
    }

    public static OSPControl createApp(Object model) {
        OSPControl control = new OSPControl(model);
        control.setSize(300, 300);
        control.setVisible(true);
        return control;
    }

    class ClearMouseAdapter
    extends MouseAdapter {
        ClearMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            OSPControl.this.clearMessages();
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            OSPControl.this.clearLabel.setFont(new Font(OSPControl.this.clearLabel.getFont().getFamily(), 1, 10));
            OSPControl.this.clearLabel.setText(ControlsRes.getString("OSPControl.Click_to_clear_message"));
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            OSPControl.this.clearLabel.setFont(new Font(OSPControl.this.clearLabel.getFont().getFamily(), 0, 9));
            OSPControl.this.clearLabel.setText(ControlsRes.getString("OSPControl.Clear"));
        }
    }

    static class OSPControlLoader
    implements XML.ObjectLoader {
        OSPControlLoader() {
        }

        @Override
        public void saveObject(XMLControl xmlControl, Object obj) {
            OSPControl ospControl = (OSPControl)obj;
            this.saveControlProperites(xmlControl, ospControl);
            if (xmlControl.getLevel() == 0) {
                xmlControl.setValue("model", ospControl.model);
            }
        }

        protected void saveControlProperites(XMLControl xmlControl, OSPControl ospControl) {
            for (String name : ospControl.getPropertyNamesRaw()) {
                Object val = ospControl.getObject(name);
                if (val.getClass() == DoubleArray.class) {
                    xmlControl.setValue(name, ((DoubleArray)val).getArray());
                    continue;
                }
                if (val.getClass() == IntegerArray.class) {
                    xmlControl.setValue(name, ((IntegerArray)val).getArray());
                    continue;
                }
                if (val.getClass() == Boolean.class) {
                    xmlControl.setValue(name, (Boolean)val);
                    continue;
                }
                if (val.getClass() == Double.class) {
                    xmlControl.setValue(name, (Double)val);
                    continue;
                }
                if (val.getClass() == Integer.class) {
                    xmlControl.setValue(name, (Integer)val);
                    continue;
                }
                if (val.getClass() == Character.class) {
                    xmlControl.setValue(name, ((Character)val).toString());
                    continue;
                }
                if (val.getClass().isArray()) {
                    xmlControl.setValue(name, val);
                    continue;
                }
                xmlControl.setValue(name, val);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new OSPControl((Object)null);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            OSPControl cf = (OSPControl)obj;
            Iterator<String> it = control.getPropertyNamesRaw().iterator();
            cf.table.setLockValues(true);
            while (it.hasNext()) {
                String name = it.next();
                switch (control.getPropertyType(name)) {
                    case 3: {
                        if (cf.getObject(name) instanceof OSPCombo) {
                            OSPCombo combo = (OSPCombo)cf.getObject(name);
                            String itemName = control.getString(name);
                            String[] items = combo.items;
                            int i = 0;
                            int n = items.length;
                            while (i < n) {
                                if (itemName.equals(items[i])) {
                                    combo.selected = i;
                                    break;
                                }
                                ++i;
                            }
                            cf.setValue(name, combo);
                            break;
                        }
                        cf.setValue(name, control.getString(name));
                        break;
                    }
                    case 0: {
                        cf.setValue(name, control.getInt(name));
                        break;
                    }
                    case 1: {
                        cf.setValue(name, control.getDouble(name));
                        break;
                    }
                    case 2: {
                        cf.setValue(name, control.getBoolean(name));
                        break;
                    }
                    case 6: {
                        if (name.equals("model")) {
                            cf.model = control.getChildControl("model").loadObject(cf.model);
                            break;
                        }
                    }
                    default: {
                        cf.setValue(name, control.getObject(name));
                    }
                }
            }
            cf.table.setLockValues(false);
            return obj;
        }
    }
}

