/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.numerics.DoubleArray;
import org.opensourcephysics.numerics.IntegerArray;
import org.opensourcephysics.numerics.Util;

public class OSPControlTable
extends XMLTable
implements Control {
    static Color ERROR_COLOR = Color.PINK;
    private HashMap<String, Double> valueCache = new HashMap();
    private boolean lockValues = false;
    private DecimalFormat format;

    public OSPControlTable() {
        this(new XMLControlElement());
    }

    public OSPControlTable(XMLControlElement control) {
        super(control);
    }

    @Override
    public void setLockValues(boolean lock) {
        this.tableModel.control.setLockValues(lock);
        this.lockValues = lock;
        if (!this.lockValues) {
            this.refresh();
        }
    }

    @Override
    public void setValue(String par, Object val) {
        if (this.getBackgroundColor(par) == ERROR_COLOR) {
            this.setBackgroundColor(par, Color.WHITE);
        }
        this.tableModel.control.setValue(par, val);
        if (!this.lockValues) {
            this.refresh();
        }
    }

    public void setDecimalFormat(String pattern) {
        this.format = pattern == null ? null : Util.newDecimalFormat(pattern);
    }

    @Override
    public void setValue(String par, double val) {
        if (this.format == null) {
            this.setValue(par, Double.toString(val));
        } else {
            this.setValue(par, this.format.format(val));
        }
        if (!Double.isNaN(val)) {
            this.valueCache.put(par, new Double(val));
        }
    }

    @Override
    public void setValue(String par, int val) {
        this.setValue(par, Integer.toString(val));
        this.valueCache.put(par, new Double(val));
    }

    @Override
    public void setValue(String par, boolean val) {
        if (this.getBackgroundColor(par) == ERROR_COLOR) {
            this.setBackgroundColor(par, Color.WHITE);
        }
        this.tableModel.control.setValue(par, val);
    }

    @Override
    public int getInt(String par) {
        XMLControl c;
        String str = this.tableModel.control.getString(par);
        if (str == null) {
            str = this.getObject(par).toString();
        }
        if (this.tableModel.control.getPropertyType(par) == 6 && (c = this.tableModel.control.getChildControl(par)).getObjectClass() == OSPCombo.class) {
            OSPCombo combo = (OSPCombo)c.loadObject(null);
            return combo.getSelectedIndex();
        }
        if (str == null) {
            this.setBackgroundColor(par, ERROR_COLOR);
            this.refresh();
            if (this.valueCache.containsKey(par)) {
                return (int)this.valueCache.get(par).doubleValue();
            }
            return 0;
        }
        Color color = (Color)this.cellColors.get(par);
        boolean editable = this.isEditable(par);
        try {
            int val = Integer.parseInt(par);
            if (editable && color != Color.WHITE) {
                this.setBackgroundColor(par, Color.WHITE);
                this.refresh();
            } else if (!editable && color != Control.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            this.valueCache.put(par, new Double(val));
            return val;
        }
        catch (NumberFormatException val) {
            try {
                int val2 = (int)Double.parseDouble(par);
                if (editable && color != Color.WHITE) {
                    this.setBackgroundColor(par, Color.WHITE);
                    this.refresh();
                } else if (!editable && color != Control.NOT_EDITABLE_BACKGROUND) {
                    this.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
                    this.refresh();
                }
                this.valueCache.put(par, new Double(val2));
                return val2;
            }
            catch (NumberFormatException val2) {
                double dval = Util.evalMath(str);
                if (Double.isNaN(dval) && color != ERROR_COLOR) {
                    this.setBackgroundColor(par, ERROR_COLOR);
                    this.refresh();
                    if (this.valueCache.containsKey(par)) {
                        return (int)this.valueCache.get(par).doubleValue();
                    }
                    return 0;
                }
                if (editable && color != Color.WHITE) {
                    this.setBackgroundColor(par, Color.WHITE);
                    this.refresh();
                } else if (!editable && color != Control.NOT_EDITABLE_BACKGROUND) {
                    this.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
                    this.refresh();
                }
                this.valueCache.put(par, new Double(dval));
                return (int)dval;
            }
        }
    }

    public boolean inputError(String par) {
        return this.getBackgroundColor(par) == ERROR_COLOR;
    }

    @Override
    public double getDouble(String par) {
        String str = this.tableModel.control.getString(par);
        if (str == null) {
            str = this.getObject(par).toString();
        }
        if (str == null) {
            this.setBackgroundColor(par, ERROR_COLOR);
            this.refresh();
            if (this.valueCache.containsKey(par)) {
                return this.valueCache.get(par);
            }
            return 0.0;
        }
        Color color = (Color)this.cellColors.get(par);
        boolean editable = this.isEditable(par);
        try {
            double val = Double.parseDouble(str);
            if (editable && color != Color.WHITE) {
                this.setBackgroundColor(par, Color.WHITE);
                this.refresh();
            } else if (!editable && color != Control.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            this.valueCache.put(par, new Double(val));
            return val;
        }
        catch (NumberFormatException val) {
            double val2 = Util.evalMath(str);
            if (Double.isNaN(val2) && color != ERROR_COLOR) {
                this.setBackgroundColor(par, ERROR_COLOR);
                this.refresh();
            } else if (editable && color != Color.WHITE) {
                this.setBackgroundColor(par, Color.WHITE);
                this.refresh();
            } else if (!editable && color != Control.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            if (Double.isNaN(val2) && this.valueCache.containsKey(par)) {
                val2 = this.valueCache.get(par);
            } else {
                this.valueCache.put(par, new Double(val2));
            }
            return val2;
        }
    }

    @Override
    public Object getObject(String par) throws UnsupportedOperationException {
        return this.tableModel.control.getObject(par);
    }

    @Override
    public String getString(String par) {
        return this.tableModel.control.getString(par);
    }

    @Override
    public boolean getBoolean(String par) {
        return this.tableModel.control.getBoolean(par);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.tableModel.control.getPropertyNames();
    }

    @Override
    public Collection<String> getPropertyNamesRaw() {
        return this.tableModel.control.getPropertyNamesRaw();
    }

    public void removeParameter(String par) {
        this.tableModel.control.setValue(par, null);
        this.setBackgroundColor(par, Color.WHITE);
    }

    @Override
    public void println(String s) {
        this.tableModel.control.println(s);
    }

    @Override
    public void println() {
        this.tableModel.control.println();
    }

    @Override
    public void print(String s) {
        this.tableModel.control.print(s);
    }

    @Override
    public void clearMessages() {
        this.tableModel.control.clearMessages();
    }

    @Override
    public void clearValues() {
        this.tableModel.control.clearValues();
    }

    @Override
    public void calculationDone(String message) {
        if (message != null) {
            this.tableModel.control.calculationDone(message);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPControlTableLoader();
    }

    static class OSPControlTableLoader
    implements XML.ObjectLoader {
        OSPControlTableLoader() {
        }

        @Override
        public void saveObject(XMLControl xmlControl, Object obj) {
            OSPControlTable controlTable = (OSPControlTable)obj;
            for (String name : controlTable.getPropertyNamesRaw()) {
                Object val = controlTable.getObject(name);
                if (val.getClass() == DoubleArray.class) {
                    xmlControl.setValue(name, ((DoubleArray)val).getArray());
                    continue;
                }
                if (val.getClass() == IntegerArray.class) {
                    xmlControl.setValue(name, ((IntegerArray)val).getArray());
                    continue;
                }
                if (val.getClass() == Boolean.class) {
                    xmlControl.setValue(name, (Boolean)val);
                    continue;
                }
                if (val.getClass() == Double.class) {
                    xmlControl.setValue(name, (Double)val);
                    continue;
                }
                if (val.getClass() == Integer.class) {
                    xmlControl.setValue(name, (Integer)val);
                    continue;
                }
                if (val.getClass().isArray()) {
                    xmlControl.setValue(name, val);
                    continue;
                }
                xmlControl.setValue(name, val);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new OSPControlTable();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            OSPControlTable controlTable = (OSPControlTable)obj;
            Iterator<String> it = control.getPropertyNamesRaw().iterator();
            controlTable.setLockValues(true);
            while (it.hasNext()) {
                String name = it.next();
                switch (control.getPropertyType(name)) {
                    case 3: {
                        controlTable.setValue(name, control.getString(name));
                        break;
                    }
                    case 0: {
                        controlTable.setValue(name, control.getInt(name));
                        break;
                    }
                    case 1: {
                        controlTable.setValue(name, control.getDouble(name));
                        break;
                    }
                    case 2: {
                        controlTable.setValue(name, control.getBoolean(name));
                        break;
                    }
                    default: {
                        controlTable.setValue(name, control.getObject(name));
                    }
                }
            }
            controlTable.setLockValues(false);
            return obj;
        }
    }
}

