/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;

public class OSPLog {
    OSPFrame frame;
    private static final boolean doNotify = false;
    private static final boolean divertSysOut = false;
    static int nLog;
    public static final PrintStream realSysout;
    private StringBuffer logBuffer = new StringBuffer();
    List<LogRecord> logRecords = new ArrayList<LogRecord>();
    private static OSPLog OSPLOG;
    private static JFileChooser chooser;
    protected static Style black;
    protected static Style red;
    protected static Style blue;
    protected static Style green;
    protected static Style magenta;
    protected static Style gray;
    protected static final Color DARK_GREEN;
    protected static final Color DARK_BLUE;
    protected static final Color DARK_RED;
    public static final Level[] levels;
    private static Level defaultLevel;
    protected static boolean logConsole;
    private Logger logger;
    private Handler fileHandler;
    private OSPLogHandler logHandler;
    private JTextPane logPane;
    private String logFileName;
    private String tempFileName;
    private JPanel logPanel;
    private JPopupMenu popup;
    private ButtonGroup popupGroup;
    private ButtonGroup menubarGroup;
    private String pkgName;
    private String bundleName;
    private JMenuItem logToFileItem;
    private boolean hasPermission = true;
    protected int myPopupFontLevel;
    private static LogRecord[] messageStorage;
    private static int messageIndex;
    static String eol;
    static String logdir;
    static String slash;
    private static boolean useFrame;

    static {
        realSysout = System.out;
        DARK_GREEN = new Color(0, 128, 0);
        DARK_BLUE = new Color(0, 0, 128);
        DARK_RED = new Color(128, 0, 0);
        levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, ConsoleLevel.ERR_CONSOLE, ConsoleLevel.OUT_CONSOLE, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        defaultLevel = ConsoleLevel.OUT_CONSOLE;
        logConsole = true;
        messageStorage = new LogRecord[128];
        messageIndex = 0;
        eol = "\n";
        logdir = ".";
        slash = "/";
        useFrame = true;
        try {
            eol = System.getProperty("line.separator", eol);
            logdir = System.getProperty("user.dir", logdir);
            slash = System.getProperty("file.separator", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean useMessageFrame() {
        return OSPRuntime.appletMode || OSPRuntime.isApplet;
    }

    public static OSPLog getOSPLog() {
        if (OSPLOG == null && !OSPLog.useMessageFrame()) {
            OSPLOG = new OSPLog("org.opensourcephysics", null);
        }
        return OSPLOG;
    }

    public static void getOSPLog(boolean useFrame) {
        OSPLog.useFrame = useFrame;
        OSPLog.getOSPLog();
    }

    public void setLogDir(String dir) {
        logdir = dir;
    }

    public String getLogDir() {
        return logdir;
    }

    public static boolean isLogVisible() {
        if (OSPLog.useMessageFrame() && MessageFrame.APPLET_MESSAGEFRAME != null) {
            return MessageFrame.APPLET_MESSAGEFRAME.isVisible();
        }
        if (OSPLOG != null) {
            return OSPLOG.isVisible();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Point p = new JFrame().getLocation();
            JFrame log = OSPLog.getFrame();
            if (log.getLocation().x == p.x && log.getLocation().y == p.y) {
                SwingUtilities.invokeLater(() -> {
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    int x = (dim.width - jFrame.getBounds().width) / 2;
                    int y = (dim.height - jFrame.getBounds().height) / 2;
                    log.setLocation(x, y);
                });
            }
        }
        try {
            if (visible) {
                this.createGUI();
                if (this.logPane == null) {
                    this.logPane = this.getTextPane();
                    this.postAllRecords();
                    FontSizer.setFonts(this, FontSizer.getLevel());
                    this.frame.pack();
                }
            }
            if (OSPLog.useMessageFrame()) {
                MessageFrame.showLog(visible);
            } else {
                this.frame.setVisible(visible);
            }
        }
        catch (Throwable t) {
            realSysout.println("OSPLog???" + t);
        }
    }

    private void postAllRecords() {
        int i = 0;
        int n = this.logRecords.size();
        while (i < n) {
            this.logHandler.publish(this.logRecords.get(i));
            ++i;
        }
        this.logRecords.clear();
    }

    public boolean isVisible() {
        if (OSPLog.useMessageFrame()) {
            return MessageFrame.isLogVisible();
        }
        return this.frame.isVisible();
    }

    public static JFrame showLog() {
        if (OSPLog.useMessageFrame()) {
            return MessageFrame.showLog(true);
        }
        OSPLog.getOSPLog().setVisible(true);
        Logger logger = OSPLOG.getLogger();
        int i = 0;
        int n = messageStorage.length;
        while (i < n) {
            LogRecord record = messageStorage[(i + messageIndex) % n];
            if (record != null) {
                logger.log(record);
            }
            ++i;
        }
        messageIndex = 0;
        return OSPLog.getOSPLog().frame;
    }

    public static void showLogInvokeLater() {
        Runnable doLater = new Runnable(){

            @Override
            public void run() {
                OSPLog.showLog();
            }
        };
        EventQueue.invokeLater(doLater);
    }

    public static int getLevelValue() {
        if (OSPLog.useMessageFrame()) {
            return MessageFrame.getLevelValue();
        }
        try {
            Level level = OSPLog.getOSPLog().getLogger().getLevel();
            if (level != null) {
                return level.intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static void setLevel(Level level) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.setLevel(level);
        } else {
            OSPLog.setLevel(level, OSPLog.getOSPLog());
        }
    }

    private static void setLevel(Level level, OSPLog ospLog) {
        try {
            ospLog.getLogger().setLevel(level);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ospLog == null || ospLog.menubarGroup == null) {
            return;
        }
        int i = 0;
        while (i < 2) {
            Enumeration<AbstractButton> e = ospLog.menubarGroup.getElements();
            if (i == 1) {
                e = ospLog.popupGroup.getElements();
            }
            while (e.hasMoreElements()) {
                JMenuItem item = (JMenuItem)e.nextElement();
                if (!ospLog.getLogger().getLevel().toString().equals(item.getActionCommand())) continue;
                item.setSelected(true);
                break;
            }
            ++i;
        }
    }

    public static Level parseLevel(String level) {
        int i = 0;
        while (i < levels.length) {
            if (levels[i].getName().equals(level)) {
                return levels[i];
            }
            ++i;
        }
        return null;
    }

    public static void severe(String msg) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.severe(msg);
        } else {
            OSPLog.log(Level.SEVERE, msg);
        }
    }

    public static void warning(String msg) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.warning(msg);
        } else {
            OSPLog.log(Level.WARNING, msg);
        }
    }

    public static void info(String msg) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.info(msg);
        } else {
            OSPLog.log(Level.INFO, msg);
        }
    }

    public static void config(String msg) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.config(msg);
        } else {
            OSPLog.log(Level.CONFIG, msg);
        }
    }

    public static void fine(String msg) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.fine(msg);
        } else {
            OSPLog.log(Level.FINE, msg);
        }
    }

    public static void clearLog() {
        messageIndex = 0;
        if (OSPLog.useMessageFrame()) {
            MessageFrame.clear();
        } else {
            OSPLOG.clear();
        }
    }

    public static void finer(String msg) {
        System.gc();
        System.out.println("OSPLog.finer " + msg);
        if (OSPLog.useMessageFrame()) {
            MessageFrame.finer(msg);
        } else {
            OSPLog.log(Level.FINER, msg);
        }
    }

    public static void finest(String msg) {
        if (OSPLog.useMessageFrame()) {
            MessageFrame.finest(msg);
        } else {
            OSPLog.log(Level.FINEST, msg);
        }
    }

    public static void setConsoleMessagesLogged(boolean log) {
        logConsole = log;
    }

    public static boolean isConsoleMessagesLogged() {
        return logConsole;
    }

    public OSPLog(Package pkg) {
        this(pkg.getName(), null);
    }

    public OSPLog(Package pkg, String resourceBundleName) {
        this(pkg.getName(), resourceBundleName);
    }

    public OSPLog(Class<?> type) {
        this(type, null);
    }

    public OSPLog(Class<?> type, String resourceBundleName) {
        this(type.getPackage().getName(), resourceBundleName);
    }

    public JPanel getLogPanel() {
        this.createGUI();
        return this.logPanel;
    }

    public void clear() {
        if (this.logPane != null) {
            this.logPane.setText(null);
        }
        this.logBuffer.setLength(0);
    }

    public String saveLog(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            return this.saveLogAs();
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write(this.getText());
            out.flush();
            out.close();
            return fileName;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String getText() {
        return this.logPane == null ? this.logBuffer.toString() : this.logPane.getText();
    }

    public String saveLogAs() {
        int result = OSPLog.getChooser().showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = OSPLog.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return null;
            }
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            return this.saveLog(fileName);
        }
        return null;
    }

    public String saveXML(String fileName) {
        if (OSPLog.useMessageFrame()) {
            this.logger.log(Level.FINE, "Cannot save XML file when running as an applet.");
            return null;
        }
        if (fileName == null || fileName.trim().equals("")) {
            return this.saveXMLAs();
        }
        String xml = this.read(this.tempFileName);
        Handler fileHandler = this.getFileHandler();
        String tail = fileHandler.getFormatter().getTail(fileHandler);
        xml = String.valueOf(xml) + tail;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write(xml);
            out.flush();
            out.close();
            return fileName;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String saveXMLAs() {
        int result = OSPLog.getChooser().showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = OSPLog.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return null;
            }
            this.logFileName = XML.getRelativePath(file.getAbsolutePath());
            return this.saveXML(this.logFileName);
        }
        return null;
    }

    public void open() {
        OSPRuntime.getChooser().showOpenDialog(null, new Runnable(){

            @Override
            public void run() {
                File file = OSPRuntime.getChooser().getSelectedFile();
                String fileName = XML.getRelativePath(file.getAbsolutePath());
                fileName = XML.getRelativePath(fileName);
                OSPLog.this.open(fileName);
            }
        }, null);
    }

    public void open(String fileName) {
        String data = this.read(fileName);
        this.logBuffer.setLength(0);
        this.logBuffer.append(data);
        if (this.logPane != null) {
            this.logPane.setText(data);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogToFileAction(boolean enable) {
        if (OSPLog.useMessageFrame()) {
            this.logger.log(Level.FINE, "Cannot log to file when running as an applet.");
            return;
        }
        if (enable && this.fileHandler == null) {
            this.logToFileItem.setSelected(true);
            this.logger.addHandler(this.getFileHandler());
        } else if (this.fileHandler != null) {
            this.logToFileItem.setSelected(false);
            this.logger.removeHandler(this.fileHandler);
            this.fileHandler.close();
            this.fileHandler = null;
            this.logger.log(Level.INFO, String.valueOf(this.tempFileName) + " closed");
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.frame.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void createGUI() {
        if (this.logPanel != null || this.frame == null) {
            return;
        }
        this.logPanel = new JPanel(new BorderLayout());
        this.logPanel.setPreferredSize(new Dimension(480, 240));
        this.frame.setContentPane(this.logPanel);
        this.createMenus();
        this.frame.setDefaultCloseOperation(1);
    }

    private JTextPane getTextPane() {
        JTextPane textPane = GUIUtils.newJTextPane();
        textPane.setEditable(false);
        textPane.setAutoscrolls(true);
        JScrollPane textScroller = new JScrollPane(textPane);
        textScroller.setWheelScrollingEnabled(true);
        this.logPanel.add((Component)textScroller, "Center");
        black = StyleContext.getDefaultStyleContext().getStyle("default");
        red = textPane.addStyle("red", black);
        StyleConstants.setForeground(red, DARK_RED);
        blue = textPane.addStyle("blue", black);
        StyleConstants.setForeground(blue, DARK_BLUE);
        green = textPane.addStyle("green", black);
        StyleConstants.setForeground(green, DARK_GREEN);
        magenta = textPane.addStyle("magenta", black);
        StyleConstants.setForeground(magenta, new Color(155, 0, 155));
        gray = textPane.addStyle("gray", black);
        StyleConstants.setForeground(gray, Color.GRAY);
        textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    if (OSPRuntime.isPopupTrigger(e) && OSPLog.this.popup != null) {
                        FontSizer.setFonts(OSPLog.this.popup);
                        OSPLog.this.popup.show(OSPLog.this.logPane, e.getX(), e.getY() + 8);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error in mouse action.");
                    System.err.println(ex.toString());
                    ex.printStackTrace();
                }
            }
        });
        return textPane;
    }

    protected Logger createLogger() {
        if (this.bundleName != null) {
            try {
                this.logger = Logger.getLogger(this.pkgName, this.bundleName);
            }
            catch (Exception ex) {
                this.logger = Logger.getLogger(this.pkgName);
            }
        } else {
            this.logger = Logger.getLogger(this.pkgName);
        }
        try {
            this.logger.setLevel(defaultLevel);
            this.logHandler = new OSPLogHandler(null, this);
            this.logHandler.setFormatter(new ConsoleFormatter());
            this.logHandler.setLevel(Level.ALL);
            OSPRuntime.class.getClass();
            this.logger.setUseParentHandlers(false);
            this.logger.addHandler(this.logHandler);
        }
        catch (SecurityException ex) {
            this.hasPermission = false;
        }
        return this.logger;
    }

    protected synchronized Handler getFileHandler() {
        if (this.fileHandler != null) {
            return this.fileHandler;
        }
        try {
            int i = this.pkgName.lastIndexOf(".");
            if (i > -1) {
                this.pkgName = this.pkgName.substring(i + 1);
            }
            this.tempFileName = logdir.endsWith(slash) ? String.valueOf(logdir) + this.pkgName + ".log" : String.valueOf(logdir) + slash + this.pkgName + ".log";
            this.fileHandler = new FileHandler(this.tempFileName);
            this.fileHandler.setFormatter(new XMLFormatter());
            this.fileHandler.setLevel(Level.ALL);
            this.logger.addHandler(this.fileHandler);
            this.logger.log(Level.INFO, "Logging to file enabled. File = " + this.tempFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.fileHandler;
    }

    protected void createMenus() {
        if (!this.hasPermission || this.frame == null) {
            return;
        }
        this.popup = new JPopupMenu();
        JMenu menu = new JMenu(ControlsRes.getString("OSPLog.Level_menu"));
        this.popup.add(menu);
        this.popupGroup = new ButtonGroup();
        int i = 0;
        while (i < levels.length) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(levels[i].getName());
            menu.add((Component)item, 0);
            this.popupGroup.add(item);
            if (this.logger.getLevel().toString().equals(levels[i].toString())) {
                item.setSelected(true);
            }
            item.setActionCommand(levels[i].getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPLog.this.logger.setLevel(Level.parse(e.getActionCommand()));
                    Enumeration<AbstractButton> e2 = OSPLog.this.menubarGroup.getElements();
                    while (e2.hasMoreElements()) {
                        JMenuItem item = (JMenuItem)e2.nextElement();
                        if (!OSPLog.this.logger.getLevel().toString().equals(item.getActionCommand())) continue;
                        item.setSelected(true);
                        break;
                    }
                }
            });
            ++i;
        }
        this.popup.addSeparator();
        AbstractAction openAction = new AbstractAction(ControlsRes.getString("OSPLog.Open_popup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.open();
            }
        };
        openAction.setEnabled(!OSPLog.useMessageFrame());
        this.popup.add(openAction);
        AbstractAction saveAsAction = new AbstractAction(ControlsRes.getString("OSPLog.SaveAs_popup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.saveLogAs();
            }
        };
        saveAsAction.setEnabled(!OSPLog.useMessageFrame());
        this.popup.add(saveAsAction);
        this.popup.addSeparator();
        AbstractAction clearAction = new AbstractAction(ControlsRes.getString("OSPLog.Clear_popup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.clear();
            }
        };
        this.popup.add(clearAction);
        JMenuBar menubar = new JMenuBar();
        this.frame.setJMenuBar(menubar);
        menu = new JMenu(ControlsRes.getString("OSPLog.File_menu"));
        menubar.add(menu);
        menu.add(openAction);
        menu.add(saveAsAction);
        menu = new JMenu(ControlsRes.getString("OSPLog.Edit_menu"));
        menubar.add(menu);
        menu.add(clearAction);
        menu = new JMenu(ControlsRes.getString("OSPLog.Level_menu"));
        menubar.add(menu);
        this.menubarGroup = new ButtonGroup();
        int i2 = 0;
        while (i2 < levels.length) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(levels[i2].getName());
            menu.add((Component)item, 0);
            this.menubarGroup.add(item);
            if (this.logger.getLevel().toString().equals(levels[i2].toString())) {
                item.setSelected(true);
            }
            item.setActionCommand(levels[i2].getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPLog.this.logger.setLevel(Level.parse(e.getActionCommand()));
                    Enumeration<AbstractButton> e2 = OSPLog.this.popupGroup.getElements();
                    while (e2.hasMoreElements()) {
                        JMenuItem item = (JMenuItem)e2.nextElement();
                        if (!OSPLog.this.logger.getLevel().toString().equals(item.getActionCommand())) continue;
                        item.setSelected(true);
                        break;
                    }
                }
            });
            ++i2;
        }
        JMenu prefMenu = new JMenu(ControlsRes.getString("OSPLog.Options_menu"));
        menubar.add(prefMenu);
        this.logToFileItem = new JCheckBoxMenuItem(ControlsRes.getString("OSPLog.LogToFile_check_box"));
        this.logToFileItem.setSelected(false);
        this.logToFileItem.setEnabled(!OSPLog.useMessageFrame());
        this.logToFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.setLogToFileAction(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        prefMenu.add(this.logToFileItem);
    }

    protected static JFileChooser getChooser() {
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        FontSizer.setFonts(chooser);
        return chooser;
    }

    protected String read(String fileName) {
        File file = new File(fileName);
        StringBuffer buffer = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            buffer = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                buffer.append(String.valueOf(line) + XML.NEW_LINE);
                line = in.readLine();
            }
            in.close();
            return buffer.toString();
        }
        catch (IOException ex) {
            this.logger.warning(ex.toString());
            return "";
        }
    }

    private OSPLog(String name, String resourceBundleName) {
        if (useFrame) {
            this.frame = new OSPFrame(ControlsRes.getString("OSPLog.DefaultTitle"));
            this.frame.setName("LogTool");
        }
        this.bundleName = resourceBundleName;
        this.pkgName = name;
        ConsoleLevel.class.getName();
        this.createLogger();
        LoggerOutputStream loggerOut = new LoggerOutputStream(ConsoleLevel.OUT_CONSOLE, System.out);
        LoggerOutputStream loggerErr = new LoggerOutputStream(ConsoleLevel.ERR_CONSOLE, System.err);
        LoggerPrintStream loggerOutPrint = new LoggerPrintStream(loggerOut, false);
        LoggerPrintStream loggerErrPrint = new LoggerPrintStream(loggerErr, true);
        try {
            System.err.println("OSPLog divertSysOut = false -- bypassing OSPLog.setOut");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        OSPLog.setLevel(defaultLevel, this);
    }

    private static void log(Level level, String msg) {
        if (OSPRuntime.dontLog) {
            return;
        }
        LogRecord record = new LogRecord(level, msg);
        String className = null;
        String methodName = null;
        if (OSPRuntime.isJS) {
            OSPRuntime.showStatus("OSPLog[" + level + "] " + msg);
        } else {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            int i = 0;
            while (i < stack.length) {
                StackTraceElement el = stack[i];
                className = el.getClassName();
                if (!className.equals("org.opensourcephysics.controls.OSPLog")) {
                    methodName = el.getMethodName();
                    break;
                }
                ++i;
            }
        }
        if (methodName != null) {
            record.setSourceClassName(className);
            record.setSourceMethodName(methodName);
        }
        if (OSPLOG != null) {
            OSPLOG.getLogger().log(record);
        } else {
            OSPLog.messageStorage[OSPLog.messageIndex++] = record;
            messageIndex %= messageStorage.length;
        }
    }

    public static void debug(String msg) {
        realSysout.println("OSPLog.debug " + msg);
    }

    public static void setFonts(int level) {
        OSPLog log = OSPLog.getOSPLog();
        FontSizer.setFonts(log.frame);
    }

    public static void finalized(Object c) {
        OSPLog.notify(c, "finalized");
    }

    public static void notify(Object c, String msg) {
    }

    public static JFrame getFrame() {
        return OSPLog.getOSPLog().frame;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (OSPLog.getFrame() != null) {
            OSPLog.getFrame().addPropertyChangeListener(propertyChangeListener);
        }
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (OSPLog.getFrame() != null) {
            OSPLog.getFrame().removePropertyChangeListener(propertyChangeListener);
        }
    }

    public static void addPropertyChangeListener(String name, PropertyChangeListener propertyChangeListener) {
        if (OSPLog.getFrame() != null) {
            OSPLog.getFrame().addPropertyChangeListener(name, propertyChangeListener);
        }
    }

    class ConsoleFormatter
    extends SimpleFormatter {
        ConsoleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String message = this.formatMessage(record);
            if (record.getLevel().intValue() == ConsoleLevel.OUT_CONSOLE.intValue() || record.getLevel().intValue() == ConsoleLevel.ERR_CONSOLE.intValue()) {
                StringBuffer sb = new StringBuffer();
                if (message.length() > 0 && message.charAt(0) == '\t') {
                    message = message.replaceFirst("\t", "    ");
                } else {
                    sb.append("CONSOLE: ");
                }
                sb.append(message);
                sb.append(eol);
                if (record.getThrown() != null) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        pw.close();
                        sb.append(sw.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return sb.toString();
            }
            return super.format(record);
        }
    }

    class LoggerOutputStream
    extends OutputStream {
        StringBuffer buffer = new StringBuffer();
        ConsoleLevel level;

        LoggerOutputStream(ConsoleLevel level, OutputStream oldStream) {
            this.level = level;
        }

        public void print(String msg) {
            this.buffer.append(msg);
        }

        public void println(String msg) {
            this.buffer.append(msg);
            this.logMsg();
        }

        @Override
        public void write(int c) throws IOException {
            if (c == 10) {
                this.logMsg();
            } else {
                this.buffer.append((char)c);
            }
        }

        private void logMsg() {
            LogRecord record = new LogRecord(this.level, this.buffer.toString());
            OSPLog.getOSPLog().getLogger().log(record);
            this.buffer = new StringBuffer();
        }
    }

    public static class LoggerPrintStream
    extends PrintStream {
        protected boolean isErr;

        public LoggerPrintStream(LoggerOutputStream out, boolean isErr) {
            super(out);
            this.isErr = isErr;
        }

        @Override
        public void println(String msg) {
            ((LoggerOutputStream)this.out).println(msg);
        }

        @Override
        public void print(String msg) {
            ((LoggerOutputStream)this.out).print(msg);
        }
    }

    class OSPFrame
    extends JFrame {
        public OSPFrame(String string) {
            super(string);
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }

        @Override
        public void setVisible(boolean vis) {
            FontSizer.setFonts(this, FontSizer.getLevel());
            super.setVisible(vis);
        }
    }

    class OSPLogHandler
    extends Handler {
        OSPLog ospLog;

        public OSPLogHandler(JTextPane textPane, OSPLog log) {
            OSPLog.this.logPane = textPane;
            this.ospLog = log;
        }

        public void setTextPane(JTextPane textPane) {
            OSPLog.this.logPane = textPane;
        }

        @Override
        public void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            if (OSPLog.this.logPane == null) {
                OSPLog.this.logRecords.add(record);
                return;
            }
            String msg = this.getFormatter().format(record);
            Style style = green;
            int val = record.getLevel().intValue();
            if (val == ConsoleLevel.ERR_CONSOLE.intValue()) {
                if (msg.indexOf("OutOfMemory") > -1) {
                    this.ospLog.firePropertyChange("error", null, OSPRuntime.OUT_OF_MEMORY_ERROR);
                }
                if (!logConsole) {
                    return;
                }
                style = magenta;
            } else if (val == ConsoleLevel.OUT_CONSOLE.intValue()) {
                if (msg.indexOf("ERROR org.ffmpeg") > -1) {
                    this.ospLog.firePropertyChange("ffmpeg_error", null, msg);
                } else if (msg.indexOf("JNILibraryLoader") > -1) {
                    this.ospLog.firePropertyChange("xuggle_error", null, msg);
                }
                if (!logConsole) {
                    return;
                }
                style = gray;
            } else if (val >= Level.WARNING.intValue()) {
                style = red;
            } else if (val >= Level.INFO.intValue()) {
                style = black;
            } else if (val >= Level.CONFIG.intValue()) {
                style = green;
            } else if (val >= Level.FINEST.intValue()) {
                style = blue;
            }
            try {
                Document doc = OSPLog.this.logPane.getDocument();
                doc.insertString(doc.getLength(), String.valueOf(msg) + '\n', style);
                Rectangle rect = OSPLog.this.logPane.getBounds();
                rect.y = rect.height;
                OSPLog.this.logPane.scrollRectToVisible(rect);
            }
            catch (BadLocationException ex) {
                System.err.println(ex);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

