/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.AnimationControl;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class SimulationControl
extends AnimationControl
implements SimControl {
    Set<String> fixedParameters = new HashSet<String>();

    public SimulationControl(Simulation animation) {
        super(animation);
    }

    @Override
    public void setParameterToFixed(String name, boolean fixed) {
        if (fixed) {
            this.fixedParameters.add(name);
        } else {
            this.fixedParameters.remove(name);
        }
        this.table.refresh();
    }

    public boolean isParamterFixed(String name) {
        return this.fixedParameters.contains(name);
    }

    @Override
    public void setValue(String name, Object val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    @Override
    public void setAdjustableValue(String name, Object val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    @Override
    public void setValue(String name, double val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    @Override
    public void setAdjustableValue(String name, double val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    @Override
    public void setValue(String name, int val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    @Override
    public void setAdjustableValue(String name, int val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    @Override
    public void setValue(String name, boolean val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    @Override
    public void removeParameter(String name) {
        super.removeParameter(name);
        this.fixedParameters.remove(name);
    }

    @Override
    public void setAdjustableValue(String name, boolean val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    @Override
    void resetBtnActionPerformed(ActionEvent e) {
        for (String par : this.fixedParameters) {
            this.table.setEditable(par, true);
            this.table.setBackgroundColor(par, Color.WHITE);
        }
        this.table.refresh();
        super.resetBtnActionPerformed(e);
    }

    @Override
    void startBtnActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.initText)) {
            this.table.setEditable(true);
            for (String par : this.fixedParameters) {
                this.table.setEditable(par, false);
                this.table.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
            }
        } else if (e.getActionCommand().equals(this.startText)) {
            for (String par : this.table.getPropertyNamesRaw()) {
                this.table.setEditable(par, false);
                this.table.setBackgroundColor(par, Control.NOT_EDITABLE_BACKGROUND);
            }
        } else if (e.getActionCommand().equals(this.stopText)) {
            for (String par : this.table.getPropertyNamesRaw()) {
                if (this.fixedParameters.contains(par)) continue;
                this.table.setEditable(par, true);
                this.table.setBackgroundColor(par, Color.WHITE);
            }
        }
        this.table.refresh();
        super.startBtnActionPerformed(e);
    }

    public static XML.ObjectLoader getLoader() {
        return new SimulationControlLoader();
    }

    public static SimulationControl createApp(Simulation model) {
        SimulationControl control = new SimulationControl(model);
        model.setControl(control);
        return control;
    }

    public static SimulationControl createApp(Simulation model, String[] xml) {
        SimulationControl control = SimulationControl.createApp(model);
        control.loadXML(xml);
        return control;
    }

    static class SimulationControlLoader
    extends AnimationControl.AnimationControlLoader {
        SimulationControlLoader() {
        }

        @Override
        public Object createObject(XMLControl control) {
            return new SimulationControl(null);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            SimulationControl sc = (SimulationControl)obj;
            String[] fixedParm = sc.fixedParameters.toArray(new String[0]);
            super.loadObject(control, obj);
            sc.fixedParameters.clear();
            int i = 0;
            int n = fixedParm.length;
            while (i < n) {
                sc.fixedParameters.add(fixedParm[i]);
                ++i;
            }
            for (String parm : sc.table.getPropertyNamesRaw()) {
                if (sc.fixedParameters.contains(parm)) continue;
                sc.table.setEditable(parm, true);
                sc.table.setBackgroundColor(parm, Color.WHITE);
            }
            if (sc.model instanceof AbstractSimulation && control.getObject("steps per display") != null) {
                ((AbstractSimulation)sc.model).enableStepsPerDisplay(true);
                ((AbstractSimulation)sc.model).setStepsPerDisplay(Integer.parseInt(control.getString("steps per display")));
            } else {
                ((AbstractSimulation)sc.model).enableStepsPerDisplay(false);
            }
            return obj;
        }
    }
}

