/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public class XML {
    public static String NEW_LINE = System.getProperty("line.separator", "\n");
    public static final String CDATA_PRE = "<![CDATA[";
    public static final int CDATA_PRE_LEN = 9;
    public static final String CDATA_POST = "]]>";
    public static final int CDATA_POST_LEN = 3;
    public static final String CDATA_POST_PROP = "]]></property>";
    public static final int INDENT = 4;
    private static Map<Class<?>, ObjectLoader> loaders = new HashMap();
    private static ObjectLoader defaultLoader;
    private static String dtdName;
    private static String dtd;
    private static String defaultName;
    private static ClassLoader classLoader;

    static {
        defaultName = "osp10.dtd";
        try {
            NEW_LINE = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        XML.setLoader(Color.class, new ObjectLoader(){

            @Override
            public void saveObject(XMLControl control, Object obj) {
                Color color = (Color)obj;
                control.setValue("red", color.getRed());
                control.setValue("green", color.getGreen());
                control.setValue("blue", color.getBlue());
                control.setValue("alpha", color.getAlpha());
            }

            @Override
            public Object createObject(XMLControl control) {
                int r = control.getInt("red");
                int g = control.getInt("green");
                int b = control.getInt("blue");
                int a = control.getInt("alpha");
                return new Color(r, g, b, a);
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                int r = control.getInt("red");
                int g = control.getInt("green");
                int b = control.getInt("blue");
                int a = control.getInt("alpha");
                return new Color(r, g, b, a);
            }
        });
        XML.setLoader(Double.class, new ObjectLoader(){

            @Override
            public void saveObject(XMLControl control, Object obj) {
                Double dbl = (Double)obj;
                control.setValue("value", dbl);
            }

            @Override
            public Object createObject(XMLControl control) {
                double val = control.getDouble("value");
                return val;
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                Double dbl = (Double)obj;
                double val = control.getDouble("value");
                if (dbl == val) {
                    return dbl;
                }
                return val;
            }
        });
        XML.setLoader(Integer.class, new ObjectLoader(){

            @Override
            public void saveObject(XMLControl control, Object obj) {
                Integer i = (Integer)obj;
                control.setValue("value", i);
            }

            @Override
            public Object createObject(XMLControl control) {
                int val = control.getInt("value");
                return val;
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                Integer i = (Integer)obj;
                int val = control.getInt("value");
                if (i == val) {
                    return i;
                }
                return val;
            }
        });
        XML.setLoader(Boolean.class, new ObjectLoader(){

            @Override
            public void saveObject(XMLControl control, Object obj) {
                Boolean bool = (Boolean)obj;
                control.setValue("value", bool);
            }

            @Override
            public Object createObject(XMLControl control) {
                boolean val = control.getBoolean("value");
                return val;
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                Boolean bool = (Boolean)obj;
                boolean val = control.getBoolean("value");
                if (bool == val) {
                    return bool;
                }
                return val;
            }
        });
        XML.setLoader(Dimension.class, new ObjectLoader(){

            @Override
            public void saveObject(XMLControl control, Object obj) {
                Dimension dim = (Dimension)obj;
                control.setValue("dimensions", new int[]{dim.width, dim.height});
            }

            @Override
            public Object createObject(XMLControl control) {
                return new Dimension();
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                Dimension dim = (Dimension)obj;
                int[] dimensions = (int[])control.getObject("dimensions");
                dim.width = dimensions[0];
                dim.height = dimensions[1];
                return dim;
            }
        });
        XML.setLoader(Point.class, new ObjectLoader(){

            @Override
            public void saveObject(XMLControl control, Object obj) {
                Point p = (Point)obj;
                control.setValue("location", new int[]{p.x, p.y});
            }

            @Override
            public Object createObject(XMLControl control) {
                return new Point();
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                Point p = (Point)obj;
                int[] location = (int[])control.getObject("location");
                p.x = location[0];
                p.y = location[1];
                return p;
            }
        });
    }

    private XML() {
    }

    public static void setLoader(Class<?> classtype, ObjectLoader loader) {
        if (!(loader instanceof NonStaticLoader)) {
            loaders.put(classtype, loader);
        }
    }

    public static ObjectLoader getLoader(Class<?> classtype) {
        ObjectLoader loader = loaders.get(classtype);
        if (loader == null) {
            try {
                Method method = classtype.getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers()) && (loader = (ObjectLoader)method.invoke(null, null)) != null) {
                    XML.setLoader(classtype, loader);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (loader == null) {
            if (defaultLoader == null) {
                defaultLoader = new XMLLoader();
            }
            loader = defaultLoader;
        }
        return loader;
    }

    public static void setDefaultLoader(ObjectLoader loader) {
        defaultLoader = loader;
    }

    public static String getAttr(String xml, String attr, String def) {
        String string;
        int i = xml.indexOf(String.valueOf(attr) + "=\"");
        if (i < 0) {
            string = def;
        } else {
            i = i + attr.length() + 2;
            string = xml.substring(i, xml.indexOf(34, i));
        }
        return string;
    }

    public static boolean requiresCDATA(String text) {
        return text.indexOf("\"") != -1 || text.indexOf("<") != -1 || text.indexOf(">") != -1 || text.indexOf("&") != -1 || text.indexOf("'") != -1;
    }

    public static String getDTD(String doctype) {
        if (dtdName != doctype) {
            dtdName = defaultName;
            try {
                String dtdPath = "/org/opensourcephysics/resources/controls/doctypes/";
                URL url = XML.class.getResource(String.valueOf(dtdPath) + doctype);
                if (url == null) {
                    return dtd;
                }
                Object content = url.getContent();
                if (content instanceof InputStream) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)content));
                    StringBuffer buffer = new StringBuffer(0);
                    while ((line = reader.readLine()) != null) {
                        buffer.append(String.valueOf(line) + NEW_LINE);
                    }
                    dtd = buffer.toString();
                    dtdName = doctype;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return dtd;
    }

    public static void setClassLoader(ClassLoader loader) {
        classLoader = loader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static String forwardSlash(String path) {
        if (path == null) {
            return "";
        }
        int i = path.indexOf("\\");
        while (i != -1) {
            path = String.valueOf(path.substring(0, i)) + "/" + path.substring(i + 1);
            i = path.indexOf("\\");
        }
        return path;
    }

    public static String getName(String path) {
        if (path == null) {
            return "";
        }
        int i = path.lastIndexOf("/");
        if (i == -1) {
            i = path.lastIndexOf("\\");
        }
        if (i != -1) {
            return path.substring(i + 1);
        }
        return path;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int i = fileName.lastIndexOf(46);
        int j = XML.forwardSlash(fileName).lastIndexOf(47);
        if (i > 0 && i < fileName.length() - 1 && i > j) {
            return fileName.substring(i + 1);
        }
        return null;
    }

    public static String getSimpleClassName(Class<?> type) {
        String name = type.getName();
        int i = name.indexOf(";");
        if (i > -1) {
            name = name.substring(0, i);
        }
        while (name.startsWith("[")) {
            name = name.substring(1);
            name = String.valueOf(name) + "[]";
        }
        String ext = XML.getExtension(name);
        if (ext != null) {
            name = ext;
        }
        if ((i = name.indexOf("[")) > -1) {
            String s = name.substring(0, i);
            if (s.equals("I")) {
                s = "int";
            } else if (s.equals("D")) {
                s = "double";
            } else if (s.equals("Z")) {
                s = "boolean";
            }
            name = String.valueOf(s) + name.substring(i);
        }
        return name;
    }

    public static String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = XML.forwardSlash(fileName);
        int n = XML.forwardSlash(fileName).lastIndexOf("/");
        String name = XML.getName(fileName);
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            name = name.substring(0, i);
        }
        fileName = String.valueOf(fileName.substring(0, n + 1)) + name;
        while (fileName.lastIndexOf(46) == fileName.length() - 1 && fileName.length() > 0) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName;
    }

    public static String getPathRelativeTo(String absolutePath, String base) {
        if (base == null || base.equals("")) {
            base = XML.getUserDirectory();
        }
        absolutePath = XML.forwardSlash(absolutePath);
        base = XML.forwardSlash(base);
        if (!absolutePath.startsWith("/") && absolutePath.indexOf(":") == -1) {
            return absolutePath;
        }
        if (!base.startsWith("/") && base.indexOf(":") == -1) {
            return absolutePath;
        }
        int jar = absolutePath.indexOf("jar!");
        if (jar > -1) {
            absolutePath = absolutePath.substring(jar + 5);
            return absolutePath;
        }
        String relativePath = "";
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        int j = 0;
        while (j < 6) {
            if (j > 0) {
                int k = base.lastIndexOf("/");
                if (k != -1) {
                    base = base.substring(0, k);
                    relativePath = String.valueOf(relativePath) + "../";
                } else {
                    if (base.equals("")) break;
                    base = "";
                    relativePath = String.valueOf(relativePath) + "../";
                }
            }
            if (!base.equals("") && absolutePath.startsWith(base)) {
                String path = absolutePath.substring(base.length());
                int k = path.indexOf("/");
                if (k == 0) {
                    path = path.substring(1);
                }
                relativePath = String.valueOf(relativePath) + path;
                return relativePath;
            }
            ++j;
        }
        return absolutePath;
    }

    public static String getRelativePath(String absolutePath) {
        return XML.getPathRelativeTo(absolutePath, XML.getUserDirectory());
    }

    public static String getUserDirectory() {
        String userDir = System.getProperty("user.dir", ".");
        return userDir;
    }

    public static String getDirectoryPath(String fileName) {
        if (fileName == null) {
            return "";
        }
        int slash = (fileName = XML.forwardSlash(fileName)).lastIndexOf("/");
        if (slash != -1) {
            return fileName.substring(0, slash);
        }
        return "";
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        String path = XML.forwardSlash(file.getAbsolutePath());
        int n = path.indexOf("/../");
        while (n >= 0) {
            String pre = path.substring(0, n);
            int m = pre.lastIndexOf("/");
            if (m < 0) break;
            String post = path.substring(n + 3);
            path = String.valueOf(pre.substring(0, m)) + post;
            n = path.indexOf("/../");
        }
        n = path.indexOf("/./");
        while (n >= 0) {
            path = String.valueOf(path.substring(0, n)) + path.substring(n + 2);
            n = path.indexOf("/./");
        }
        return path;
    }

    public static String getResolvedPath(String relativePath, String base) {
        if (base != null && base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        if ((relativePath = XML.forwardSlash(relativePath)).startsWith("/") || relativePath.indexOf(":/") >= 0) {
            return relativePath;
        }
        base = XML.forwardSlash(base);
        while (relativePath.startsWith("../") && !base.equals("")) {
            if (base.indexOf("/") == -1) {
                base = "/" + base;
            }
            relativePath = relativePath.substring(3);
            base = base.substring(0, base.lastIndexOf("/"));
        }
        if (relativePath.startsWith("./")) {
            relativePath = relativePath.substring(2);
        }
        if (relativePath.equals(".")) {
            relativePath = "";
        }
        if (base.equals("")) {
            return relativePath;
        }
        if (base.endsWith("/") || relativePath.startsWith("&")) {
            return String.valueOf(base) + relativePath;
        }
        return String.valueOf(base) + "/" + relativePath;
    }

    public static void createFolders(String path) {
        File dir2 = new File(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (!dir2.exists()) {
            dirs.add(0, dir2);
            int j = path.lastIndexOf("/");
            if (j == -1) break;
            path = path.substring(0, j);
            dir2 = new File(path);
        }
        for (File dir2 : dirs) {
            dir2.mkdir();
        }
    }

    public static String removeCDATA(String content) {
        int pt = content.indexOf(CDATA_PRE);
        return pt >= 0 ? content.substring(pt + 9, content.indexOf(CDATA_POST)) : content;
    }

    public static interface NonStaticLoader {
    }

    public static interface ObjectLoader {
        public void saveObject(XMLControl var1, Object var2);

        public Object createObject(XMLControl var1);

        public Object loadObject(XMLControl var1, Object var2);
    }
}

