/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLNode;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLPropertyElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public final class XMLControlElement
extends XMLNode
implements XMLControl {
    public static final int ALWAYS_DECRYPT = 0;
    public static final int PASSWORD_DECRYPT = 3;
    public static final int NEVER_DECRYPT = 5;
    public static int compactArraySize = 0;
    protected static String encoding = "UTF-8";
    protected Class<?> theClass = null;
    protected Map<String, Integer> counts = new HashMap<String, Integer>();
    protected Object object;
    protected int level;
    private ArrayList<String> propNames = new ArrayList();
    private ArrayList<XMLProperty> props = new ArrayList();
    protected BufferedReader input;
    protected BufferedWriter output;
    public boolean canWrite;
    protected boolean valid = false;
    protected boolean readFailed = false;
    protected String version;
    protected String doctype = "osp10.dtd";
    private String basepath;
    private String password;
    private int decryptPolicy = 0;
    private Object data;
    private Map<String, XMLControl> childMap;
    private XMLControl[] childControls;
    private Map<String, XMLProperty> propMap;
    public XML.ObjectLoader loader;
    private boolean isFinalizable;
    static Object sync = new Object();

    @Override
    public String getBasepath() {
        return this.basepath;
    }

    @Override
    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }

    public Object getData() {
        return this.data;
    }

    public XMLControlElement() {
    }

    public XMLControlElement(Class<?> type) {
        this.setObjectClass(type);
    }

    public XMLControlElement(Object obj) {
        this.setObjectClass(obj.getClass());
        this.saveObject(obj);
    }

    public XMLControlElement(XMLProperty parent) {
        this.parent = parent;
        this.level = parent.getLevel();
    }

    public XMLControlElement(File xmlFile) {
        try {
            String data = this.getFileData(xmlFile);
            if (data != null) {
                this.readData(data);
                return;
            }
        }
        catch (Exception ex) {
            OSPLog.warning("Failed to read xml: " + xmlFile + ex.getMessage());
        }
        this.readFailed = true;
    }

    private String getFileData(File xmlFile) {
        byte[] bytes = null;
        try {
            bytes = ResourceLoader.getURLContents(xmlFile.toURI().toURL(), false);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bytes == null ? null : new String(bytes);
    }

    public XMLControlElement(String input) {
        this();
        this.readData(input);
    }

    public XMLControlElement(XMLControl control) {
        this();
        this.readXML(control.toXML());
    }

    @Override
    public void setLockValues(boolean lock) {
    }

    @Override
    public void setValue(String name, boolean value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, 2, String.valueOf(value), false);
    }

    @Override
    public void setValue(String name, double value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, 1, String.valueOf(value), false);
    }

    @Override
    public void setValue(String name, int value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, 0, String.valueOf(value), false);
    }

    @Override
    public void setValue(String name, Object obj) {
        this.setValue(name, obj, XMLPropertyElement.defaultWriteNullFinalArrayElements);
    }

    @Override
    public void setValue(String name, double[] val, int decimalPlaces) {
        this.setValue(name, new XMLProperty.WrappedArray(val, decimalPlaces));
    }

    public void setValue(String name, Object obj, boolean writeNullFinalElement) {
        if (name == null) {
            return;
        }
        if (obj == null) {
            boolean childRemoved = false;
            if (this.getPropMap().containsKey(name)) {
                Iterator<XMLProperty> it = this.props.iterator();
                while (it.hasNext()) {
                    XMLProperty prop = it.next();
                    if (!name.equals(prop.getPropertyName())) continue;
                    it.remove();
                    this.propNames.remove(name);
                    this.getPropMap().remove(name);
                    if (this.getChildMap().remove(name) == null) break;
                    childRemoved = true;
                    break;
                }
            }
            if (childRemoved) {
                this.childControls = null;
            }
            return;
        }
        if (obj instanceof Boolean) {
            this.setValue(name, (Boolean)obj);
            return;
        }
        int type = XMLProperty.getDataType(obj);
        switch (type) {
            case -1: {
                break;
            }
            case 0: 
            case 1: {
                obj = obj.toString();
            }
            default: {
                this.setXMLProperty(name, type, obj, writeNullFinalElement);
            }
        }
    }

    @Override
    public boolean getBoolean(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && prop.getPropertyType() == 2) {
            return "true".equals(prop.getPropertyContent().get(0));
        }
        if (prop != null && prop.getPropertyType() == 3) {
            return "true".equals(prop.getPropertyContent().get(0));
        }
        return false;
    }

    @Override
    public double getDouble(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null) {
            switch (prop.getPropertyType()) {
                case 0: 
                case 1: 
                case 3: {
                    try {
                        return Double.parseDouble((String)prop.getPropertyContent().get(0));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return Double.NaN;
    }

    @Override
    public int getInt(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null) {
            switch (prop.getPropertyType()) {
                case 0: 
                case 3: {
                    try {
                        return Integer.parseInt((String)prop.getPropertyContent().get(0));
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case 6: {
                    XMLControl control = (XMLControl)prop.getPropertyContent().get(0);
                    if (control.getObjectClass() != OSPCombo.class) break;
                    OSPCombo combo = (OSPCombo)control.loadObject(null);
                    return combo.getSelectedIndex();
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public String getString(String name) {
        XMLControl control;
        int type;
        XMLProperty prop = this.getXMLProperty(name);
        int n = type = prop == null ? -1 : prop.getPropertyType();
        if (type == 3) {
            return XML.removeCDATA((String)prop.getPropertyContent().get(0));
        }
        if (name.equals("basepath") && this.getRootControl() != null) {
            return this.getRootControl().basepath;
        }
        if (type == 6 && (control = (XMLControl)prop.getPropertyContent().get(0)).getObjectClass() == OSPCombo.class) {
            OSPCombo combo = (OSPCombo)control.loadObject(null);
            return combo.toString();
        }
        return null;
    }

    @Override
    public Object getObject(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop == null) {
            return null;
        }
        Object o = XMLControlElement.getPropValue(prop, this.data);
        return this.data != null && name.equals("framedata") ? XMLControlElement.getAdjustedFrameData(o, this.data) : o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> arrayList = this.propNames;
        synchronized (arrayList) {
            return new ArrayList<String>(this.propNames);
        }
    }

    @Override
    public Collection<String> getPropertyNamesRaw() {
        return this.propNames;
    }

    @Override
    public int getPropertyType(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        return prop == null ? -1 : prop.getPropertyType();
    }

    public void setPassword(String pass) {
        this.password = pass;
        if (this.getObjectClass() != Cryptic.class) {
            this.setValue("xml_password", pass);
        }
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.getString("xml_password");
        }
        return this.password;
    }

    public void setDecryptPolicy(int policy) {
        this.decryptPolicy = policy == 5 ? 5 : (policy == 3 ? 3 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAsync(String name, Function<String, Void> whenDone) {
        Object object = sync;
        synchronized (object) {
            Resource res = ResourceLoader.getResource(name);
            if (res == null) {
                this.processReader(name, null, null, whenDone);
            } else if (res.getFile() != null) {
                this.processReader(name, res, res.openReader(), whenDone);
            } else {
                ResourceLoader.getURLContentsAsync(res.getURL(), bytes -> {
                    if (bytes == null) {
                        this.processReader(name, null, null, whenDone);
                    } else {
                        this.processReader(name, res, ResourceLoader.readerForStream(new ByteArrayInputStream((byte[])bytes), null), whenDone);
                    }
                    return null;
                });
            }
        }
    }

    protected void processReader(String name, Resource res, BufferedReader in, Function<String, Void> whenDone) {
        if (res == null) {
            OSPLog.warning("Could not open " + name);
            this.readFailed = true;
            whenDone.apply(null);
            return;
        }
        this.read(in);
        whenDone.apply(this.readFailed ? null : this.setPath(name, res));
    }

    private void readData(String input) {
        if (input.startsWith("<?xml")) {
            this.readXML(input);
        } else {
            this.read(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(String fileName) {
        Object object = sync;
        synchronized (object) {
            Resource res = ResourceLoader.getResource(fileName);
            if (res != null) {
                try {
                    BufferedReader in = res.openReader();
                    if (in != null) {
                        this.read(in);
                        return this.setPath(fileName, res);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            OSPLog.warning("Could not open " + fileName);
            this.readFailed = true;
        }
        return null;
    }

    @Override
    public void readXML(String xml) {
        this.readXML(xml, null);
    }

    private boolean readXML(String xml, String requiredType) {
        if (this.readInput(xml == null ? null : new BufferedReader(new StringReader(xml)), requiredType)) {
            this.canWrite = false;
        }
        return !this.readFailed;
    }

    @Override
    public void read(Reader in) {
        this.readInput(in == null ? null : (in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in)), null);
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String readForClass(String name, Class<?> type) {
        Resource res = ResourceLoader.getResource(name);
        return this.readInput(res == null ? null : new BufferedReader(res.openReader()), type.getName()) ? this.setPath(name, res) : null;
    }

    public boolean readXMLForClass(String xml, Class<?> type) {
        return this.readXML(xml, type.getName());
    }

    private String setPath(String name, Resource res) {
        String path = XML.getDirectoryPath(name);
        if (path.length() == 0) {
            this.basepath = XML.getDirectoryPath(res.getAbsolutePath());
        } else {
            ResourceLoader.addSearchPath(path);
            this.basepath = path;
        }
        File file = res.getFile();
        this.canWrite = file != null && file.canWrite();
        return res.getAbsolutePath();
    }

    @Override
    public boolean failedToRead() {
        return this.readFailed;
    }

    @Override
    public String write(String fileName) {
        File file;
        block9: {
            this.canWrite = true;
            if (!OSPRuntime.isJS) {
                String dir;
                File file2;
                int n = fileName.lastIndexOf("/");
                if (n < 0) {
                    n = fileName.lastIndexOf("\\");
                }
                if (n > 0 && !(file2 = new File(dir = fileName.substring(0, n + 1))).exists() && !file2.mkdirs()) {
                    this.canWrite = false;
                    return null;
                }
            }
            file = new File(fileName);
            if (!file.exists() || file.canWrite()) break block9;
            JOptionPane.showMessageDialog(null, String.valueOf(ControlsRes.getString("Dialog.ReadOnly.Message")) + ": " + file.getPath(), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            this.canWrite = false;
            return null;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName(encoding);
            this.write(new OutputStreamWriter((OutputStream)stream, charset));
            if (file.exists()) {
                String path = XML.getDirectoryPath(file.getCanonicalPath());
                ResourceLoader.addSearchPath(path);
            }
            if (this.isValid()) {
                fileName = fileName.indexOf("/") != -1 ? String.valueOf(fileName.substring(0, fileName.lastIndexOf("/") + 1)) + this.getDoctype() : (fileName.indexOf("\\") != -1 ? String.valueOf(fileName.substring(0, fileName.lastIndexOf("\\") + 1)) + this.getDoctype() : this.doctype);
                this.writeDocType(new FileWriter(fileName));
            }
            if (file.exists()) {
                return XML.getAbsolutePath(file);
            }
        }
        catch (IOException ex) {
            this.canWrite = false;
            OSPLog.warning(ex.getMessage());
        }
        return null;
    }

    @Override
    public void write(Writer out) {
        try {
            this.output = new BufferedWriter(out);
            String xml = this.toXML();
            if (this.getPassword() != null) {
                Cryptic cryptic = new Cryptic(xml);
                XMLControlElement control = new XMLControlElement(cryptic);
                xml = control.toXML();
            }
            this.output.write(xml);
            this.output.flush();
            this.output.close();
        }
        catch (IOException ex) {
            OSPLog.info(ex.getMessage());
        }
    }

    public void writeDocType(Writer out) {
        try {
            this.output = new BufferedWriter(out);
            this.output.write(XML.getDTD(this.getDoctype()));
            this.output.flush();
            this.output.close();
        }
        catch (IOException ex) {
            OSPLog.info(ex.getMessage());
        }
    }

    @Override
    public String toXML() {
        return this.toString();
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid && XML.getDTD(this.getDoctype()) != null;
    }

    public void setVersion(String vers) {
        this.version = vers;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDoctype(String name) {
        XML.getDTD(name);
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setObjectClass(Class<?> type) {
        if (this.object != null && !type.isInstance(this.object)) {
            throw new RuntimeException(this.object + " " + ControlsRes.getString("XMLControlElement.Exception.NotInstanceOf") + " " + type);
        }
        this.theClass = type;
        this.className = type.getName();
    }

    @Override
    public Class<?> getObjectClass() {
        if (this.className == null || this.theClass != null && this.theClass.getName().equals(this.className)) {
            return this.theClass;
        }
        this.theClass = null;
        try {
            this.theClass = Class.forName(this.className);
            return this.theClass;
        }
        catch (ClassNotFoundException ex) {
            try {
                Class<?> clazz;
                ClassLoader loader = XML.getClassLoader();
                if (loader == null) {
                    clazz = null;
                } else {
                    this.theClass = loader.loadClass(this.className);
                    clazz = this.theClass;
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.theClass;
            }
        }
    }

    @Override
    public String getObjectClassName() {
        return this.className;
    }

    @Override
    public void saveObject(Object obj) {
        Class<?> type;
        if (obj == null) {
            obj = this.object;
        }
        if ((type = this.getObjectClass()) == null || type.equals(Object.class)) {
            if (obj == null) {
                return;
            }
            type = obj.getClass();
        }
        if (type.isInstance(obj)) {
            this.object = obj;
            this.className = obj.getClass().getName();
            this.clearValues();
            XML.ObjectLoader loader = XML.getLoader(type);
            loader.saveObject(this, obj);
        }
    }

    @Override
    public Object loadObject(Object obj) {
        return this.loadObject(obj, false, false);
    }

    @Override
    public Object loadObject(Object obj, Object data) {
        this.data = data;
        return this.loadObject(obj, false, false);
    }

    public Object loadObject(Object obj, boolean autoImport) {
        return this.loadObject(obj, autoImport, false);
    }

    public Object loadObject(Object obj, boolean autoImport, boolean importAll) {
        Class<?> oclass;
        Class<?> myType = this.getObjectClass();
        Class<?> clazz = oclass = obj == null ? null : obj.getClass();
        if (myType == null) {
            int result;
            if (oclass == null) {
                return null;
            }
            if (!autoImport && (result = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("XMLControlElement.Dialog.UnknownClass.Message")) + " \"" + this.className + "\"" + XML.NEW_LINE + ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Query") + " \"" + obj.getClass().getName() + "\"", ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Title"), 0, 3)) != 0) {
                return obj;
            }
            if (!this.importInto(obj, importAll)) {
                return obj;
            }
            myType = oclass;
        } else if (obj == null) {
            oclass = myType;
        }
        boolean needLoader = this.object == null || myType != oclass || this.loader == null;
        XML.ObjectLoader loader = null;
        try {
            XML.ObjectLoader objectLoader = loader = needLoader ? XML.getLoader(myType) : this.loader;
            if (myType == oclass || oclass != null && loader.getClass() == XML.getLoader(oclass).getClass()) {
                autoImport = true;
                importAll = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obj != null && myType != oclass && !myType.isInstance(obj)) {
            int result;
            if (!autoImport && (result = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Message")) + " \"" + myType.getName() + "\"" + XML.NEW_LINE + ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Query") + " \"" + obj.getClass().getName() + "\"", ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Title"), 0, 2)) != 0) {
                return obj;
            }
            if (!this.importInto(obj, importAll)) {
                return obj;
            }
            myType = oclass;
            loader = XML.getLoader(myType);
        }
        if (obj == null) {
            Object object = obj = this.object == null ? loader.createObject(this) : this.object;
            if (obj == null || !myType.isInstance(obj)) {
                return obj;
            }
        }
        obj = loader.loadObject(this, obj);
        if (this.isFinalizable || loader instanceof VideoIO.FinalizableLoader) {
            this.isFinalizable = true;
            if (!((VideoIO.FinalizableLoader)((Object)loader)).isFinalized()) {
                this.loader = loader;
                this.object = obj;
            }
        }
        return obj;
    }

    @Override
    public void clearValues() {
        this.props.clear();
        this.propNames.clear();
        if (this.propMap != null) {
            this.propMap.clear();
        }
        if (this.childMap != null) {
            this.childMap.clear();
            this.childControls = null;
        }
    }

    @Override
    public void println(String s) {
        System.out.println(s);
    }

    @Override
    public void println() {
        System.out.println();
    }

    @Override
    public void print(String s) {
        System.out.print(s);
    }

    @Override
    public void clearMessages() {
        System.out.println("XMLControlElment.clearMessages");
    }

    @Override
    public void calculationDone(String s) {
    }

    @Override
    public String getPropertyName() {
        XMLProperty parent = this.getParentProperty();
        if (this.className == null) {
            if (parent == null) {
                return "null";
            }
            return parent.getPropertyName();
        }
        if (this.isArrayOrCollectionItem()) {
            if (this.name == null) {
                String myName = this.getString("name");
                if (myName != null && !"".equals(myName)) {
                    this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                    this.name = String.valueOf(this.name) + " \"" + myName + "\"";
                } else {
                    XMLProperty root = this;
                    while (root.getParentProperty() != null) {
                        root = root.getParentProperty();
                    }
                    if (root instanceof XMLControlElement) {
                        XMLProperty rootControl = root;
                        this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                        this.name = ((XMLControlElement)rootControl).addNumbering(this.name);
                    }
                }
            }
            return this.name;
        }
        if (parent != null) {
            return parent.getPropertyName();
        }
        return this.className.substring(this.className.lastIndexOf(".") + 1);
    }

    @Override
    public Class<?> getPropertyClass() {
        return this.getObjectClass();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public List<Object> getPropertyContent() {
        return new ArrayList<Object>(this.props);
    }

    @Override
    public List<XMLProperty> getPropsRaw() {
        return this.props;
    }

    @Override
    public XMLControl getChildControl(String name) {
        return this.getChildMap().get(name);
    }

    @Override
    public XMLControl[] getChildControls() {
        if (this.childControls == null) {
            ArrayList<XMLControl> list = new ArrayList<XMLControl>();
            for (XMLProperty prop : this.props) {
                if (prop.getPropertyType() != 6) continue;
                list.add((XMLControl)prop.getPropertyContent().get(0));
            }
            this.childControls = list.toArray(new XMLControl[list.size()]);
        }
        return this.childControls;
    }

    public XMLControlElement getRootControl() {
        if (this.parent == null) {
            return this;
        }
        XMLProperty prop = this.parent;
        while (prop.getParentProperty() != null) {
            prop = prop.getParentProperty();
        }
        if (prop instanceof XMLControlElement) {
            return (XMLControlElement)prop;
        }
        return null;
    }

    public String addNumbering(String name) {
        Integer count = this.counts.get(name);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.counts.put(name, count);
        return String.valueOf(name) + " " + count.toString();
    }

    public String toString() {
        StringBuffer xml = new StringBuffer("");
        if (this.getLevel() == 0) {
            xml.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            if (this.isValid()) {
                xml.append(String.valueOf(XML.NEW_LINE) + "<!DOCTYPE object SYSTEM \"" + this.doctype + "\">");
            }
        }
        xml.append(String.valueOf(XML.NEW_LINE) + XMLControlElement.indent(this.getLevel()) + "<object class=\"" + this.className + "\"");
        if (this.version != null && this.getLevel() == 0) {
            xml.append(" version=\"" + this.version + "\"");
        }
        if (this.props.isEmpty()) {
            xml.append("/>");
        } else {
            xml.append(">");
            Iterator<XMLProperty> it = this.props.iterator();
            while (it.hasNext()) {
                xml.append(it.next().toString());
            }
            xml.append(String.valueOf(XML.NEW_LINE) + XMLControlElement.indent(this.getLevel()) + "</object>");
        }
        return xml.toString();
    }

    public <T> List<T> getObjects(Class<T> type) {
        return this.getObjects(type, false);
    }

    public <T> List<T> getObjects(Class<T> type, boolean useChooser) {
        List<XMLProperty> props;
        if (useChooser) {
            String name = type.getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            XMLTreeChooser chooser = new XMLTreeChooser(ControlsRes.getString("XMLControlElement.Chooser.SelectObjectsOfClass.Title"), String.valueOf(ControlsRes.getString("XMLControlElement.Chooser.SelectObjectsOfClass.Label")) + " " + name, null);
            props = chooser.choose(this, type);
        } else {
            XMLTree tree = new XMLTree(this);
            tree.setHighlightedClass(type);
            tree.selectHighlightedProperties();
            props = tree.getSelectedProperties();
        }
        ArrayList<T> objects = new ArrayList<T>();
        for (XMLControl xMLControl : props) {
            objects.add(type.cast(xMLControl.loadObject(null)));
        }
        return objects;
    }

    public Object clone() {
        return new XMLControlElement(this);
    }

    private boolean isArrayOrCollectionItem() {
        XMLProperty parent = this.getParentProperty();
        if (parent != null) {
            return (parent = parent.getParentProperty()) != null && "arraycollection".indexOf(parent.getPropertyType()) >= 0;
        }
        return false;
    }

    private boolean importInto(Object obj, boolean importAll) {
        final XMLControlElement control = new XMLControlElement(obj);
        Collection<String> list = control.getPropertyNames();
        list.retainAll(this.getPropertyNamesRaw());
        final ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (XMLProperty prop : this.props) {
            String propName = prop.getPropertyName();
            if (!list.contains(propName)) continue;
            names.add(propName);
            if (prop.getPropertyType() == 6) {
                values.add(prop.getPropertyClass().getSimpleName());
                continue;
            }
            values.add(prop.getPropertyContent().get(0));
        }
        if (names.isEmpty() || importAll) {
            return this.processImport(control, names);
        }
        final boolean[] isOK = new boolean[1];
        ListChooser chooser = new ListChooser(ControlsRes.getString("XMLControlElement.Chooser.ImportObjects.Title"), ControlsRes.getString("XMLControlElement.Chooser.ImportObjects.Label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    XMLControlElement.this.processImport(control, names);
                    isOK[0] = true;
                }
            }
        });
        chooser.choose(names, names, values, null, null, null);
        return isOK[0];
    }

    private boolean processImport(XMLControl control, Collection<String> names) {
        Iterator<XMLProperty> it = this.props.iterator();
        while (it.hasNext()) {
            String name = it.next().getPropertyName();
            if (names.contains(name)) continue;
            it.remove();
            this.propNames.remove(name);
            this.getPropMap().remove(name);
        }
        for (String name : control.getPropertyNamesRaw()) {
            if (names.contains(name)) continue;
            switch (control.getPropertyType(name)) {
                case 0: {
                    this.setValue(name, control.getInt(name));
                    break;
                }
                case 1: {
                    this.setValue(name, control.getDouble(name));
                    break;
                }
                case 2: {
                    this.setValue(name, control.getBoolean(name));
                    break;
                }
                case 3: {
                    this.setValue(name, control.getString(name));
                    break;
                }
                default: {
                    this.setValue(name, control.getObject(name));
                }
            }
        }
        return true;
    }

    private void setXMLProperty(String name, int type, Object value, boolean writeNullFinalArrayElement) {
        XMLPropertyElement prop = new XMLPropertyElement(this, name, type, value, writeNullFinalArrayElement);
        if (this.propNames.contains(name)) {
            Iterator<XMLProperty> it = this.props.iterator();
            int i = 0;
            while (it.hasNext()) {
                XMLProperty p = it.next();
                if (p.getPropertyName().equals(name)) {
                    it.remove();
                    this.setProperty(name, prop, i);
                    return;
                }
                ++i;
            }
        } else {
            this.propNames.add(name);
        }
        this.setProperty(name, prop, -1);
    }

    private void setProperty(String name, XMLProperty prop, int i) {
        if (i < 0) {
            this.props.add(prop);
        } else {
            this.props.add(i, prop);
        }
        this.getPropMap().put(name, prop);
        if (prop.getPropertyType() == 6) {
            this.getChildMap().put(name, (XMLControl)prop.getPropertyContent().get(0));
            this.childControls = null;
        }
    }

    private Map<String, XMLProperty> getPropMap() {
        if (this.propMap == null) {
            this.propMap = new HashMap<String, XMLProperty>();
        }
        return this.propMap;
    }

    private XMLProperty getXMLProperty(String name) {
        return name == null ? null : this.getPropMap().get(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readInput(BufferedReader in, String className) {
        if (in == null) {
            this.readFailed = true;
            return false;
        }
        this.input = in;
        this.readFailed = false;
        try {
            String openingTag = this.input.readLine();
            int count = 0;
            while (true) {
                if (openingTag == null || openingTag.indexOf("<object class=") >= 0) {
                    if (openingTag == null) {
                        this.readFailed = true;
                        return false;
                    }
                    this.version = XML.getAttr(openingTag, "version", this.version);
                    this.readObject(this, openingTag, className);
                    break;
                }
                if (++count > 9) {
                    this.readFailed = true;
                    return false;
                }
                openingTag = this.input.readLine();
            }
        }
        catch (Exception ex) {
            this.readFailed = true;
            OSPLog.warning("Failed to read xml: " + ex.getMessage());
            return false;
        }
        if (Cryptic.class.equals(this.getObjectClass())) {
            Cryptic cryptic = (Cryptic)this.loadObject(null);
            String xml = cryptic.decrypt();
            XMLControlElement test = new XMLControlElement(xml);
            if (test.failedToRead()) {
                return false;
            }
            String pass = this.password;
            this.password = test.getString("xml_password");
            switch (this.decryptPolicy) {
                case 5: {
                    return false;
                }
                case 3: {
                    if (this.password == null || this.password.equals("") || this.password.equals(pass) || Password.verify(this.password, null)) break;
                    this.readFailed = true;
                    return false;
                }
            }
            this.clearValues();
            this.object = null;
            className = Object.class.getName();
            this.theClass = null;
            return this.readXML(xml, null);
        }
        if (!this.readFailed) return true;
        return false;
    }

    private XMLControlElement readObject(XMLControlElement control, String xml, String requiredType) throws IOException {
        control.clearValues();
        String className = XMLControlElement.getClassName(xml);
        if (requiredType != null && !className.equals(requiredType)) {
            this.readFailed = true;
            return null;
        }
        control.className = className;
        if (xml.indexOf("/>") != -1) {
            this.input.readLine();
            return control;
        }
        XMLControlElement prop = control;
        xml = this.input.readLine();
        while (xml != null) {
            if (xml.indexOf("</object>") >= 0) {
                this.input.readLine();
                return control;
            }
            if (xml.indexOf("<property") >= 0) {
                control.addProperty(this.readProperty(new XMLPropertyElement(prop), xml));
            }
            xml = this.input.readLine();
        }
        return control;
    }

    private void addProperty(XMLProperty child) {
        String name = child.getPropertyName();
        this.propNames.add(name);
        this.setProperty(name, child, -1);
    }

    private Map<String, XMLControl> getChildMap() {
        if (this.childMap == null) {
            this.childMap = new HashMap<String, XMLControl>();
        }
        return this.childMap;
    }

    private XMLPropertyElement readProperty(XMLPropertyElement prop, String xml) throws IOException {
        prop.name = XML.getAttr(xml, "name", null);
        prop.type = XMLProperty.getTypeCode(XML.getAttr(xml, "type", null));
        switch (prop.type) {
            case 4: 
            case 5: {
                prop.className = XMLControlElement.getClassName(xml);
                if (xml.indexOf("/>") >= 0) {
                    return prop;
                }
                xml = this.input.readLine();
                while (xml.indexOf("<property") >= 0) {
                    prop.content.add(this.readProperty(new XMLPropertyElement(prop), xml));
                    xml = this.input.readLine();
                }
                break;
            }
            case 6: {
                if (xml.indexOf(">null</property") >= 0) break;
                XMLControlElement control = this.readObject(new XMLControlElement(prop), this.input.readLine(), null);
                prop.content.add(control);
                prop.className = control.className;
                break;
            }
            case 3: {
                int pt = xml.indexOf("<![CDATA[");
                if (pt >= 0) {
                    String s = xml.substring(pt + 9);
                    while ((pt = s.indexOf("]]></property>")) < 0) {
                        s = String.valueOf(s) + XML.NEW_LINE + this.input.readLine();
                    }
                    prop.content.add(s.substring(0, pt));
                    break;
                }
            }
            default: {
                int pt;
                String s = xml.substring(xml.indexOf(">") + 1);
                while ((pt = s.indexOf("</property>")) < 0) {
                    s = String.valueOf(s) + XML.NEW_LINE + this.input.readLine();
                }
                prop.content.add(s.substring(0, pt));
            }
        }
        return prop;
    }

    private static String indent(int level) {
        String space = "";
        int i = 0;
        while (i < 4 * level) {
            space = String.valueOf(space) + " ";
            ++i;
        }
        return space;
    }

    public static Object getAdjustedFrameData(Object o, Object data) {
        if (!(o instanceof Object[])) {
            return o;
        }
        Object[] a = (Object[])o;
        return a.length <= 1 || !(data instanceof FrameDataAdjusterI) ? a : ((FrameDataAdjusterI)data).adjustFrameData(a);
    }

    private static Object getPropValue(XMLProperty prop, Object data) {
        switch (prop.getPropertyType()) {
            case 6: {
                return XMLControlElement.objectValue(prop, data);
            }
            case 4: {
                return XMLControlElement.arrayValue(prop, data);
            }
            case 5: {
                return XMLControlElement.collectionValue(prop, data);
            }
            case 0: {
                return XMLControlElement.intValue(prop);
            }
            case 1: {
                return XMLControlElement.doubleValue(prop);
            }
            case 2: {
                return XMLControlElement.booleanValue(prop);
            }
            case 3: {
                return XMLControlElement.stringValue(prop);
            }
        }
        return null;
    }

    private static Object objectValue(XMLProperty prop, Object data) {
        if (prop.getPropertyType() != 6) {
            return null;
        }
        if (prop.getPropertyContent().isEmpty()) {
            return null;
        }
        Object content = prop.getPropertyContent().get(0);
        if (!(content instanceof XMLControl)) {
            return null;
        }
        XMLControl control = (XMLControl)content;
        return control.loadObject(null, data);
    }

    private static double doubleValue(XMLProperty prop) {
        if (prop.getPropertyType() != 1) {
            return Double.NaN;
        }
        return Double.parseDouble((String)prop.getPropertyContent().get(0));
    }

    private static int intValue(XMLProperty prop) {
        if (prop.getPropertyType() != 0) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt((String)prop.getPropertyContent().get(0));
    }

    private static boolean booleanValue(XMLProperty prop) {
        return prop.getPropertyContent().get(0).equals("true");
    }

    private static String stringValue(XMLProperty prop) {
        return prop.getPropertyType() == 3 ? XML.removeCDATA((String)prop.getPropertyContent().get(0)) : null;
    }

    private static Object arrayValue(XMLProperty prop, Object data) {
        if (prop.getPropertyType() != 4) {
            return null;
        }
        Class<?> componentType = prop.getPropertyClass().getComponentType();
        List<Object> content = prop.getPropertyContent();
        if (content.isEmpty()) {
            return Array.newInstance(componentType, 0);
        }
        XMLProperty first = (XMLProperty)content.get(0);
        if (first.getPropertyName().equals("array")) {
            Object obj = first.getPropertyContent().get(0);
            if (obj instanceof String) {
                return XMLControlElement.arrayValue((String)obj, componentType);
            }
            return null;
        }
        XMLProperty last = (XMLProperty)content.get(content.size() - 1);
        String index = last.getPropertyName();
        int n = Integer.parseInt(index.substring(1, index.indexOf("]")));
        Object array = Array.newInstance(componentType, n + 1);
        for (XMLProperty xMLProperty : content) {
            index = xMLProperty.getPropertyName();
            n = Integer.parseInt(index.substring(1, index.indexOf("]")));
            switch (xMLProperty.getPropertyType()) {
                case 6: {
                    Array.set(array, n, XMLControlElement.objectValue(xMLProperty, data));
                    break;
                }
                case 0: {
                    int val = XMLControlElement.intValue(xMLProperty);
                    if (Object.class.isAssignableFrom(componentType)) {
                        Array.set(array, n, val);
                        break;
                    }
                    Array.setInt(array, n, val);
                    break;
                }
                case 1: {
                    double d = XMLControlElement.doubleValue(xMLProperty);
                    if (Object.class.isAssignableFrom(componentType)) {
                        Array.set(array, n, d);
                        break;
                    }
                    Array.setDouble(array, n, d);
                    break;
                }
                case 2: {
                    boolean b = XMLControlElement.booleanValue(xMLProperty);
                    if (Object.class.isAssignableFrom(componentType)) {
                        Array.set(array, n, b);
                        break;
                    }
                    Array.setBoolean(array, n, b);
                    break;
                }
                case 3: {
                    Array.set(array, n, XMLControlElement.stringValue(xMLProperty));
                    break;
                }
                case 4: {
                    Array.set(array, n, XMLControlElement.arrayValue(xMLProperty, data));
                    break;
                }
                case 5: {
                    Array.set(array, n, XMLControlElement.collectionValue(xMLProperty, data));
                }
            }
        }
        return array;
    }

    private static Object arrayValue(String s, Class<?> componentType) {
        Object array;
        block14: {
            String[] list;
            block15: {
                block13: {
                    System.out.println(s);
                    if (!s.startsWith("{") || !s.endsWith("}")) {
                        return null;
                    }
                    if (componentType.isArray()) {
                        ArrayList<Object> list2 = new ArrayList<Object>();
                        Class<?> arrayType = componentType.getComponentType();
                        boolean allowTrailingNull = false;
                        int n = s.length() - (allowTrailingNull ? 0 : 1);
                        boolean wasArray = false;
                        int pt = 1;
                        while (pt < n) {
                            switch (s.charAt(pt)) {
                                case ',': 
                                case '}': {
                                    if (wasArray) {
                                        wasArray = false;
                                        break;
                                    }
                                    list2.add(null);
                                    break;
                                }
                                case '{': {
                                    int pt1 = XMLControlElement.indexOfClosingBrace(s, pt, n);
                                    list2.add(XMLControlElement.arrayValue(s.substring(pt, pt1 + 1), arrayType));
                                    pt = pt1;
                                    wasArray = true;
                                }
                            }
                            ++pt;
                        }
                        n = list2.size();
                        Object array2 = Array.newInstance(componentType, n);
                        int p = 0;
                        while (p < n) {
                            Object v = list2.get(p);
                            if (v != null) {
                                Array.set(array2, p, v);
                            }
                            ++p;
                        }
                        return array2;
                    }
                    list = s.length() == 0 ? new String[]{} : s.substring(1, s.length() - 1).split(",");
                    array = Array.newInstance(componentType, list.length);
                    if (componentType != Integer.TYPE) break block13;
                    int pt = list.length;
                    while (--pt >= 0) {
                        ((int[])array)[pt] = Integer.parseInt(list[pt]);
                    }
                    System.out.println(Arrays.toString((int[])array));
                    break block14;
                }
                if (componentType != Double.TYPE) break block15;
                int pt = list.length;
                while (--pt >= 0) {
                    ((double[])array)[pt] = Double.parseDouble(list[pt]);
                }
                break block14;
            }
            if (componentType != Boolean.TYPE) break block14;
            int pt = list.length;
            while (--pt >= 0) {
                ((boolean[])array)[pt] = Boolean.parseBoolean(list[pt]);
            }
        }
        return array;
    }

    private static int indexOfClosingBrace(String s, int pt, int n) {
        int c = 0;
        int i = pt;
        while (i < n) {
            switch (s.charAt(i)) {
                case '{': {
                    ++c;
                    break;
                }
                case '}': {
                    if (--c != 0) break;
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static Object collectionValue(XMLProperty prop, Object data) {
        if (prop.getPropertyType() != 5) {
            return null;
        }
        Class<?> classType = prop.getPropertyClass();
        try {
            Collection c = (Collection)classType.newInstance();
            List<Object> content = prop.getPropertyContent();
            for (XMLProperty xMLProperty : content) {
                switch (xMLProperty.getPropertyType()) {
                    case 6: {
                        c.add(XMLControlElement.objectValue(xMLProperty, data));
                        break;
                    }
                    case 3: {
                        c.add(XMLControlElement.stringValue(xMLProperty));
                        break;
                    }
                    case 4: {
                        c.add(XMLControlElement.arrayValue(xMLProperty, data));
                        break;
                    }
                    case 5: {
                        c.add(XMLControlElement.collectionValue(xMLProperty, data));
                    }
                }
            }
            return c;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getClassName(String xml) {
        try {
            String packageName;
            String className = XML.getAttr(xml, "class", "");
            int i = className.lastIndexOf(".");
            if (i >= 0 && (packageName = className.substring(0, i)).endsWith("org.opensourcephysics.media")) {
                className = String.valueOf(packageName) + ".core" + className.substring(i);
            }
            return className;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void finalize() {
        if (this.isFinalizable) {
            OSPLog.finalized("XMLControlElement finalized " + this.className);
        }
    }

    public void dispose() {
        this.object = null;
        this.loader = null;
        this.data = null;
    }

    public static interface FrameDataAdjusterI {
        public Object[] adjustFrameData(Object[] var1);
    }
}

