/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Collection;
import java.util.List;
import org.opensourcephysics.controls.XMLControl;

public interface XMLProperty {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_INT = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_ARRAY = 4;
    public static final int TYPE_COLLECTION = 5;
    public static final int TYPE_OBJECT = 6;
    public static final int TYPE_WRAPPED_ARRAY = 7;
    public static final String[] types = new String[]{"int", "double", "boolean", "string", "array", "collection", "object", "array"};

    public static String getTypeName(int type) {
        return type == -1 ? "object" : types[type];
    }

    public static int getTypeCode(String type) {
        switch (type) {
            case "int": {
                return 0;
            }
            case "double": {
                return 1;
            }
            case "boolean": {
                return 2;
            }
            case "string": {
                return 3;
            }
            case "array": {
                return 4;
            }
            case "collection": {
                return 5;
            }
            case "object": {
                return 6;
            }
        }
        return -1;
    }

    public static int getDataType(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (obj instanceof String) {
            return 3;
        }
        if (obj instanceof Collection) {
            return 5;
        }
        if (obj instanceof WrappedArray) {
            return 7;
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            String type = componentType.getName();
            if (type.indexOf(".") == -1 && "intdoubleboolean".indexOf(type) == -1) {
                return -1;
            }
            return 4;
        }
        if (obj instanceof Double) {
            return 1;
        }
        if (obj instanceof Integer) {
            return 0;
        }
        return 6;
    }

    public String getPropertyName();

    public int getPropertyType();

    public Class<?> getPropertyClass();

    public XMLProperty getParentProperty();

    public int getLevel();

    public List<Object> getPropertyContent();

    public XMLControl getChildControl(String var1);

    public XMLControl[] getChildControls();

    public void setValue(String var1);

    public static class WrappedArray {
        private double[] val;
        private int decimalPlaces;

        public WrappedArray(double[] val, int decimalPlaces) {
            this.val = val;
            this.decimalPlaces = decimalPlaces;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            String zeros = ".00000000000".substring(0, this.decimalPlaces + 1);
            int i = 0;
            int n = this.val.length;
            while (i < n) {
                String s;
                if (i > 0) {
                    sb.append(',');
                }
                if ((s = Double.toString(this.val[i] == 0.0 || this.decimalPlaces > 5 ? this.val[i] : this.val[i] + 1.0E-6)).indexOf("E") < 0) {
                    int pt = s.indexOf(46) + 1 + this.decimalPlaces;
                    if (s.length() > pt && (s = s.substring(0, pt)).endsWith(zeros)) {
                        s = s.substring(0, pt - zeros.length());
                    }
                }
                sb.append(s);
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

