/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLNode;
import org.opensourcephysics.controls.XMLProperty;

public final class XMLPropertyElement
extends XMLNode
implements XMLProperty {
    public static boolean defaultWriteNullFinalArrayElements = true;
    List<Object> content = new ArrayList<Object>();
    private boolean writeNullFinalElement;

    public XMLPropertyElement(XMLProperty mother) {
        this.parent = mother;
    }

    public XMLPropertyElement(XMLProperty mother, String propertyName, int propertyType, Object value) {
        this(mother, propertyName, propertyType, value, defaultWriteNullFinalArrayElements);
    }

    /*
     * Unable to fully structure code
     */
    public XMLPropertyElement(XMLProperty mother, String propertyName, int propertyType, Object value, boolean writeNullFinalArrayElement) {
        this(mother);
        this.name = propertyName;
        this.type = propertyType;
        this.writeNullFinalElement = writeNullFinalArrayElement;
        switch (this.type) {
            case 3: {
                if (XML.requiresCDATA((String)value)) {
                    this.content.add("<![CDATA[" + value + "]]>");
                    break;
                }
                this.content.add(value.toString());
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.content.add(value.toString());
                break;
            }
            case 6: {
                if (value == null) {
                    this.content.add("null");
                    break;
                }
                this.className = value.getClass().getName();
                control = new XMLControlElement(this);
                control.saveObject(value);
                this.content.add(control);
                break;
            }
            case 5: {
                this.className = value.getClass().getName();
                for (E next : (Collection)value) {
                    type = XMLProperty.getDataType(next);
                    if (type == -1) continue;
                    this.content.add(new XMLPropertyElement(this, "item", type, next, this.writeNullFinalElement));
                }
                break;
            }
            case 7: {
                this.className = "[D";
                this.content.add(new XMLPropertyElement(this, "array", 3, ((XMLProperty.WrappedArray)value).toString(), this.writeNullFinalElement));
                break;
            }
            case 4: {
                this.className = value.getClass().getName();
                baseType = value.getClass().getComponentType();
                array = value;
                count = Array.getLength(array);
                while (count > 0 && baseType.getComponentType() != null) {
                    baseType = baseType.getComponentType();
                    if ((array = Array.get(array, 0)) == null) break;
                    count *= Array.getLength(array);
                }
                v0 = primitive = baseType == Integer.TYPE || baseType == Double.TYPE || baseType == Boolean.TYPE;
                if (primitive && count > XMLControlElement.compactArraySize) {
                    this.content.add(new XMLPropertyElement(this, "array", 3, this.getArrayString(value), this.writeNullFinalElement));
                    break;
                }
                length = Array.getLength(value);
                last = this.writeNullFinalElement != false ? length - 1 : length;
                j = 0;
                while (j < length) {
                    next = Array.get(value, j);
                    type = XMLProperty.getDataType(next);
                    if (type != -1) ** GOTO lbl67
                    if (j < last) ** GOTO lbl69
                    type = 6;
lbl67:
                    // 2 sources

                    this.content.add(new XMLPropertyElement(this, "[" + j + "]", type, next, this.writeNullFinalElement));
lbl69:
                    // 2 sources

                    ++j;
                }
                break;
            }
        }
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public Class<?> getPropertyClass() {
        switch (this.type) {
            case 0: {
                return Integer.TYPE;
            }
            case 1: {
                return Double.TYPE;
            }
            case 2: {
                return Boolean.TYPE;
            }
            case 3: {
                return String.class;
            }
        }
        try {
            return Class.forName(this.className);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public int getLevel() {
        return this.parent.getLevel() + 1;
    }

    @Override
    public List<Object> getPropertyContent() {
        return this.content;
    }

    @Override
    public XMLControl getChildControl(String name) {
        XMLControl[] children = this.getChildControls();
        int i = 0;
        while (i < children.length) {
            if (children[i].getPropertyName().equals(name)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public XMLControl[] getChildControls() {
        switch (this.type) {
            case 6: {
                if (this.content.isEmpty()) break;
                return new XMLControl[]{(XMLControl)this.content.get(0)};
            }
            case 4: 
            case 5: {
                ArrayList<XMLControl> list = new ArrayList<XMLControl>();
                for (XMLProperty xMLProperty : this.content) {
                    if (xMLProperty.getPropertyType() != 6 || xMLProperty.getPropertyContent().isEmpty()) continue;
                    list.add((XMLControl)xMLProperty.getPropertyContent().get(0));
                }
                return list.toArray(new XMLControl[0]);
            }
        }
        return new XMLControl[0];
    }

    @Override
    public void setValue(String stringValue) {
        try {
            switch (this.type) {
                case 0: {
                    Integer.parseInt(stringValue);
                    break;
                }
                case 1: {
                    Double.parseDouble(stringValue);
                    break;
                }
                case 2: {
                    stringValue = stringValue.equals("true") ? "true" : "false";
                    break;
                }
                case 3: {
                    stringValue = "<![CDATA[" + stringValue + "]]>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    return;
                }
            }
        }
        catch (NumberFormatException ex) {
            return;
        }
        this.content.clear();
        this.content.add(stringValue);
    }

    public String toString() {
        StringBuffer xml = new StringBuffer(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "<property name=\"" + this.name + "\" type=\"" + XMLProperty.getTypeName(this.type) + "\"");
        switch (this.type) {
            case 4: 
            case 5: 
            case 7: {
                xml.append(" class=\"" + this.className + "\"");
            }
        }
        List<Object> c = this.content;
        if (this.type == 6 && c.isEmpty()) {
            c = new ArrayList<Object>();
            c.add("null");
        }
        if (c.isEmpty()) {
            xml.append("/>");
            return xml.toString();
        }
        xml.append(">");
        boolean hasChildren = false;
        for (Object next : c) {
            hasChildren = hasChildren || next instanceof XMLProperty;
            xml.append(next);
        }
        if (hasChildren) {
            xml.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()));
        }
        xml.append("</property>");
        return xml.toString();
    }

    protected String indent(int level) {
        String space = "";
        int i = 0;
        while (i < 4 * level) {
            space = String.valueOf(space) + " ";
            ++i;
        }
        return space;
    }

    protected String getArrayString(Object array) {
        StringBuffer sb = new StringBuffer("{");
        int length = Array.getLength(array);
        int j = 0;
        while (j < length) {
            Object element;
            if (j > 0) {
                sb.append(',');
            }
            if ((element = Array.get(array, j)) != null && element.getClass().isArray()) {
                sb.append(this.getArrayString(element));
            } else {
                sb.append(element);
            }
            ++j;
        }
        sb.append('}');
        return sb.toString();
    }
}

