/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTableInspector;
import org.opensourcephysics.controls.XMLTableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ArrayInspector;

public class XMLTable
extends JTable {
    static final Color LIGHT_BLUE = new Color(196, 196, 255);
    XMLTableModel tableModel;
    XMLCellRenderer xmlRenderer = new XMLCellRenderer();
    XMLValueEditor valueEditor = new XMLValueEditor();
    Color defaultBackgroundColor = Color.white;
    Map<String, Color> cellColors = new HashMap<String, Color>();
    Map<String, Color> selectedCellColors = new HashMap<String, Color>();
    Map<String, Color> editingCellColors = new HashMap<String, Color>();
    Color defaultEditingColor;
    PropertyChangeListener comboListener;

    public XMLTable(XMLControl control) {
        this.tableModel = new XMLTableModel(control);
        this.init();
    }

    public XMLTable(XMLTableModel model) {
        this.tableModel = model;
        this.init();
    }

    public XMLControl getControl() {
        return this.tableModel.control;
    }

    public void setEditable(boolean editable) {
        this.tableModel.editable = editable;
    }

    public boolean isEditable() {
        return this.tableModel.editable;
    }

    public void setEditable(String propName, boolean editable) {
        if (!editable) {
            this.tableModel.uneditablePropNames.add(propName);
        } else {
            this.tableModel.uneditablePropNames.remove(propName);
        }
    }

    public boolean isEditable(String propName) {
        return !this.tableModel.uneditablePropNames.contains(propName);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.tableModel.editable && this.tableModel.isCellEditable(row, col);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.xmlRenderer != null) {
            this.xmlRenderer.setFont(font);
            this.valueEditor.field.setFont(font);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (XMLTable.this.getTableHeader().getHeight() > 0) {
                        XMLTable.this.setRowHeight(XMLTable.this.getTableHeader().getHeight());
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    public void setSelectedColor(String propName, Color color) {
        this.selectedCellColors.put(propName, color);
    }

    public Color getSelectedColor(String propName) {
        Color color = this.selectedCellColors.get(propName);
        return color == null ? LIGHT_BLUE : color;
    }

    public void setBackgroundColor(String propName, Color color) {
        this.cellColors.put(propName, color);
    }

    public Color getBackgroundColor(String propName) {
        Color color = this.cellColors.get(propName);
        return color == null ? this.defaultBackgroundColor : color;
    }

    public void setEditingColor(String propName, Color color) {
        this.editingCellColors.put(propName, color);
    }

    public Color getEditingColor(String propName) {
        Color color = this.editingCellColors.get(propName);
        return color == null ? this.defaultEditingColor : color;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.xmlRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        return this.valueEditor;
    }

    public void refresh() {
        SwingUtilities.invokeLater(() -> this.tableChanged(new TableModelEvent(this.tableModel, -1)));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.firePropertyChange("tableData", null, e);
        super.tableChanged(e);
    }

    public void addControlListener(String methodName, Object target) {
        this.addControlListener(null, methodName, target);
    }

    public void addControlListener(String parameterName, String methodName, final Object target) {
        Class[] parameters = new Class[]{String.class};
        try {
            final Method m = target.getClass().getMethod(methodName, parameters);
            this.tableModel.addTableModelListener(new TableModelListener(parameterName){
                final String par;
                {
                    this.par = string;
                }

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() != 0 || e.getColumn() != 1 || e.getFirstRow() < 0) {
                        return;
                    }
                    String name = XMLTable.this.getValueAt(e.getFirstRow(), 0).toString();
                    if (this.par == null || this.par.equals(name)) {
                        Object[] args = new Object[]{name};
                        try {
                            m.invoke(target, args);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(String.valueOf(ControlsRes.getString("XMLTable.ErrorMessage.NoMethod")) + " " + methodName + "()");
        }
    }

    private void init() {
        this.setModel(this.tableModel);
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.setForeground(Color.BLACK);
        this.setGridColor(Color.BLACK);
        InputMap im = this.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        Object key = im.get(tab);
        if (key != null) {
            final Action prevTabAction = this.getActionMap().get(key);
            AbstractAction tabAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    prevTabAction.actionPerformed(e);
                    JTable table = (JTable)e.getSource();
                    int rowCount = table.getRowCount();
                    int row = table.getSelectedRow();
                    int column = table.getSelectedColumn();
                    while (!table.isCellEditable(row, column)) {
                        if (column == 0) {
                            column = 1;
                        } else {
                            ++row;
                        }
                        if (row == rowCount) {
                            row = 0;
                        }
                        if (row == table.getSelectedRow() && column == table.getSelectedColumn()) break;
                    }
                    table.changeSelection(row, column, false, false);
                }
            };
            this.getActionMap().put(key, tabAction);
        } else {
            System.out.println("XMLTable No previous tab action");
        }
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel panel;
                JTable table = (JTable)e.getSource();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                table.editCellAt(row, column, e);
                Component comp = table.getEditorComponent();
                if (comp instanceof JPanel && (comp = (panel = (JPanel)comp).getComponent(0)) instanceof JTextField) {
                    JTextField field = (JTextField)comp;
                    OSPCombo combo = null;
                    Object value = XMLTable.this.tableModel.getValueAt(row, column);
                    if (value instanceof XMLControl) {
                        final XMLControl control = (XMLControl)value;
                        if (control.getObjectClass() == OSPCombo.class) {
                            combo = (OSPCombo)control.loadObject(null);
                        } else if (control.getObjectClass() == Boolean.class) {
                            Boolean bool = (Boolean)control.loadObject(null);
                            int n = bool != false ? 0 : 1;
                            combo = new OSPCombo(new String[]{"true", "false"}, n);
                            combo.addPropertyChangeListener("value", new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent e) {
                                    OSPCombo combo = (OSPCombo)e.getSource();
                                    Boolean bool = combo.getSelectedIndex() == 0;
                                    control.saveObject(bool);
                                }
                            });
                        }
                    }
                    if (combo == null) {
                        field.requestFocus();
                        field.selectAll();
                    } else {
                        combo.row = row;
                        combo.column = column;
                        combo.removePropertyChangeListener("index", XMLTable.this.comboListener);
                        combo.addPropertyChangeListener("index", XMLTable.this.comboListener);
                        combo.showPopup(field);
                    }
                }
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(im.get(enter), enterAction);
        this.comboListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                OSPCombo combo = (OSPCombo)e.getSource();
                int n = (Integer)e.getOldValue();
                if (n != combo.getSelectedIndex()) {
                    combo.firePropertyChange("value", n, combo.getSelectedIndex());
                    XMLTable.this.tableModel.fireTableCellUpdated(combo.row, combo.column);
                }
                combo.removePropertyChangeListener("index", this);
                XMLTable.this.valueEditor.stopCellEditing();
            }
        };
    }

    private boolean isInspectable(XMLProperty prop) {
        switch (prop.getPropertyType()) {
            case 5: 
            case 6: {
                return true;
            }
            case 4: {
                return ArrayInspector.canInspect(prop);
            }
        }
        return false;
    }

    class XMLCellRenderer
    extends DefaultTableCellRenderer {
        Color lightGreen = new Color(204, 255, 204);
        Color lightGray = UIManager.getColor("Panel.background");
        Font font = new JTextField().getFont();

        public XMLCellRenderer() {
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setFont(this.font);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.BLACK);
            if (value == null) {
                value = "";
            }
            String propName = (String)XMLTable.this.tableModel.getValueAt(row, 0);
            if (column == 0) {
                if (isSelected) {
                    this.setBackground(LIGHT_BLUE);
                } else {
                    this.setBackground(this.lightGray);
                }
                this.setHorizontalAlignment(2);
                String text = value.toString();
                if (OSPRuntime.loadTranslatorTool) {
                    text = OSPRuntime.getTranslator().getProperty(XMLTable.this, text);
                }
                this.setText(text);
                this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
                return this;
            }
            String childValue = null;
            if (value instanceof XMLProperty) {
                XMLProperty prop = (XMLProperty)value;
                XMLProperty parent = prop.getParentProperty();
                Class<?> childClass = parent.getPropertyClass();
                String className = XML.getSimpleClassName(childClass);
                XMLControl control = (XMLControl)parent.getParentProperty();
                Object childObj = control.getObject(parent.getPropertyName());
                if (parent.getPropertyType() == 4) {
                    Object array = childObj;
                    Class<?> baseType = array.getClass().getComponentType();
                    int count = Array.getLength(array);
                    int insert = className.indexOf("[]") + 1;
                    className = String.valueOf(className.substring(0, insert)) + count + className.substring(insert);
                    while (baseType.getComponentType() != null) {
                        baseType = baseType.getComponentType();
                        if ((array = Array.get(array, 0)) == null) break;
                        count = Array.getLength(array);
                        insert = className.indexOf("[]", insert) + 1;
                        className = String.valueOf(className.substring(0, insert)) + count + className.substring(insert);
                    }
                }
                if (childClass != OSPCombo.class && childClass != Boolean.class && childClass != Character.class) {
                    this.setText(className);
                    this.setBackground(XMLTable.this.isInspectable(parent) ? this.lightGreen : this.lightGray);
                    this.setBorder(new CellBorder(new Color(240, 240, 240)));
                    this.setHorizontalAlignment(0);
                    if (isSelected && XMLTable.this.isInspectable(parent)) {
                        this.setBackground(XMLTable.this.getSelectedColor(propName));
                        this.setForeground(Color.RED);
                    }
                    return this;
                }
                childValue = childObj.toString();
            }
            if (isSelected) {
                this.setBackground(XMLTable.this.getSelectedColor(propName));
                this.setForeground(Color.RED);
            } else {
                this.setBackground(XMLTable.this.getBackgroundColor(propName));
            }
            this.setHorizontalAlignment(2);
            this.setText(childValue == null ? value.toString() : childValue);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            if (!XMLTable.this.tableModel.editable || XMLTable.this.tableModel.uneditablePropNames.contains(propName)) {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }

    class XMLValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        int keepFocus = -2;
        OSPCombo combo;

        XMLValueEditor() {
            XMLTable.this.defaultEditingColor = this.field.getSelectionColor();
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.field.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128), 1));
            this.field.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XMLValueEditor.this.stopCellEditing();
                    XMLValueEditor.this.keepFocus = -2;
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        XMLValueEditor.this.stopCellEditing();
                        XMLValueEditor.this.keepFocus = -2;
                    } else if (XMLValueEditor.this.field.isEnabled()) {
                        XMLValueEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    int i;
                    if (e.isTemporary()) {
                        return;
                    }
                    if (XMLValueEditor.this.field.getBackground() != ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.defaultBackgroundColor) {
                        XMLValueEditor.this.stopCellEditing();
                    }
                    if (XMLValueEditor.this.keepFocus == (i = XMLTable.this.getSelectedRow())) {
                        XMLValueEditor.this.keepFocus = -2;
                    } else {
                        XMLTable.this.requestFocusInWindow();
                    }
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    XMLValueEditor.this.doOpenCombo();
                }
            });
        }

        protected void doOpenCombo() {
            if (this.combo != null) {
                if (this.combo.getPropertyChangeListeners("index").length > 0) {
                    this.combo.removePropertyChangeListener("index", XMLTable.this.comboListener);
                    this.combo.setVisible(false);
                    this.stopCellEditing();
                } else {
                    this.combo.removePropertyChangeListener("index", XMLTable.this.comboListener);
                    this.combo.addPropertyChangeListener("index", XMLTable.this.comboListener);
                    this.combo.showPopup(this.field);
                }
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo = null;
            String propName = (String)XMLTable.this.tableModel.getValueAt(row, 0);
            this.field.setBackground(XMLTable.this.defaultBackgroundColor);
            this.field.setSelectionColor(XMLTable.this.getEditingColor(propName));
            final int rowNumber = row;
            final int colNumber = column;
            if (value instanceof XMLControl) {
                final XMLControl childControl = (XMLControl)value;
                if (childControl.getObjectClass() == Color.class) {
                    Color color = (Color)childControl.loadObject(null);
                    String title = ControlsRes.getString("XMLTable.ColorChooser.Title");
                    OSPRuntime.chooseColor(color, title, newColor -> {
                        if (newColor != null && !color.equals(newColor)) {
                            childControl.saveObject(newColor);
                            XMLTable.this.tableModel.fireTableCellUpdated(row, column);
                        }
                    });
                    return null;
                }
                if (childControl.getObjectClass() == Character.class) {
                    Character c = (Character)childControl.loadObject(null);
                    this.field.setEditable(true);
                    this.field.setText(c.toString());
                    return this.panel;
                }
                if (childControl.getObjectClass() == OSPCombo.class) {
                    this.combo = (OSPCombo)childControl.loadObject(null);
                    this.combo.row = row;
                    this.combo.column = column;
                    this.field.setText(this.combo.toString());
                    this.field.setEditable(false);
                    return this.panel;
                }
                if (childControl.getObjectClass() == Boolean.class) {
                    Boolean bool = (Boolean)childControl.loadObject(null);
                    int n = bool != false ? 0 : 1;
                    this.combo = new OSPCombo(new String[]{"true", "false"}, n);
                    this.combo.row = row;
                    this.combo.column = column;
                    this.field.setText(bool.toString());
                    this.field.setEditable(false);
                    this.combo.addPropertyChangeListener("value", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            OSPCombo combo = (OSPCombo)e.getSource();
                            Boolean bool = combo.getSelectedIndex() == 0;
                            childControl.saveObject(bool);
                        }
                    });
                    return this.panel;
                }
                XMLTableInspector inspector = new XMLTableInspector(childControl, XMLTable.this.isEditable());
                inspector.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (e.getPropertyName().equals("xmlData")) {
                            ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.tableModel.fireTableCellUpdated(rowNumber, colNumber);
                        }
                    }
                });
                Container cont = XMLTable.this.getTopLevelAncestor();
                Point p = cont.getLocationOnScreen();
                inspector.setLocation(p.x + 30, p.y + 30);
                inspector.setVisible(true);
                return null;
            }
            if (value instanceof XMLProperty) {
                XMLProperty arrayProp;
                ArrayInspector arrayInspector;
                Point p;
                Container cont;
                XMLProperty prop = (XMLProperty)value;
                XMLProperty parent = prop.getParentProperty();
                if (parent.getPropertyType() == 5) {
                    String name = parent.getPropertyName();
                    if ((parent = parent.getParentProperty()) instanceof XMLControl) {
                        XMLControlElement cControl = new XMLControlElement();
                        Collection c = (Collection)((XMLControl)parent).getObject(name);
                        Iterator it = c.iterator();
                        int i = 0;
                        while (it.hasNext()) {
                            Object next = it.next();
                            cControl.setValue("item_" + i, next);
                            ++i;
                        }
                        XMLTableInspector inspector = new XMLTableInspector(cControl);
                        inspector.setTitle(String.valueOf(ControlsRes.getString("XMLTable.Inspector.Title")) + name + "\"");
                        cont = XMLTable.this.getTopLevelAncestor();
                        p = cont.getLocationOnScreen();
                        inspector.setLocation(p.x + 30, p.y + 30);
                        inspector.setVisible(true);
                        cont.transferFocus();
                    }
                }
                if ((arrayInspector = ArrayInspector.getInspector(arrayProp = prop.getParentProperty())) != null) {
                    String name = arrayProp.getPropertyName();
                    parent = arrayProp.getParentProperty();
                    while (!(parent instanceof XMLControl)) {
                        name = parent.getPropertyName();
                        arrayProp = parent;
                        parent = parent.getParentProperty();
                    }
                    final XMLControl arrayControl = (XMLControl)parent;
                    final String arrayName = name;
                    final Object arrayObj = arrayInspector.getArray();
                    arrayInspector.setEditable(XMLTable.this.tableModel.editable);
                    arrayInspector.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("cell")) {
                                arrayControl.setValue(arrayName, arrayObj);
                            } else if (e.getPropertyName().equals("arrayData")) {
                                ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.tableModel.fireTableCellUpdated(rowNumber, colNumber);
                            }
                        }
                    });
                    cont = XMLTable.this.getTopLevelAncestor();
                    p = cont.getLocationOnScreen();
                    arrayInspector.setLocation(p.x + 30, p.y + 30);
                    arrayInspector.setVisible(true);
                    cont.transferFocus();
                }
                return null;
            }
            this.field.setEditable(true);
            if (value != null) {
                this.field.setText(value.toString());
            }
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                XMLControl childControl;
                int row;
                MouseEvent me = (MouseEvent)e;
                XMLTable table = (XMLTable)me.getSource();
                this.keepFocus = row = table.rowAtPoint(me.getPoint());
                Object value = XMLTable.this.tableModel.getValueAt(row, 1);
                if (value instanceof XMLControl && ((childControl = (XMLControl)value).getObjectClass() == OSPCombo.class || childControl.getObjectClass() == Boolean.class || childControl.getObjectClass() == Character.class)) {
                    return true;
                }
                if (value instanceof String || me.getClickCount() == 2) {
                    return true;
                }
            } else if (e instanceof ActionEvent) {
                this.keepFocus = -2;
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            XMLTable.this.requestFocusInWindow();
            if (this.field.getBackground() != XMLTable.this.defaultBackgroundColor) {
                this.field.setBackground(XMLTable.this.defaultBackgroundColor);
                return this.field.getText();
            }
            return null;
        }
    }
}

