/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;

public class XMLTableInspector
extends JDialog
implements PropertyChangeListener {
    static String frameTitle = ControlsRes.getString("XMLTableInspector.Title");
    private XMLTable table;
    private boolean changed;

    public XMLTableInspector(XMLControl control) {
        this(control, true, true);
    }

    public XMLTableInspector(XMLControl control, boolean editable) {
        this(control, editable, true);
    }

    public XMLTableInspector(XMLControl control, boolean editable, boolean modal) {
        super((Frame)null, modal);
        this.createGUI();
        XMLTable table = new XMLTable(control);
        table.setEditable(editable);
        this.setTable(table);
        String s = XML.getExtension(control.getObjectClassName());
        this.setTitle(String.valueOf(frameTitle) + " " + s + " \"" + control.getPropertyName() + "\" ");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (XMLTableInspector.this.changed) {
                    XMLTableInspector.this.firePropertyChange("xmlData", null, null);
                    XMLTableInspector.this.changed = false;
                }
            }
        });
    }

    public XMLTableInspector(boolean editable, boolean modal) {
        super((Frame)null, modal);
        this.table = new OSPControlTable(new XMLControlElement());
        this.table.setEditable(editable);
        this.table.addPropertyChangeListener("cell", this);
        this.table.addPropertyChangeListener("tableData", this);
        this.createGUI();
        String s = XML.getExtension(this.getXMLControl().getObjectClassName());
        this.setTitle(String.valueOf(frameTitle) + " " + s + " \"" + this.getXMLControl().getPropertyName() + "\" ");
    }

    public Control getControl() {
        return this.table instanceof Control ? (Control)((Object)this.table) : this.table.tableModel.control;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.changed = true;
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public XMLTable getTable() {
        return this.table;
    }

    public void setTable(XMLTable xmlTable) {
        if (this.table != null) {
            this.table.removePropertyChangeListener("cell", this);
            this.table.removePropertyChangeListener("tableData", this);
            xmlTable.setEditable(this.table.isEditable());
        }
        this.table = xmlTable;
        this.table.addPropertyChangeListener("cell", this);
        this.table.addPropertyChangeListener("tableData", this);
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.createHorizontalScrollBar();
        this.getContentPane().add((Component)scrollpane, "Center");
    }

    public XMLControl getXMLControl() {
        return this.table.tableModel.control;
    }

    private void createGUI() {
        this.setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
    }
}

