/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.tools.ArrayInspector;

public class XMLTableModel
extends AbstractTableModel {
    XMLControl control;
    boolean editable = true;
    Collection<String> uneditablePropNames = new HashSet<String>();

    public XMLTableModel(XMLControl control) {
        this.control = control;
    }

    @Override
    public int getColumnCount() {
        if (this.control == null) {
            return 0;
        }
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? ControlsRes.XML_NAME : ControlsRes.XML_VALUE;
    }

    @Override
    public int getRowCount() {
        if (this.control == null) {
            return 0;
        }
        return this.control.getPropsRaw().size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            XMLProperty val = this.control.getPropsRaw().get(row);
            Object content = val.getPropertyContent().get(0);
            if (content.toString().indexOf("![CDATA[") > -1) {
                content = this.control.getString(val.getPropertyName());
            }
            return column == 0 ? val.getPropertyName() : content;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        String propName = (String)this.getValueAt(row, 0);
        if (this.uneditablePropNames.contains(propName)) {
            return false;
        }
        Object value = this.getValueAt(row, col);
        if (value instanceof XMLControl) {
            return true;
        }
        if (value instanceof XMLProperty) {
            XMLProperty prop = (XMLProperty)value;
            XMLProperty parent = prop.getParentProperty();
            switch (parent.getPropertyType()) {
                case 4: {
                    return ArrayInspector.canInspect(parent);
                }
                case 5: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        boolean changed = false;
        if (value instanceof String) {
            String s = (String)value;
            XMLProperty prop = this.control.getPropsRaw().get(row);
            changed = !s.equals(this.control.getString(prop.getPropertyName()));
            switch (prop.getPropertyType()) {
                case 3: {
                    this.control.setValue(prop.getPropertyName(), s);
                    break;
                }
                case 0: {
                    try {
                        this.control.setValue(prop.getPropertyName(), Integer.parseInt(s));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case 1: {
                    try {
                        this.control.setValue(prop.getPropertyName(), Double.parseDouble(s));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case 2: {
                    boolean bool = s.toLowerCase().startsWith("t");
                    changed = bool ^ this.control.getBoolean(prop.getPropertyName());
                    this.control.setValue(prop.getPropertyName(), bool);
                    break;
                }
                case 6: {
                    XMLControl childControl = this.control.getChildControl(prop.getPropertyName());
                    if (childControl.getObjectClass() != Character.class || s.length() != 1) break;
                    Character c = new Character(s.charAt(0));
                    changed = !c.equals(this.control.getObject(prop.getPropertyName()));
                    this.control.setValue(prop.getPropertyName(), c);
                }
            }
        }
        if (changed) {
            this.fireTableCellUpdated(row, col);
        }
    }
}

