/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeNode;
import org.opensourcephysics.tools.ResourceLoader;

public class XMLTree {
    protected static Icon hiliteIcon;
    protected XMLTreeNode root;
    protected JTree tree;
    protected JScrollPane scroller;
    protected XMLControl control;
    protected List<XMLProperty> selectedProps = new ArrayList<XMLProperty>();
    protected Class<?> hilite = Object.class;

    public XMLTree(XMLControl control) {
        this.control = control;
        this.createGUI();
    }

    public JTree getTree() {
        return this.tree;
    }

    public List<XMLProperty> getSelectedProperties() {
        this.selectedProps.clear();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                XMLTreeNode node = (XMLTreeNode)paths[i].getLastPathComponent();
                this.selectedProps.add(node.getProperty());
                ++i;
            }
        }
        return this.selectedProps;
    }

    public JScrollPane getScrollPane() {
        return this.scroller;
    }

    public void setHighlightedClass(Class<?> type) {
        if (type != null) {
            this.hilite = type;
            this.scroller.repaint();
        }
    }

    public Class<?> getHighlightedClass() {
        return this.hilite;
    }

    public void selectHighlightedProperties() {
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            XMLTreeNode node = (XMLTreeNode)e.nextElement();
            XMLProperty prop = node.getProperty();
            Class<?> type = prop.getPropertyClass();
            if (type == null || !this.hilite.isAssignableFrom(type)) continue;
            TreePath path = new TreePath(node.getPath());
            this.tree.addSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    public void showHighlightedProperties() {
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            XMLTreeNode node = (XMLTreeNode)e.nextElement();
            XMLProperty prop = node.getProperty();
            Class<?> type = prop.getPropertyClass();
            if (type == null || !this.hilite.isAssignableFrom(type)) continue;
            TreePath path = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(path);
        }
    }

    protected void createGUI() {
        String imageFile = "/org/opensourcephysics/resources/controls/images/hilite.gif";
        hiliteIcon = ResourceLoader.getImageIcon(imageFile);
        this.root = new XMLTreeNode(this.control);
        this.tree = new JTree(this.root);
        this.tree.setCellRenderer(new HighlightRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.scroller = new JScrollPane(this.tree);
        this.scroller.setPreferredSize(new Dimension(200, 200));
    }

    private class HighlightRenderer
    extends DefaultTreeCellRenderer {
        private HighlightRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            XMLTreeNode node = (XMLTreeNode)value;
            XMLProperty prop = node.getProperty();
            Class<?> type = prop.getPropertyClass();
            if (type != null && XMLTree.this.hilite.isAssignableFrom(type)) {
                this.setIcon(hiliteIcon);
            }
            return this;
        }
    }
}

