/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;

public class XMLTreeChooser
extends JDialog {
    private JPanel scrollPane;
    private XMLTree tree;
    private JLabel textLabel;
    private boolean applyChanges = false;
    private Class<?> classType;
    private Runnable whenClosed;

    public XMLTreeChooser(String title, String text) {
        this(title, text, null);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.dispose();
            if (this.whenClosed != null) {
                SwingUtilities.invokeLater(this.whenClosed);
            }
        }
    }

    public XMLTreeChooser(String title, String text, Component comp) {
        super(JOptionPane.getFrameForComponent(comp), true);
        this.setTitle(title);
        this.textLabel = new JLabel(" " + text);
        this.textLabel.setHorizontalTextPosition(2);
        JButton cancelButton = new JButton(ControlsRes.getString("Chooser.Button.Cancel"));
        JButton okButton = new JButton(ControlsRes.getString("Chooser.Button.OK"));
        JButton selectAllButton = new JButton(ControlsRes.getString("Chooser.Button.SelectAll"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLTreeChooser.this.setVisible(false);
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLTreeChooser.this.applyChanges = true;
                XMLTreeChooser.this.setVisible(false);
            }
        });
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLTreeChooser.this.tree.selectHighlightedProperties();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.add(this.textLabel);
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(selectAllButton);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.scrollPane = new JPanel(new BorderLayout());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(340, 340));
        this.setContentPane(contentPane);
        contentPane.add((Component)headerPane, "North");
        contentPane.add((Component)this.scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    public List<XMLProperty> choose(XMLControl control, Class<?> type) {
        this.tree = new XMLTree(control);
        this.tree.setHighlightedClass(type);
        this.tree.selectHighlightedProperties();
        this.textLabel.setIcon(XMLTree.hiliteIcon);
        this.scrollPane.removeAll();
        this.scrollPane.add((Component)this.tree.getScrollPane(), "Center");
        this.validate();
        this.applyChanges = false;
        this.classType = type;
        this.whenClosed = null;
        this.setVisible(true);
        return this.getList();
    }

    public void chooseAsync(XMLControl control, Class<?> type, Runnable whenClosed) {
        this.tree = new XMLTree(control);
        this.tree.setHighlightedClass(type);
        this.tree.selectHighlightedProperties();
        this.textLabel.setIcon(XMLTree.hiliteIcon);
        this.scrollPane.removeAll();
        this.scrollPane.add((Component)this.tree.getScrollPane(), "Center");
        this.validate();
        this.applyChanges = false;
        this.classType = type;
        this.whenClosed = whenClosed;
        this.setVisible(true);
    }

    public List<XMLProperty> getList() {
        ArrayList<XMLProperty> list = new ArrayList<XMLProperty>();
        if (this.applyChanges) {
            List<XMLProperty> props = this.tree.getSelectedProperties();
            for (XMLProperty prop : props) {
                Class<?> propClass = prop.getPropertyClass();
                if (propClass == null || !this.classType.isAssignableFrom(propClass)) continue;
                list.add(prop);
            }
        }
        return list;
    }
}

