/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.desktop;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;

public class OSPDesktop {
    static final String desktopClassName = "java.awt.Desktop";
    static boolean desktopSupported;

    static {
        if (!OSPRuntime.isJS) {
            try {
                Method m = Class.forName(desktopClassName).getMethod("isDesktopSupported", null);
                desktopSupported = (Boolean)m.invoke(null, null);
            }
            catch (Exception e) {
                desktopSupported = false;
            }
        }
    }

    public static boolean displayURL(String url) {
        block8: {
            block7: {
                try {
                    if (!OSPRuntime.isJS) break block7;
                    if (url.startsWith("file") || url.startsWith("/")) {
                        byte[] bytes = ResourceLoader.getURLBytes(url);
                        if (bytes == null) {
                            OSPLog.warning("OSP Desktop could not display " + url);
                        } else {
                            String name = url.toString();
                            name = name.substring(name.lastIndexOf("/") + 1);
                            File fout = new File(name);
                            FileOutputStream fos = new FileOutputStream(fout);
                            fos.write(bytes);
                            fos.close();
                        }
                        return true;
                    }
                    break block8;
                }
                catch (Exception e1) {
                    return false;
                }
            }
            if (!OSPDesktop.browse(url)) break block8;
            return true;
        }
        OSPRuntime.displayURL(url);
        return true;
    }

    public static boolean isDesktopSupported() {
        return desktopSupported;
    }

    public static boolean browse(String uriName) {
        if (!desktopSupported) {
            return false;
        }
        try {
            return OSPDesktop.browse(new URI(uriName));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean browse(URI uri) {
        if (!desktopSupported || uri == null) {
            return false;
        }
        Class[] parameters = new Class[]{URI.class};
        try {
            Method m = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object desktop = m.invoke(null, null);
            m = Class.forName(desktopClassName).getMethod("browse", parameters);
            Object[] args = new Object[]{uri};
            m.invoke(desktop, args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean mail(String addr) {
        if (!desktopSupported || addr == null) {
            return false;
        }
        Class[] parameters = new Class[]{URI.class};
        try {
            URI uri = new URI("mailto:" + addr.trim());
            Method m = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object desktop = m.invoke(null, null);
            m = Class.forName(desktopClassName).getMethod("mail", parameters);
            Object[] args = new Object[]{uri};
            m.invoke(desktop, args);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean mail() {
        if (!desktopSupported) {
            return false;
        }
        try {
            Method m = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object desktop = m.invoke(null, null);
            m = Class.forName(desktopClassName).getMethod("mail", null);
            m.invoke(desktop, null);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean edit(File file) {
        if (!desktopSupported) {
            return false;
        }
        Class[] parameters = new Class[]{File.class};
        try {
            Method m = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object desktop = m.invoke(null, null);
            m = Class.forName(desktopClassName).getMethod("edit", parameters);
            Object[] args = new Object[]{file};
            m.invoke(desktop, args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean open(File file) {
        if (!desktopSupported) {
            return false;
        }
        Class[] parameters = new Class[]{File.class};
        try {
            Method m = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object desktop = m.invoke(null, null);
            m = Class.forName(desktopClassName).getMethod("open", parameters);
            Object[] args = new Object[]{file};
            m.invoke(desktop, args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

