/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.desktop.ostermiller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Vector;
import org.opensourcephysics.desktop.ostermiller.BrowserCommandLexer;

public class Browser {
    public static String[] exec = null;

    public static void init() {
        exec = Browser.defaultCommands();
    }

    public static String[] defaultCommands() {
        String[] exec = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            exec = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            Vector<String> browsers = new Vector<String>();
            try {
                Process p = Runtime.getRuntime().exec("which open");
                if (p.waitFor() == 0) {
                    browsers.add("open {0}");
                }
            }
            catch (IOException p) {
            }
            catch (InterruptedException p) {
                // empty catch block
            }
            if (browsers.size() > 0) {
                exec = browsers.toArray(new String[0]);
            }
        } else if (System.getProperty("os.name").startsWith("SunOS")) {
            exec = new String[]{"/usr/dt/bin/sdtwebclient {0}"};
        } else {
            Process p2;
            Vector<String> browsers = new Vector<String>();
            try {
                p2 = Runtime.getRuntime().exec("which firebird");
                if (p2.waitFor() == 0) {
                    browsers.add("firebird -remote openURL({0})");
                    browsers.add("firebird {0}");
                }
            }
            catch (IOException p2) {
            }
            catch (InterruptedException p2) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which mozilla");
                if (p2.waitFor() == 0) {
                    browsers.add("mozilla -remote openURL({0})");
                    browsers.add("mozilla {0}");
                }
            }
            catch (IOException p3) {
            }
            catch (InterruptedException p3) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which opera");
                if (p2.waitFor() == 0) {
                    browsers.add("opera -remote openURL({0})");
                    browsers.add("opera {0}");
                }
            }
            catch (IOException p4) {
            }
            catch (InterruptedException p4) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which galeon");
                if (p2.waitFor() == 0) {
                    browsers.add("galeon {0}");
                }
            }
            catch (IOException p5) {
            }
            catch (InterruptedException p5) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which konqueror");
                if (p2.waitFor() == 0) {
                    browsers.add("konqueror {0}");
                }
            }
            catch (IOException p6) {
            }
            catch (InterruptedException p6) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which netscape");
                if (p2.waitFor() == 0) {
                    browsers.add("netscape -remote openURL({0})");
                    browsers.add("netscape {0}");
                }
            }
            catch (IOException p7) {
            }
            catch (InterruptedException p7) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which xterm");
                if (p2.waitFor() == 0 && (p2 = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    browsers.add("xterm -e lynx {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (browsers.size() > 0) {
                exec = browsers.toArray(new String[0]);
            }
        }
        return exec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void displayURL(String url) throws IOException {
        if (exec == null || exec.length == 0) {
            if (!System.getProperty("os.name").startsWith("Mac")) throw new IOException("Browser execute command not defined.");
            boolean success = false;
            try {
                Class<?> nSWorkspace;
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURI().toURL()});
                    nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace", true, classLoader);
                } else {
                    nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                Method sharedWorkspace = nSWorkspace.getMethod("sharedWorkspace", new Class[0]);
                Object workspace = sharedWorkspace.invoke(null, new Object[0]);
                Method openURL = nSWorkspace.getMethod("openURL", Class.forName("java.net.URL"));
                success = (Boolean)openURL.invoke(workspace, new URL(url));
            }
            catch (Exception nSWorkspace) {
                // empty catch block
            }
            if (success) return;
            try {
                Class<?> mrjFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Method openURL = mrjFileUtils.getMethod("openURL", Class.forName("java.lang.String"));
                openURL.invoke(null, url);
                return;
            }
            catch (Exception x) {
                System.err.println(x.getMessage());
                throw new IOException("Browser launch failed.");
            }
        }
        new URL(url);
        StringBuffer sb = new StringBuffer(url.length());
        int i = 0;
        while (i < url.length()) {
            char c = url.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                sb.append(c);
            } else if ((c = (char)(c & 0xFF)) < '\u0010') {
                sb.append("%0" + Integer.toHexString(c));
            } else {
                sb.append("%" + Integer.toHexString(c));
            }
            ++i;
        }
        Object[] messageArray = new String[]{sb.toString()};
        String command = null;
        boolean found = false;
        try {
            int i2 = 0;
            while (i2 < exec.length && !found) {
                try {
                    String t;
                    command = MessageFormat.format(exec[i2], messageArray);
                    Vector<String> argsVector = new Vector<String>();
                    BrowserCommandLexer lex = new BrowserCommandLexer(new StringReader(command));
                    while ((t = lex.getNextToken()) != null) {
                        argsVector.add(t);
                    }
                    String[] args = new String[argsVector.size()];
                    if ((args = argsVector.toArray(args))[0].equals("rundll32") && args[1].equals("url.dll,FileProtocolHandler")) {
                        if (args[2].startsWith("file:/")) {
                            if (args[2].charAt(6) != '/') {
                                args[2] = "file://" + args[2].substring(6);
                            }
                            if (args[2].charAt(7) != '/') {
                                args[2] = "file:///" + args[2].substring(7);
                            }
                        } else if (!args[2].toLowerCase().endsWith("html")) {
                            args[2].toLowerCase().endsWith("htm");
                        }
                    }
                    Process p = Runtime.getRuntime().exec(args);
                    int j = 0;
                    while (j < 2) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++j;
                    }
                    if (p.exitValue() == 0) {
                        found = true;
                    }
                }
                catch (IOException x) {
                    System.err.println("Warning: " + x.getMessage());
                }
                ++i2;
            }
            if (found) return;
            throw new IOException("Browser launch failed.");
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void displayURLs(String[] urls) throws IOException {
        if (urls == null || urls.length == 0) {
            return;
        }
        if (urls.length == 1) {
            Browser.displayURL(urls[0]);
            return;
        }
        File shortcut = File.createTempFile("DisplayURLs", ".html");
        shortcut = shortcut.getCanonicalFile();
        shortcut.deleteOnExit();
        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
        out.println("<!-- saved from url=(0014)about:internet -->");
        out.println("<html>");
        out.println("<head>");
        out.println("<title> Open URLs </title>");
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        out.println("function displayURLs(){");
        int i = 1;
        while (i < urls.length) {
            out.println("window.open(\"" + urls[i] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
            ++i;
        }
        out.println("location.href=\"" + urls[0] + "\";");
        out.println("}");
        out.println("</script>");
        out.println("</head>");
        out.println("<body onload=\"javascript:displayURLs()\">");
        out.println("<noscript>");
        i = 0;
        while (i < urls.length) {
            out.println("<a target=\"_blank\" href=\"" + urls[i] + "\">" + urls[i] + "</a><br>");
            ++i;
        }
        out.println("</noscript>");
        out.println("</body>");
        out.println("</html>");
        out.close();
        Browser.displayURL(shortcut.toURI().toURL().toString());
    }
}

